/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array3D;
import mitiv.array.Byte3D;
import mitiv.array.Double1D;
import mitiv.array.Double2D;
import mitiv.array.DoubleArray;
import mitiv.array.Float3D;
import mitiv.array.Int3D;
import mitiv.array.Long3D;
import mitiv.array.ShapedArray;
import mitiv.array.Short3D;
import mitiv.array.impl.FlatDouble3D;
import mitiv.array.impl.StriddenDouble3D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.DoubleGenerator;

public abstract class Double3D
extends Array3D
implements DoubleArray {
    protected Double3D(int dim1, int dim2, int dim3) {
        super(dim1, dim2, dim3);
    }

    protected Double3D(int[] dims) {
        super(dims);
    }

    protected Double3D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 5;
    }

    public abstract double get(int var1, int var2, int var3);

    public abstract void set(int var1, int var2, int var3, double var4);

    @Override
    public void fill(double value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        this.set(i1, i2, i3, value);
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        this.set(i1, i2, i3, value);
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        }
    }

    @Override
    public void increment(double value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        this.set(i1, i2, i3, this.get(i1, i2, i3) + value);
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        this.set(i1, i2, i3, this.get(i1, i2, i3) + value);
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        }
    }

    @Override
    public void decrement(double value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        this.set(i1, i2, i3, this.get(i1, i2, i3) - value);
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        this.set(i1, i2, i3, this.get(i1, i2, i3) - value);
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        }
    }

    @Override
    public void scale(double value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        this.set(i1, i2, i3, this.get(i1, i2, i3) * value);
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        this.set(i1, i2, i3, this.get(i1, i2, i3) * value);
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        }
    }

    @Override
    public void map(DoubleFunction function) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        this.set(i1, i2, i3, function.apply(this.get(i1, i2, i3)));
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        this.set(i1, i2, i3, function.apply(this.get(i1, i2, i3)));
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        }
    }

    @Override
    public void fill(DoubleGenerator generator) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        this.set(i1, i2, i3, generator.nextDouble());
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        this.set(i1, i2, i3, generator.nextDouble());
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        }
    }

    @Override
    public void scan(DoubleScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        if (initialized) {
                            scanner.update(this.get(i1, i2, i3));
                        } else {
                            scanner.initialize(this.get(i1, i2, i3));
                            initialized = true;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        if (initialized) {
                            scanner.update(this.get(i1, i2, i3));
                        } else {
                            scanner.initialize(this.get(i1, i2, i3));
                            initialized = true;
                        }
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        }
    }

    @Override
    public double[] flatten(boolean forceCopy) {
        double[] out = new double[this.number];
        int i = -1;
        int i3 = 0;
        while (i3 < this.dim3) {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    out[++i] = this.get(i1, i2, i3);
                    ++i1;
                }
                ++i2;
            }
            ++i3;
        }
        return out;
    }

    @Override
    public double[] flatten() {
        return this.flatten(false);
    }

    @Override
    public double min() {
        double minValue = this.get(0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        if (skip) {
                            skip = false;
                        } else {
                            double value = this.get(i1, i2, i3);
                            if (value < minValue) {
                                minValue = value;
                            }
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        if (skip) {
                            skip = false;
                        } else {
                            double value = this.get(i1, i2, i3);
                            if (value < minValue) {
                                minValue = value;
                            }
                        }
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        }
        return minValue;
    }

    @Override
    public double max() {
        double maxValue = this.get(0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        if (skip) {
                            skip = false;
                        } else {
                            double value = this.get(i1, i2, i3);
                            if (value > maxValue) {
                                maxValue = value;
                            }
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        if (skip) {
                            skip = false;
                        } else {
                            double value = this.get(i1, i2, i3);
                            if (value > maxValue) {
                                maxValue = value;
                            }
                        }
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        }
        return maxValue;
    }

    @Override
    public double[] getMinAndMax() {
        double[] result = new double[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(double[] mm) {
        double minValue;
        double maxValue = minValue = this.get(0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        if (skip) {
                            skip = false;
                        } else {
                            double value = this.get(i1, i2, i3);
                            if (value < minValue) {
                                minValue = value;
                            }
                            if (value > maxValue) {
                                maxValue = value;
                            }
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        if (skip) {
                            skip = false;
                        } else {
                            double value = this.get(i1, i2, i3);
                            if (value < minValue) {
                                minValue = value;
                            }
                            if (value > maxValue) {
                                maxValue = value;
                            }
                        }
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public double sum() {
        double totalValue = 0.0;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        totalValue += this.get(i1, i2, i3);
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        totalValue += this.get(i1, i2, i3);
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        }
        return totalValue;
    }

    @Override
    public double average() {
        return this.sum() / (double)this.number;
    }

    @Override
    public Byte3D toByte() {
        byte[] out = new byte[this.number];
        int i = -1;
        int i3 = 0;
        while (i3 < this.dim3) {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    out[++i] = (byte)this.get(i1, i2, i3);
                    ++i1;
                }
                ++i2;
            }
            ++i3;
        }
        return Byte3D.wrap(out, this.dim1, this.dim2, this.dim3);
    }

    @Override
    public Short3D toShort() {
        short[] out = new short[this.number];
        int i = -1;
        int i3 = 0;
        while (i3 < this.dim3) {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    out[++i] = (short)this.get(i1, i2, i3);
                    ++i1;
                }
                ++i2;
            }
            ++i3;
        }
        return Short3D.wrap(out, this.dim1, this.dim2, this.dim3);
    }

    @Override
    public Int3D toInt() {
        int[] out = new int[this.number];
        int i = -1;
        int i3 = 0;
        while (i3 < this.dim3) {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    out[++i] = (int)this.get(i1, i2, i3);
                    ++i1;
                }
                ++i2;
            }
            ++i3;
        }
        return Int3D.wrap(out, this.dim1, this.dim2, this.dim3);
    }

    @Override
    public Long3D toLong() {
        long[] out = new long[this.number];
        int i = -1;
        int i3 = 0;
        while (i3 < this.dim3) {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    out[++i] = (long)this.get(i1, i2, i3);
                    ++i1;
                }
                ++i2;
            }
            ++i3;
        }
        return Long3D.wrap(out, this.dim1, this.dim2, this.dim3);
    }

    @Override
    public Float3D toFloat() {
        float[] out = new float[this.number];
        int i = -1;
        int i3 = 0;
        while (i3 < this.dim3) {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    out[++i] = (float)this.get(i1, i2, i3);
                    ++i1;
                }
                ++i2;
            }
            ++i3;
        }
        return Float3D.wrap(out, this.dim1, this.dim2, this.dim3);
    }

    @Override
    public Double3D toDouble() {
        return this;
    }

    @Override
    public Double3D copy() {
        return new FlatDouble3D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        Double3D src = arr.getType() == 5 ? (Double3D)arr : (Double3D)arr.toDouble();
        if (this.getOrder() == 2 && src.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        this.set(i1, i2, i3, src.get(i1, i2, i3));
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        this.set(i1, i2, i3, src.get(i1, i2, i3));
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        int i = -1;
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        this.set(i1, i2, i3, src.get(++i));
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        this.set(i1, i2, i3, src.get(++i));
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Double3D create() {
        return new FlatDouble3D(this.getShape());
    }

    public static Double3D create(int dim1, int dim2, int dim3) {
        return new FlatDouble3D(dim1, dim2, dim3);
    }

    public static Double3D create(int[] dims) {
        return new FlatDouble3D(dims);
    }

    public static Double3D create(Shape shape) {
        return new FlatDouble3D(shape);
    }

    public static Double3D wrap(double[] data, int dim1, int dim2, int dim3) {
        return new FlatDouble3D(data, dim1, dim2, dim3);
    }

    public static Double3D wrap(double[] data, int[] dims) {
        return new FlatDouble3D(data, dims);
    }

    public static Double3D wrap(double[] data, Shape shape) {
        return new FlatDouble3D(data, shape);
    }

    public static Double3D wrap(double[] data, int offset, int stride1, int stride2, int stride3, int dim1, int dim2, int dim3) {
        return new StriddenDouble3D(data, offset, stride1, stride2, stride3, dim1, dim2, dim3);
    }

    @Override
    public abstract Double2D slice(int var1);

    @Override
    public abstract Double2D slice(int var1, int var2);

    @Override
    public abstract Double3D view(Range var1, Range var2, Range var3);

    @Override
    public abstract Double3D view(int[] var1, int[] var2, int[] var3);

    @Override
    public abstract Double1D as1D();
}

