/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.base.mdarray.MDLongArray;
import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5DataBlock;
import ch.systemsx.cisd.hdf5.HDF5MDDataBlock;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlock1DParameters;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlockMDParameters;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5LongReader;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import java.util.Iterator;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;

class HDF5LongReader
implements IHDF5LongReader {
    private final HDF5BaseReader baseReader;

    HDF5LongReader(HDF5BaseReader baseReader) {
        assert (baseReader != null);
        this.baseReader = baseReader;
    }

    @Override
    public long getAttr(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<Long> getAttributeRunnable = new ICallableWithCleanUp<Long>(){

            @Override
            public Long call(ICleanUpRegistry registry) {
                int objectId = ((HDF5LongReader)HDF5LongReader.this).baseReader.h5.openObject(((HDF5LongReader)HDF5LongReader.this).baseReader.fileId, objectPath, registry);
                int attributeId = ((HDF5LongReader)HDF5LongReader.this).baseReader.h5.openAttribute(objectId, attributeName, registry);
                long[] data = ((HDF5LongReader)HDF5LongReader.this).baseReader.h5.readAttributeAsLongArray(attributeId, HDF5Constants.H5T_NATIVE_INT64, 1);
                return data[0];
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public long[] getArrayAttr(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<long[]> getAttributeRunnable = new ICallableWithCleanUp<long[]>(){

            @Override
            public long[] call(ICleanUpRegistry registry) {
                int objectId = ((HDF5LongReader)HDF5LongReader.this).baseReader.h5.openObject(((HDF5LongReader)HDF5LongReader.this).baseReader.fileId, objectPath, registry);
                return HDF5LongReader.this.getLongArrayAttribute(objectId, attributeName, registry);
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public MDLongArray getMDArrayAttr(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDLongArray> getAttributeRunnable = new ICallableWithCleanUp<MDLongArray>(){

            @Override
            public MDLongArray call(ICleanUpRegistry registry) {
                int objectId = ((HDF5LongReader)HDF5LongReader.this).baseReader.h5.openObject(((HDF5LongReader)HDF5LongReader.this).baseReader.fileId, objectPath, registry);
                return HDF5LongReader.this.getLongMDArrayAttribute(objectId, attributeName, registry);
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public long[][] getMatrixAttr(String objectPath, String attributeName) throws HDF5JavaException {
        MDLongArray array = this.getMDArrayAttr(objectPath, attributeName);
        if (array.rank() != 2) {
            throw new HDF5JavaException("Array is supposed to be of rank 2, but is of rank " + array.rank());
        }
        return array.toMatrix();
    }

    @Override
    public long read(final String objectPath) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<Long> readCallable = new ICallableWithCleanUp<Long>(){

            @Override
            public Long call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5LongReader)HDF5LongReader.this).baseReader.h5.openDataSet(((HDF5LongReader)HDF5LongReader.this).baseReader.fileId, objectPath, registry);
                long[] data = new long[1];
                ((HDF5LongReader)HDF5LongReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT64, data);
                return data[0];
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public long[] readArray(final String objectPath) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<long[]> readCallable = new ICallableWithCleanUp<long[]>(){

            @Override
            public long[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5LongReader)HDF5LongReader.this).baseReader.h5.openDataSet(((HDF5LongReader)HDF5LongReader.this).baseReader.fileId, objectPath, registry);
                return HDF5LongReader.this.readLongArray(dataSetId, registry);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    private long[] readLongArray(int dataSetId, ICleanUpRegistry registry) {
        try {
            HDF5BaseReader.DataSpaceParameters spaceParams = this.baseReader.getSpaceParameters(dataSetId, registry);
            long[] data = new long[spaceParams.blockSize];
            this.baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT64, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
            return data;
        }
        catch (HDF5LibraryException ex) {
            int dataTypeId;
            if (ex.getMajorErrorNumber() == HDF5Constants.H5E_DATATYPE && ex.getMinorErrorNumber() == HDF5Constants.H5E_CANTINIT && this.baseReader.h5.getClassType(dataTypeId = this.baseReader.h5.getDataTypeForDataSet(dataSetId, registry)) == HDF5Constants.H5T_ARRAY) {
                return this.readLongArrayFromArrayType(dataSetId, dataTypeId, registry);
            }
            throw ex;
        }
    }

    private long[] readLongArrayFromArrayType(int dataSetId, int dataTypeId, ICleanUpRegistry registry) {
        int spaceId = this.baseReader.h5.createScalarDataSpace();
        int[] dimensions = this.baseReader.h5.getArrayDimensions(dataTypeId);
        long[] data = new long[HDF5Utils.getOneDimensionalArraySize(dimensions)];
        int memoryDataTypeId = this.baseReader.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT64, data.length, registry);
        this.baseReader.h5.readDataSet(dataSetId, memoryDataTypeId, spaceId, spaceId, data);
        return data;
    }

    @Override
    public int[] readToMDArrayWithOffset(final String objectPath, final MDLongArray array, final int[] memoryOffset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<int[]> readCallable = new ICallableWithCleanUp<int[]>(){

            @Override
            public int[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5LongReader)HDF5LongReader.this).baseReader.h5.openDataSet(((HDF5LongReader)HDF5LongReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5LongReader.this.baseReader.getBlockSpaceParameters(dataSetId, memoryOffset, array.dimensions(), registry);
                int nativeDataTypeId = HDF5LongReader.this.baseReader.getNativeDataTypeId(dataSetId, HDF5Constants.H5T_NATIVE_INT64, registry);
                ((HDF5LongReader)HDF5LongReader.this).baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, array.getAsFlatArray());
                return MDArray.toInt(spaceParams.dimensions);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public int[] readToMDArrayBlockWithOffset(final String objectPath, final MDLongArray array, final int[] blockDimensions, final long[] offset, final int[] memoryOffset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<int[]> readCallable = new ICallableWithCleanUp<int[]>(){

            @Override
            public int[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5LongReader)HDF5LongReader.this).baseReader.h5.openDataSet(((HDF5LongReader)HDF5LongReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5LongReader.this.baseReader.getBlockSpaceParameters(dataSetId, memoryOffset, array.dimensions(), offset, blockDimensions, registry);
                int nativeDataTypeId = HDF5LongReader.this.baseReader.getNativeDataTypeId(dataSetId, HDF5Constants.H5T_NATIVE_INT64, registry);
                ((HDF5LongReader)HDF5LongReader.this).baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, array.getAsFlatArray());
                return MDArray.toInt(spaceParams.dimensions);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public long[] readArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.readArrayBlockWithOffset(objectPath, blockSize, blockNumber * (long)blockSize);
    }

    @Override
    public long[] readArrayBlockWithOffset(final String objectPath, final int blockSize, final long offset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<long[]> readCallable = new ICallableWithCleanUp<long[]>(){

            @Override
            public long[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5LongReader)HDF5LongReader.this).baseReader.h5.openDataSet(((HDF5LongReader)HDF5LongReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5LongReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockSize, registry);
                long[] data = new long[spaceParams.blockSize];
                ((HDF5LongReader)HDF5LongReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT64, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                return data;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public long[][] readMatrix(String objectPath) throws HDF5JavaException {
        MDLongArray array = this.readMDArray(objectPath);
        if (array.rank() != 2) {
            throw new HDF5JavaException("Array is supposed to be of rank 2, but is of rank " + array.rank());
        }
        return array.toMatrix();
    }

    @Override
    public long[][] readMatrixBlock(String objectPath, int blockSizeX, int blockSizeY, long blockNumberX, long blockNumberY) throws HDF5JavaException {
        MDLongArray array = this.readMDArrayBlock(objectPath, new int[]{blockSizeX, blockSizeY}, new long[]{blockNumberX, blockNumberY});
        if (array.rank() != 2) {
            throw new HDF5JavaException("Array is supposed to be of rank 2, but is of rank " + array.rank());
        }
        return array.toMatrix();
    }

    @Override
    public long[][] readMatrixBlockWithOffset(String objectPath, int blockSizeX, int blockSizeY, long offsetX, long offsetY) throws HDF5JavaException {
        MDLongArray array = this.readMDArrayBlockWithOffset(objectPath, new int[]{blockSizeX, blockSizeY}, new long[]{offsetX, offsetY});
        if (array.rank() != 2) {
            throw new HDF5JavaException("Array is supposed to be of rank 2, but is of rank " + array.rank());
        }
        return array.toMatrix();
    }

    @Override
    public MDLongArray readMDArray(final String objectPath) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDLongArray> readCallable = new ICallableWithCleanUp<MDLongArray>(){

            @Override
            public MDLongArray call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5LongReader)HDF5LongReader.this).baseReader.h5.openDataSet(((HDF5LongReader)HDF5LongReader.this).baseReader.fileId, objectPath, registry);
                return HDF5LongReader.this.readLongMDArray(dataSetId, registry);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    MDLongArray readLongMDArray(int dataSetId, ICleanUpRegistry registry) {
        try {
            HDF5BaseReader.DataSpaceParameters spaceParams = this.baseReader.getSpaceParameters(dataSetId, registry);
            long[] data = new long[spaceParams.blockSize];
            this.baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT64, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
            return new MDLongArray(data, spaceParams.dimensions);
        }
        catch (HDF5LibraryException ex) {
            int dataTypeId;
            if (ex.getMajorErrorNumber() == HDF5Constants.H5E_DATATYPE && ex.getMinorErrorNumber() == HDF5Constants.H5E_CANTINIT && this.baseReader.h5.getClassType(dataTypeId = this.baseReader.h5.getDataTypeForDataSet(dataSetId, registry)) == HDF5Constants.H5T_ARRAY) {
                return this.readLongMDArrayFromArrayType(dataSetId, dataTypeId, registry);
            }
            throw ex;
        }
    }

    private MDLongArray readLongMDArrayFromArrayType(int dataSetId, int dataTypeId, ICleanUpRegistry registry) {
        int spaceId = this.baseReader.h5.createScalarDataSpace();
        int[] dimensions = this.baseReader.h5.getArrayDimensions(dataTypeId);
        long[] data = new long[MDArray.getLength(dimensions)];
        int memoryDataTypeId = this.baseReader.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT64, dimensions, registry);
        this.baseReader.h5.readDataSet(dataSetId, memoryDataTypeId, spaceId, spaceId, data);
        return new MDLongArray(data, dimensions);
    }

    @Override
    public MDLongArray readMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        long[] offset = new long[blockDimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * (long)blockDimensions[i];
            ++i;
        }
        return this.readMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
    }

    @Override
    public MDLongArray readMDArrayBlockWithOffset(final String objectPath, final int[] blockDimensions, final long[] offset) {
        assert (objectPath != null);
        assert (blockDimensions != null);
        assert (offset != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDLongArray> readCallable = new ICallableWithCleanUp<MDLongArray>(){

            @Override
            public MDLongArray call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5LongReader)HDF5LongReader.this).baseReader.h5.openDataSet(((HDF5LongReader)HDF5LongReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5LongReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockDimensions, registry);
                long[] dataBlock = new long[spaceParams.blockSize];
                ((HDF5LongReader)HDF5LongReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT64, spaceParams.memorySpaceId, spaceParams.dataSpaceId, dataBlock);
                return new MDLongArray(dataBlock, blockDimensions);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public Iterable<HDF5DataBlock<long[]>> getArrayNaturalBlocks(final String dataSetPath) throws HDF5JavaException {
        this.baseReader.checkOpen();
        final HDF5NaturalBlock1DParameters params = new HDF5NaturalBlock1DParameters(this.baseReader.getDataSetInformation(dataSetPath));
        return new Iterable<HDF5DataBlock<long[]>>(){

            @Override
            public Iterator<HDF5DataBlock<long[]>> iterator() {
                return new Iterator<HDF5DataBlock<long[]>>(params){
                    final HDF5NaturalBlock1DParameters.HDF5NaturalBlock1DIndex index;
                    {
                        this.index = hDF5NaturalBlock1DParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5DataBlock<long[]> next() {
                        long offset = this.index.computeOffsetAndSizeGetOffset();
                        long[] block = HDF5LongReader.this.readArrayBlockWithOffset(dataSetPath, this.index.getBlockSize(), offset);
                        return new HDF5DataBlock<long[]>(block, this.index.getAndIncIndex(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDLongArray>> getMDArrayNaturalBlocks(final String dataSetPath) {
        this.baseReader.checkOpen();
        final HDF5NaturalBlockMDParameters params = new HDF5NaturalBlockMDParameters(this.baseReader.getDataSetInformation(dataSetPath));
        return new Iterable<HDF5MDDataBlock<MDLongArray>>(){

            @Override
            public Iterator<HDF5MDDataBlock<MDLongArray>> iterator() {
                return new Iterator<HDF5MDDataBlock<MDLongArray>>(params){
                    final HDF5NaturalBlockMDParameters.HDF5NaturalBlockMDIndex index;
                    {
                        this.index = hDF5NaturalBlockMDParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5MDDataBlock<MDLongArray> next() {
                        long[] offset = this.index.computeOffsetAndSizeGetOffsetClone();
                        MDLongArray data = HDF5LongReader.this.readMDArrayBlockWithOffset(dataSetPath, this.index.getBlockSize(), offset);
                        return new HDF5MDDataBlock<MDLongArray>(data, this.index.getIndexClone(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    long[] getLongArrayAttribute(int objectId, String attributeName, ICleanUpRegistry registry) {
        int memoryTypeId;
        int len;
        Object[] arrayDimensions;
        int attributeId = this.baseReader.h5.openAttribute(objectId, attributeName, registry);
        int attributeTypeId = this.baseReader.h5.getDataTypeForAttribute(attributeId, registry);
        if (this.baseReader.h5.getClassType(attributeTypeId) == HDF5Constants.H5T_ARRAY) {
            arrayDimensions = this.baseReader.h5.getArrayDimensions(attributeTypeId);
            if (arrayDimensions.length != 1) {
                throw new HDF5JavaException("Array needs to be of rank 1, but is of rank " + arrayDimensions.length);
            }
            len = arrayDimensions[0];
            memoryTypeId = this.baseReader.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT64, len, registry);
        } else {
            arrayDimensions = this.baseReader.h5.getDataDimensionsForAttribute(attributeId, registry);
            memoryTypeId = HDF5Constants.H5T_NATIVE_INT64;
            len = HDF5Utils.getOneDimensionalArraySize((long[])arrayDimensions);
        }
        long[] data = this.baseReader.h5.readAttributeAsLongArray(attributeId, memoryTypeId, len);
        return data;
    }

    MDLongArray getLongMDArrayAttribute(int objectId, String attributeName, ICleanUpRegistry registry) {
        try {
            int memoryTypeId;
            int[] arrayDimensions;
            int attributeId = this.baseReader.h5.openAttribute(objectId, attributeName, registry);
            int attributeTypeId = this.baseReader.h5.getDataTypeForAttribute(attributeId, registry);
            if (this.baseReader.h5.getClassType(attributeTypeId) == HDF5Constants.H5T_ARRAY) {
                arrayDimensions = this.baseReader.h5.getArrayDimensions(attributeTypeId);
                memoryTypeId = this.baseReader.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT64, arrayDimensions, registry);
            } else {
                arrayDimensions = MDArray.toInt(this.baseReader.h5.getDataDimensionsForAttribute(attributeId, registry));
                memoryTypeId = HDF5Constants.H5T_NATIVE_INT64;
            }
            int len = MDArray.getLength(arrayDimensions);
            long[] data = this.baseReader.h5.readAttributeAsLongArray(attributeId, memoryTypeId, len);
            return new MDLongArray(data, arrayDimensions);
        }
        catch (IllegalArgumentException ex) {
            throw new HDF5JavaException(ex.getMessage());
        }
    }
}

