/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array5D;
import mitiv.array.Byte5D;
import mitiv.array.Double5D;
import mitiv.array.Float1D;
import mitiv.array.Float4D;
import mitiv.array.FloatArray;
import mitiv.array.Int5D;
import mitiv.array.Long5D;
import mitiv.array.ShapedArray;
import mitiv.array.Short5D;
import mitiv.array.impl.FlatFloat5D;
import mitiv.array.impl.StriddenFloat5D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.FloatFunction;
import mitiv.base.mapping.FloatScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.FloatGenerator;

public abstract class Float5D
extends Array5D
implements FloatArray {
    protected Float5D(int dim1, int dim2, int dim3, int dim4, int dim5) {
        super(dim1, dim2, dim3, dim4, dim5);
    }

    protected Float5D(int[] dims) {
        super(dims);
    }

    protected Float5D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 4;
    }

    public abstract float get(int var1, int var2, int var3, int var4, int var5);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, float var6);

    @Override
    public void fill(float value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                this.set(i1, i2, i3, i4, i5, value);
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                this.set(i1, i2, i3, i4, i5, value);
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        }
    }

    @Override
    public void increment(float value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                this.set(i1, i2, i3, i4, i5, this.get(i1, i2, i3, i4, i5) + value);
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                this.set(i1, i2, i3, i4, i5, this.get(i1, i2, i3, i4, i5) + value);
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        }
    }

    @Override
    public void decrement(float value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                this.set(i1, i2, i3, i4, i5, this.get(i1, i2, i3, i4, i5) - value);
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                this.set(i1, i2, i3, i4, i5, this.get(i1, i2, i3, i4, i5) - value);
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        }
    }

    @Override
    public void scale(float value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                this.set(i1, i2, i3, i4, i5, this.get(i1, i2, i3, i4, i5) * value);
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                this.set(i1, i2, i3, i4, i5, this.get(i1, i2, i3, i4, i5) * value);
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        }
    }

    @Override
    public void map(FloatFunction function) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                this.set(i1, i2, i3, i4, i5, function.apply(this.get(i1, i2, i3, i4, i5)));
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                this.set(i1, i2, i3, i4, i5, function.apply(this.get(i1, i2, i3, i4, i5)));
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        }
    }

    @Override
    public void fill(FloatGenerator generator) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                this.set(i1, i2, i3, i4, i5, generator.nextFloat());
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                this.set(i1, i2, i3, i4, i5, generator.nextFloat());
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        }
    }

    @Override
    public void scan(FloatScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                if (initialized) {
                                    scanner.update(this.get(i1, i2, i3, i4, i5));
                                } else {
                                    scanner.initialize(this.get(i1, i2, i3, i4, i5));
                                    initialized = true;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                if (initialized) {
                                    scanner.update(this.get(i1, i2, i3, i4, i5));
                                } else {
                                    scanner.initialize(this.get(i1, i2, i3, i4, i5));
                                    initialized = true;
                                }
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        }
    }

    @Override
    public float[] flatten(boolean forceCopy) {
        float[] out = new float[this.number];
        int i = -1;
        int i5 = 0;
        while (i5 < this.dim5) {
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            out[++i] = this.get(i1, i2, i3, i4, i5);
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
            ++i5;
        }
        return out;
    }

    @Override
    public float[] flatten() {
        return this.flatten(false);
    }

    @Override
    public float min() {
        float minValue = this.get(0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                if (skip) {
                                    skip = false;
                                } else {
                                    float value = this.get(i1, i2, i3, i4, i5);
                                    if (value < minValue) {
                                        minValue = value;
                                    }
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                if (skip) {
                                    skip = false;
                                } else {
                                    float value = this.get(i1, i2, i3, i4, i5);
                                    if (value < minValue) {
                                        minValue = value;
                                    }
                                }
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        }
        return minValue;
    }

    @Override
    public float max() {
        float maxValue = this.get(0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                if (skip) {
                                    skip = false;
                                } else {
                                    float value = this.get(i1, i2, i3, i4, i5);
                                    if (value > maxValue) {
                                        maxValue = value;
                                    }
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                if (skip) {
                                    skip = false;
                                } else {
                                    float value = this.get(i1, i2, i3, i4, i5);
                                    if (value > maxValue) {
                                        maxValue = value;
                                    }
                                }
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        }
        return maxValue;
    }

    @Override
    public float[] getMinAndMax() {
        float[] result = new float[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(float[] mm) {
        float minValue;
        float maxValue = minValue = this.get(0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                if (skip) {
                                    skip = false;
                                } else {
                                    float value = this.get(i1, i2, i3, i4, i5);
                                    if (value < minValue) {
                                        minValue = value;
                                    }
                                    if (value > maxValue) {
                                        maxValue = value;
                                    }
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                if (skip) {
                                    skip = false;
                                } else {
                                    float value = this.get(i1, i2, i3, i4, i5);
                                    if (value < minValue) {
                                        minValue = value;
                                    }
                                    if (value > maxValue) {
                                        maxValue = value;
                                    }
                                }
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public float sum() {
        float totalValue = 0.0f;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                totalValue += this.get(i1, i2, i3, i4, i5);
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                totalValue += this.get(i1, i2, i3, i4, i5);
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        }
        return totalValue;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte5D toByte() {
        byte[] out = new byte[this.number];
        int i = -1;
        int i5 = 0;
        while (i5 < this.dim5) {
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            out[++i] = (byte)this.get(i1, i2, i3, i4, i5);
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
            ++i5;
        }
        return Byte5D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5);
    }

    @Override
    public Short5D toShort() {
        short[] out = new short[this.number];
        int i = -1;
        int i5 = 0;
        while (i5 < this.dim5) {
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            out[++i] = (short)this.get(i1, i2, i3, i4, i5);
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
            ++i5;
        }
        return Short5D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5);
    }

    @Override
    public Int5D toInt() {
        int[] out = new int[this.number];
        int i = -1;
        int i5 = 0;
        while (i5 < this.dim5) {
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            out[++i] = (int)this.get(i1, i2, i3, i4, i5);
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
            ++i5;
        }
        return Int5D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5);
    }

    @Override
    public Long5D toLong() {
        long[] out = new long[this.number];
        int i = -1;
        int i5 = 0;
        while (i5 < this.dim5) {
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            out[++i] = (long)this.get(i1, i2, i3, i4, i5);
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
            ++i5;
        }
        return Long5D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5);
    }

    @Override
    public Float5D toFloat() {
        return this;
    }

    @Override
    public Double5D toDouble() {
        double[] out = new double[this.number];
        int i = -1;
        int i5 = 0;
        while (i5 < this.dim5) {
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            out[++i] = this.get(i1, i2, i3, i4, i5);
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
            ++i5;
        }
        return Double5D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5);
    }

    @Override
    public Float5D copy() {
        return new FlatFloat5D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        Float5D src = arr.getType() == 4 ? (Float5D)arr : (Float5D)arr.toFloat();
        if (this.getOrder() == 2 && src.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                this.set(i1, i2, i3, i4, i5, src.get(i1, i2, i3, i4, i5));
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                this.set(i1, i2, i3, i4, i5, src.get(i1, i2, i3, i4, i5));
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        int i = -1;
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                this.set(i1, i2, i3, i4, i5, (float)src.get(++i));
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                this.set(i1, i2, i3, i4, i5, (float)src.get(++i));
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Float5D create() {
        return new FlatFloat5D(this.getShape());
    }

    public static Float5D create(int dim1, int dim2, int dim3, int dim4, int dim5) {
        return new FlatFloat5D(dim1, dim2, dim3, dim4, dim5);
    }

    public static Float5D create(int[] dims) {
        return new FlatFloat5D(dims);
    }

    public static Float5D create(Shape shape) {
        return new FlatFloat5D(shape);
    }

    public static Float5D wrap(float[] data, int dim1, int dim2, int dim3, int dim4, int dim5) {
        return new FlatFloat5D(data, dim1, dim2, dim3, dim4, dim5);
    }

    public static Float5D wrap(float[] data, int[] dims) {
        return new FlatFloat5D(data, dims);
    }

    public static Float5D wrap(float[] data, Shape shape) {
        return new FlatFloat5D(data, shape);
    }

    public static Float5D wrap(float[] data, int offset, int stride1, int stride2, int stride3, int stride4, int stride5, int dim1, int dim2, int dim3, int dim4, int dim5) {
        return new StriddenFloat5D(data, offset, stride1, stride2, stride3, stride4, stride5, dim1, dim2, dim3, dim4, dim5);
    }

    @Override
    public abstract Float4D slice(int var1);

    @Override
    public abstract Float4D slice(int var1, int var2);

    @Override
    public abstract Float5D view(Range var1, Range var2, Range var3, Range var4, Range var5);

    @Override
    public abstract Float5D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5);

    @Override
    public abstract Float1D as1D();
}

