/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array5D;
import mitiv.array.Byte5D;
import mitiv.array.Double1D;
import mitiv.array.Double4D;
import mitiv.array.DoubleArray;
import mitiv.array.Float5D;
import mitiv.array.Int5D;
import mitiv.array.Long5D;
import mitiv.array.ShapedArray;
import mitiv.array.Short5D;
import mitiv.array.impl.FlatDouble5D;
import mitiv.array.impl.StriddenDouble5D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.DoubleGenerator;

public abstract class Double5D
extends Array5D
implements DoubleArray {
    protected Double5D(int dim1, int dim2, int dim3, int dim4, int dim5) {
        super(dim1, dim2, dim3, dim4, dim5);
    }

    protected Double5D(int[] dims) {
        super(dims);
    }

    protected Double5D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 5;
    }

    public abstract double get(int var1, int var2, int var3, int var4, int var5);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, double var6);

    @Override
    public void fill(double value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                this.set(i1, i2, i3, i4, i5, value);
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                this.set(i1, i2, i3, i4, i5, value);
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        }
    }

    @Override
    public void increment(double value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                this.set(i1, i2, i3, i4, i5, this.get(i1, i2, i3, i4, i5) + value);
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                this.set(i1, i2, i3, i4, i5, this.get(i1, i2, i3, i4, i5) + value);
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        }
    }

    @Override
    public void decrement(double value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                this.set(i1, i2, i3, i4, i5, this.get(i1, i2, i3, i4, i5) - value);
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                this.set(i1, i2, i3, i4, i5, this.get(i1, i2, i3, i4, i5) - value);
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        }
    }

    @Override
    public void scale(double value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                this.set(i1, i2, i3, i4, i5, this.get(i1, i2, i3, i4, i5) * value);
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                this.set(i1, i2, i3, i4, i5, this.get(i1, i2, i3, i4, i5) * value);
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        }
    }

    @Override
    public void map(DoubleFunction function) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                this.set(i1, i2, i3, i4, i5, function.apply(this.get(i1, i2, i3, i4, i5)));
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                this.set(i1, i2, i3, i4, i5, function.apply(this.get(i1, i2, i3, i4, i5)));
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        }
    }

    @Override
    public void fill(DoubleGenerator generator) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                this.set(i1, i2, i3, i4, i5, generator.nextDouble());
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                this.set(i1, i2, i3, i4, i5, generator.nextDouble());
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        }
    }

    @Override
    public void scan(DoubleScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                if (initialized) {
                                    scanner.update(this.get(i1, i2, i3, i4, i5));
                                } else {
                                    scanner.initialize(this.get(i1, i2, i3, i4, i5));
                                    initialized = true;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                if (initialized) {
                                    scanner.update(this.get(i1, i2, i3, i4, i5));
                                } else {
                                    scanner.initialize(this.get(i1, i2, i3, i4, i5));
                                    initialized = true;
                                }
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        }
    }

    @Override
    public double[] flatten(boolean forceCopy) {
        double[] out = new double[this.number];
        int i = -1;
        int i5 = 0;
        while (i5 < this.dim5) {
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            out[++i] = this.get(i1, i2, i3, i4, i5);
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
            ++i5;
        }
        return out;
    }

    @Override
    public double[] flatten() {
        return this.flatten(false);
    }

    @Override
    public double min() {
        double minValue = this.get(0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                if (skip) {
                                    skip = false;
                                } else {
                                    double value = this.get(i1, i2, i3, i4, i5);
                                    if (value < minValue) {
                                        minValue = value;
                                    }
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                if (skip) {
                                    skip = false;
                                } else {
                                    double value = this.get(i1, i2, i3, i4, i5);
                                    if (value < minValue) {
                                        minValue = value;
                                    }
                                }
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        }
        return minValue;
    }

    @Override
    public double max() {
        double maxValue = this.get(0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                if (skip) {
                                    skip = false;
                                } else {
                                    double value = this.get(i1, i2, i3, i4, i5);
                                    if (value > maxValue) {
                                        maxValue = value;
                                    }
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                if (skip) {
                                    skip = false;
                                } else {
                                    double value = this.get(i1, i2, i3, i4, i5);
                                    if (value > maxValue) {
                                        maxValue = value;
                                    }
                                }
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        }
        return maxValue;
    }

    @Override
    public double[] getMinAndMax() {
        double[] result = new double[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(double[] mm) {
        double minValue;
        double maxValue = minValue = this.get(0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                if (skip) {
                                    skip = false;
                                } else {
                                    double value = this.get(i1, i2, i3, i4, i5);
                                    if (value < minValue) {
                                        minValue = value;
                                    }
                                    if (value > maxValue) {
                                        maxValue = value;
                                    }
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                if (skip) {
                                    skip = false;
                                } else {
                                    double value = this.get(i1, i2, i3, i4, i5);
                                    if (value < minValue) {
                                        minValue = value;
                                    }
                                    if (value > maxValue) {
                                        maxValue = value;
                                    }
                                }
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public double sum() {
        double totalValue = 0.0;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                totalValue += this.get(i1, i2, i3, i4, i5);
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                totalValue += this.get(i1, i2, i3, i4, i5);
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        }
        return totalValue;
    }

    @Override
    public double average() {
        return this.sum() / (double)this.number;
    }

    @Override
    public Byte5D toByte() {
        byte[] out = new byte[this.number];
        int i = -1;
        int i5 = 0;
        while (i5 < this.dim5) {
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            out[++i] = (byte)this.get(i1, i2, i3, i4, i5);
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
            ++i5;
        }
        return Byte5D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5);
    }

    @Override
    public Short5D toShort() {
        short[] out = new short[this.number];
        int i = -1;
        int i5 = 0;
        while (i5 < this.dim5) {
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            out[++i] = (short)this.get(i1, i2, i3, i4, i5);
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
            ++i5;
        }
        return Short5D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5);
    }

    @Override
    public Int5D toInt() {
        int[] out = new int[this.number];
        int i = -1;
        int i5 = 0;
        while (i5 < this.dim5) {
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            out[++i] = (int)this.get(i1, i2, i3, i4, i5);
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
            ++i5;
        }
        return Int5D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5);
    }

    @Override
    public Long5D toLong() {
        long[] out = new long[this.number];
        int i = -1;
        int i5 = 0;
        while (i5 < this.dim5) {
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            out[++i] = (long)this.get(i1, i2, i3, i4, i5);
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
            ++i5;
        }
        return Long5D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5);
    }

    @Override
    public Float5D toFloat() {
        float[] out = new float[this.number];
        int i = -1;
        int i5 = 0;
        while (i5 < this.dim5) {
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            out[++i] = (float)this.get(i1, i2, i3, i4, i5);
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
            ++i5;
        }
        return Float5D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5);
    }

    @Override
    public Double5D toDouble() {
        return this;
    }

    @Override
    public Double5D copy() {
        return new FlatDouble5D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        Double5D src = arr.getType() == 5 ? (Double5D)arr : (Double5D)arr.toDouble();
        if (this.getOrder() == 2 && src.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                this.set(i1, i2, i3, i4, i5, src.get(i1, i2, i3, i4, i5));
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                this.set(i1, i2, i3, i4, i5, src.get(i1, i2, i3, i4, i5));
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        int i = -1;
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                this.set(i1, i2, i3, i4, i5, src.get(++i));
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                this.set(i1, i2, i3, i4, i5, src.get(++i));
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Double5D create() {
        return new FlatDouble5D(this.getShape());
    }

    public static Double5D create(int dim1, int dim2, int dim3, int dim4, int dim5) {
        return new FlatDouble5D(dim1, dim2, dim3, dim4, dim5);
    }

    public static Double5D create(int[] dims) {
        return new FlatDouble5D(dims);
    }

    public static Double5D create(Shape shape) {
        return new FlatDouble5D(shape);
    }

    public static Double5D wrap(double[] data, int dim1, int dim2, int dim3, int dim4, int dim5) {
        return new FlatDouble5D(data, dim1, dim2, dim3, dim4, dim5);
    }

    public static Double5D wrap(double[] data, int[] dims) {
        return new FlatDouble5D(data, dims);
    }

    public static Double5D wrap(double[] data, Shape shape) {
        return new FlatDouble5D(data, shape);
    }

    public static Double5D wrap(double[] data, int offset, int stride1, int stride2, int stride3, int stride4, int stride5, int dim1, int dim2, int dim3, int dim4, int dim5) {
        return new StriddenDouble5D(data, offset, stride1, stride2, stride3, stride4, stride5, dim1, dim2, dim3, dim4, dim5);
    }

    @Override
    public abstract Double4D slice(int var1);

    @Override
    public abstract Double4D slice(int var1, int var2);

    @Override
    public abstract Double5D view(Range var1, Range var2, Range var3, Range var4, Range var5);

    @Override
    public abstract Double5D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5);

    @Override
    public abstract Double1D as1D();
}

