/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.Byte1D;
import mitiv.array.Double1D;
import mitiv.array.Float1D;
import mitiv.array.IntArray;
import mitiv.array.IntScalar;
import mitiv.array.Long1D;
import mitiv.array.ShapedArray;
import mitiv.array.Short1D;
import mitiv.array.impl.FlatInt1D;
import mitiv.array.impl.StriddenInt1D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.IntFunction;
import mitiv.base.mapping.IntScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.IntGenerator;

public abstract class Int1D
extends Array1D
implements IntArray {
    protected Int1D(int dim1) {
        super(dim1);
    }

    protected Int1D(int[] dims) {
        super(dims);
    }

    protected Int1D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 2;
    }

    public abstract int get(int var1);

    public abstract void set(int var1, int var2);

    @Override
    public void fill(int value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, value);
            ++i1;
        }
    }

    @Override
    public void increment(int value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, this.get(i1) + value);
            ++i1;
        }
    }

    @Override
    public void decrement(int value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, this.get(i1) - value);
            ++i1;
        }
    }

    @Override
    public void scale(int value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, this.get(i1) * value);
            ++i1;
        }
    }

    @Override
    public void map(IntFunction function) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, function.apply(this.get(i1)));
            ++i1;
        }
    }

    @Override
    public void fill(IntGenerator generator) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, generator.nextInt());
            ++i1;
        }
    }

    @Override
    public void scan(IntScanner scanner) {
        scanner.initialize(this.get(0));
        int i1 = 1;
        while (i1 < this.dim1) {
            scanner.update(this.get(i1));
            ++i1;
        }
    }

    @Override
    public int[] flatten(boolean forceCopy) {
        int[] out = new int[this.number];
        int i1 = 0;
        while (i1 < this.dim1) {
            out[i1] = this.get(i1);
            ++i1;
        }
        return out;
    }

    @Override
    public int[] flatten() {
        return this.flatten(false);
    }

    @Override
    public int min() {
        int minValue = this.get(0);
        int i1 = 1;
        while (i1 < this.dim1) {
            int value = this.get(i1);
            if (value < minValue) {
                minValue = value;
            }
            ++i1;
        }
        return minValue;
    }

    @Override
    public int max() {
        int maxValue = this.get(0);
        int i1 = 1;
        while (i1 < this.dim1) {
            int value = this.get(i1);
            if (value > maxValue) {
                maxValue = value;
            }
            ++i1;
        }
        return maxValue;
    }

    @Override
    public int[] getMinAndMax() {
        int[] result = new int[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(int[] mm) {
        int minValue;
        int maxValue = minValue = this.get(0);
        int i1 = 1;
        while (i1 < this.dim1) {
            int value = this.get(i1);
            if (value < minValue) {
                minValue = value;
            }
            if (value > maxValue) {
                maxValue = value;
            }
            ++i1;
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public int sum() {
        int totalValue = this.get(0);
        int i1 = 1;
        while (i1 < this.dim1) {
            totalValue += this.get(i1);
            ++i1;
        }
        return totalValue;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte1D toByte() {
        byte[] out = new byte[this.number];
        int i = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            out[++i] = (byte)this.get(i1);
            ++i1;
        }
        return Byte1D.wrap(out, this.dim1);
    }

    @Override
    public Short1D toShort() {
        short[] out = new short[this.number];
        int i = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            out[++i] = (short)this.get(i1);
            ++i1;
        }
        return Short1D.wrap(out, this.dim1);
    }

    @Override
    public Int1D toInt() {
        return this;
    }

    @Override
    public Long1D toLong() {
        long[] out = new long[this.number];
        int i = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            out[++i] = this.get(i1);
            ++i1;
        }
        return Long1D.wrap(out, this.dim1);
    }

    @Override
    public Float1D toFloat() {
        float[] out = new float[this.number];
        int i = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            out[++i] = this.get(i1);
            ++i1;
        }
        return Float1D.wrap(out, this.dim1);
    }

    @Override
    public Double1D toDouble() {
        double[] out = new double[this.number];
        int i = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            out[++i] = this.get(i1);
            ++i1;
        }
        return Double1D.wrap(out, this.dim1);
    }

    @Override
    public Int1D copy() {
        return new FlatInt1D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        Int1D src = arr.getType() == 2 ? (Int1D)arr : (Int1D)arr.toInt();
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, src.get(i1));
            ++i1;
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            int i1 = 0;
            while (i1 < this.dim1) {
                this.set(i1, (int)src.get(i1));
                ++i1;
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            int i1 = 0;
            while (i1 < this.dim1) {
                this.set(i1, (int)src.get(i1));
                ++i1;
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Int1D create() {
        return new FlatInt1D(this.getShape());
    }

    public static Int1D create(int dim1) {
        return new FlatInt1D(dim1);
    }

    public static Int1D create(int[] dims) {
        return new FlatInt1D(dims);
    }

    public static Int1D create(Shape shape) {
        return new FlatInt1D(shape);
    }

    public static Int1D wrap(int[] data, int dim1) {
        return new FlatInt1D(data, dim1);
    }

    public static Int1D wrap(int[] data, int[] dims) {
        return new FlatInt1D(data, dims);
    }

    public static Int1D wrap(int[] data, Shape shape) {
        return new FlatInt1D(data, shape);
    }

    public static Int1D wrap(int[] data, int offset, int stride1, int dim1) {
        return new StriddenInt1D(data, offset, stride1, dim1);
    }

    @Override
    public abstract IntScalar slice(int var1);

    @Override
    public abstract IntScalar slice(int var1, int var2);

    @Override
    public abstract Int1D view(Range var1);

    @Override
    public abstract Int1D view(int[] var1);

    @Override
    public abstract Int1D as1D();
}

