/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array2D;
import mitiv.array.Byte2D;
import mitiv.array.Double2D;
import mitiv.array.Float2D;
import mitiv.array.Int2D;
import mitiv.array.Long2D;
import mitiv.array.ShapedArray;
import mitiv.array.Short1D;
import mitiv.array.ShortArray;
import mitiv.array.impl.FlatShort2D;
import mitiv.array.impl.StriddenShort2D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.ShortGenerator;

public abstract class Short2D
extends Array2D
implements ShortArray {
    protected Short2D(int dim1, int dim2) {
        super(dim1, dim2);
    }

    protected Short2D(int[] dims) {
        super(dims);
    }

    protected Short2D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 1;
    }

    public abstract short get(int var1, int var2);

    public abstract void set(int var1, int var2, short var3);

    @Override
    public void fill(short value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    this.set(i1, i2, value);
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, value);
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void increment(short value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    this.set(i1, i2, (short)(this.get(i1, i2) + value));
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, (short)(this.get(i1, i2) + value));
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void decrement(short value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    this.set(i1, i2, (short)(this.get(i1, i2) - value));
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, (short)(this.get(i1, i2) - value));
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void scale(short value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    this.set(i1, i2, (short)(this.get(i1, i2) * value));
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, (short)(this.get(i1, i2) * value));
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void map(ShortFunction function) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    this.set(i1, i2, function.apply(this.get(i1, i2)));
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, function.apply(this.get(i1, i2)));
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void fill(ShortGenerator generator) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    this.set(i1, i2, generator.nextShort());
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, generator.nextShort());
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void scan(ShortScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    if (initialized) {
                        scanner.update(this.get(i1, i2));
                    } else {
                        scanner.initialize(this.get(i1, i2));
                        initialized = true;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    if (initialized) {
                        scanner.update(this.get(i1, i2));
                    } else {
                        scanner.initialize(this.get(i1, i2));
                        initialized = true;
                    }
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public short[] flatten(boolean forceCopy) {
        short[] out = new short[this.number];
        int i = -1;
        int i2 = 0;
        while (i2 < this.dim2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                out[++i] = this.get(i1, i2);
                ++i1;
            }
            ++i2;
        }
        return out;
    }

    @Override
    public short[] flatten() {
        return this.flatten(false);
    }

    @Override
    public short min() {
        short minValue = this.get(0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    if (skip) {
                        skip = false;
                    } else {
                        short value = this.get(i1, i2);
                        if (value < minValue) {
                            minValue = value;
                        }
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    if (skip) {
                        skip = false;
                    } else {
                        short value = this.get(i1, i2);
                        if (value < minValue) {
                            minValue = value;
                        }
                    }
                    ++i1;
                }
                ++i2;
            }
        }
        return minValue;
    }

    @Override
    public short max() {
        short maxValue = this.get(0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    if (skip) {
                        skip = false;
                    } else {
                        short value = this.get(i1, i2);
                        if (value > maxValue) {
                            maxValue = value;
                        }
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    if (skip) {
                        skip = false;
                    } else {
                        short value = this.get(i1, i2);
                        if (value > maxValue) {
                            maxValue = value;
                        }
                    }
                    ++i1;
                }
                ++i2;
            }
        }
        return maxValue;
    }

    @Override
    public short[] getMinAndMax() {
        short[] result = new short[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(short[] mm) {
        short minValue;
        short maxValue = minValue = this.get(0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    if (skip) {
                        skip = false;
                    } else {
                        short value = this.get(i1, i2);
                        if (value < minValue) {
                            minValue = value;
                        }
                        if (value > maxValue) {
                            maxValue = value;
                        }
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    if (skip) {
                        skip = false;
                    } else {
                        short value = this.get(i1, i2);
                        if (value < minValue) {
                            minValue = value;
                        }
                        if (value > maxValue) {
                            maxValue = value;
                        }
                    }
                    ++i1;
                }
                ++i2;
            }
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public int sum() {
        int totalValue = 0;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    totalValue += this.get(i1, i2);
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    totalValue += this.get(i1, i2);
                    ++i1;
                }
                ++i2;
            }
        }
        return totalValue;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte2D toByte() {
        byte[] out = new byte[this.number];
        int i = -1;
        int i2 = 0;
        while (i2 < this.dim2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                out[++i] = (byte)this.get(i1, i2);
                ++i1;
            }
            ++i2;
        }
        return Byte2D.wrap(out, this.dim1, this.dim2);
    }

    @Override
    public Short2D toShort() {
        return this;
    }

    @Override
    public Int2D toInt() {
        int[] out = new int[this.number];
        int i = -1;
        int i2 = 0;
        while (i2 < this.dim2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                out[++i] = this.get(i1, i2);
                ++i1;
            }
            ++i2;
        }
        return Int2D.wrap(out, this.dim1, this.dim2);
    }

    @Override
    public Long2D toLong() {
        long[] out = new long[this.number];
        int i = -1;
        int i2 = 0;
        while (i2 < this.dim2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                out[++i] = this.get(i1, i2);
                ++i1;
            }
            ++i2;
        }
        return Long2D.wrap(out, this.dim1, this.dim2);
    }

    @Override
    public Float2D toFloat() {
        float[] out = new float[this.number];
        int i = -1;
        int i2 = 0;
        while (i2 < this.dim2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                out[++i] = this.get(i1, i2);
                ++i1;
            }
            ++i2;
        }
        return Float2D.wrap(out, this.dim1, this.dim2);
    }

    @Override
    public Double2D toDouble() {
        double[] out = new double[this.number];
        int i = -1;
        int i2 = 0;
        while (i2 < this.dim2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                out[++i] = this.get(i1, i2);
                ++i1;
            }
            ++i2;
        }
        return Double2D.wrap(out, this.dim1, this.dim2);
    }

    @Override
    public Short2D copy() {
        return new FlatShort2D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        Short2D src = arr.getType() == 1 ? (Short2D)arr : (Short2D)arr.toShort();
        if (this.getOrder() == 2 && src.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    this.set(i1, i2, src.get(i1, i2));
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, src.get(i1, i2));
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        int i = -1;
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, (short)src.get(++i));
                    ++i1;
                }
                ++i2;
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, (short)src.get(++i));
                    ++i1;
                }
                ++i2;
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Short2D create() {
        return new FlatShort2D(this.getShape());
    }

    public static Short2D create(int dim1, int dim2) {
        return new FlatShort2D(dim1, dim2);
    }

    public static Short2D create(int[] dims) {
        return new FlatShort2D(dims);
    }

    public static Short2D create(Shape shape) {
        return new FlatShort2D(shape);
    }

    public static Short2D wrap(short[] data, int dim1, int dim2) {
        return new FlatShort2D(data, dim1, dim2);
    }

    public static Short2D wrap(short[] data, int[] dims) {
        return new FlatShort2D(data, dims);
    }

    public static Short2D wrap(short[] data, Shape shape) {
        return new FlatShort2D(data, shape);
    }

    public static Short2D wrap(short[] data, int offset, int stride1, int stride2, int dim1, int dim2) {
        return new StriddenShort2D(data, offset, stride1, stride2, dim1, dim2);
    }

    @Override
    public abstract Short1D slice(int var1);

    @Override
    public abstract Short1D slice(int var1, int var2);

    @Override
    public abstract Short2D view(Range var1, Range var2);

    @Override
    public abstract Short2D view(int[] var1, int[] var2);

    @Override
    public abstract Short1D as1D();
}

