/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Byte1D;
import mitiv.array.Byte3D;
import mitiv.array.Byte4D;
import mitiv.array.impl.FlatByte1D;
import mitiv.array.impl.FlatByte3D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedByte4D;
import mitiv.array.impl.StriddenByte3D;
import mitiv.array.impl.StriddenByte4D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ByteFunction;
import mitiv.base.mapping.ByteScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.ByteGenerator;

public class FlatByte4D
extends Byte4D {
    static final int order = 1;
    final byte[] data;
    final int dim1dim2;
    final int dim1dim2dim3;

    public FlatByte4D(int dim1, int dim2, int dim3, int dim4) {
        super(dim1, dim2, dim3, dim4);
        this.data = new byte[this.number];
        this.dim1dim2 = dim1 * dim2;
        this.dim1dim2dim3 = this.dim1dim2 * dim3;
    }

    public FlatByte4D(int[] dims) {
        super(dims);
        this.data = new byte[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
    }

    public FlatByte4D(Shape shape) {
        super(shape);
        this.data = new byte[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
    }

    public FlatByte4D(byte[] arr, int dim1, int dim2, int dim3, int dim4) {
        super(dim1, dim2, dim3, dim4);
        this.checkSize(arr);
        this.data = arr;
        this.dim1dim2 = dim1 * dim2;
        this.dim1dim2dim3 = this.dim1dim2 * dim3;
    }

    public FlatByte4D(byte[] arr, int[] dims) {
        super(dims);
        this.checkSize(arr);
        this.data = arr;
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
    }

    public FlatByte4D(byte[] arr, Shape shape) {
        super(shape);
        this.checkSize(arr);
        this.data = arr;
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null.");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small.");
        }
    }

    private void checkSize(byte[] arr) {
        if (arr == null || arr.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small.");
        }
    }

    final int index(int i1, int i2, int i3, int i4) {
        return this.dim1dim2dim3 * i4 + this.dim1dim2 * i3 + this.dim1 * i2 + i1;
    }

    @Override
    public final byte get(int i1, int i2, int i3, int i4) {
        return this.data[this.dim1dim2dim3 * i4 + this.dim1dim2 * i3 + this.dim1 * i2 + i1];
    }

    @Override
    public final void set(int i1, int i2, int i3, int i4, byte value) {
        this.data[this.dim1dim2dim3 * i4 + this.dim1dim2 * i3 + this.dim1 * i2 + i1] = value;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(byte value) {
        int j = 0;
        while (j < this.number) {
            this.data[j] = value;
            ++j;
        }
    }

    @Override
    public void fill(ByteGenerator generator) {
        int j = 0;
        while (j < this.number) {
            this.data[j] = generator.nextByte();
            ++j;
        }
    }

    @Override
    public void increment(byte value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = (byte)(this.data[n] + value);
        }
    }

    @Override
    public void decrement(byte value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = (byte)(this.data[n] - value);
        }
    }

    @Override
    public void scale(byte value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = (byte)(this.data[n] * value);
        }
    }

    @Override
    public void map(ByteFunction function) {
        int j = 0;
        while (j < this.number) {
            this.data[j] = function.apply(this.data[j]);
            ++j;
        }
    }

    @Override
    public void scan(ByteScanner scanner) {
        scanner.initialize(this.data[0]);
        int j = 1;
        while (j < this.number) {
            scanner.update(this.data[j]);
            ++j;
        }
    }

    @Override
    public byte[] flatten(boolean forceCopy) {
        if (forceCopy) {
            byte[] result = new byte[this.number];
            System.arraycopy(this.data, 0, result, 0, this.number);
            return result;
        }
        return this.data;
    }

    @Override
    public Byte3D slice(int idx) {
        if ((idx = Helper.fixIndex(idx, this.dim4)) == 0) {
            return new FlatByte3D(this.data, this.dim1, this.dim2, this.dim3);
        }
        return new StriddenByte3D(this.data, this.dim1dim2dim3 * idx, 1, this.dim1, this.dim1dim2, this.dim1, this.dim2, this.dim3);
    }

    @Override
    public Byte3D slice(int idx, int dim) {
        int sliceDim3;
        int sliceDim2;
        int sliceDim1;
        int sliceStride3;
        int sliceStride2;
        int sliceStride1;
        int sliceOffset;
        if ((dim = Helper.fixSliceIndex(dim, 4)) == 0) {
            sliceOffset = Helper.fixIndex(idx, this.dim1);
            sliceStride1 = this.dim1;
            sliceStride2 = this.dim1dim2;
            sliceStride3 = this.dim1dim2dim3;
            sliceDim1 = this.dim2;
            sliceDim2 = this.dim3;
            sliceDim3 = this.dim4;
        } else if (dim == 1) {
            sliceOffset = this.dim1 * Helper.fixIndex(idx, this.dim2);
            sliceStride1 = 1;
            sliceStride2 = this.dim1dim2;
            sliceStride3 = this.dim1dim2dim3;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim3;
            sliceDim3 = this.dim4;
        } else if (dim == 2) {
            sliceOffset = this.dim1dim2 * Helper.fixIndex(idx, this.dim3);
            sliceStride1 = 1;
            sliceStride2 = this.dim1;
            sliceStride3 = this.dim1dim2dim3;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
            sliceDim3 = this.dim4;
        } else {
            sliceOffset = this.dim1dim2dim3 * Helper.fixIndex(idx, this.dim4);
            sliceStride1 = 1;
            sliceStride2 = this.dim1;
            sliceStride3 = this.dim1dim2;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
            sliceDim3 = this.dim3;
        }
        return new StriddenByte3D(this.data, sliceOffset, sliceStride1, sliceStride2, sliceStride3, sliceDim1, sliceDim2, sliceDim3);
    }

    @Override
    public Byte4D view(Range rng1, Range rng2, Range rng3, Range rng4) {
        CompiledRange cr1 = new CompiledRange(rng1, this.dim1, 0, 1);
        CompiledRange cr2 = new CompiledRange(rng2, this.dim2, 0, this.dim1);
        CompiledRange cr3 = new CompiledRange(rng3, this.dim3, 0, this.dim1dim2);
        CompiledRange cr4 = new CompiledRange(rng4, this.dim4, 0, this.dim1dim2dim3);
        if (cr1.doesNothing() && cr2.doesNothing() && cr3.doesNothing() && cr4.doesNothing()) {
            return this;
        }
        return new StriddenByte4D(this.data, cr1.getOffset() + cr2.getOffset() + cr3.getOffset() + cr4.getOffset(), cr1.getStride(), cr2.getStride(), cr3.getStride(), cr4.getStride(), cr1.getNumber(), cr2.getNumber(), cr3.getNumber(), cr4.getNumber());
    }

    @Override
    public Byte4D view(int[] sel1, int[] sel2, int[] sel3, int[] sel4) {
        int[] idx1 = Helper.select(0, 1, this.dim1, sel1);
        int[] idx2 = Helper.select(0, this.dim1, this.dim2, sel2);
        int[] idx3 = Helper.select(0, this.dim1dim2, this.dim3, sel3);
        int[] idx4 = Helper.select(0, this.dim1dim2dim3, this.dim4, sel4);
        return new SelectedByte4D(this.data, idx1, idx2, idx3, idx4);
    }

    @Override
    public Byte1D as1D() {
        return new FlatByte1D(this.data, this.number);
    }
}

