/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Long1D;
import mitiv.array.Long2D;
import mitiv.array.Long3D;
import mitiv.array.impl.FlatLong1D;
import mitiv.array.impl.FlatLong2D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedLong3D;
import mitiv.array.impl.StriddenLong2D;
import mitiv.array.impl.StriddenLong3D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.LongFunction;
import mitiv.base.mapping.LongScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.LongGenerator;

public class FlatLong3D
extends Long3D {
    static final int order = 1;
    final long[] data;
    final int dim1dim2;

    public FlatLong3D(int dim1, int dim2, int dim3) {
        super(dim1, dim2, dim3);
        this.data = new long[this.number];
        this.dim1dim2 = dim1 * dim2;
    }

    public FlatLong3D(int[] dims) {
        super(dims);
        this.data = new long[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
    }

    public FlatLong3D(Shape shape) {
        super(shape);
        this.data = new long[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
    }

    public FlatLong3D(long[] arr, int dim1, int dim2, int dim3) {
        super(dim1, dim2, dim3);
        this.checkSize(arr);
        this.data = arr;
        this.dim1dim2 = dim1 * dim2;
    }

    public FlatLong3D(long[] arr, int[] dims) {
        super(dims);
        this.checkSize(arr);
        this.data = arr;
        this.dim1dim2 = this.dim1 * this.dim2;
    }

    public FlatLong3D(long[] arr, Shape shape) {
        super(shape);
        this.checkSize(arr);
        this.data = arr;
        this.dim1dim2 = this.dim1 * this.dim2;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null.");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small.");
        }
    }

    private void checkSize(long[] arr) {
        if (arr == null || arr.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small.");
        }
    }

    final int index(int i1, int i2, int i3) {
        return this.dim1dim2 * i3 + this.dim1 * i2 + i1;
    }

    @Override
    public final long get(int i1, int i2, int i3) {
        return this.data[this.dim1dim2 * i3 + this.dim1 * i2 + i1];
    }

    @Override
    public final void set(int i1, int i2, int i3, long value) {
        this.data[this.dim1dim2 * i3 + this.dim1 * i2 + i1] = value;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(long value) {
        int j = 0;
        while (j < this.number) {
            this.data[j] = value;
            ++j;
        }
    }

    @Override
    public void fill(LongGenerator generator) {
        int j = 0;
        while (j < this.number) {
            this.data[j] = generator.nextLong();
            ++j;
        }
    }

    @Override
    public void increment(long value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = this.data[n] + value;
        }
    }

    @Override
    public void decrement(long value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = this.data[n] - value;
        }
    }

    @Override
    public void scale(long value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = this.data[n] * value;
        }
    }

    @Override
    public void map(LongFunction function) {
        int j = 0;
        while (j < this.number) {
            this.data[j] = function.apply(this.data[j]);
            ++j;
        }
    }

    @Override
    public void scan(LongScanner scanner) {
        scanner.initialize(this.data[0]);
        int j = 1;
        while (j < this.number) {
            scanner.update(this.data[j]);
            ++j;
        }
    }

    @Override
    public long[] flatten(boolean forceCopy) {
        if (forceCopy) {
            long[] result = new long[this.number];
            System.arraycopy(this.data, 0, result, 0, this.number);
            return result;
        }
        return this.data;
    }

    @Override
    public Long2D slice(int idx) {
        if ((idx = Helper.fixIndex(idx, this.dim3)) == 0) {
            return new FlatLong2D(this.data, this.dim1, this.dim2);
        }
        return new StriddenLong2D(this.data, this.dim1dim2 * idx, 1, this.dim1, this.dim1, this.dim2);
    }

    @Override
    public Long2D slice(int idx, int dim) {
        int sliceDim2;
        int sliceDim1;
        int sliceStride2;
        int sliceStride1;
        int sliceOffset;
        if ((dim = Helper.fixSliceIndex(dim, 3)) == 0) {
            sliceOffset = Helper.fixIndex(idx, this.dim1);
            sliceStride1 = this.dim1;
            sliceStride2 = this.dim1dim2;
            sliceDim1 = this.dim2;
            sliceDim2 = this.dim3;
        } else if (dim == 1) {
            sliceOffset = this.dim1 * Helper.fixIndex(idx, this.dim2);
            sliceStride1 = 1;
            sliceStride2 = this.dim1dim2;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim3;
        } else {
            sliceOffset = this.dim1dim2 * Helper.fixIndex(idx, this.dim3);
            sliceStride1 = 1;
            sliceStride2 = this.dim1;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
        }
        return new StriddenLong2D(this.data, sliceOffset, sliceStride1, sliceStride2, sliceDim1, sliceDim2);
    }

    @Override
    public Long3D view(Range rng1, Range rng2, Range rng3) {
        CompiledRange cr1 = new CompiledRange(rng1, this.dim1, 0, 1);
        CompiledRange cr2 = new CompiledRange(rng2, this.dim2, 0, this.dim1);
        CompiledRange cr3 = new CompiledRange(rng3, this.dim3, 0, this.dim1dim2);
        if (cr1.doesNothing() && cr2.doesNothing() && cr3.doesNothing()) {
            return this;
        }
        return new StriddenLong3D(this.data, cr1.getOffset() + cr2.getOffset() + cr3.getOffset(), cr1.getStride(), cr2.getStride(), cr3.getStride(), cr1.getNumber(), cr2.getNumber(), cr3.getNumber());
    }

    @Override
    public Long3D view(int[] sel1, int[] sel2, int[] sel3) {
        int[] idx1 = Helper.select(0, 1, this.dim1, sel1);
        int[] idx2 = Helper.select(0, this.dim1, this.dim2, sel2);
        int[] idx3 = Helper.select(0, this.dim1dim2, this.dim3, sel3);
        return new SelectedLong3D(this.data, idx1, idx2, idx3);
    }

    @Override
    public Long1D as1D() {
        return new FlatLong1D(this.data, this.number);
    }
}

