/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Short1D;
import mitiv.array.Short4D;
import mitiv.array.Short5D;
import mitiv.array.impl.FlatShort1D;
import mitiv.array.impl.FlatShort4D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedShort5D;
import mitiv.array.impl.StriddenShort4D;
import mitiv.array.impl.StriddenShort5D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.ShortGenerator;

public class FlatShort5D
extends Short5D {
    static final int order = 1;
    final short[] data;
    final int dim1dim2;
    final int dim1dim2dim3;
    final int dim1dim2dim3dim4;

    public FlatShort5D(int dim1, int dim2, int dim3, int dim4, int dim5) {
        super(dim1, dim2, dim3, dim4, dim5);
        this.data = new short[this.number];
        this.dim1dim2 = dim1 * dim2;
        this.dim1dim2dim3 = this.dim1dim2 * dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * dim4;
    }

    public FlatShort5D(int[] dims) {
        super(dims);
        this.data = new short[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
    }

    public FlatShort5D(Shape shape) {
        super(shape);
        this.data = new short[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
    }

    public FlatShort5D(short[] arr, int dim1, int dim2, int dim3, int dim4, int dim5) {
        super(dim1, dim2, dim3, dim4, dim5);
        this.checkSize(arr);
        this.data = arr;
        this.dim1dim2 = dim1 * dim2;
        this.dim1dim2dim3 = this.dim1dim2 * dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * dim4;
    }

    public FlatShort5D(short[] arr, int[] dims) {
        super(dims);
        this.checkSize(arr);
        this.data = arr;
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
    }

    public FlatShort5D(short[] arr, Shape shape) {
        super(shape);
        this.checkSize(arr);
        this.data = arr;
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null.");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small.");
        }
    }

    private void checkSize(short[] arr) {
        if (arr == null || arr.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small.");
        }
    }

    final int index(int i1, int i2, int i3, int i4, int i5) {
        return this.dim1dim2dim3dim4 * i5 + this.dim1dim2dim3 * i4 + this.dim1dim2 * i3 + this.dim1 * i2 + i1;
    }

    @Override
    public final short get(int i1, int i2, int i3, int i4, int i5) {
        return this.data[this.dim1dim2dim3dim4 * i5 + this.dim1dim2dim3 * i4 + this.dim1dim2 * i3 + this.dim1 * i2 + i1];
    }

    @Override
    public final void set(int i1, int i2, int i3, int i4, int i5, short value) {
        this.data[this.dim1dim2dim3dim4 * i5 + this.dim1dim2dim3 * i4 + this.dim1dim2 * i3 + this.dim1 * i2 + i1] = value;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(short value) {
        int j = 0;
        while (j < this.number) {
            this.data[j] = value;
            ++j;
        }
    }

    @Override
    public void fill(ShortGenerator generator) {
        int j = 0;
        while (j < this.number) {
            this.data[j] = generator.nextShort();
            ++j;
        }
    }

    @Override
    public void increment(short value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = (short)(this.data[n] + value);
        }
    }

    @Override
    public void decrement(short value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = (short)(this.data[n] - value);
        }
    }

    @Override
    public void scale(short value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = (short)(this.data[n] * value);
        }
    }

    @Override
    public void map(ShortFunction function) {
        int j = 0;
        while (j < this.number) {
            this.data[j] = function.apply(this.data[j]);
            ++j;
        }
    }

    @Override
    public void scan(ShortScanner scanner) {
        scanner.initialize(this.data[0]);
        int j = 1;
        while (j < this.number) {
            scanner.update(this.data[j]);
            ++j;
        }
    }

    @Override
    public short[] flatten(boolean forceCopy) {
        if (forceCopy) {
            short[] result = new short[this.number];
            System.arraycopy(this.data, 0, result, 0, this.number);
            return result;
        }
        return this.data;
    }

    @Override
    public Short4D slice(int idx) {
        if ((idx = Helper.fixIndex(idx, this.dim5)) == 0) {
            return new FlatShort4D(this.data, this.dim1, this.dim2, this.dim3, this.dim4);
        }
        return new StriddenShort4D(this.data, this.dim1dim2dim3dim4 * idx, 1, this.dim1, this.dim1dim2, this.dim1dim2dim3, this.dim1, this.dim2, this.dim3, this.dim4);
    }

    @Override
    public Short4D slice(int idx, int dim) {
        int sliceDim4;
        int sliceDim3;
        int sliceDim2;
        int sliceDim1;
        int sliceStride4;
        int sliceStride3;
        int sliceStride2;
        int sliceStride1;
        int sliceOffset;
        if ((dim = Helper.fixSliceIndex(dim, 5)) == 0) {
            sliceOffset = Helper.fixIndex(idx, this.dim1);
            sliceStride1 = this.dim1;
            sliceStride2 = this.dim1dim2;
            sliceStride3 = this.dim1dim2dim3;
            sliceStride4 = this.dim1dim2dim3dim4;
            sliceDim1 = this.dim2;
            sliceDim2 = this.dim3;
            sliceDim3 = this.dim4;
            sliceDim4 = this.dim5;
        } else if (dim == 1) {
            sliceOffset = this.dim1 * Helper.fixIndex(idx, this.dim2);
            sliceStride1 = 1;
            sliceStride2 = this.dim1dim2;
            sliceStride3 = this.dim1dim2dim3;
            sliceStride4 = this.dim1dim2dim3dim4;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim3;
            sliceDim3 = this.dim4;
            sliceDim4 = this.dim5;
        } else if (dim == 2) {
            sliceOffset = this.dim1dim2 * Helper.fixIndex(idx, this.dim3);
            sliceStride1 = 1;
            sliceStride2 = this.dim1;
            sliceStride3 = this.dim1dim2dim3;
            sliceStride4 = this.dim1dim2dim3dim4;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
            sliceDim3 = this.dim4;
            sliceDim4 = this.dim5;
        } else if (dim == 3) {
            sliceOffset = this.dim1dim2dim3 * Helper.fixIndex(idx, this.dim4);
            sliceStride1 = 1;
            sliceStride2 = this.dim1;
            sliceStride3 = this.dim1dim2;
            sliceStride4 = this.dim1dim2dim3dim4;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
            sliceDim3 = this.dim3;
            sliceDim4 = this.dim5;
        } else {
            sliceOffset = this.dim1dim2dim3dim4 * Helper.fixIndex(idx, this.dim5);
            sliceStride1 = 1;
            sliceStride2 = this.dim1;
            sliceStride3 = this.dim1dim2;
            sliceStride4 = this.dim1dim2dim3;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
            sliceDim3 = this.dim3;
            sliceDim4 = this.dim4;
        }
        return new StriddenShort4D(this.data, sliceOffset, sliceStride1, sliceStride2, sliceStride3, sliceStride4, sliceDim1, sliceDim2, sliceDim3, sliceDim4);
    }

    @Override
    public Short5D view(Range rng1, Range rng2, Range rng3, Range rng4, Range rng5) {
        CompiledRange cr1 = new CompiledRange(rng1, this.dim1, 0, 1);
        CompiledRange cr2 = new CompiledRange(rng2, this.dim2, 0, this.dim1);
        CompiledRange cr3 = new CompiledRange(rng3, this.dim3, 0, this.dim1dim2);
        CompiledRange cr4 = new CompiledRange(rng4, this.dim4, 0, this.dim1dim2dim3);
        CompiledRange cr5 = new CompiledRange(rng5, this.dim5, 0, this.dim1dim2dim3dim4);
        if (cr1.doesNothing() && cr2.doesNothing() && cr3.doesNothing() && cr4.doesNothing() && cr5.doesNothing()) {
            return this;
        }
        return new StriddenShort5D(this.data, cr1.getOffset() + cr2.getOffset() + cr3.getOffset() + cr4.getOffset() + cr5.getOffset(), cr1.getStride(), cr2.getStride(), cr3.getStride(), cr4.getStride(), cr5.getStride(), cr1.getNumber(), cr2.getNumber(), cr3.getNumber(), cr4.getNumber(), cr5.getNumber());
    }

    @Override
    public Short5D view(int[] sel1, int[] sel2, int[] sel3, int[] sel4, int[] sel5) {
        int[] idx1 = Helper.select(0, 1, this.dim1, sel1);
        int[] idx2 = Helper.select(0, this.dim1, this.dim2, sel2);
        int[] idx3 = Helper.select(0, this.dim1dim2, this.dim3, sel3);
        int[] idx4 = Helper.select(0, this.dim1dim2dim3, this.dim4, sel4);
        int[] idx5 = Helper.select(0, this.dim1dim2dim3dim4, this.dim5, sel5);
        return new SelectedShort5D(this.data, idx1, idx2, idx3, idx4, idx5);
    }

    @Override
    public Short1D as1D() {
        return new FlatShort1D(this.data, this.number);
    }
}

