/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Long1D;
import mitiv.array.LongScalar;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedLong1D;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.LongFunction;
import mitiv.base.mapping.LongScanner;
import mitiv.random.LongGenerator;

public class StriddenLong1D
extends Long1D {
    final int order;
    final long[] data;
    final int offset;
    final int stride1;

    public StriddenLong1D(long[] arr, int offset, int[] stride, int[] dims) {
        super(dims);
        if (stride.length != 1) {
            throw new IllegalArgumentException("There must be as many strides as the rank.");
        }
        this.data = arr;
        this.offset = offset;
        this.stride1 = stride[0];
        this.order = Long1D.checkViewStrides(this.data.length, offset, this.stride1, this.dim1);
    }

    public StriddenLong1D(long[] arr, int offset, int stride1, int dim1) {
        super(dim1);
        this.data = arr;
        this.offset = offset;
        this.stride1 = stride1;
        this.order = Long1D.checkViewStrides(this.data.length, offset, stride1, dim1);
    }

    @Override
    public void checkSanity() {
        Long1D.checkViewStrides(this.data.length, this.offset, this.stride1, this.dim1);
    }

    private boolean isFlat() {
        return this.offset == 0 && this.stride1 == 1;
    }

    final int index(int i1) {
        return this.offset + this.stride1 * i1;
    }

    @Override
    public final long get(int i1) {
        return this.data[this.offset + this.stride1 * i1];
    }

    @Override
    public final void set(int i1, long value) {
        this.data[this.offset + this.stride1 * i1] = value;
    }

    @Override
    public final int getOrder() {
        return this.order;
    }

    @Override
    public void fill(long value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            int j1 = this.stride1 * i1 + this.offset;
            this.data[j1] = value;
            ++i1;
        }
    }

    @Override
    public void fill(LongGenerator generator) {
        int i1 = 0;
        while (i1 < this.dim1) {
            int j1 = this.stride1 * i1 + this.offset;
            this.data[j1] = generator.nextLong();
            ++i1;
        }
    }

    @Override
    public void increment(long value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            int j1;
            int n = j1 = this.stride1 * i1 + this.offset;
            this.data[n] = this.data[n] + value;
            ++i1;
        }
    }

    @Override
    public void decrement(long value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            int j1;
            int n = j1 = this.stride1 * i1 + this.offset;
            this.data[n] = this.data[n] - value;
            ++i1;
        }
    }

    @Override
    public void scale(long value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            int j1;
            int n = j1 = this.stride1 * i1 + this.offset;
            this.data[n] = this.data[n] * value;
            ++i1;
        }
    }

    @Override
    public void map(LongFunction function) {
        int i1 = 0;
        while (i1 < this.dim1) {
            int j1 = this.stride1 * i1 + this.offset;
            this.data[j1] = function.apply(this.data[j1]);
            ++i1;
        }
    }

    @Override
    public void scan(LongScanner scanner) {
        boolean initialized = false;
        int i1 = 0;
        while (i1 < this.dim1) {
            int j1 = this.stride1 * i1 + this.offset;
            if (initialized) {
                scanner.update(this.data[j1]);
            } else {
                scanner.initialize(this.data[j1]);
                initialized = true;
            }
            ++i1;
        }
    }

    @Override
    public long[] flatten(boolean forceCopy) {
        if (!forceCopy && this.isFlat()) {
            return this.data;
        }
        long[] out = new long[this.number];
        int j = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            int j1 = this.stride1 * i1 + this.offset;
            out[++j] = this.data[j1];
            ++i1;
        }
        return out;
    }

    @Override
    public LongScalar slice(int idx) {
        return new LongScalar(this.data, this.offset + this.stride1 * idx);
    }

    @Override
    public LongScalar slice(int idx, int dim) {
        if (dim < 0) {
            ++dim;
        }
        if (dim != 0) {
            throw new IndexOutOfBoundsException("Dimension index out of bounds.");
        }
        int sliceOffset = this.offset + this.stride1 * idx;
        return new LongScalar(this.data, sliceOffset);
    }

    @Override
    public Long1D view(Range rng1) {
        CompiledRange cr1 = new CompiledRange(rng1, this.dim1, this.offset, this.stride1);
        if (cr1.doesNothing()) {
            return this;
        }
        return new StriddenLong1D(this.data, cr1.getOffset(), cr1.getStride(), cr1.getNumber());
    }

    @Override
    public Long1D view(int[] sel1) {
        int[] idx1 = Helper.select(this.offset, this.stride1, this.dim1, sel1);
        return new SelectedLong1D(this.data, idx1);
    }

    @Override
    public Long1D as1D() {
        return this;
    }
}

