/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv;

import mitiv.exception.IncorrectSpaceException;
import mitiv.exception.NotImplementedException;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.RealComplexFFT;
import mitiv.linalg.shaped.ShapedLinearOperator;
import mitiv.linalg.shaped.ShapedVectorSpace;

public class ConvolutionOperator
extends ShapedLinearOperator {
    protected RealComplexFFT FFT = null;
    protected Vector mtf;
    protected Vector tmp;
    protected final int number;
    private final boolean single;

    public ConvolutionOperator(RealComplexFFT FFT, Vector psf) {
        this(FFT, psf, null);
    }

    public ConvolutionOperator(RealComplexFFT FFT, Vector psf, Vector mtf) {
        super(FFT.getInputSpace());
        ShapedVectorSpace realSpace = FFT.getInputSpace();
        ShapedVectorSpace complexSpace = FFT.getOutputSpace();
        if (psf != null && !psf.belongsTo(realSpace)) {
            throw new IncorrectSpaceException("PSF must belong to the input space of the FFT operator");
        }
        if (mtf != null && !mtf.belongsTo(complexSpace)) {
            throw new IncorrectSpaceException("MTF must belong to the output space of the FFT operator");
        }
        if (mtf == null) {
            if (psf == null) {
                throw new NullPointerException("At least one of PSF or MTF must be non-null");
            }
            this.mtf = complexSpace.create();
            FFT.apply(this.mtf, psf);
        } else {
            this.mtf = mtf;
        }
        this.FFT = FFT;
        this.tmp = complexSpace.create();
        this.number = realSpace.getNumber();
        int type = realSpace.getType();
        boolean bl = this.single = type == 4;
        if (!this.single && type != 5) {
            throw new IllegalArgumentException("Only float and double types supported");
        }
    }

    @Override
    protected void _apply(Vector dst, Vector src, int job) {
        if (job != DIRECT && job != ADJOINT) {
            throw new NotImplementedException("For now we do not implement inverse convolution operations (talk to \u00c9ric if you ignore the dangers of doing that!)");
        }
        this.FFT.apply(this.tmp, src, DIRECT);
        if (this.single) {
            float[] h = ((FloatShapedVector)this.mtf).getData();
            float[] z = ((FloatShapedVector)this.tmp).getData();
            if (job == DIRECT) {
                int k = 0;
                while (k < this.number) {
                    int real = k + k;
                    int imag = real + 1;
                    float h_re = h[real];
                    float h_im = h[imag];
                    float z_re = z[real];
                    float z_im = z[imag];
                    z[real] = h_re * z_re - h_im * z_im;
                    z[imag] = h_re * z_im + h_im * z_re;
                    ++k;
                }
            } else {
                int k = 0;
                while (k < this.number) {
                    int real = k + k;
                    int imag = real + 1;
                    float h_re = h[real];
                    float h_im = h[imag];
                    float z_re = z[real];
                    float z_im = z[imag];
                    z[real] = h_re * z_re + h_im * z_im;
                    z[imag] = h_re * z_im - h_im * z_re;
                    ++k;
                }
            }
        } else {
            double[] h = ((DoubleShapedVector)this.mtf).getData();
            double[] z = ((DoubleShapedVector)this.tmp).getData();
            if (job == DIRECT) {
                int k = 0;
                while (k < this.number) {
                    int real = k + k;
                    int imag = real + 1;
                    double h_re = h[real];
                    double h_im = h[imag];
                    double z_re = z[real];
                    double z_im = z[imag];
                    z[real] = h_re * z_re - h_im * z_im;
                    z[imag] = h_re * z_im + h_im * z_re;
                    ++k;
                }
            } else {
                int k = 0;
                while (k < this.number) {
                    int real = k + k;
                    int imag = real + 1;
                    double h_re = h[real];
                    double h_im = h[imag];
                    double z_re = z[real];
                    double z_im = z[imag];
                    z[real] = h_re * z_re + h_im * z_im;
                    z[imag] = h_re * z_im - h_im * z_re;
                    ++k;
                }
            }
        }
        this.FFT.apply(dst, this.tmp, INVERSE);
    }
}

