/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.FloatShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.utils.CommonUtils;
import org.jtransforms.fft.DoubleFFT_1D;
import org.jtransforms.fft.DoubleFFT_3D;
import org.jtransforms.fft.FloatFFT_1D;

public class DeconvUtils {
    private BufferedImage image;
    private BufferedImage image_psf;
    private DoubleFFT_1D fft1D;
    private FloatFFT_1D fft1DFloat;
    public int sizePadding = -1;
    private ShapedVector imageVect;
    private ShapedVector imagePsfVect;
    private ShapedVectorSpace imageSpace;
    private ShapedVectorSpace imageSpaceComplex;
    private boolean single = true;
    boolean isComplex;
    private ShapedArray imgShaped;
    private ShapedArray psfShaped;
    public int sizeZ;
    private DoubleFFT_3D fft3D;
    public static final int JOB_WIENER = 0;
    public static final int JOB_QUAD = 1;
    public static final int JOB_CG = 2;
    public int width;
    public int height;

    private void setValue() {
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
        if (this.image_psf.getWidth() > this.image.getWidth() || this.image_psf.getHeight() > this.image.getHeight()) {
            throw new IllegalArgumentException("PSF is too large");
        }
    }

    public void readImage(String pathImage, String pathPSF) {
        try {
            this.readImage(ImageIO.read(new File(pathImage)), ImageIO.read(new File(pathPSF)));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Wrong path given");
        }
    }

    public void readImage(BufferedImage image, BufferedImage PSF) {
        this.readImage(image, PSF, false);
    }

    public void readImage(BufferedImage image, BufferedImage PSF, Boolean padding) {
        if (padding.booleanValue()) {
            this.sizePadding = CommonUtils.estimatePsfSize(PSF);
            this.image = CommonUtils.imagePad(image, this.sizePadding);
        } else {
            this.image = image;
        }
        this.image_psf = PSF;
        this.setValue();
    }

    public void readImage(ShapedArray imgList, ShapedArray psfList) {
        this.imgShaped = imgList;
        this.psfShaped = psfList;
        Shape shape = imgList.getShape();
        this.width = shape.dimension(0);
        this.height = shape.dimension(1);
        this.sizeZ = shape.rank() == 3 ? shape.dimension(2) : 1;
    }

    public void readImageVect(String pathImage, String pathPSF, boolean singlePrecision) {
        try {
            this.readImageVect(ImageIO.read(new File(pathImage)), ImageIO.read(new File(pathPSF)), singlePrecision);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Wrong path given");
        }
    }

    public void readImageVect(BufferedImage image, BufferedImage PSF, boolean singlePrecision) {
        this.readImageVect(image, PSF, false, singlePrecision, true);
    }

    public void readImageVect(ArrayList<BufferedImage> image, ArrayList<BufferedImage> PSF, boolean singlePrecision) {
        throw new RuntimeException("Not implemented yet");
    }

    public void readImageVect(BufferedImage image, BufferedImage PSF, Boolean padding, boolean singlePrecision, boolean isComplex) {
        if (singlePrecision) {
            this.imageSpace = new FloatShapedVectorSpace(image.getHeight(), image.getWidth());
            FloatShapedVectorSpace psfSpace = new FloatShapedVectorSpace(PSF.getWidth(), PSF.getHeight());
            this.imageSpaceComplex = new FloatShapedVectorSpace(image.getHeight() * 2, image.getWidth());
            this.imageVect = CommonUtils.imageToVector(this.imageSpace, image, singlePrecision, isComplex);
            this.imagePsfVect = CommonUtils.imageToVector(psfSpace, PSF, singlePrecision, isComplex);
        } else {
            this.imageSpace = new DoubleShapedVectorSpace(image.getHeight(), image.getWidth());
            DoubleShapedVectorSpace psfSpace = new DoubleShapedVectorSpace(PSF.getHeight(), PSF.getWidth());
            this.imageSpaceComplex = new DoubleShapedVectorSpace(image.getHeight() * 2, image.getWidth());
            this.imageVect = isComplex ? CommonUtils.imageToVector(this.imageSpaceComplex, image, singlePrecision, isComplex) : CommonUtils.imageToVector(this.imageSpace, image, singlePrecision, isComplex);
            this.imagePsfVect = CommonUtils.imageToVector(psfSpace, PSF, singlePrecision, false);
        }
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.single = singlePrecision;
        this.image = image;
        this.image_psf = PSF;
        this.isComplex = isComplex;
    }

    public void PadImageAndPSF(double coef) {
        this.sizeZ = (int)((double)this.sizeZ * coef);
        this.width = (int)((double)this.width * coef);
        this.height = (int)((double)this.height * coef);
    }

    public ShapedVector cloneImageVect() {
        return this.imageVect.getSpace().clone(this.imageVect);
    }

    public ShapedVector getImageVect() {
        return this.imageVect;
    }

    public ShapedVector clonePsfVect() {
        return this.imagePsfVect.getSpace().clone(this.imagePsfVect);
    }

    public ShapedVector getPSfVect() {
        return this.imagePsfVect;
    }

    public ShapedVector getPsfPadVect() {
        return CommonUtils.psfPadding1D(this.imageSpace, this.imageSpaceComplex, this.imagePsfVect, this.single, this.isComplex);
    }

    public BufferedImage arrayToImage(ShapedVector vector, int correction, boolean isComplex) {
        return CommonUtils.vectorToImage(this.imageSpace, vector, correction, this.single, isComplex);
    }

    public double[] imageToArray1D(boolean isComplex) {
        return CommonUtils.imageToArray1D(this.image, isComplex);
    }

    public double[] psfToArray1D(boolean isComplex) {
        if (this.image_psf.getWidth() != this.image.getWidth() || this.image_psf.getHeight() != this.image.getHeight()) {
            throw new IllegalArgumentException("The PSF should be of same size as image (No scale for now when splitted)");
        }
        return CommonUtils.imageToArray1D(this.image_psf, isComplex);
    }

    public double[] image3DToArray1D(boolean isComplex) {
        return this.imgShaped.toDouble().flatten();
    }

    public double[] psf3DToArray1Dexp(boolean isComplex) {
        return this.psfShaped.toDouble().flatten();
    }

    public double[] shiftPsf3DToArray1D(boolean isComplex) {
        double[] out = isComplex ? new double[this.width * this.height * this.sizeZ * 2] : new double[this.width * this.height * this.sizeZ];
        double[] psfIn = this.psfShaped.toDouble().flatten();
        if (psfIn.length != out.length) {
            System.err.println("Bad size for psf and output deconvutil l356");
        }
        CommonUtils.fftShift3D(psfIn, out, this.width, this.height, this.sizeZ);
        return out;
    }

    public float[] imageToArray1DFloat(boolean isComplex) {
        return CommonUtils.imageToArray1DFloat(this.image, isComplex);
    }

    public BufferedImage arrayToImage1D(double[] array, int job, boolean isComplex) {
        return CommonUtils.arrayToImage1D(array, job, this.image.getWidth(), this.image.getHeight(), isComplex);
    }

    public BufferedImage arrayToImage1D(float[] array, int job, boolean isComplex) {
        return CommonUtils.arrayToImage1D(array, job, this.image.getWidth(), this.image.getHeight(), isComplex);
    }

    public ArrayList<BufferedImage> arrayToImage3D(double[] array, int job, boolean isComplex) {
        ArrayList<BufferedImage> out = new ArrayList<BufferedImage>();
        if (isComplex) {
            double[] tmp = new double[this.width * this.height * 2];
            int j = 0;
            while (j < this.sizeZ) {
                int i = 0;
                while (i < this.width * this.height * 2) {
                    tmp[i] = array[i + 2 * j * this.height * this.width];
                    ++i;
                }
                out.add(CommonUtils.arrayToImage1D(tmp, job, this.width, this.height, true));
                ++j;
            }
        } else {
            double[] tmp = new double[this.width * this.height];
            int j = 0;
            while (j < this.sizeZ) {
                int i = 0;
                while (i < this.width * this.height) {
                    tmp[i] = array[i + j * this.height * this.width];
                    ++i;
                }
                out.add(CommonUtils.arrayToImage1D(tmp, job, this.width, this.height, false));
                ++j;
            }
        }
        return out;
    }

    private void scale(double[] array) {
        double scale = 1.0 / (double)(this.width * this.height);
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = array[n] * scale;
        }
    }

    private void scale(float[] array) {
        double scale = 1.0 / (double)(this.width * this.height);
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = (float)((double)array[n] * scale);
        }
    }

    public void FFT1D(double[] array) {
        if (this.fft1D == null) {
            this.fft1D = new DoubleFFT_1D((long)(this.width * this.height));
        }
        this.fft1D.realForwardFull(array);
    }

    public void FFT1DComplex(double[] array) {
        if (this.fft1D == null) {
            this.fft1D = new DoubleFFT_1D((long)(this.width * this.height));
        }
        this.fft1D.complexForward(array);
    }

    public void FFT3D(double[] array) {
        if (this.fft3D == null) {
            this.fft3D = new DoubleFFT_3D((long)this.sizeZ, (long)this.height, (long)this.width);
        }
        this.fft3D.realForwardFull(array);
    }

    public void FFT3DComplex(double[] array) {
        if (this.fft3D == null) {
            this.fft3D = new DoubleFFT_3D((long)this.sizeZ, (long)this.height, (long)this.width);
        }
        this.fft3D.complexForward(array);
    }

    public void IFFT3D(double[] array) {
        this.fft3D.complexInverse(array, true);
    }

    public void FFT1D(float[] array) {
        if (this.fft1DFloat == null) {
            this.fft1DFloat = new FloatFFT_1D((long)(this.width * this.height));
        }
        this.fft1DFloat.realForwardFull(array);
    }

    public void IFFT1D(double[] array) {
        this.fft1D.complexInverse(array, false);
        this.scale(array);
    }

    public void IFFT1D(float[] array) {
        this.fft1DFloat.complexInverse(array, false);
        this.scale(array);
    }

    public void FFT1D(ShapedVector vector) {
        if (this.single) {
            FloatShapedVector vectorFloat = (FloatShapedVector)vector;
            float[] array = vectorFloat.getData();
            int size = this.imageSpace.getNumber();
            if (this.fft1DFloat == null) {
                this.fft1DFloat = new FloatFFT_1D((long)size);
            }
            this.fft1DFloat.realForwardFull(array);
        } else {
            DoubleShapedVector vectorDouble = (DoubleShapedVector)vector;
            double[] array = vectorDouble.getData();
            int size = this.imageSpace.getNumber();
            if (this.fft1D == null) {
                this.fft1D = new DoubleFFT_1D((long)size);
            }
            this.fft1D.realForwardFull(array);
        }
    }

    public void IFFT1D(ShapedVector vector) {
        if (this.single) {
            FloatShapedVector vectorFloat = (FloatShapedVector)vector;
            float[] array = vectorFloat.getData();
            this.fft1DFloat.complexInverse(array, true);
        } else {
            DoubleShapedVector vectorDouble = (DoubleShapedVector)vector;
            double[] array = vectorDouble.getData();
            this.fft1D.complexInverse(array, true);
        }
    }

    public double[] psfPadding1D(boolean isComplex) {
        return CommonUtils.psfPadding1D(this.image, this.image_psf, isComplex);
    }

    public float[] psfPadding1DFloat(boolean isComplex) {
        return CommonUtils.psfPadding1DFloat(this.image, this.image_psf, isComplex);
    }

    public int getImagePadding() {
        return this.sizePadding;
    }

    public ShapedArray getImgShaped() {
        return this.imgShaped;
    }

    public void setImgShaped(ShapedArray imgShaped) {
        this.imgShaped = imgShaped;
    }

    public ShapedArray getPsfShaped() {
        return this.psfShaped;
    }

    public void setPsfShaped(ShapedArray psfShaped) {
        this.psfShaped = psfShaped;
    }
}

