/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv.impl;

import mitiv.deconv.impl.ConvolutionDouble;
import mitiv.linalg.shaped.ShapedVectorSpace;
import org.jtransforms.fft.DoubleFFT_1D;

public class ConvolutionDouble1D
extends ConvolutionDouble {
    private DoubleFFT_1D fft = null;
    private final double scale;
    private final int number;
    private final int dim1;
    private final int off1;
    private final int end1;
    private final boolean fastPull;

    public ConvolutionDouble1D(ShapedVectorSpace space) {
        super(space);
        if (space.getRank() != 1) {
            throw new IllegalArgumentException("Vector space must be have 1 dimension(s)");
        }
        this.number = space.getNumber();
        this.scale = 1.0 / (double)this.number;
        this.dim1 = space.getDimension(0);
        this.off1 = 0;
        this.end1 = this.dim1;
        this.fastPull = true;
    }

    public ConvolutionDouble1D(ShapedVectorSpace inp, ShapedVectorSpace out, int[] off) {
        super(inp, out);
        if (inp.getRank() != 1) {
            throw new IllegalArgumentException("Input space is not 1D");
        }
        if (out.getRank() != 1) {
            throw new IllegalArgumentException("Output space is not 1D");
        }
        this.number = inp.getNumber();
        this.scale = 1.0 / (double)this.number;
        this.dim1 = inp.getDimension(0);
        this.off1 = off[0];
        this.end1 = this.off1 + out.getDimension(0);
        if (this.off1 < 0 || this.off1 >= this.dim1) {
            throw new IllegalArgumentException("Out of range offset along 1st dimension.");
        }
        if (this.end1 > this.dim1) {
            throw new IllegalArgumentException("Data (+ offset) beyond 1st dimension.");
        }
        this.fastPull = out.getShape().equals(inp.getShape());
    }

    private final void createFFT() {
        if (this.fft == null) {
            this.fft = new DoubleFFT_1D((long)this.dim1);
        }
    }

    @Override
    public final void forwardFFT(double[] z) {
        if (z.length != 2 * this.number) {
            throw new IllegalArgumentException("Bad workspace size");
        }
        this.timerForFFT.resume();
        if (this.fft == null) {
            this.createFFT();
        }
        this.fft.complexForward(z);
        this.timerForFFT.stop();
    }

    @Override
    public final void backwardFFT(double[] z) {
        if (z.length != 2 * this.number) {
            throw new IllegalArgumentException("Bad argument size");
        }
        this.timerForFFT.resume();
        if (this.fft == null) {
            this.createFFT();
        }
        this.fft.complexInverse(z, false);
        this.timerForFFT.stop();
    }

    @Override
    public void pull(double[] x) {
        if (x == null || x.length != this.number) {
            throw new IllegalArgumentException("Bad output size");
        }
        double[] z = this.getWorkspace();
        int real = 0;
        if (this.fastPull) {
            int k = 0;
            while (k < this.number) {
                x[k] = this.scale * z[real];
                real += 2;
                ++k;
            }
        } else {
            int k = 0;
            int i1 = 0;
            while (i1 < this.dim1) {
                if (this.off1 <= i1 && i1 < this.end1) {
                    x[k] = this.scale * z[real];
                    ++k;
                }
                real += 2;
                ++i1;
            }
        }
    }
}

