/*
 * Decompiled with CFR 0.152.
 */
package mitiv.io;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import javax.imageio.ImageIO;
import mitiv.array.ArrayFactory;
import mitiv.array.Byte2D;
import mitiv.array.Byte3D;
import mitiv.array.Double2D;
import mitiv.array.Double3D;
import mitiv.array.Float2D;
import mitiv.array.Float3D;
import mitiv.array.Int2D;
import mitiv.array.Int3D;
import mitiv.array.Long2D;
import mitiv.array.Long3D;
import mitiv.array.ShapedArray;
import mitiv.array.Short2D;
import mitiv.array.Short3D;
import mitiv.exception.IllegalTypeException;
import mitiv.io.BufferedInputDataStream;
import mitiv.io.FormatOptions;
import mitiv.io.MdaFormat;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;

public enum DataFormat {
    PNM("PNM", "Portable anymap (PBM/PGM/PPM/PNM) image.", new String[]{"pnm", "ppm", "pgm", "pbm"}),
    JPEG("JPEG", "JPEG image.", new String[]{"jpg", "jpeg"}),
    PNG("PNG", "Portable Network Graphic (PNG) image.", new String[]{"png"}),
    GIF("GIF", "GIF image.", new String[]{"gif"}),
    BMP("BMP", "BMP image.", new String[]{"bmp"}),
    WBMP("WBMP", "Wireless Bitmap (WBMP) image format.", new String[]{"wbmp"}),
    TIFF("TIFF", "TIFF image format.", new String[]{"tiff", "tif"}),
    FITS("FITS", "Flexible Image Transport System (FITS) format.", new String[]{"fits", "fts", "fit"}),
    MDA("MDA", "Multi-dimensional array (MDA) format.", new String[]{"mda"});

    private final String identifier;
    private final String description;
    private final String[] extensions;

    private DataFormat(String ident, String descr, String[] extensions) {
        this.identifier = ident;
        this.description = descr;
        this.extensions = extensions;
    }

    public String identifier() {
        return this.identifier;
    }

    public String description() {
        return this.description;
    }

    public String[] extensions() {
        return this.extensions;
    }

    public String toString() {
        return this.description;
    }

    public boolean match(String suffix) {
        if (suffix != null && suffix.length() > 0) {
            int n = this.extensions == null ? 0 : this.extensions.length;
            int k = 0;
            while (k < n) {
                if (suffix.equalsIgnoreCase(this.extensions[k])) {
                    return true;
                }
                ++k;
            }
        }
        return false;
    }

    public static final DataFormat guessFormat(String name) {
        int index = name.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        String suffix = name.substring(index + 1);
        if (MDA.match(suffix)) {
            return MDA;
        }
        if (PNG.match(suffix)) {
            return PNG;
        }
        if (JPEG.match(suffix)) {
            return JPEG;
        }
        if (PNM.match(suffix)) {
            return PNM;
        }
        if (TIFF.match(suffix)) {
            return TIFF;
        }
        if (FITS.match(suffix)) {
            return FITS;
        }
        if (BMP.match(suffix)) {
            return BMP;
        }
        if (WBMP.match(suffix)) {
            return WBMP;
        }
        if (FITS.match(suffix)) {
            return FITS;
        }
        if (GIF.match(suffix)) {
            return GIF;
        }
        return null;
    }

    public static final DataFormat guessFormat(String name, FormatOptions opts) {
        DataFormat format;
        DataFormat dataFormat = format = opts == null ? null : opts.getDataFormat();
        if (format != null) {
            return format;
        }
        return DataFormat.guessFormat(name);
    }

    public static final DataFormat guessFormat(BufferedInputDataStream stream) throws IOException {
        int preserved = stream.insure(80);
        if (preserved < 2) {
            return null;
        }
        DataFormat format = null;
        stream.mark();
        try {
            int length = Math.min(preserved, 80);
            byte[] magic = new byte[length];
            length = stream.read(magic, 0, length);
            if (length < 2) {
                return null;
            }
            if (length >= 2 && DataFormat.matchMagic(magic, '\u00ff', '\u00d8')) {
                format = JPEG;
            } else if (length >= 4 && DataFormat.matchMagic(magic, '\u0089', 'P', 'N', 'G')) {
                format = PNG;
            } else if (length >= 4 && DataFormat.matchMagic(magic, 'M', 'M', '\u0000', '*')) {
                format = TIFF;
            } else if (length >= 4 && DataFormat.matchMagic(magic, 'I', 'I', '*', '\u0000')) {
                format = TIFF;
            } else if (length >= 4 && DataFormat.matchMagic(magic, 'G', 'I', 'F', '8')) {
                format = GIF;
            } else if (length >= 3 && magic[0] == 80 && DataFormat.isSpace(magic[2]) && 49 <= magic[1] && magic[1] <= 54) {
                format = PNM;
            } else if (length >= 3 && DataFormat.matchMagic(magic, 'S', 'I', 'M', 'P', 'L', 'E', ' ', ' ', '=')) {
                format = FITS;
            }
        }
        finally {
            stream.reset();
        }
        return format;
    }

    private static final boolean matchMagic(byte[] b, char c0, char c1) {
        return b[0] == (byte)c0 && b[1] == (byte)c1;
    }

    private static final boolean matchMagic(byte[] b, char c0, char c1, char c2, char c3) {
        return b[0] == (byte)c0 && b[1] == (byte)c1 && b[2] == (byte)c2 && b[3] == (byte)c3;
    }

    private static final boolean matchMagic(byte[] b, char c0, char c1, char c2, char c3, char c4, char c5, char c6, char c7, char c8) {
        return b[0] == (byte)c0 && b[1] == (byte)c1 && b[2] == (byte)c2 && b[3] == (byte)c3 && b[4] == (byte)c4 && b[5] == (byte)c5 && b[6] == (byte)c6 && b[7] == (byte)c7 && b[8] == (byte)c8;
    }

    private static final boolean isSpace(byte s) {
        return s == 32 || s == 10 || s == 13 || s == 9;
    }

    private static void fatal(String reason) {
        throw new IllegalArgumentException(reason);
    }

    public static ShapedArray load(String name) {
        ShapedArray arr = null;
        DataFormat format = DataFormat.guessFormat(name);
        try {
            if (format == MDA) {
                arr = MdaFormat.load(name);
            } else {
                BufferedImage img = ImageIO.read(new File(name));
                arr = DataFormat.imageToShapedArray(img);
            }
        }
        catch (Exception e) {
            DataFormat.fatal("Error while reading " + name + "(" + e.getMessage() + ").");
        }
        return arr;
    }

    public static void save(ShapedArray arr, String name) throws FileNotFoundException, IOException {
        DataFormat.save(arr, name, new FormatOptions());
    }

    public static void save(ShapedArray arr, String name, FormatOptions opts) throws FileNotFoundException, IOException {
        DataFormat format = DataFormat.guessFormat(name, opts);
        String identifier = null;
        switch (format) {
            case JPEG: 
            case PNG: 
            case GIF: 
            case BMP: 
            case WBMP: {
                identifier = format.identifier();
                break;
            }
            case MDA: {
                MdaFormat.save(arr, name);
                return;
            }
            default: {
                identifier = null;
            }
        }
        if (identifier == null) {
            DataFormat.fatal("Unknown/unsupported format name.");
        }
        BufferedImage image = DataFormat.makeBufferedImage(arr, opts);
        ImageIO.write((RenderedImage)image, identifier, new File(name));
    }

    public static BufferedImage makeBufferedImage(ShapedArray arr) {
        return DataFormat.makeBufferedImage(arr, new FormatOptions());
    }

    protected static boolean isFlat(ShapedArray arr) {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static BufferedImage makeBufferedImage(ShapedArray arr, FormatOptions opts) {
        block59: {
            block60: {
                block58: {
                    shape = arr.getShape();
                    rank = shape.rank();
                    arrayType = arr.getType();
                    depth = -1;
                    imageType = -1;
                    if (rank == 2) {
                        depth = 1;
                        imageType = arrayType == 0 ? 10 : 11;
                    } else if (rank == 3) {
                        depth = shape.dimension(0);
                        if (depth == 3) {
                            imageType = 5;
                        } else if (depth == 4 && arrayType == 0) {
                            imageType = 6;
                        } else {
                            depth = -1;
                        }
                    }
                    if (depth < 0) {
                        throw new IllegalArgumentException("Conversion to image is only allowed for WIDTH x HEIGHT arrays, 3 x WIDTH x HEIGHT arrays or 4 x WIDTH x HEIGHT byte arrays.");
                    }
                    width = shape.dimension(rank - 2);
                    height = shape.dimension(rank - 1);
                    image = new BufferedImage(width, height, imageType);
                    raster = image.getRaster();
                    minX = raster.getMinX();
                    minY = raster.getMinY();
                    if (imageType != 10) break block58;
                    src = (Byte2D)arr;
                    if (raster.getNumBands() != 1 || raster.getNumDataElements() != 1 || raster.getTransferType() != 0) {
                        throw new IllegalArgumentException("assertion failed for TYPE_BYTE_GRAY");
                    }
                    if (DataFormat.isFlat(src)) {
                        raster.setDataElements(minX, minY, width, height, src.flatten());
                    } else {
                        data = new byte[1];
                        y = 0;
                        while (y < height) {
                            x = 0;
                            while (x < width) {
                                data[0] = src.get(x, y);
                                raster.setDataElements(minX + x, minY + y, data);
                                ++x;
                            }
                            ++y;
                        }
                    }
                    break block59;
                }
                if (imageType == 11) {
                    if (raster.getNumBands() != 1 || raster.getNumDataElements() != 1 || raster.getTransferType() != 1) {
                        throw new IllegalArgumentException("assertion failed for TYPE_USHORT_GRAY");
                    }
                    data = new short[1];
                    switch (arrayType) {
                        case 1: {
                            src = (Short2D)arr;
                            sf = opts.getScaling(arr, 0.0, 65535.0);
                            scale = (float)sf[0];
                            bias = (float)sf[1];
                            factor = 1.0f / scale;
                            minLevel = 0.0f;
                            maxLevel = 65535.0f;
                            y = 0;
                            while (y < height) {
                                x = 0;
                                while (x < width) {
                                    data[0] = (short)((int)Math.max(0.0f, Math.min(((float)src.get(x, y) - bias) * factor, 65535.0f)) & 65535);
                                    raster.setDataElements(minX + x, minY + y, data);
                                    ++x;
                                }
                                ++y;
                            }
                        }
                        case 2: {
                            src = (Int2D)arr;
                            sf = opts.getScaling(arr, 0.0, 65535.0);
                            scale = (float)sf[0];
                            bias = (float)sf[1];
                            factor = 1.0f / scale;
                            minLevel = 0.0f;
                            maxLevel = 65535.0f;
                            y = 0;
                            while (y < height) {
                                x = 0;
                                while (x < width) {
                                    data[0] = (short)((int)Math.max(0.0f, Math.min(((float)src.get(x, y) - bias) * factor, 65535.0f)) & 65535);
                                    raster.setDataElements(minX + x, minY + y, data);
                                    ++x;
                                }
                                ++y;
                            }
                        }
                        case 3: {
                            src = (Long2D)arr;
                            sf = opts.getScaling(arr, 0.0, 65535.0);
                            scale = sf[0];
                            bias = sf[1];
                            factor = 1.0 / scale;
                            minLevel = 0.0;
                            maxLevel = 65535.0;
                            y = 0;
                            while (y < height) {
                                x = 0;
                                while (x < width) {
                                    data[0] = (short)((int)Math.max(0.0, Math.min(((double)src.get(x, y) - bias) * factor, 65535.0)) & 65535);
                                    raster.setDataElements(minX + x, minY + y, data);
                                    ++x;
                                }
                                ++y;
                            }
                        }
                        case 4: {
                            src = (Float2D)arr;
                            sf = opts.getScaling(arr, 0.0, 65535.0);
                            scale = (float)sf[0];
                            bias = (float)sf[1];
                            factor = 1.0f / scale;
                            minLevel = 0.0f;
                            maxLevel = 65535.0f;
                            y = 0;
                            while (y < height) {
                                x = 0;
                                while (x < width) {
                                    data[0] = (short)((int)Math.max(0.0f, Math.min((src.get(x, y) - bias) * factor, 65535.0f)) & 65535);
                                    raster.setDataElements(minX + x, minY + y, data);
                                    ++x;
                                }
                                ++y;
                            }
                        }
                        case 5: {
                            src = (Double2D)arr;
                            sf = opts.getScaling(arr, 0.0, 65535.0);
                            scale = sf[0];
                            bias = sf[1];
                            factor = 1.0 / scale;
                            minLevel = 0.0;
                            maxLevel = 65535.0;
                            y = 0;
                            while (y < height) {
                                x = 0;
                                while (x < width) {
                                    data[0] = (short)((int)Math.max(0.0, Math.min((src.get(x, y) - bias) * factor, 65535.0)) & 65535);
                                    raster.setDataElements(minX + x, minY + y, data);
                                    ++x;
                                }
                                ++y;
                            }
                            break;
                        }
                    }
                    throw new IllegalTypeException();
                }
                if (imageType != 5) break block60;
                if (raster.getNumBands() != 3 || raster.getNumDataElements() != 3 || raster.getTransferType() != 0) {
                    throw new IllegalArgumentException("assertion failed for TYPE_3BYTE_BGR");
                }
                data = new byte[3];
                switch (arrayType) {
                    case 0: {
                        src = (Byte3D)arr;
                        if (!DataFormat.isFlat(src)) ** GOTO lbl154
                        raster.setDataElements(minX, minY, width, height, src.flatten());
                        ** GOTO lbl166
lbl154:
                        // 1 sources

                        y = 0;
                        while (y < height) {
                            x = 0;
                            while (x < width) {
                                data[0] = src.get(0, x, y);
                                data[1] = src.get(1, x, y);
                                data[2] = src.get(2, x, y);
                                raster.setDataElements(minX + x, minY + y, data);
                                ++x;
                            }
                            ++y;
                        }
                    }
lbl166:
                    // 3 sources

                    case 1: {
                        src = (Short3D)arr;
                        sf = opts.getScaling(arr, 0.0, 255.0);
                        scale = (float)sf[0];
                        bias = (float)sf[1];
                        factor = 1.0f / scale;
                        minLevel = 0.0f;
                        maxLevel = 255.0f;
                        y = 0;
                        while (y < height) {
                            x = 0;
                            while (x < width) {
                                data[0] = (byte)((int)Math.max(0.0f, Math.min(((float)src.get(0, x, y) - bias) * factor, 255.0f)) & 255);
                                data[1] = (byte)((int)Math.max(0.0f, Math.min(((float)src.get(1, x, y) - bias) * factor, 255.0f)) & 255);
                                data[2] = (byte)((int)Math.max(0.0f, Math.min(((float)src.get(2, x, y) - bias) * factor, 255.0f)) & 255);
                                raster.setDataElements(minX + x, minY + y, data);
                                ++x;
                            }
                            ++y;
                        }
                    }
                    case 2: {
                        src = (Int3D)arr;
                        sf = opts.getScaling(arr, 0.0, 255.0);
                        scale = (float)sf[0];
                        bias = (float)sf[1];
                        factor = 1.0f / scale;
                        minLevel = 0.0f;
                        maxLevel = 255.0f;
                        y = 0;
                        while (y < height) {
                            x = 0;
                            while (x < width) {
                                data[0] = (byte)((int)Math.max(0.0f, Math.min(((float)src.get(0, x, y) - bias) * factor, 255.0f)) & 255);
                                data[1] = (byte)((int)Math.max(0.0f, Math.min(((float)src.get(1, x, y) - bias) * factor, 255.0f)) & 255);
                                data[2] = (byte)((int)Math.max(0.0f, Math.min(((float)src.get(2, x, y) - bias) * factor, 255.0f)) & 255);
                                raster.setDataElements(minX + x, minY + y, data);
                                ++x;
                            }
                            ++y;
                        }
                    }
                    case 3: {
                        src = (Long3D)arr;
                        sf = opts.getScaling(arr, 0.0, 255.0);
                        scale = sf[0];
                        bias = sf[1];
                        factor = 1.0 / scale;
                        minLevel = 0.0;
                        maxLevel = 255.0;
                        y = 0;
                        while (y < height) {
                            x = 0;
                            while (x < width) {
                                data[0] = (byte)((int)Math.max(0.0, Math.min(((double)src.get(0, x, y) - bias) * factor, 255.0)) & 255);
                                data[1] = (byte)((int)Math.max(0.0, Math.min(((double)src.get(1, x, y) - bias) * factor, 255.0)) & 255);
                                data[2] = (byte)((int)Math.max(0.0, Math.min(((double)src.get(2, x, y) - bias) * factor, 255.0)) & 255);
                                raster.setDataElements(minX + x, minY + y, data);
                                ++x;
                            }
                            ++y;
                        }
                    }
                    case 4: {
                        src = (Float3D)arr;
                        sf = opts.getScaling(arr, 0.0, 255.0);
                        scale = (float)sf[0];
                        bias = (float)sf[1];
                        factor = 1.0f / scale;
                        minLevel = 0.0f;
                        maxLevel = 255.0f;
                        y = 0;
                        while (y < height) {
                            x = 0;
                            while (x < width) {
                                data[0] = (byte)((int)Math.max(0.0f, Math.min((src.get(0, x, y) - bias) * factor, 255.0f)) & 255);
                                data[1] = (byte)((int)Math.max(0.0f, Math.min((src.get(1, x, y) - bias) * factor, 255.0f)) & 255);
                                data[2] = (byte)((int)Math.max(0.0f, Math.min((src.get(2, x, y) - bias) * factor, 255.0f)) & 255);
                                raster.setDataElements(minX + x, minY + y, data);
                                ++x;
                            }
                            ++y;
                        }
                    }
                    case 5: {
                        src = (Double3D)arr;
                        sf = opts.getScaling(arr, 0.0, 255.0);
                        scale = sf[0];
                        bias = sf[1];
                        factor = 1.0 / scale;
                        minLevel = 0.0;
                        maxLevel = 255.0;
                        y = 0;
                        while (y < height) {
                            x = 0;
                            while (x < width) {
                                data[0] = (byte)((int)Math.max(0.0, Math.min((src.get(0, x, y) - bias) * factor, 255.0)) & 255);
                                data[1] = (byte)((int)Math.max(0.0, Math.min((src.get(1, x, y) - bias) * factor, 255.0)) & 255);
                                data[2] = (byte)((int)Math.max(0.0, Math.min((src.get(2, x, y) - bias) * factor, 255.0)) & 255);
                                raster.setDataElements(minX + x, minY + y, data);
                                ++x;
                            }
                            ++y;
                        }
                        break;
                    }
                }
                throw new IllegalTypeException();
            }
            src = (Byte3D)arr;
            if (raster.getNumBands() != 4 || raster.getNumDataElements() != 4 || raster.getTransferType() != 0) {
                throw new IllegalArgumentException("assertion failed for TYPE_4BYTE_ABGR");
            }
            if (DataFormat.isFlat(src)) {
                raster.setDataElements(minX, minY, width, height, src.flatten());
            } else {
                data = new byte[4];
                y = 0;
                while (y < height) {
                    x = 0;
                    while (x < width) {
                        data[0] = src.get(0, x, y);
                        data[1] = src.get(1, x, y);
                        data[2] = src.get(2, x, y);
                        data[3] = src.get(3, x, y);
                        raster.setDataElements(minX + x, minY + y, data);
                        ++x;
                    }
                    ++y;
                }
            }
        }
        return image;
    }

    public static BufferedImage makeBufferedImage(ShapedVector vec) {
        if (vec instanceof DoubleShapedVector) {
            return DataFormat.makeBufferedImage(ArrayFactory.wrap(((DoubleShapedVector)vec).getData(), vec.getShape()));
        }
        if (vec instanceof FloatShapedVector) {
            return DataFormat.makeBufferedImage(ArrayFactory.wrap(((FloatShapedVector)vec).getData(), vec.getShape()));
        }
        throw new IllegalArgumentException("Unable to convert shaped vector to image.");
    }

    public static BufferedImage makeBufferedImage(ShapedVector vec, FormatOptions opts) {
        if (vec instanceof DoubleShapedVector) {
            return DataFormat.makeBufferedImage(ArrayFactory.wrap(((DoubleShapedVector)vec).getData(), vec.getShape()), opts);
        }
        if (vec instanceof FloatShapedVector) {
            return DataFormat.makeBufferedImage(ArrayFactory.wrap(((FloatShapedVector)vec).getData(), vec.getShape()), opts);
        }
        throw new IllegalArgumentException("Unable to convert shaped vector to image.");
    }

    public static String getImageTypeName(BufferedImage image) {
        return DataFormat.getImageTypeName(image.getType());
    }

    public static String getImageTypeName(int type) {
        switch (type) {
            case 1: {
                return "TYPE_INT_RGB";
            }
            case 4: {
                return "TYPE_INT_BGR";
            }
            case 5: {
                return "TYPE_3BYTE_BGR";
            }
            case 8: {
                return "TYPE_USHORT_565_RGB";
            }
            case 9: {
                return "TYPE_USHORT_555_RGB";
            }
            case 2: {
                return "TYPE_INT_ARGB";
            }
            case 3: {
                return "TYPE_INT_ARGB_PRE";
            }
            case 6: {
                return "TYPE_4BYTE_ABGR";
            }
            case 7: {
                return "TYPE_4BYTE_ABGR_PRE";
            }
            case 10: {
                return "TYPE_BYTE_GRAY";
            }
            case 11: {
                return "TYPE_USHORT_GRAY";
            }
            case 12: {
                return "TYPE_BYTE_BINARY";
            }
            case 13: {
                return "TYPE_BYTE_INDEXED";
            }
            case 0: {
                return "TYPE_CUSTOM";
            }
        }
        return "UNKOWN";
    }

    public static String getDataTypeName(DataBuffer buffer) {
        return DataFormat.getDataTypeName(buffer.getDataType());
    }

    public static String getDataTypeName(int type) {
        switch (type) {
            case 0: {
                return "TYPE_BYTE";
            }
            case 2: {
                return "TYPE_SHORT";
            }
            case 1: {
                return "TYPE_USHORT";
            }
            case 3: {
                return "TYPE_INT";
            }
            case 4: {
                return "TYPE_FLOAT";
            }
            case 5: {
                return "TYPE_DOUBLE";
            }
            case 32: {
                return "TYPE_UNDEFINED";
            }
        }
        return "UNKOWN";
    }

    public static void printImageInfo(PrintStream output, BufferedImage image, String name) {
        WritableRaster raster = image.getRaster();
        int height = raster.getHeight();
        int width = raster.getWidth();
        int minX = raster.getMinX();
        int minY = raster.getMinY();
        int numBands = raster.getNumBands();
        int transferType = raster.getTransferType();
        int numElements = raster.getNumDataElements();
        if (name != null) {
            output.format("image name       %s\n", name);
        }
        output.format("image type:      %s\n", DataFormat.getImageTypeName(image));
        output.format("image size:      %d x %d\n", width, height);
        output.format("image origin:    (%d,%d)\n", minX, minY);
        output.format("number of bands: %d\n", numBands);
        output.format("transfer data:   %s x %d\n", DataFormat.getDataTypeName(transferType), numElements);
    }

    public static BufferedImage convertImage(BufferedImage img, int type) {
        if (img.getType() == type) {
            return img;
        }
        BufferedImage result = new BufferedImage(img.getWidth(), img.getHeight(), type);
        Graphics2D g2 = result.createGraphics();
        g2.drawImage(img, null, null);
        g2.dispose();
        return result;
    }

    public static ShapedArray imageToShapedArray(BufferedImage image) {
        WritableRaster raster = image.getRaster();
        int height = raster.getHeight();
        int width = raster.getWidth();
        int minX = raster.getMinX();
        int minY = raster.getMinY();
        int numBands = raster.getNumBands();
        int transferType = raster.getTransferType();
        int numDataElements = raster.getNumDataElements();
        int type = image.getType();
        switch (type) {
            case 1: {
                if (numBands != 3 || numDataElements != 1 || transferType != 3) {
                    throw new IllegalArgumentException("assertion failed for TYPE_INT_RGB");
                }
                Byte3D arr = Byte3D.wrap(new byte[3 * width * height], 3, width, height);
                int[] data = new int[1];
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        raster.getDataElements(x + minX, y + minY, data);
                        int pixel = data[0];
                        int red = pixel >> 16 & 0xFF;
                        int green = pixel >> 8 & 0xFF;
                        int blue = pixel & 0xFF;
                        arr.set(0, x, y, (byte)red);
                        arr.set(1, x, y, (byte)green);
                        arr.set(2, x, y, (byte)blue);
                        ++x;
                    }
                    ++y;
                }
                return arr;
            }
            case 2: {
                if (numBands != 4 || numDataElements != 1 || transferType != 3) {
                    throw new IllegalArgumentException("assertion failed for TYPE_INT_ARGB");
                }
                Byte3D arr = Byte3D.wrap(new byte[4 * width * height], 4, width, height);
                int[] data = new int[1];
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        raster.getDataElements(x + minX, y + minY, data);
                        int pixel = data[0];
                        int alpha = pixel >> 24 & 0xFF;
                        int red = pixel >> 16 & 0xFF;
                        int green = pixel >> 8 & 0xFF;
                        int blue = pixel & 0xFF;
                        arr.set(0, x, y, (byte)red);
                        arr.set(1, x, y, (byte)green);
                        arr.set(2, x, y, (byte)blue);
                        arr.set(3, x, y, (byte)alpha);
                        ++x;
                    }
                    ++y;
                }
                return arr;
            }
            case 3: {
                int b = 255;
                int a = 510;
                if (numBands != 4 || numDataElements != 1 || transferType != 3) {
                    throw new IllegalArgumentException("assertion failed for TYPE_INT_ARGB_PRE");
                }
                Byte3D arr = Byte3D.wrap(new byte[4 * width * height], 4, width, height);
                int[] data = new int[1];
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        raster.getDataElements(x + minX, y + minY, data);
                        int pixel = data[0];
                        int alpha = pixel >> 24 & 0xFF;
                        int c = 2 * alpha;
                        int red = ((pixel >> 16 & 0xFF) * c + 255) / 510;
                        int green = ((pixel >> 8 & 0xFF) * c + 255) / 510;
                        int blue = ((pixel & 0xFF) * c + 255) / 510;
                        arr.set(0, x, y, (byte)red);
                        arr.set(1, x, y, (byte)green);
                        arr.set(2, x, y, (byte)blue);
                        arr.set(3, x, y, (byte)alpha);
                        ++x;
                    }
                    ++y;
                }
                return arr;
            }
            case 4: {
                if (numBands != 3 || numDataElements != 1 || transferType != 3) {
                    throw new IllegalArgumentException("assertion failed for TYPE_INT_BGR");
                }
                Byte3D arr = Byte3D.wrap(new byte[3 * width * height], 3, width, height);
                int[] data = new int[1];
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        raster.getDataElements(x + minX, y + minY, data);
                        int pixel = data[0];
                        int red = pixel >> 8 & 0xFF;
                        int green = pixel >> 16 & 0xFF;
                        int blue = pixel >> 24 & 0xFF;
                        arr.set(0, x, y, (byte)red);
                        arr.set(1, x, y, (byte)green);
                        arr.set(2, x, y, (byte)blue);
                        ++x;
                    }
                    ++y;
                }
                return arr;
            }
            case 8: {
                if (numBands != 3 || numDataElements != 1 || transferType != 1) {
                    throw new IllegalArgumentException("assertion failed for TYPE_USHORT_565_RGB");
                }
                Byte3D arr = Byte3D.wrap(new byte[3 * width * height], 3, width, height);
                short[] data = new short[1];
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        raster.getDataElements(x + minX, y + minY, data);
                        short pixel = data[0];
                        int red = pixel >> 11 & 0x1F;
                        int green = pixel >> 5 & 0x3F;
                        int blue = pixel & 0x1F;
                        arr.set(0, x, y, (byte)red);
                        arr.set(1, x, y, (byte)green);
                        arr.set(2, x, y, (byte)blue);
                        ++x;
                    }
                    ++y;
                }
                return arr;
            }
            case 9: {
                if (numBands != 3 || numDataElements != 1 || transferType != 1) {
                    throw new IllegalArgumentException("assertion failed for TYPE_USHORT_555_RGB");
                }
                Byte3D arr = Byte3D.wrap(new byte[3 * width * height], 3, width, height);
                short[] data = new short[1];
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        raster.getDataElements(x + minX, y + minY, data);
                        short pixel = data[0];
                        int red = pixel >> 10 & 0x1F;
                        int green = pixel >> 5 & 0x1F;
                        int blue = pixel & 0x1F;
                        arr.set(0, x, y, (byte)red);
                        arr.set(1, x, y, (byte)green);
                        arr.set(2, x, y, (byte)blue);
                        ++x;
                    }
                    ++y;
                }
                return arr;
            }
            case 5: {
                if (numBands != 3 || numDataElements != 3 || transferType != 0) {
                    throw new IllegalArgumentException("assertion failed for TYPE_3BYTE_BGR");
                }
                Byte3D arr = Byte3D.wrap(new byte[3 * width * height], 3, width, height);
                byte[] data = new byte[3];
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        raster.getDataElements(x + minX, y + minY, data);
                        arr.set(0, x, y, data[0]);
                        arr.set(1, x, y, data[1]);
                        arr.set(2, x, y, data[2]);
                        ++x;
                    }
                    ++y;
                }
                return arr;
            }
            case 6: {
                if (numBands != 4 || numDataElements != 4 || transferType != 0) {
                    throw new IllegalArgumentException("assertion failed for TYPE_4BYTE_ABGR");
                }
                Byte3D arr = Byte3D.wrap(new byte[4 * width * height], 4, width, height);
                byte[] data = new byte[4];
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        raster.getDataElements(x + minX, y + minY, data);
                        arr.set(0, x, y, data[0]);
                        arr.set(1, x, y, data[1]);
                        arr.set(2, x, y, data[2]);
                        arr.set(3, x, y, data[3]);
                        ++x;
                    }
                    ++y;
                }
                return arr;
            }
            case 7: {
                int b = 255;
                int a = 510;
                if (numBands != 4 || numDataElements != 4 || transferType != 0) {
                    throw new IllegalArgumentException("assertion failed for TYPE_4BYTE_ABGR_PRE");
                }
                Byte3D arr = Byte3D.wrap(new byte[4 * width * height], 4, width, height);
                byte[] data = new byte[4];
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        raster.getDataElements(x + minX, y + minY, data);
                        byte alpha = data[3];
                        int c = 2 * alpha;
                        int red = (data[0] * c + 255) / 510;
                        int green = (data[1] * c + 255) / 510;
                        int blue = (data[2] * c + 255) / 510;
                        arr.set(0, x, y, (byte)red);
                        arr.set(1, x, y, (byte)green);
                        arr.set(2, x, y, (byte)blue);
                        arr.set(3, x, y, alpha);
                        ++x;
                    }
                    ++y;
                }
                return arr;
            }
            case 10: {
                if (numBands != 1 || numDataElements != 1 || transferType != 0) {
                    throw new IllegalArgumentException("assertion failed for TYPE_BYTE_GRAY");
                }
                Byte2D arr = Byte2D.wrap(new byte[width * height], width, height);
                byte[] data = new byte[1];
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        raster.getDataElements(x + minX, y + minY, data);
                        arr.set(x, y, data[0]);
                        ++x;
                    }
                    ++y;
                }
                return arr;
            }
            case 11: {
                if (numBands != 1 || numDataElements != 1 || transferType != 1) {
                    throw new IllegalArgumentException("assertion failed for TYPE_USHORT_GRAY");
                }
                Int2D arr = Int2D.wrap(new int[width * height], width, height);
                short[] data = new short[1];
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        raster.getDataElements(x + minX, y + minY, data);
                        arr.set(x, y, data[0]);
                        ++x;
                    }
                    ++y;
                }
                return arr;
            }
            case 12: {
                if (numBands != 1 || numDataElements != 1 || transferType != 0) {
                    throw new IllegalArgumentException("assertion failed for TYPE_BYTE_BINARY");
                }
                Byte2D arr = Byte2D.wrap(new byte[width * height], width, height);
                byte[] data = new byte[1];
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        raster.getDataElements(x + minX, y + minY, data);
                        arr.set(x, y, data[0]);
                        ++x;
                    }
                    ++y;
                }
                return arr;
            }
        }
        if (transferType == 4) {
            if (numBands == 1) {
                Float2D arr = Float2D.wrap(new float[width * height], width, height);
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        arr.set(x, y, raster.getSampleFloat(x + minX, y + minY, 0));
                        ++x;
                    }
                    ++y;
                }
                return arr;
            }
            Float3D arr = Float3D.wrap(new float[numBands * width * height], numBands, width, height);
            if (numBands == 3) {
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        arr.set(0, x, y, raster.getSampleFloat(x + minX, y + minY, 0));
                        arr.set(1, x, y, raster.getSampleFloat(x + minX, y + minY, 1));
                        arr.set(2, x, y, raster.getSampleFloat(x + minX, y + minY, 2));
                        ++x;
                    }
                    ++y;
                }
            } else {
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        int b = 0;
                        while (b < numBands) {
                            arr.set(b, x, y, raster.getSampleFloat(x + minX, y + minY, b));
                            ++b;
                        }
                        ++x;
                    }
                    ++y;
                }
            }
            return arr;
        }
        if (transferType == 5) {
            if (numBands == 1) {
                Double2D arr = Double2D.wrap(new double[width * height], width, height);
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        arr.set(x, y, raster.getSampleDouble(x + minX, y + minY, 0));
                        ++x;
                    }
                    ++y;
                }
                return arr;
            }
            Double3D arr = Double3D.wrap(new double[numBands * width * height], numBands, width, height);
            if (numBands == 3) {
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        arr.set(0, x, y, raster.getSampleDouble(x + minX, y + minY, 0));
                        arr.set(1, x, y, raster.getSampleDouble(x + minX, y + minY, 1));
                        arr.set(2, x, y, raster.getSampleDouble(x + minX, y + minY, 2));
                        ++x;
                    }
                    ++y;
                }
            } else {
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        int b = 0;
                        while (b < numBands) {
                            arr.set(b, x, y, raster.getSampleDouble(x + minX, y + minY, b));
                            ++b;
                        }
                        ++x;
                    }
                    ++y;
                }
            }
            return arr;
        }
        if (numBands == 1) {
            Int2D arr = Int2D.wrap(new int[width * height], width, height);
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    arr.set(x, y, raster.getSample(x + minX, y + minY, 0));
                    ++x;
                }
                ++y;
            }
            return arr;
        }
        Int3D arr = Int3D.wrap(new int[numBands * width * height], numBands, width, height);
        if (numBands == 3) {
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    arr.set(0, x, y, raster.getSample(x + minX, y + minY, 0));
                    arr.set(1, x, y, raster.getSample(x + minX, y + minY, 1));
                    arr.set(2, x, y, raster.getSample(x + minX, y + minY, 2));
                    ++x;
                }
                ++y;
            }
        } else {
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    int b = 0;
                    while (b < numBands) {
                        arr.set(b, x, y, raster.getSample(x + minX, y + minY, b));
                        ++b;
                    }
                    ++x;
                }
                ++y;
            }
        }
        return arr;
    }

    public static void main(String[] args) {
        String[] str = ImageIO.getReaderFormatNames();
        System.out.format("Format names understood by registered readers:\n", new Object[0]);
        int i = 0;
        while (i < str.length) {
            System.out.format("  - %s\n", str[i]);
            ++i;
        }
        str = ImageIO.getReaderFileSuffixes();
        System.out.format("\nImage suffixes understood by registered readers:\n", new Object[0]);
        i = 0;
        while (i < str.length) {
            System.out.format("  - %s\n", str[i]);
            ++i;
        }
        str = ImageIO.getWriterFormatNames();
        System.out.format("\nFormat names understood by registered writers:\n", new Object[0]);
        i = 0;
        while (i < str.length) {
            System.out.format("  - %s\n", str[i]);
            ++i;
        }
        str = ImageIO.getWriterFileSuffixes();
        System.out.format("\nImage suffixes understood by registered writers:\n", new Object[0]);
        i = 0;
        while (i < str.length) {
            System.out.format("  - %s\n", str[i]);
            ++i;
        }
        if (args == null || args.length == 0) {
            args = new String[]{"/tmp/test-image.jpg"};
        }
        int[] imageTypes = new int[]{1, 4, 5, 8, 9, 2, 3, 6, 7, 10, 11, 12, 13};
        int k = 0;
        while (k < args.length) {
            String name = args[k];
            try {
                BufferedImage image = ImageIO.read(new File(name));
                DataFormat.printImageInfo(System.out, image, name);
                System.out.format("\n", new Object[0]);
                int j = 0;
                while (j < imageTypes.length) {
                    BufferedImage converted = DataFormat.convertImage(image, imageTypes[j]);
                    DataFormat.printImageInfo(System.out, converted, name);
                    ++j;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++k;
        }
    }
}

