/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg.shaped;

import mitiv.base.Shape;
import mitiv.linalg.LinearOperator;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.FloatShapedVectorSpace;
import mitiv.linalg.shaped.ShapedLinearOperator;
import mitiv.linalg.shaped.ShapedVectorSpace;
import org.jtransforms.fft.DoubleFFT_1D;
import org.jtransforms.fft.DoubleFFT_2D;
import org.jtransforms.fft.DoubleFFT_3D;
import org.jtransforms.fft.FloatFFT_1D;
import org.jtransforms.fft.FloatFFT_2D;
import org.jtransforms.fft.FloatFFT_3D;

public class RealComplexFFT
extends ShapedLinearOperator {
    private Object xform = null;
    private double[] tempDouble = null;
    private float[] tempFloat = null;
    private final int number;
    private final int rank;
    private final Shape shape;
    private final boolean single;
    public boolean useSystemArrayCopy = false;

    public RealComplexFFT(ShapedVectorSpace space) {
        super(space, RealComplexFFT.complexSpace(space));
        this.number = space.getNumber();
        this.shape = space.getShape();
        this.single = space.getType() == 4;
        this.rank = space.getRank();
        if (this.rank < 1 || this.rank > 3) {
            throw new IllegalArgumentException("Only 1D, 2D or 3D transforms supported");
        }
    }

    private static ShapedVectorSpace complexSpace(ShapedVectorSpace realSpace) {
        ShapedVectorSpace complexSpace;
        Shape realShape = realSpace.getShape();
        if (realSpace.getRank() < 1) {
            throw new IllegalArgumentException("Rank must be at least 1 for the FFT.");
        }
        int[] complexDims = realShape.copyDimensions();
        complexDims[0] = complexDims[0] * 2;
        Shape complexShape = Shape.make(complexDims);
        int type = realSpace.getType();
        if (type == 4) {
            complexSpace = new FloatShapedVectorSpace(complexShape);
        } else if (type == 5) {
            complexSpace = new DoubleShapedVectorSpace(complexShape);
        } else {
            throw new IllegalArgumentException("Only float or double supported");
        }
        return complexSpace;
    }

    @Override
    protected void _apply(Vector dst, Vector src, int job) {
        if (this.single) {
            if (this.xform == null) {
                this.xform = this.rank == 1 ? new FloatFFT_1D((long)this.shape.dimension(0)) : (this.rank == 2 ? new FloatFFT_2D((long)this.shape.dimension(1), (long)this.shape.dimension(0)) : new FloatFFT_3D((long)this.shape.dimension(2), (long)this.shape.dimension(1), (long)this.shape.dimension(0)));
            }
            if (this.tempFloat == null) {
                this.tempFloat = new float[2 * this.number];
            }
            float[] w = this.tempFloat;
            float[] x = ((FloatShapedVector)src).getData();
            float[] y = ((FloatShapedVector)dst).getData();
            if (job == LinearOperator.ADJOINT || job == LinearOperator.INVERSE) {
                int k;
                if (this.useSystemArrayCopy) {
                    System.arraycopy(x, 0, w, 0, 2 * this.number);
                } else {
                    k = 0;
                    while (k < this.number) {
                        int real = k + k;
                        int imag = real + 1;
                        w[real] = x[real];
                        w[imag] = x[imag];
                        ++k;
                    }
                }
                if (this.rank == 1) {
                    ((FloatFFT_1D)this.xform).complexInverse(w, false);
                } else if (this.rank == 2) {
                    ((FloatFFT_2D)this.xform).complexInverse(w, false);
                } else {
                    ((FloatFFT_3D)this.xform).complexInverse(w, false);
                }
                if (job == LinearOperator.INVERSE) {
                    float s = 1.0f / (float)this.number;
                    int k2 = 0;
                    while (k2 < this.number) {
                        y[k2] = s * w[2 * k2];
                        ++k2;
                    }
                } else {
                    k = 0;
                    while (k < this.number) {
                        y[k] = w[2 * k];
                        ++k;
                    }
                }
            } else {
                if (job == LinearOperator.DIRECT) {
                    int k = 0;
                    while (k < this.number) {
                        y[2 * k] = x[k];
                        y[2 * k + 1] = 0.0f;
                        ++k;
                    }
                } else {
                    float s = 1.0f / (float)this.number;
                    int k = 0;
                    while (k < this.number) {
                        y[2 * k] = s * x[k];
                        y[2 * k + 1] = 0.0f;
                        ++k;
                    }
                }
                if (this.rank == 1) {
                    ((FloatFFT_1D)this.xform).complexForward(y);
                } else if (this.rank == 2) {
                    ((FloatFFT_2D)this.xform).complexForward(y);
                } else {
                    ((FloatFFT_3D)this.xform).complexForward(y);
                }
            }
        } else {
            if (this.xform == null) {
                this.xform = this.rank == 1 ? new DoubleFFT_1D((long)this.shape.dimension(0)) : (this.rank == 2 ? new DoubleFFT_2D((long)this.shape.dimension(1), (long)this.shape.dimension(0)) : new DoubleFFT_3D((long)this.shape.dimension(2), (long)this.shape.dimension(1), (long)this.shape.dimension(0)));
            }
            if (this.tempDouble == null) {
                this.tempDouble = new double[2 * this.number];
            }
            double[] w = this.tempDouble;
            double[] x = ((DoubleShapedVector)src).getData();
            double[] y = ((DoubleShapedVector)dst).getData();
            if (job == LinearOperator.ADJOINT || job == LinearOperator.INVERSE) {
                int k;
                if (this.useSystemArrayCopy) {
                    System.arraycopy(x, 0, w, 0, 2 * this.number);
                } else {
                    k = 0;
                    while (k < this.number) {
                        int real = k + k;
                        int imag = real + 1;
                        w[real] = x[real];
                        w[imag] = x[imag];
                        ++k;
                    }
                }
                if (this.rank == 1) {
                    ((DoubleFFT_1D)this.xform).complexInverse(w, false);
                } else if (this.rank == 2) {
                    ((DoubleFFT_2D)this.xform).complexInverse(w, false);
                } else {
                    ((DoubleFFT_3D)this.xform).complexInverse(w, false);
                }
                if (job == LinearOperator.INVERSE) {
                    double s = 1.0 / (double)this.number;
                    int k3 = 0;
                    while (k3 < this.number) {
                        y[k3] = s * w[2 * k3];
                        ++k3;
                    }
                } else {
                    k = 0;
                    while (k < this.number) {
                        y[k] = w[2 * k];
                        ++k;
                    }
                }
            } else {
                if (job == LinearOperator.DIRECT) {
                    int k = 0;
                    while (k < this.number) {
                        y[2 * k] = x[k];
                        y[2 * k + 1] = 0.0;
                        ++k;
                    }
                } else {
                    double s = 1.0 / (double)this.number;
                    int k = 0;
                    while (k < this.number) {
                        y[2 * k] = s * x[k];
                        y[2 * k + 1] = 0.0;
                        ++k;
                    }
                }
                if (this.rank == 1) {
                    ((DoubleFFT_1D)this.xform).complexForward(y);
                } else if (this.rank == 2) {
                    ((DoubleFFT_2D)this.xform).complexForward(y);
                } else {
                    ((DoubleFFT_3D)this.xform).complexForward(y);
                }
            }
        }
    }
}

