/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg.shaped;

import mitiv.array.ShapedArray;
import mitiv.base.ArrayDescriptor;
import mitiv.base.Shape;
import mitiv.base.Shaped;
import mitiv.base.Typed;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.VectorSpace;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.FloatShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVector;

public abstract class ShapedVectorSpace
extends VectorSpace
implements Shaped,
Typed {
    final ArrayDescriptor descr;

    ShapedVectorSpace(ArrayDescriptor descr) {
        super(descr.getNumber());
        this.descr = descr;
    }

    ShapedVectorSpace(int type, Shape shape) {
        this(new ArrayDescriptor(type, shape));
    }

    ShapedVectorSpace(int type, int[] shape) {
        this(new ArrayDescriptor(type, shape));
    }

    ShapedVectorSpace(int type, int dim1) {
        this(type, Shape.make(dim1));
    }

    ShapedVectorSpace(int type, int dim1, int dim2) {
        this(type, Shape.make(dim1, dim2));
    }

    ShapedVectorSpace(int type, int dim1, int dim2, int dim3) {
        this(type, Shape.make(dim1, dim2, dim3));
    }

    ShapedVectorSpace(int type, int dim1, int dim2, int dim3, int dim4) {
        this(type, Shape.make(dim1, dim2, dim3, dim4));
    }

    ShapedVectorSpace(int type, int dim1, int dim2, int dim3, int dim4, int dim5) {
        this(type, Shape.make(dim1, dim2, dim3, dim4, dim5));
    }

    ShapedVectorSpace(int type, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6) {
        this(type, Shape.make(dim1, dim2, dim3, dim4, dim5, dim6));
    }

    ShapedVectorSpace(int type, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7) {
        this(type, Shape.make(dim1, dim2, dim3, dim4, dim5, dim6, dim7));
    }

    ShapedVectorSpace(int type, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8) {
        this(type, Shape.make(dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8));
    }

    ShapedVectorSpace(int type, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8, int dim9) {
        this(type, Shape.make(dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9));
    }

    @Override
    public final int getType() {
        return this.descr.getType();
    }

    @Override
    public final int getRank() {
        return this.descr.getRank();
    }

    @Override
    public final int getOrder() {
        return this.descr.getOrder();
    }

    @Override
    public final Shape getShape() {
        return this.descr.getShape();
    }

    @Override
    public final int getDimension(int k) {
        return this.descr.getDimension(k);
    }

    public ShapedVector clone(ShapedVector vec) {
        this.check(vec);
        return this._clone(vec);
    }

    protected ShapedVector _clone(ShapedVector vec) {
        ShapedVector cpy = vec.getType() == 5 ? new DoubleShapedVector((DoubleShapedVectorSpace)vec.getOwner()) : new FloatShapedVector((FloatShapedVectorSpace)vec.getOwner());
        this._copy(cpy, vec);
        return cpy;
    }

    public void checkShape(ShapedArray arr) {
        int rank = this.getRank();
        if (rank != arr.getRank()) {
            throw new NonConformableArrayException("Shaped array rank mismatch.");
        }
        int k = 0;
        while (k < rank) {
            if (this.getDimension(k) != arr.getDimension(k)) {
                throw new NonConformableArrayException("Shaped array dimension mismatch.");
            }
            ++k;
        }
    }

    public abstract ShapedVector create(ShapedArray var1);

    public abstract ShapedVector create(ShapedArray var1, boolean var2);
}

