/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.linalg.Vector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.FloatShapedVectorSpace;
import mitiv.optim.SimpleBoxedSet;

public class FloatBoxedSet
extends SimpleBoxedSet {
    private float[] lo = null;
    private float[] up = null;
    private int bound = 0;

    public FloatBoxedSet(FloatShapedVectorSpace space) {
        super(space);
    }

    private float[] getData(Vector vec) {
        this.space.check(vec);
        return ((FloatShapedVector)vec).getData();
    }

    @Override
    public void setLowerBound(double _val) {
        float val = (float)_val;
        if (val > Float.NEGATIVE_INFINITY) {
            this.lo = new float[]{val};
            this.bound = this.bound / 3 * 3 + 1;
        } else {
            this.lo = null;
            this.bound = this.bound / 3 * 3;
        }
    }

    @Override
    public void setLowerBound(Vector vec) {
        if (vec != null) {
            this.lo = this.getData(vec);
            this.bound = this.bound / 3 * 3 + 2;
        } else {
            this.lo = null;
            this.bound = this.bound / 3 * 3;
        }
    }

    @Override
    public void setUpperBound(double _val) {
        float val = (float)_val;
        if (val < Float.POSITIVE_INFINITY) {
            this.up = new float[]{val};
            this.bound = this.bound % 3 + 3;
        } else {
            this.up = null;
            this.bound %= 3;
        }
    }

    @Override
    public void setUpperBound(Vector vec) {
        if (vec != null) {
            this.up = this.getData(vec);
            this.bound = this.bound % 3 + 6;
        } else {
            this.up = null;
            this.bound %= 3;
        }
    }

    @Override
    public final void projectVariables(Vector dst, Vector vec) {
        float[] xp = this.getData(dst);
        float[] x = this.getData(vec);
        int n = x.length;
        switch (this.bound) {
            case 0: {
                if (xp == x) break;
                System.arraycopy(xp, 0, x, 0, n);
                break;
            }
            case 1: {
                float a = this.lo[0];
                int i = 0;
                while (i < n) {
                    float t = x[i];
                    if (t < a) {
                        t = a;
                    }
                    xp[i] = t;
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < n) {
                    float t = x[i];
                    float a = this.lo[i];
                    if (t < a) {
                        t = a;
                    }
                    xp[i] = t;
                    ++i;
                }
                break;
            }
            case 3: {
                float b = this.up[0];
                int i = 0;
                while (i < n) {
                    float t = x[i];
                    if (t > b) {
                        t = b;
                    }
                    xp[i] = t;
                    ++i;
                }
                break;
            }
            case 4: {
                float a = this.lo[0];
                float b = this.up[0];
                int i = 0;
                while (i < n) {
                    float t = x[i];
                    if (t < a) {
                        t = a;
                    }
                    if (t > b) {
                        t = b;
                    }
                    xp[i] = t;
                    ++i;
                }
                break;
            }
            case 5: {
                float b = this.up[0];
                int i = 0;
                while (i < n) {
                    float t = x[i];
                    float a = this.lo[i];
                    if (t < a) {
                        t = a;
                    }
                    if (t > b) {
                        t = b;
                    }
                    xp[i] = t;
                    ++i;
                }
                break;
            }
            case 6: {
                int i = 0;
                while (i < n) {
                    float t = x[i];
                    float b = this.up[i];
                    if (t > b) {
                        t = b;
                    }
                    xp[i] = t;
                    ++i;
                }
                break;
            }
            case 7: {
                float a = this.lo[0];
                int i = 0;
                while (i < n) {
                    float t = x[i];
                    float b = this.up[i];
                    if (t < a) {
                        t = a;
                    }
                    if (t > b) {
                        t = b;
                    }
                    xp[i] = t;
                    ++i;
                }
                break;
            }
            case 8: {
                int i = 0;
                while (i < n) {
                    float a = this.lo[i];
                    float t = x[i];
                    float b = this.up[i];
                    if (t < a) {
                        t = a;
                    }
                    if (t > b) {
                        t = b;
                    }
                    xp[i] = t;
                    ++i;
                }
                break;
            }
        }
    }

    @Override
    public void projectDirection(Vector dst, Vector vec, Vector dir, int orient) {
        float[] dp = this.getData(dst);
        float[] x = this.getData(vec);
        float[] d = this.getData(dir);
        int n = x.length;
        switch (this.bound) {
            case 0: {
                if (dp == d) break;
                System.arraycopy(dp, 0, d, 0, n);
                break;
            }
            case 1: {
                float a = this.lo[0];
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] >= 0.0f || x[i] > a ? d[i] : 0.0f;
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] <= 0.0f || x[i] > a ? d[i] : 0.0f;
                        ++i;
                    }
                }
                break;
            }
            case 2: {
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] >= 0.0f || x[i] > this.lo[i] ? d[i] : 0.0f;
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] <= 0.0f || x[i] > this.lo[i] ? d[i] : 0.0f;
                        ++i;
                    }
                }
                break;
            }
            case 3: {
                float b = this.up[0];
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] <= 0.0f || x[i] < b ? d[i] : 0.0f;
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] >= 0.0f || x[i] < b ? d[i] : 0.0f;
                        ++i;
                    }
                }
                break;
            }
            case 4: {
                float a = this.lo[0];
                float b = this.up[0];
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] < 0.0f ? (x[i] > a ? d[i] : 0.0f) : (d[i] > 0.0f ? (x[i] < b ? d[i] : 0.0f) : 0.0f);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] > 0.0f ? (x[i] > a ? d[i] : 0.0f) : (d[i] < 0.0f ? (x[i] < b ? d[i] : 0.0f) : 0.0f);
                        ++i;
                    }
                }
                break;
            }
            case 5: {
                float b = this.up[0];
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] < 0.0f ? (x[i] > this.lo[i] ? d[i] : 0.0f) : (d[i] > 0.0f ? (x[i] < b ? d[i] : 0.0f) : 0.0f);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] > 0.0f ? (x[i] > this.lo[i] ? d[i] : 0.0f) : (d[i] < 0.0f ? (x[i] < b ? d[i] : 0.0f) : 0.0f);
                        ++i;
                    }
                }
                break;
            }
            case 6: {
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] <= 0.0f || x[i] < this.up[i] ? d[i] : 0.0f;
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] >= 0.0f || x[i] < this.up[i] ? d[i] : 0.0f;
                        ++i;
                    }
                }
                break;
            }
            case 7: {
                float a = this.lo[0];
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] < 0.0f ? (x[i] > a ? d[i] : 0.0f) : (d[i] > 0.0f ? (x[i] < this.up[i] ? d[i] : 0.0f) : 0.0f);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] > 0.0f ? (x[i] > a ? d[i] : 0.0f) : (d[i] < 0.0f ? (x[i] < this.up[i] ? d[i] : 0.0f) : 0.0f);
                        ++i;
                    }
                }
                break;
            }
            case 8: {
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] < 0.0f ? (x[i] > this.lo[i] ? d[i] : 0.0f) : (d[i] > 0.0f ? (x[i] < this.up[i] ? d[i] : 0.0f) : 0.0f);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] > 0.0f ? (x[i] > this.lo[i] ? d[i] : 0.0f) : (d[i] < 0.0f ? (x[i] < this.up[i] ? d[i] : 0.0f) : 0.0f);
                        ++i;
                    }
                }
                break;
            }
        }
    }

    @Override
    public void findFreeVariables(Vector dst, Vector vec, Vector dir, int orient) {
        float[] w = this.getData(dst);
        float[] x = this.getData(vec);
        float[] d = this.getData(dir);
        int n = x.length;
        switch (this.bound) {
            case 0: {
                int i = 0;
                while (i < n) {
                    w[i] = 1.0f;
                    ++i;
                }
                break;
            }
            case 1: {
                float a = this.lo[0];
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        w[i] = (float)(d[i] < 0.0f ? x[i] > a : d[i] > 0.0f);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        w[i] = (float)(d[i] > 0.0f ? x[i] > a : d[i] < 0.0f);
                        ++i;
                    }
                }
                break;
            }
            case 2: {
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        w[i] = (float)(d[i] < 0.0f ? x[i] > this.lo[i] : d[i] > 0.0f);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        w[i] = (float)(d[i] > 0.0f ? x[i] > this.lo[i] : d[i] < 0.0f);
                        ++i;
                    }
                }
                break;
            }
            case 3: {
                float b = this.up[0];
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        w[i] = (float)(d[i] < 0.0f ? true : (d[i] > 0.0f ? x[i] < b : false));
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        w[i] = (float)(d[i] > 0.0f ? true : (d[i] < 0.0f ? x[i] < b : false));
                        ++i;
                    }
                }
                break;
            }
            case 4: {
                float a = this.lo[0];
                float b = this.up[0];
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        w[i] = (float)(d[i] < 0.0f ? x[i] > a : (d[i] > 0.0f ? x[i] < b : false));
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        w[i] = (float)(d[i] > 0.0f ? x[i] > a : (d[i] < 0.0f ? x[i] < b : false));
                        ++i;
                    }
                }
                break;
            }
            case 5: {
                float b = this.up[0];
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        w[i] = (float)(d[i] < 0.0f ? x[i] > this.lo[i] : (d[i] > 0.0f ? x[i] < b : false));
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        w[i] = (float)(d[i] > 0.0f ? x[i] > this.lo[i] : (d[i] < 0.0f ? x[i] < b : false));
                        ++i;
                    }
                }
                break;
            }
            case 6: {
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        w[i] = (float)(d[i] < 0.0f ? true : (d[i] > 0.0f ? x[i] < this.up[i] : false));
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        w[i] = (float)(d[i] > 0.0f ? true : (d[i] < 0.0f ? x[i] < this.up[i] : false));
                        ++i;
                    }
                }
                break;
            }
            case 7: {
                float a = this.lo[0];
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        w[i] = (float)(d[i] < 0.0f ? x[i] > a : (d[i] > 0.0f ? x[i] < this.up[i] : false));
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        w[i] = (float)(d[i] > 0.0f ? x[i] > a : (d[i] < 0.0f ? x[i] < this.up[i] : false));
                        ++i;
                    }
                }
                break;
            }
            case 8: {
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        w[i] = (float)(d[i] < 0.0f ? x[i] > this.lo[i] : (d[i] > 0.0f ? x[i] < this.up[i] : false));
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        w[i] = (float)(d[i] > 0.0f ? x[i] > this.lo[i] : (d[i] < 0.0f ? x[i] < this.up[i] : false));
                        ++i;
                    }
                }
                break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public double[] findStepLimits(Vector vec, Vector dir, int orient) {
        x = this.getData(vec);
        d = this.getData(dir);
        n = x.length;
        s3 = Infinityf;
        s2 = Infinityf;
        s1 = Infinityf;
        switch (this.bound) {
            case 1: {
                s3 = 0.0f;
                a = this.lo[0];
                if (orient > 0) {
                    i = 0;
                    while (i < n) {
                        p = d[i];
                        if (p < 0.0f) {
                            s = (a - x[i]) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0f) {
                                s2 = s;
                            }
                            if (s > s3) {
                                s3 = s;
                            }
                        } else if (p > 0.0f) {
                            s3 = Infinityf;
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < n) {
                        p = d[i];
                        if (p > 0.0f) {
                            s = (x[i] - a) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0f) {
                                s2 = s;
                            }
                            if (s > s3) {
                                s3 = s;
                            }
                        } else if (p < 0.0f) {
                            s3 = Infinityf;
                        }
                        ++i;
                    }
                }
                break;
            }
            case 2: {
                s3 = 0.0f;
                if (orient > 0) {
                    i = 0;
                    while (i < n) {
                        p = d[i];
                        if (p < 0.0f) {
                            s = (this.lo[i] - x[i]) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0f) {
                                s2 = s;
                            }
                            if (s > s3) {
                                s3 = s;
                            }
                        } else if (p > 0.0f) {
                            s3 = Infinityf;
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < n) {
                        p = d[i];
                        if (p > 0.0f) {
                            s = (x[i] - this.lo[i]) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0f) {
                                s2 = s;
                            }
                            if (s > s3) {
                                s3 = s;
                            }
                        } else if (p < 0.0f) {
                            s3 = Infinityf;
                        }
                        ++i;
                    }
                }
                break;
            }
            case 3: {
                s3 = 0.0f;
                b = this.up[0];
                if (orient > 0) {
                    i = 0;
                    while (i < n) {
                        p = d[i];
                        if (p > 0.0f) {
                            s = (b - x[i]) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0f) {
                                s2 = s;
                            }
                            if (s > s3) {
                                s3 = s;
                            }
                        } else if (p < 0.0f) {
                            s3 = Infinityf;
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < n) {
                        p = d[i];
                        if (p < 0.0f) {
                            s = (x[i] - b) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0f) {
                                s2 = s;
                            }
                            if (s > s3) {
                                s3 = s;
                            }
                        } else if (p > 0.0f) {
                            s3 = Infinityf;
                        }
                        ++i;
                    }
                }
                break;
            }
            case 4: {
                s3 = 0.0f;
                a = this.lo[0];
                b = this.up[0];
                if (orient <= 0) ** GOTO lbl143
                i = 0;
                while (i < n) {
                    p = d[i];
                    if (!(p > 0.0f)) ** GOTO lbl132
                    s = (b - x[i]) / p;
                    ** GOTO lbl134
lbl132:
                    // 1 sources

                    if (!(p < 0.0f)) ** GOTO lbl140
                    s = (a - x[i]) / p;
lbl134:
                    // 2 sources

                    if (s < s1) {
                        s1 = s;
                    }
                    if (s < s2 && s > 0.0f) {
                        s2 = s;
                    }
                    if (s > s3) {
                        s3 = s;
                    }
lbl140:
                    // 4 sources

                    ++i;
                }
                break;
lbl143:
                // 1 sources

                i = 0;
                while (i < n) {
                    p = d[i];
                    if (!(p < 0.0f)) ** GOTO lbl149
                    s = (x[i] - b) / p;
                    ** GOTO lbl151
lbl149:
                    // 1 sources

                    if (!(p > 0.0f)) ** GOTO lbl157
                    s = (x[i] - a) / p;
lbl151:
                    // 2 sources

                    if (s < s1) {
                        s1 = s;
                    }
                    if (s < s2 && s > 0.0f) {
                        s2 = s;
                    }
                    if (s > s3) {
                        s3 = s;
                    }
lbl157:
                    // 4 sources

                    ++i;
                }
                break;
            }
            case 5: {
                s3 = 0.0f;
                b = this.up[0];
                if (orient <= 0) ** GOTO lbl181
                i = 0;
                while (i < n) {
                    p = d[i];
                    if (!(p > 0.0f)) ** GOTO lbl170
                    s = (b - x[i]) / p;
                    ** GOTO lbl172
lbl170:
                    // 1 sources

                    if (!(p < 0.0f)) ** GOTO lbl178
                    s = (this.lo[i] - x[i]) / p;
lbl172:
                    // 2 sources

                    if (s < s1) {
                        s1 = s;
                    }
                    if (s < s2 && s > 0.0f) {
                        s2 = s;
                    }
                    if (s > s3) {
                        s3 = s;
                    }
lbl178:
                    // 4 sources

                    ++i;
                }
                break;
lbl181:
                // 1 sources

                i = 0;
                while (i < n) {
                    p = d[i];
                    if (!(p < 0.0f)) ** GOTO lbl187
                    s = (x[i] - b) / p;
                    ** GOTO lbl189
lbl187:
                    // 1 sources

                    if (!(p > 0.0f)) ** GOTO lbl195
                    s = (x[i] - this.lo[i]) / p;
lbl189:
                    // 2 sources

                    if (s < s1) {
                        s1 = s;
                    }
                    if (s < s2 && s > 0.0f) {
                        s2 = s;
                    }
                    if (s > s3) {
                        s3 = s;
                    }
lbl195:
                    // 4 sources

                    ++i;
                }
                break;
            }
            case 6: {
                s3 = 0.0f;
                if (orient > 0) {
                    i = 0;
                    while (i < n) {
                        p = d[i];
                        if (p > 0.0f) {
                            s = (this.up[i] - x[i]) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0f) {
                                s2 = s;
                            }
                            if (s > s3) {
                                s3 = s;
                            }
                        } else if (p < 0.0f) {
                            s3 = Infinityf;
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < n) {
                        p = d[i];
                        if (p < 0.0f) {
                            s = (x[i] - this.up[i]) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0f) {
                                s2 = s;
                            }
                            if (s > s3) {
                                s3 = s;
                            }
                        } else if (p > 0.0f) {
                            s3 = Infinityf;
                        }
                        ++i;
                    }
                }
                break;
            }
            case 7: {
                s3 = 0.0f;
                a = this.lo[0];
                if (orient <= 0) ** GOTO lbl256
                i = 0;
                while (i < n) {
                    p = d[i];
                    if (!(p > 0.0f)) ** GOTO lbl245
                    s = (this.up[i] - x[i]) / p;
                    ** GOTO lbl247
lbl245:
                    // 1 sources

                    if (!(p < 0.0f)) ** GOTO lbl253
                    s = (a - x[i]) / p;
lbl247:
                    // 2 sources

                    if (s < s1) {
                        s1 = s;
                    }
                    if (s < s2 && s > 0.0f) {
                        s2 = s;
                    }
                    if (s > s3) {
                        s3 = s;
                    }
lbl253:
                    // 4 sources

                    ++i;
                }
                break;
lbl256:
                // 1 sources

                i = 0;
                while (i < n) {
                    p = d[i];
                    if (!(p < 0.0f)) ** GOTO lbl262
                    s = (x[i] - this.up[i]) / p;
                    ** GOTO lbl264
lbl262:
                    // 1 sources

                    if (!(p > 0.0f)) ** GOTO lbl270
                    s = (x[i] - a) / p;
lbl264:
                    // 2 sources

                    if (s < s1) {
                        s1 = s;
                    }
                    if (s < s2 && s > 0.0f) {
                        s2 = s;
                    }
                    if (s > s3) {
                        s3 = s;
                    }
lbl270:
                    // 4 sources

                    ++i;
                }
                break;
            }
            case 8: {
                s3 = 0.0f;
                if (orient <= 0) ** GOTO lbl293
                i = 0;
                while (i < n) {
                    p = d[i];
                    if (!(p > 0.0f)) ** GOTO lbl282
                    s = (this.up[i] - x[i]) / p;
                    ** GOTO lbl284
lbl282:
                    // 1 sources

                    if (!(p < 0.0f)) ** GOTO lbl290
                    s = (this.lo[i] - x[i]) / p;
lbl284:
                    // 2 sources

                    if (s < s1) {
                        s1 = s;
                    }
                    if (s < s2 && s > 0.0f) {
                        s2 = s;
                    }
                    if (s > s3) {
                        s3 = s;
                    }
lbl290:
                    // 4 sources

                    ++i;
                }
                break;
lbl293:
                // 1 sources

                i = 0;
                while (i < n) {
                    p = d[i];
                    if (!(p < 0.0f)) ** GOTO lbl299
                    s = (x[i] - this.up[i]) / p;
                    ** GOTO lbl301
lbl299:
                    // 1 sources

                    if (!(p > 0.0f)) ** GOTO lbl307
                    s = (x[i] - this.lo[i]) / p;
lbl301:
                    // 2 sources

                    if (s < s1) {
                        s1 = s;
                    }
                    if (s < s2 && s > 0.0f) {
                        s2 = s;
                    }
                    if (s > s3) {
                        s3 = s;
                    }
lbl307:
                    // 4 sources

                    ++i;
                }
                break;
            }
        }
        return new double[]{s1, s2, s3};
    }
}

