/*
 * Decompiled with CFR 0.152.
 */
package mitiv.utils;

import java.util.Locale;

public class Timer {
    private long integrated = 0L;
    private long marked = 0L;
    private boolean running = false;
    private static final double NANOSECOND = 1.0E-9;

    public final void start() {
        this.integrated = 0L;
        this.running = true;
        this.marked = System.nanoTime();
    }

    public final void reset() {
        this.integrated = 0L;
    }

    public final void stop() {
        if (this.running) {
            long current = System.nanoTime();
            this.integrated += current - this.marked;
            this.marked = current;
            this.running = false;
        }
    }

    public void resume() {
        if (!this.running) {
            this.marked = System.nanoTime();
            this.running = true;
        }
    }

    public double getElapsedTime() {
        long total = this.integrated;
        if (this.running) {
            total += System.nanoTime() - this.marked;
        }
        return (double)total * 1.0E-9;
    }

    public static void main(String[] args) {
        Locale.setDefault(Locale.US);
        Timer t1 = new Timer();
        Timer t2 = new Timer();
        long sum = 0L;
        t1.start();
        t2.start();
        int j = 0;
        while (j < 1000) {
            sum += (long)(j * j);
            t2.stop();
            int k = 0;
            while (k < j) {
                sum += (long)(k * k * k);
                ++k;
            }
            t2.resume();
            ++j;
        }
        t2.stop();
        System.out.format("elapsed time 1 = %.9f s\n", t1.getElapsedTime());
        System.out.format("elapsed time 2 = %.9f s\n", t2.getElapsedTime());
        System.out.format("result = %d\n", sum);
        System.out.format("elapsed time 1 = %.9f s\n", t1.getElapsedTime());
        System.out.format("elapsed time 2 = %.9f s\n", t2.getElapsedTime());
        System.out.format("result = %d\n", sum);
        System.out.format("elapsed time 1 = %.9f s\n", t1.getElapsedTime());
    }
}

