/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array9D;
import mitiv.array.Byte9D;
import mitiv.array.Double1D;
import mitiv.array.Double8D;
import mitiv.array.DoubleArray;
import mitiv.array.Float9D;
import mitiv.array.Int9D;
import mitiv.array.Long9D;
import mitiv.array.ShapedArray;
import mitiv.array.Short9D;
import mitiv.array.impl.FlatDouble9D;
import mitiv.array.impl.StriddenDouble9D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.DoubleGenerator;

public abstract class Double9D
extends Array9D
implements DoubleArray {
    protected Double9D(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8, int dim9) {
        super(dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9);
    }

    protected Double9D(int[] dims) {
        super(dims);
    }

    protected Double9D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 5;
    }

    public abstract double get(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, double var10);

    @Override
    public void fill(double value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            int i9 = 0;
                                            while (i9 < this.dim9) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, value);
                                                ++i9;
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, value);
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        }
    }

    @Override
    public void increment(double value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            int i9 = 0;
                                            while (i9 < this.dim9) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9) + value);
                                                ++i9;
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9) + value);
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        }
    }

    @Override
    public void decrement(double value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            int i9 = 0;
                                            while (i9 < this.dim9) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9) - value);
                                                ++i9;
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9) - value);
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        }
    }

    @Override
    public void scale(double value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            int i9 = 0;
                                            while (i9 < this.dim9) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9) * value);
                                                ++i9;
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9) * value);
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        }
    }

    @Override
    public void map(DoubleFunction function) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            int i9 = 0;
                                            while (i9 < this.dim9) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, function.apply(this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9)));
                                                ++i9;
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, function.apply(this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9)));
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        }
    }

    @Override
    public void fill(DoubleGenerator generator) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            int i9 = 0;
                                            while (i9 < this.dim9) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, generator.nextDouble());
                                                ++i9;
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, generator.nextDouble());
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        }
    }

    @Override
    public void scan(DoubleScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            int i9 = 0;
                                            while (i9 < this.dim9) {
                                                if (initialized) {
                                                    scanner.update(this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9));
                                                } else {
                                                    scanner.initialize(this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9));
                                                    initialized = true;
                                                }
                                                ++i9;
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                if (initialized) {
                                                    scanner.update(this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9));
                                                } else {
                                                    scanner.initialize(this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9));
                                                    initialized = true;
                                                }
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        }
    }

    @Override
    public double[] flatten(boolean forceCopy) {
        double[] out = new double[this.number];
        int i = -1;
        int i9 = 0;
        while (i9 < this.dim9) {
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            out[++i] = this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
            ++i9;
        }
        return out;
    }

    @Override
    public double[] flatten() {
        return this.flatten(false);
    }

    @Override
    public double min() {
        double minValue = this.get(0, 0, 0, 0, 0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            int i9 = 0;
                                            while (i9 < this.dim9) {
                                                if (skip) {
                                                    skip = false;
                                                } else {
                                                    double value = this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                                    if (value < minValue) {
                                                        minValue = value;
                                                    }
                                                }
                                                ++i9;
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                if (skip) {
                                                    skip = false;
                                                } else {
                                                    double value = this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                                    if (value < minValue) {
                                                        minValue = value;
                                                    }
                                                }
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        }
        return minValue;
    }

    @Override
    public double max() {
        double maxValue = this.get(0, 0, 0, 0, 0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            int i9 = 0;
                                            while (i9 < this.dim9) {
                                                if (skip) {
                                                    skip = false;
                                                } else {
                                                    double value = this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                                    if (value > maxValue) {
                                                        maxValue = value;
                                                    }
                                                }
                                                ++i9;
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                if (skip) {
                                                    skip = false;
                                                } else {
                                                    double value = this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                                    if (value > maxValue) {
                                                        maxValue = value;
                                                    }
                                                }
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        }
        return maxValue;
    }

    @Override
    public double[] getMinAndMax() {
        double[] result = new double[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(double[] mm) {
        double minValue;
        double maxValue = minValue = this.get(0, 0, 0, 0, 0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            int i9 = 0;
                                            while (i9 < this.dim9) {
                                                if (skip) {
                                                    skip = false;
                                                } else {
                                                    double value = this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                                    if (value < minValue) {
                                                        minValue = value;
                                                    }
                                                    if (value > maxValue) {
                                                        maxValue = value;
                                                    }
                                                }
                                                ++i9;
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                if (skip) {
                                                    skip = false;
                                                } else {
                                                    double value = this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                                    if (value < minValue) {
                                                        minValue = value;
                                                    }
                                                    if (value > maxValue) {
                                                        maxValue = value;
                                                    }
                                                }
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public double sum() {
        double totalValue = 0.0;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            int i9 = 0;
                                            while (i9 < this.dim9) {
                                                totalValue += this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                                ++i9;
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                totalValue += this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        }
        return totalValue;
    }

    @Override
    public double average() {
        return this.sum() / (double)this.number;
    }

    @Override
    public Byte9D toByte() {
        byte[] out = new byte[this.number];
        int i = -1;
        int i9 = 0;
        while (i9 < this.dim9) {
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            out[++i] = (byte)this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
            ++i9;
        }
        return Byte9D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7, this.dim8, this.dim9);
    }

    @Override
    public Short9D toShort() {
        short[] out = new short[this.number];
        int i = -1;
        int i9 = 0;
        while (i9 < this.dim9) {
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            out[++i] = (short)this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
            ++i9;
        }
        return Short9D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7, this.dim8, this.dim9);
    }

    @Override
    public Int9D toInt() {
        int[] out = new int[this.number];
        int i = -1;
        int i9 = 0;
        while (i9 < this.dim9) {
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            out[++i] = (int)this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
            ++i9;
        }
        return Int9D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7, this.dim8, this.dim9);
    }

    @Override
    public Long9D toLong() {
        long[] out = new long[this.number];
        int i = -1;
        int i9 = 0;
        while (i9 < this.dim9) {
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            out[++i] = (long)this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
            ++i9;
        }
        return Long9D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7, this.dim8, this.dim9);
    }

    @Override
    public Float9D toFloat() {
        float[] out = new float[this.number];
        int i = -1;
        int i9 = 0;
        while (i9 < this.dim9) {
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            out[++i] = (float)this.get(i1, i2, i3, i4, i5, i6, i7, i8, i9);
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
            ++i9;
        }
        return Float9D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7, this.dim8, this.dim9);
    }

    @Override
    public Double9D toDouble() {
        return this;
    }

    @Override
    public Double9D copy() {
        return new FlatDouble9D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        Double9D src = arr.getType() == 5 ? (Double9D)arr : (Double9D)arr.toDouble();
        if (this.getOrder() == 2 && src.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            int i9 = 0;
                                            while (i9 < this.dim9) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, src.get(i1, i2, i3, i4, i5, i6, i7, i8, i9));
                                                ++i9;
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, src.get(i1, i2, i3, i4, i5, i6, i7, i8, i9));
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        int i = -1;
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, src.get(++i));
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            int i9 = 0;
            while (i9 < this.dim9) {
                int i8 = 0;
                while (i8 < this.dim8) {
                    int i7 = 0;
                    while (i7 < this.dim7) {
                        int i6 = 0;
                        while (i6 < this.dim6) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i4 = 0;
                                while (i4 < this.dim4) {
                                    int i3 = 0;
                                    while (i3 < this.dim3) {
                                        int i2 = 0;
                                        while (i2 < this.dim2) {
                                            int i1 = 0;
                                            while (i1 < this.dim1) {
                                                this.set(i1, i2, i3, i4, i5, i6, i7, i8, i9, src.get(++i));
                                                ++i1;
                                            }
                                            ++i2;
                                        }
                                        ++i3;
                                    }
                                    ++i4;
                                }
                                ++i5;
                            }
                            ++i6;
                        }
                        ++i7;
                    }
                    ++i8;
                }
                ++i9;
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Double9D create() {
        return new FlatDouble9D(this.getShape());
    }

    public static Double9D create(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8, int dim9) {
        return new FlatDouble9D(dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9);
    }

    public static Double9D create(int[] dims) {
        return new FlatDouble9D(dims);
    }

    public static Double9D create(Shape shape) {
        return new FlatDouble9D(shape);
    }

    public static Double9D wrap(double[] data, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8, int dim9) {
        return new FlatDouble9D(data, dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9);
    }

    public static Double9D wrap(double[] data, int[] dims) {
        return new FlatDouble9D(data, dims);
    }

    public static Double9D wrap(double[] data, Shape shape) {
        return new FlatDouble9D(data, shape);
    }

    public static Double9D wrap(double[] data, int offset, int stride1, int stride2, int stride3, int stride4, int stride5, int stride6, int stride7, int stride8, int stride9, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8, int dim9) {
        return new StriddenDouble9D(data, offset, stride1, stride2, stride3, stride4, stride5, stride6, stride7, stride8, stride9, dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9);
    }

    @Override
    public abstract Double8D slice(int var1);

    @Override
    public abstract Double8D slice(int var1, int var2);

    @Override
    public abstract Double9D view(Range var1, Range var2, Range var3, Range var4, Range var5, Range var6, Range var7, Range var8, Range var9);

    @Override
    public abstract Double9D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8, int[] var9);

    @Override
    public abstract Double1D as1D();
}

