/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array8D;
import mitiv.array.Byte8D;
import mitiv.array.Double8D;
import mitiv.array.Float8D;
import mitiv.array.Int1D;
import mitiv.array.Int7D;
import mitiv.array.IntArray;
import mitiv.array.Long8D;
import mitiv.array.ShapedArray;
import mitiv.array.Short8D;
import mitiv.array.impl.FlatInt8D;
import mitiv.array.impl.StriddenInt8D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.IntFunction;
import mitiv.base.mapping.IntScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.IntGenerator;

public abstract class Int8D
extends Array8D
implements IntArray {
    protected Int8D(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8) {
        super(dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8);
    }

    protected Int8D(int[] dims) {
        super(dims);
    }

    protected Int8D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 2;
    }

    public abstract int get(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    @Override
    public void fill(int value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, value);
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, value);
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
        }
    }

    @Override
    public void increment(int value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, this.get(i1, i2, i3, i4, i5, i6, i7, i8) + value);
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, this.get(i1, i2, i3, i4, i5, i6, i7, i8) + value);
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
        }
    }

    @Override
    public void decrement(int value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, this.get(i1, i2, i3, i4, i5, i6, i7, i8) - value);
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, this.get(i1, i2, i3, i4, i5, i6, i7, i8) - value);
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
        }
    }

    @Override
    public void scale(int value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, this.get(i1, i2, i3, i4, i5, i6, i7, i8) * value);
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, this.get(i1, i2, i3, i4, i5, i6, i7, i8) * value);
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
        }
    }

    @Override
    public void map(IntFunction function) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, function.apply(this.get(i1, i2, i3, i4, i5, i6, i7, i8)));
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, function.apply(this.get(i1, i2, i3, i4, i5, i6, i7, i8)));
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
        }
    }

    @Override
    public void fill(IntGenerator generator) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, generator.nextInt());
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, generator.nextInt());
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
        }
    }

    @Override
    public void scan(IntScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            if (initialized) {
                                                scanner.update(this.get(i1, i2, i3, i4, i5, i6, i7, i8));
                                            } else {
                                                scanner.initialize(this.get(i1, i2, i3, i4, i5, i6, i7, i8));
                                                initialized = true;
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            if (initialized) {
                                                scanner.update(this.get(i1, i2, i3, i4, i5, i6, i7, i8));
                                            } else {
                                                scanner.initialize(this.get(i1, i2, i3, i4, i5, i6, i7, i8));
                                                initialized = true;
                                            }
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
        }
    }

    @Override
    public int[] flatten(boolean forceCopy) {
        int[] out = new int[this.number];
        int i = -1;
        int i8 = 0;
        while (i8 < this.dim8) {
            int i7 = 0;
            while (i7 < this.dim7) {
                int i6 = 0;
                while (i6 < this.dim6) {
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        out[++i] = this.get(i1, i2, i3, i4, i5, i6, i7, i8);
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
            ++i8;
        }
        return out;
    }

    @Override
    public int[] flatten() {
        return this.flatten(false);
    }

    @Override
    public int min() {
        int minValue = this.get(0, 0, 0, 0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            if (skip) {
                                                skip = false;
                                            } else {
                                                int value = this.get(i1, i2, i3, i4, i5, i6, i7, i8);
                                                if (value < minValue) {
                                                    minValue = value;
                                                }
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            if (skip) {
                                                skip = false;
                                            } else {
                                                int value = this.get(i1, i2, i3, i4, i5, i6, i7, i8);
                                                if (value < minValue) {
                                                    minValue = value;
                                                }
                                            }
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
        }
        return minValue;
    }

    @Override
    public int max() {
        int maxValue = this.get(0, 0, 0, 0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            if (skip) {
                                                skip = false;
                                            } else {
                                                int value = this.get(i1, i2, i3, i4, i5, i6, i7, i8);
                                                if (value > maxValue) {
                                                    maxValue = value;
                                                }
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            if (skip) {
                                                skip = false;
                                            } else {
                                                int value = this.get(i1, i2, i3, i4, i5, i6, i7, i8);
                                                if (value > maxValue) {
                                                    maxValue = value;
                                                }
                                            }
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
        }
        return maxValue;
    }

    @Override
    public int[] getMinAndMax() {
        int[] result = new int[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(int[] mm) {
        int minValue;
        int maxValue = minValue = this.get(0, 0, 0, 0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            if (skip) {
                                                skip = false;
                                            } else {
                                                int value = this.get(i1, i2, i3, i4, i5, i6, i7, i8);
                                                if (value < minValue) {
                                                    minValue = value;
                                                }
                                                if (value > maxValue) {
                                                    maxValue = value;
                                                }
                                            }
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            if (skip) {
                                                skip = false;
                                            } else {
                                                int value = this.get(i1, i2, i3, i4, i5, i6, i7, i8);
                                                if (value < minValue) {
                                                    minValue = value;
                                                }
                                                if (value > maxValue) {
                                                    maxValue = value;
                                                }
                                            }
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public int sum() {
        int totalValue = 0;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            totalValue += this.get(i1, i2, i3, i4, i5, i6, i7, i8);
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            totalValue += this.get(i1, i2, i3, i4, i5, i6, i7, i8);
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
        }
        return totalValue;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte8D toByte() {
        byte[] out = new byte[this.number];
        int i = -1;
        int i8 = 0;
        while (i8 < this.dim8) {
            int i7 = 0;
            while (i7 < this.dim7) {
                int i6 = 0;
                while (i6 < this.dim6) {
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        out[++i] = (byte)this.get(i1, i2, i3, i4, i5, i6, i7, i8);
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
            ++i8;
        }
        return Byte8D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7, this.dim8);
    }

    @Override
    public Short8D toShort() {
        short[] out = new short[this.number];
        int i = -1;
        int i8 = 0;
        while (i8 < this.dim8) {
            int i7 = 0;
            while (i7 < this.dim7) {
                int i6 = 0;
                while (i6 < this.dim6) {
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        out[++i] = (short)this.get(i1, i2, i3, i4, i5, i6, i7, i8);
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
            ++i8;
        }
        return Short8D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7, this.dim8);
    }

    @Override
    public Int8D toInt() {
        return this;
    }

    @Override
    public Long8D toLong() {
        long[] out = new long[this.number];
        int i = -1;
        int i8 = 0;
        while (i8 < this.dim8) {
            int i7 = 0;
            while (i7 < this.dim7) {
                int i6 = 0;
                while (i6 < this.dim6) {
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        out[++i] = this.get(i1, i2, i3, i4, i5, i6, i7, i8);
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
            ++i8;
        }
        return Long8D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7, this.dim8);
    }

    @Override
    public Float8D toFloat() {
        float[] out = new float[this.number];
        int i = -1;
        int i8 = 0;
        while (i8 < this.dim8) {
            int i7 = 0;
            while (i7 < this.dim7) {
                int i6 = 0;
                while (i6 < this.dim6) {
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        out[++i] = this.get(i1, i2, i3, i4, i5, i6, i7, i8);
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
            ++i8;
        }
        return Float8D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7, this.dim8);
    }

    @Override
    public Double8D toDouble() {
        double[] out = new double[this.number];
        int i = -1;
        int i8 = 0;
        while (i8 < this.dim8) {
            int i7 = 0;
            while (i7 < this.dim7) {
                int i6 = 0;
                while (i6 < this.dim6) {
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        out[++i] = this.get(i1, i2, i3, i4, i5, i6, i7, i8);
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
            ++i8;
        }
        return Double8D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7, this.dim8);
    }

    @Override
    public Int8D copy() {
        return new FlatInt8D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        Int8D src = arr.getType() == 2 ? (Int8D)arr : (Int8D)arr.toInt();
        if (this.getOrder() == 2 && src.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int i8 = 0;
                                        while (i8 < this.dim8) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, src.get(i1, i2, i3, i4, i5, i6, i7, i8));
                                            ++i8;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, src.get(i1, i2, i3, i4, i5, i6, i7, i8));
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        int i = -1;
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, (int)src.get(++i));
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            int i8 = 0;
            while (i8 < this.dim8) {
                int i7 = 0;
                while (i7 < this.dim7) {
                    int i6 = 0;
                    while (i6 < this.dim6) {
                        int i5 = 0;
                        while (i5 < this.dim5) {
                            int i4 = 0;
                            while (i4 < this.dim4) {
                                int i3 = 0;
                                while (i3 < this.dim3) {
                                    int i2 = 0;
                                    while (i2 < this.dim2) {
                                        int i1 = 0;
                                        while (i1 < this.dim1) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, (int)src.get(++i));
                                            ++i1;
                                        }
                                        ++i2;
                                    }
                                    ++i3;
                                }
                                ++i4;
                            }
                            ++i5;
                        }
                        ++i6;
                    }
                    ++i7;
                }
                ++i8;
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Int8D create() {
        return new FlatInt8D(this.getShape());
    }

    public static Int8D create(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8) {
        return new FlatInt8D(dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8);
    }

    public static Int8D create(int[] dims) {
        return new FlatInt8D(dims);
    }

    public static Int8D create(Shape shape) {
        return new FlatInt8D(shape);
    }

    public static Int8D wrap(int[] data, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8) {
        return new FlatInt8D(data, dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8);
    }

    public static Int8D wrap(int[] data, int[] dims) {
        return new FlatInt8D(data, dims);
    }

    public static Int8D wrap(int[] data, Shape shape) {
        return new FlatInt8D(data, shape);
    }

    public static Int8D wrap(int[] data, int offset, int stride1, int stride2, int stride3, int stride4, int stride5, int stride6, int stride7, int stride8, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8) {
        return new StriddenInt8D(data, offset, stride1, stride2, stride3, stride4, stride5, stride6, stride7, stride8, dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8);
    }

    @Override
    public abstract Int7D slice(int var1);

    @Override
    public abstract Int7D slice(int var1, int var2);

    @Override
    public abstract Int8D view(Range var1, Range var2, Range var3, Range var4, Range var5, Range var6, Range var7, Range var8);

    @Override
    public abstract Int8D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8);

    @Override
    public abstract Int1D as1D();
}

