/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.Byte1D;
import mitiv.array.Double1D;
import mitiv.array.Float1D;
import mitiv.array.Int1D;
import mitiv.array.LongArray;
import mitiv.array.LongScalar;
import mitiv.array.ShapedArray;
import mitiv.array.Short1D;
import mitiv.array.impl.FlatLong1D;
import mitiv.array.impl.StriddenLong1D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.LongFunction;
import mitiv.base.mapping.LongScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.LongGenerator;

public abstract class Long1D
extends Array1D
implements LongArray {
    protected Long1D(int dim1) {
        super(dim1);
    }

    protected Long1D(int[] dims) {
        super(dims);
    }

    protected Long1D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 3;
    }

    public abstract long get(int var1);

    public abstract void set(int var1, long var2);

    @Override
    public void fill(long value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, value);
            ++i1;
        }
    }

    @Override
    public void increment(long value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, this.get(i1) + value);
            ++i1;
        }
    }

    @Override
    public void decrement(long value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, this.get(i1) - value);
            ++i1;
        }
    }

    @Override
    public void scale(long value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, this.get(i1) * value);
            ++i1;
        }
    }

    @Override
    public void map(LongFunction function) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, function.apply(this.get(i1)));
            ++i1;
        }
    }

    @Override
    public void fill(LongGenerator generator) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, generator.nextLong());
            ++i1;
        }
    }

    @Override
    public void scan(LongScanner scanner) {
        scanner.initialize(this.get(0));
        int i1 = 1;
        while (i1 < this.dim1) {
            scanner.update(this.get(i1));
            ++i1;
        }
    }

    @Override
    public long[] flatten(boolean forceCopy) {
        long[] out = new long[this.number];
        int i1 = 0;
        while (i1 < this.dim1) {
            out[i1] = this.get(i1);
            ++i1;
        }
        return out;
    }

    @Override
    public long[] flatten() {
        return this.flatten(false);
    }

    @Override
    public long min() {
        long minValue = this.get(0);
        int i1 = 1;
        while (i1 < this.dim1) {
            long value = this.get(i1);
            if (value < minValue) {
                minValue = value;
            }
            ++i1;
        }
        return minValue;
    }

    @Override
    public long max() {
        long maxValue = this.get(0);
        int i1 = 1;
        while (i1 < this.dim1) {
            long value = this.get(i1);
            if (value > maxValue) {
                maxValue = value;
            }
            ++i1;
        }
        return maxValue;
    }

    @Override
    public long[] getMinAndMax() {
        long[] result = new long[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(long[] mm) {
        long minValue;
        long maxValue = minValue = this.get(0);
        int i1 = 1;
        while (i1 < this.dim1) {
            long value = this.get(i1);
            if (value < minValue) {
                minValue = value;
            }
            if (value > maxValue) {
                maxValue = value;
            }
            ++i1;
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public long sum() {
        long totalValue = this.get(0);
        int i1 = 1;
        while (i1 < this.dim1) {
            totalValue += this.get(i1);
            ++i1;
        }
        return totalValue;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte1D toByte() {
        byte[] out = new byte[this.number];
        int i = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            out[++i] = (byte)this.get(i1);
            ++i1;
        }
        return Byte1D.wrap(out, this.dim1);
    }

    @Override
    public Short1D toShort() {
        short[] out = new short[this.number];
        int i = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            out[++i] = (short)this.get(i1);
            ++i1;
        }
        return Short1D.wrap(out, this.dim1);
    }

    @Override
    public Int1D toInt() {
        int[] out = new int[this.number];
        int i = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            out[++i] = (int)this.get(i1);
            ++i1;
        }
        return Int1D.wrap(out, this.dim1);
    }

    @Override
    public Long1D toLong() {
        return this;
    }

    @Override
    public Float1D toFloat() {
        float[] out = new float[this.number];
        int i = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            out[++i] = this.get(i1);
            ++i1;
        }
        return Float1D.wrap(out, this.dim1);
    }

    @Override
    public Double1D toDouble() {
        double[] out = new double[this.number];
        int i = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            out[++i] = this.get(i1);
            ++i1;
        }
        return Double1D.wrap(out, this.dim1);
    }

    @Override
    public Long1D copy() {
        return new FlatLong1D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        Long1D src = arr.getType() == 3 ? (Long1D)arr : (Long1D)arr.toLong();
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, src.get(i1));
            ++i1;
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            int i1 = 0;
            while (i1 < this.dim1) {
                this.set(i1, (long)src.get(i1));
                ++i1;
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            int i1 = 0;
            while (i1 < this.dim1) {
                this.set(i1, (long)src.get(i1));
                ++i1;
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Long1D create() {
        return new FlatLong1D(this.getShape());
    }

    public static Long1D create(int dim1) {
        return new FlatLong1D(dim1);
    }

    public static Long1D create(int[] dims) {
        return new FlatLong1D(dims);
    }

    public static Long1D create(Shape shape) {
        return new FlatLong1D(shape);
    }

    public static Long1D wrap(long[] data, int dim1) {
        return new FlatLong1D(data, dim1);
    }

    public static Long1D wrap(long[] data, int[] dims) {
        return new FlatLong1D(data, dims);
    }

    public static Long1D wrap(long[] data, Shape shape) {
        return new FlatLong1D(data, shape);
    }

    public static Long1D wrap(long[] data, int offset, int stride1, int dim1) {
        return new StriddenLong1D(data, offset, stride1, dim1);
    }

    @Override
    public abstract LongScalar slice(int var1);

    @Override
    public abstract LongScalar slice(int var1, int var2);

    @Override
    public abstract Long1D view(Range var1);

    @Override
    public abstract Long1D view(int[] var1);

    @Override
    public abstract Long1D as1D();
}

