/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Byte1D;
import mitiv.array.ByteScalar;
import mitiv.array.impl.Helper;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ByteFunction;
import mitiv.base.mapping.ByteScanner;
import mitiv.random.ByteGenerator;

public class SelectedByte1D
extends Byte1D {
    static final int order = 0;
    final byte[] data;
    final int[] idx1;

    public SelectedByte1D(byte[] arr, int[] idx1) {
        super(idx1.length);
        this.data = arr;
        this.idx1 = idx1;
    }

    @Override
    public final void checkSanity() {
        int indexMax;
        int offsetMin = 0;
        int offsetMax = 0;
        int indexMin = indexMax = this.idx1[0];
        int i1 = 1;
        while (i1 < this.dim1) {
            int index = this.idx1[i1];
            if (index < indexMin) {
                indexMin = index;
            }
            if (index > indexMax) {
                indexMax = index;
            }
            ++i1;
        }
        if ((offsetMin += indexMin) < 0 || (offsetMax += indexMax) >= this.data.length) {
            throw new IndexOutOfBoundsException("Selected indices are out of bounds.");
        }
    }

    final int index(int i1) {
        return this.idx1[i1];
    }

    @Override
    public final byte get(int i1) {
        return this.data[this.idx1[i1]];
    }

    @Override
    public final void set(int i1, byte value) {
        this.data[this.idx1[i1]] = value;
    }

    @Override
    public final int getOrder() {
        return 0;
    }

    @Override
    public void fill(byte value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            int j1 = this.idx1[i1];
            this.data[j1] = value;
            ++i1;
        }
    }

    @Override
    public void fill(ByteGenerator generator) {
        int i1 = 0;
        while (i1 < this.dim1) {
            int j1 = this.idx1[i1];
            this.data[j1] = generator.nextByte();
            ++i1;
        }
    }

    @Override
    public void increment(byte value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            int j1;
            int n = j1 = this.idx1[i1];
            this.data[n] = (byte)(this.data[n] + value);
            ++i1;
        }
    }

    @Override
    public void decrement(byte value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            int j1;
            int n = j1 = this.idx1[i1];
            this.data[n] = (byte)(this.data[n] - value);
            ++i1;
        }
    }

    @Override
    public void scale(byte value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            int j1;
            int n = j1 = this.idx1[i1];
            this.data[n] = (byte)(this.data[n] * value);
            ++i1;
        }
    }

    @Override
    public void map(ByteFunction function) {
        int i1 = 0;
        while (i1 < this.dim1) {
            int j1 = this.idx1[i1];
            this.data[j1] = function.apply(this.data[j1]);
            ++i1;
        }
    }

    @Override
    public void scan(ByteScanner scanner) {
        boolean initialized = false;
        int i1 = 0;
        while (i1 < this.dim1) {
            int j1 = this.idx1[i1];
            if (initialized) {
                scanner.update(this.data[j1]);
            } else {
                scanner.initialize(this.data[j1]);
                initialized = true;
            }
            ++i1;
        }
    }

    @Override
    public byte[] flatten(boolean forceCopy) {
        byte[] out = new byte[this.number];
        int j = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            int j1 = this.idx1[i1];
            out[++j] = this.data[j1];
            ++i1;
        }
        return out;
    }

    @Override
    public ByteScalar slice(int idx) {
        return new ByteScalar(this.data, this.idx1[Helper.fixIndex(idx, this.dim1)]);
    }

    @Override
    public ByteScalar slice(int idx, int dim) {
        Helper.fixSliceIndex(dim, 1);
        return new ByteScalar(this.data, Helper.fixIndex(idx, this.dim1));
    }

    @Override
    public Byte1D view(Range rng1) {
        int[] viewIndex1 = Helper.select(this.idx1, rng1);
        if (viewIndex1 == this.idx1) {
            return this;
        }
        return new SelectedByte1D(this.data, viewIndex1);
    }

    @Override
    public Byte1D view(int[] sel1) {
        int[] viewIndex1 = Helper.select(this.idx1, sel1);
        if (viewIndex1 == this.idx1) {
            return this;
        }
        return new SelectedByte1D(this.data, viewIndex1);
    }

    @Override
    public Byte1D as1D() {
        return this;
    }
}

