/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Byte1D;
import mitiv.array.Byte4D;
import mitiv.array.Byte5D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedByte1D;
import mitiv.array.impl.SelectedByte4D;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ByteFunction;
import mitiv.base.mapping.ByteScanner;
import mitiv.random.ByteGenerator;

public class SelectedByte5D
extends Byte5D {
    static final int order = 0;
    final byte[] data;
    final int[] idx1;
    final int[] idx2;
    final int[] idx3;
    final int[] idx4;
    final int[] idx5;

    public SelectedByte5D(byte[] arr, int[] idx1, int[] idx2, int[] idx3, int[] idx4, int[] idx5) {
        super(idx1.length, idx2.length, idx3.length, idx4.length, idx5.length);
        this.data = arr;
        this.idx1 = idx1;
        this.idx2 = idx2;
        this.idx3 = idx3;
        this.idx4 = idx4;
        this.idx5 = idx5;
    }

    @Override
    public final void checkSanity() {
        int index;
        int indexMax;
        int offsetMin = 0;
        int offsetMax = 0;
        int indexMin = indexMax = this.idx1[0];
        int i1 = 1;
        while (i1 < this.dim1) {
            index = this.idx1[i1];
            if (index < indexMin) {
                indexMin = index;
            }
            if (index > indexMax) {
                indexMax = index;
            }
            ++i1;
        }
        offsetMin += indexMin;
        offsetMax += indexMax;
        indexMin = indexMax = this.idx2[0];
        int i2 = 1;
        while (i2 < this.dim2) {
            index = this.idx2[i2];
            if (index < indexMin) {
                indexMin = index;
            }
            if (index > indexMax) {
                indexMax = index;
            }
            ++i2;
        }
        offsetMin += indexMin;
        offsetMax += indexMax;
        indexMin = indexMax = this.idx3[0];
        int i3 = 1;
        while (i3 < this.dim3) {
            index = this.idx3[i3];
            if (index < indexMin) {
                indexMin = index;
            }
            if (index > indexMax) {
                indexMax = index;
            }
            ++i3;
        }
        offsetMin += indexMin;
        offsetMax += indexMax;
        indexMin = indexMax = this.idx4[0];
        int i4 = 1;
        while (i4 < this.dim4) {
            index = this.idx4[i4];
            if (index < indexMin) {
                indexMin = index;
            }
            if (index > indexMax) {
                indexMax = index;
            }
            ++i4;
        }
        offsetMin += indexMin;
        offsetMax += indexMax;
        indexMin = indexMax = this.idx5[0];
        int i5 = 1;
        while (i5 < this.dim5) {
            index = this.idx5[i5];
            if (index < indexMin) {
                indexMin = index;
            }
            if (index > indexMax) {
                indexMax = index;
            }
            ++i5;
        }
        if ((offsetMin += indexMin) < 0 || (offsetMax += indexMax) >= this.data.length) {
            throw new IndexOutOfBoundsException("Selected indices are out of bounds.");
        }
    }

    final int index(int i1, int i2, int i3, int i4, int i5) {
        return this.idx5[i5] + this.idx4[i4] + this.idx3[i3] + this.idx2[i2] + this.idx1[i1];
    }

    @Override
    public final byte get(int i1, int i2, int i3, int i4, int i5) {
        return this.data[this.idx5[i5] + this.idx4[i4] + this.idx3[i3] + this.idx2[i2] + this.idx1[i1]];
    }

    @Override
    public final void set(int i1, int i2, int i3, int i4, int i5, byte value) {
        this.data[this.idx5[i5] + this.idx4[i4] + this.idx3[i3] + this.idx2[i2] + this.idx1[i1]] = value;
    }

    @Override
    public final int getOrder() {
        return 0;
    }

    @Override
    public void fill(byte value) {
        int i5 = 0;
        while (i5 < this.dim5) {
            int j5 = this.idx5[i5];
            int i4 = 0;
            while (i4 < this.dim4) {
                int j4 = this.idx4[i4] + j5;
                int i3 = 0;
                while (i3 < this.dim3) {
                    int j3 = this.idx3[i3] + j4;
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int j2 = this.idx2[i2] + j3;
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            int j1 = this.idx1[i1] + j2;
                            this.data[j1] = value;
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
            ++i5;
        }
    }

    @Override
    public void fill(ByteGenerator generator) {
        int i5 = 0;
        while (i5 < this.dim5) {
            int j5 = this.idx5[i5];
            int i4 = 0;
            while (i4 < this.dim4) {
                int j4 = this.idx4[i4] + j5;
                int i3 = 0;
                while (i3 < this.dim3) {
                    int j3 = this.idx3[i3] + j4;
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int j2 = this.idx2[i2] + j3;
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            int j1 = this.idx1[i1] + j2;
                            this.data[j1] = generator.nextByte();
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
            ++i5;
        }
    }

    @Override
    public void increment(byte value) {
        int i5 = 0;
        while (i5 < this.dim5) {
            int j5 = this.idx5[i5];
            int i4 = 0;
            while (i4 < this.dim4) {
                int j4 = this.idx4[i4] + j5;
                int i3 = 0;
                while (i3 < this.dim3) {
                    int j3 = this.idx3[i3] + j4;
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int j2 = this.idx2[i2] + j3;
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            int j1;
                            int n = j1 = this.idx1[i1] + j2;
                            this.data[n] = (byte)(this.data[n] + value);
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
            ++i5;
        }
    }

    @Override
    public void decrement(byte value) {
        int i5 = 0;
        while (i5 < this.dim5) {
            int j5 = this.idx5[i5];
            int i4 = 0;
            while (i4 < this.dim4) {
                int j4 = this.idx4[i4] + j5;
                int i3 = 0;
                while (i3 < this.dim3) {
                    int j3 = this.idx3[i3] + j4;
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int j2 = this.idx2[i2] + j3;
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            int j1;
                            int n = j1 = this.idx1[i1] + j2;
                            this.data[n] = (byte)(this.data[n] - value);
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
            ++i5;
        }
    }

    @Override
    public void scale(byte value) {
        int i5 = 0;
        while (i5 < this.dim5) {
            int j5 = this.idx5[i5];
            int i4 = 0;
            while (i4 < this.dim4) {
                int j4 = this.idx4[i4] + j5;
                int i3 = 0;
                while (i3 < this.dim3) {
                    int j3 = this.idx3[i3] + j4;
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int j2 = this.idx2[i2] + j3;
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            int j1;
                            int n = j1 = this.idx1[i1] + j2;
                            this.data[n] = (byte)(this.data[n] * value);
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
            ++i5;
        }
    }

    @Override
    public void map(ByteFunction function) {
        int i5 = 0;
        while (i5 < this.dim5) {
            int j5 = this.idx5[i5];
            int i4 = 0;
            while (i4 < this.dim4) {
                int j4 = this.idx4[i4] + j5;
                int i3 = 0;
                while (i3 < this.dim3) {
                    int j3 = this.idx3[i3] + j4;
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int j2 = this.idx2[i2] + j3;
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            int j1 = this.idx1[i1] + j2;
                            this.data[j1] = function.apply(this.data[j1]);
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
            ++i5;
        }
    }

    @Override
    public void scan(ByteScanner scanner) {
        boolean initialized = false;
        int i5 = 0;
        while (i5 < this.dim5) {
            int j5 = this.idx5[i5];
            int i4 = 0;
            while (i4 < this.dim4) {
                int j4 = this.idx4[i4] + j5;
                int i3 = 0;
                while (i3 < this.dim3) {
                    int j3 = this.idx3[i3] + j4;
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int j2 = this.idx2[i2] + j3;
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            int j1 = this.idx1[i1] + j2;
                            if (initialized) {
                                scanner.update(this.data[j1]);
                            } else {
                                scanner.initialize(this.data[j1]);
                                initialized = true;
                            }
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
            ++i5;
        }
    }

    @Override
    public byte[] flatten(boolean forceCopy) {
        byte[] out = new byte[this.number];
        int j = -1;
        int i5 = 0;
        while (i5 < this.dim5) {
            int j5 = this.idx5[i5];
            int i4 = 0;
            while (i4 < this.dim4) {
                int j4 = this.idx4[i4] + j5;
                int i3 = 0;
                while (i3 < this.dim3) {
                    int j3 = this.idx3[i3] + j4;
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int j2 = this.idx2[i2] + j3;
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            int j1 = this.idx1[i1] + j2;
                            out[++j] = this.data[j1];
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
            ++i5;
        }
        return out;
    }

    @Override
    public Byte4D slice(int idx) {
        int[] sliceIndex1;
        int sliceOffset = this.idx5[Helper.fixIndex(idx, this.dim5)];
        if (sliceOffset == 0) {
            sliceIndex1 = this.idx1;
        } else {
            sliceIndex1 = new int[this.dim1];
            int i = 0;
            while (i < this.dim1) {
                sliceIndex1[i] = this.idx1[i] + sliceOffset;
                ++i;
            }
        }
        return new SelectedByte4D(this.data, sliceIndex1, this.idx2, this.idx3, this.idx4);
    }

    @Override
    public Byte4D slice(int idx, int dim) {
        int[] sliceIndex4;
        int[] sliceIndex3;
        int[] sliceIndex2;
        int[] sliceIndex1;
        int sliceOffset;
        if ((dim = Helper.fixSliceIndex(dim, 5)) == 0) {
            sliceOffset = this.idx1[Helper.fixIndex(idx, this.dim1)];
            sliceIndex1 = this.idx2;
            sliceIndex2 = this.idx3;
            sliceIndex3 = this.idx4;
            sliceIndex4 = this.idx5;
        } else if (dim == 1) {
            sliceIndex1 = this.idx1;
            sliceOffset = this.idx2[Helper.fixIndex(idx, this.dim2)];
            sliceIndex2 = this.idx3;
            sliceIndex3 = this.idx4;
            sliceIndex4 = this.idx5;
        } else if (dim == 2) {
            sliceIndex1 = this.idx1;
            sliceIndex2 = this.idx2;
            sliceOffset = this.idx3[Helper.fixIndex(idx, this.dim3)];
            sliceIndex3 = this.idx4;
            sliceIndex4 = this.idx5;
        } else if (dim == 3) {
            sliceIndex1 = this.idx1;
            sliceIndex2 = this.idx2;
            sliceIndex3 = this.idx3;
            sliceOffset = this.idx4[Helper.fixIndex(idx, this.dim4)];
            sliceIndex4 = this.idx5;
        } else {
            sliceIndex1 = this.idx1;
            sliceIndex2 = this.idx2;
            sliceIndex3 = this.idx3;
            sliceIndex4 = this.idx4;
            sliceOffset = this.idx5[Helper.fixIndex(idx, this.dim5)];
        }
        if (sliceOffset != 0) {
            int length = sliceIndex1.length;
            int[] tempIndex = new int[length];
            int i = 0;
            while (i < length) {
                tempIndex[i] = sliceOffset + sliceIndex1[i];
                ++i;
            }
            sliceIndex1 = tempIndex;
        }
        return new SelectedByte4D(this.data, sliceIndex1, sliceIndex2, sliceIndex3, sliceIndex4);
    }

    @Override
    public Byte5D view(Range rng1, Range rng2, Range rng3, Range rng4, Range rng5) {
        int[] viewIndex1 = Helper.select(this.idx1, rng1);
        int[] viewIndex2 = Helper.select(this.idx2, rng2);
        int[] viewIndex3 = Helper.select(this.idx3, rng3);
        int[] viewIndex4 = Helper.select(this.idx4, rng4);
        int[] viewIndex5 = Helper.select(this.idx5, rng5);
        if (viewIndex1 == this.idx1 && viewIndex2 == this.idx2 && viewIndex3 == this.idx3 && viewIndex4 == this.idx4 && viewIndex5 == this.idx5) {
            return this;
        }
        return new SelectedByte5D(this.data, viewIndex1, viewIndex2, viewIndex3, viewIndex4, viewIndex5);
    }

    @Override
    public Byte5D view(int[] sel1, int[] sel2, int[] sel3, int[] sel4, int[] sel5) {
        int[] viewIndex1 = Helper.select(this.idx1, sel1);
        int[] viewIndex2 = Helper.select(this.idx2, sel2);
        int[] viewIndex3 = Helper.select(this.idx3, sel3);
        int[] viewIndex4 = Helper.select(this.idx4, sel4);
        int[] viewIndex5 = Helper.select(this.idx5, sel5);
        if (viewIndex1 == this.idx1 && viewIndex2 == this.idx2 && viewIndex3 == this.idx3 && viewIndex4 == this.idx4 && viewIndex5 == this.idx5) {
            return this;
        }
        return new SelectedByte5D(this.data, viewIndex1, viewIndex2, viewIndex3, viewIndex4, viewIndex5);
    }

    @Override
    public Byte1D as1D() {
        int[] idx = new int[this.number];
        int j = -1;
        int i5 = 0;
        while (i5 < this.dim5) {
            int j5 = this.idx5[i5];
            int i4 = 0;
            while (i4 < this.dim4) {
                int j4 = this.idx4[i4] + j5;
                int i3 = 0;
                while (i3 < this.dim3) {
                    int j3 = this.idx3[i3] + j4;
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int j2 = this.idx2[i2] + j3;
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            int j1 = this.idx1[i1] + j2;
                            idx[++j] = j1;
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
            ++i5;
        }
        return new SelectedByte1D(this.data, idx);
    }
}

