/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv;

import java.awt.image.BufferedImage;
import mitiv.array.Double2D;
import mitiv.array.Double3D;
import mitiv.array.DoubleArray;
import mitiv.array.ShapedArray;
import mitiv.base.indexing.Range;
import mitiv.deconv.DeconvUtils;
import mitiv.deconv.Filter;
import mitiv.invpb.LinearDeconvolver;
import mitiv.io.BufferedImageUtils;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.RealComplexFFT;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.utils.CommonUtils;

public class Deconvolution {
    public static final int PROCESSING_1D = 1;
    public static final int PROCESSING_3D = 3;
    public static final int PROCESSING_VECTOR = 2;
    private final int standardProcessing = 1;
    boolean verbose = false;
    DeconvUtils utils = new DeconvUtils();
    Filter wiener;
    double[] image1D;
    double[] psf1D;
    DoubleShapedVector vectorImage;
    DoubleShapedVector vectorPsf;
    int correction;
    boolean isPsfSplitted = false;
    boolean useVectors;
    DoubleShapedVectorSpace space;
    DoubleShapedVectorSpace complexSpace;
    DoubleShapedVector x;
    DoubleShapedVector w;
    RealComplexFFT fft;
    LinearDeconvolver linDeconv;
    int outputValue = 1;
    int maxIter = 20;
    double coef = 1.0;
    static boolean forceVectorUsage = false;

    public Deconvolution(Object image, Object PSF) {
        this(image, PSF, CommonUtils.SCALE, forceVectorUsage);
    }

    public Deconvolution(Object image, Object PSF, int correction) {
        this(image, PSF, correction, forceVectorUsage);
    }

    public Deconvolution(Object image, Object PSF, int correction, boolean useVectors) {
        this.useVectors = useVectors;
        if (image instanceof String) {
            if (useVectors) {
                this.utils.readImageVect((String)image, (String)PSF, false);
            } else {
                this.utils.readImage((String)image, (String)PSF);
            }
        } else if (image instanceof BufferedImage) {
            if (useVectors) {
                this.utils.readImageVect((BufferedImage)image, (BufferedImage)PSF, false);
            } else {
                this.utils.readImage((BufferedImage)image, (BufferedImage)PSF);
            }
        } else if (image instanceof ShapedArray) {
            this.utils.readImage((ShapedArray)image, (ShapedArray)PSF);
        } else {
            throw new IllegalArgumentException("Input should be a ShappedArray, BufferedImage or a path");
        }
        this.correction = correction;
        this.wiener = new Filter();
    }

    public void setPaddingCoefficient(double coef) {
        this.coef = coef;
    }

    public ShapedArray firstDeconvolution(double alpha) {
        if (this.useVectors) {
            return this.firstDeconvolution(alpha, 2, false);
        }
        return this.firstDeconvolution(alpha, 1, false);
    }

    public ShapedArray firstDeconvolution(double alpha, boolean isPsfSplitted) {
        if (this.useVectors) {
            return this.firstDeconvolution(alpha, 2, isPsfSplitted);
        }
        return this.firstDeconvolution(alpha, 1, isPsfSplitted);
    }

    public ShapedArray firstDeconvolution(double alpha, int job, boolean isPsfSplitted) {
        this.isPsfSplitted = isPsfSplitted;
        switch (job) {
            case 1: {
                return this.firstDeconvolutionSimple1D(alpha);
            }
            case 2: {
                return this.firstDeconvolutionVector(alpha);
            }
            case 3: {
                return this.firstDeconvolutionSimple3D(alpha);
            }
        }
        throw new IllegalArgumentException("The job given does not exist");
    }

    public ShapedArray nextDeconvolution(double alpha) {
        if (this.useVectors) {
            return this.nextDeconvolution(alpha, 2);
        }
        return this.nextDeconvolution(alpha, 1);
    }

    public ShapedArray nextDeconvolution(double alpha, int job) {
        switch (job) {
            case 1: {
                return this.nextDeconvolutionSimple1D(alpha);
            }
            case 2: {
                return this.nextDeconvolutionVector(alpha);
            }
            case 3: {
                return this.nextDeconvolutionSimple3D(alpha);
            }
        }
        throw new IllegalArgumentException("The job given does not exist");
    }

    private ShapedArray firstDeconvolutionSimple1D(double alpha) {
        this.image1D = this.utils.imageToArray1D(true);
        this.psf1D = this.isPsfSplitted ? this.utils.psfToArray1D(true) : this.utils.psfPadding1D(true);
        this.utils.FFT1D(this.image1D);
        this.utils.FFT1D(this.psf1D);
        double[] out = this.wiener.wiener1D(alpha, this.psf1D, this.image1D, this.utils.width, this.utils.height);
        this.utils.IFFT1D(out);
        Double2D outArray = Double2D.wrap(out, this.utils.width * 2, this.utils.height);
        return outArray.view(new Range(0, -1, 2), null);
    }

    private ShapedArray nextDeconvolutionSimple1D(double alpha) {
        double[] out = this.wiener.wiener1D(alpha);
        this.utils.IFFT1D(out);
        Double2D outArray = Double2D.wrap(out, this.utils.width * 2, this.utils.height);
        return outArray.view(new Range(0, -1, 2), null);
    }

    private ShapedArray firstDeconvolutionSimple3D(double alpha) {
        ShapedArray imgArray = this.utils.getImgShaped();
        ShapedArray psfArray = this.utils.getPsfShaped();
        ShapedArray weightArray = ((DoubleArray)psfArray).create();
        ((DoubleArray)weightArray).fill(1.0);
        imgArray = BufferedImageUtils.imagePad(imgArray, this.coef);
        psfArray = BufferedImageUtils.imagePad(psfArray, this.coef);
        weightArray = BufferedImageUtils.imagePad(weightArray, this.coef);
        psfArray = BufferedImageUtils.shiftPsf(psfArray);
        this.utils.PadImageAndPSF(this.coef);
        this.space = new DoubleShapedVectorSpace(this.utils.width, this.utils.height, this.utils.sizeZ);
        this.fft = new RealComplexFFT(this.space);
        this.complexSpace = (DoubleShapedVectorSpace)this.fft.getOutputSpace();
        this.vectorPsf = this.space.wrap(psfArray.toDouble().flatten());
        this.vectorImage = this.space.wrap(imgArray.toDouble().flatten());
        DoubleShapedVector vectorWgt = this.space.wrap(weightArray.toDouble().flatten());
        DoubleShapedVector imgComplex = this.complexSpace.create(0.0);
        DoubleShapedVector psfComplex = this.complexSpace.create(0.0);
        DoubleShapedVector wgtComplex = this.complexSpace.create(0.0);
        this.fft.apply(vectorWgt, wgtComplex);
        this.fft.apply(this.vectorPsf, psfComplex);
        this.fft.apply(this.vectorImage, imgComplex);
        this.vectorPsf = psfComplex;
        this.vectorImage = imgComplex;
        DoubleShapedVector out = this.complexSpace.wrap(this.wiener.wiener3D(alpha, psfComplex.getData(), imgComplex.getData(), wgtComplex.getData(), this.utils.width, this.utils.height, this.utils.sizeZ, this.coef));
        DoubleShapedVector outReal = this.space.create();
        this.fft.apply(out, outReal, RealComplexFFT.ADJOINT);
        return Double3D.wrap(outReal.getData(), this.space.getShape());
    }

    private ShapedArray nextDeconvolutionSimple3D(double alpha) {
        DoubleShapedVector out = this.complexSpace.wrap(this.wiener.wiener3D(alpha));
        DoubleShapedVector outReal = this.space.create();
        this.fft.apply(out, outReal, RealComplexFFT.ADJOINT);
        return Double3D.wrap(outReal.getData(), this.space.getShape());
    }

    private ShapedArray firstDeconvolutionVector(double alpha) {
        this.vectorImage = (DoubleShapedVector)this.utils.cloneImageVect();
        this.vectorPsf = (DoubleShapedVector)this.utils.getPsfPadVect();
        this.utils.FFT1D(this.vectorImage);
        this.utils.FFT1D(this.vectorPsf);
        ShapedVector out = this.wiener.wienerVect(alpha, this.vectorPsf, this.vectorImage);
        this.utils.IFFT1D(out);
        return Double2D.wrap(((DoubleShapedVector)out).getData(), this.utils.width, this.utils.height);
    }

    private ShapedArray nextDeconvolutionVector(double alpha) {
        ShapedVector out = this.wiener.wienerVect(alpha);
        this.utils.IFFT1D(out);
        return Double2D.wrap(((DoubleShapedVector)out).getData(), this.utils.width, this.utils.height);
    }

    public ShapedArray firstDeconvolutionQuad(double alpha) {
        if (this.useVectors) {
            return this.firstDeconvolutionQuad(alpha, 2, false);
        }
        return this.firstDeconvolutionQuad(alpha, 1, false);
    }

    public ShapedArray firstDeconvolutionQuad(double alpha, boolean isPsfSplitted) {
        if (this.useVectors) {
            return this.firstDeconvolutionQuad(alpha, 2, isPsfSplitted);
        }
        return this.firstDeconvolutionQuad(alpha, 1, isPsfSplitted);
    }

    public ShapedArray firstDeconvolutionQuad(double alpha, int job, boolean isPsfSplitted) {
        this.isPsfSplitted = isPsfSplitted;
        switch (job) {
            case 1: {
                return this.firstDeconvolutionQuad1D(alpha);
            }
            case 3: {
                return this.firstDeconvolutionQuad3D(alpha);
            }
            case 2: {
                return this.firstDeconvolutionQuadVector(alpha);
            }
        }
        throw new IllegalArgumentException("The job given does not exist");
    }

    public ShapedArray nextDeconvolutionQuad(double alpha) {
        if (this.useVectors) {
            return this.nextDeconvolutionQuad(alpha, 2);
        }
        return this.nextDeconvolutionQuad(alpha, 1);
    }

    public ShapedArray nextDeconvolutionQuad(double alpha, int job) {
        switch (job) {
            case 1: {
                return this.nextDeconvolutionQuad1D(alpha);
            }
            case 3: {
                return this.nextDeconvolutionQuad3D(alpha);
            }
            case 2: {
                return this.nextDeconvolutionQuadVector(alpha);
            }
        }
        throw new IllegalArgumentException("The job given does not exist");
    }

    private ShapedArray firstDeconvolutionQuad1D(double alpha) {
        this.image1D = this.utils.imageToArray1D(true);
        this.psf1D = this.isPsfSplitted ? this.utils.psfToArray1D(true) : this.utils.psfPadding1D(true);
        this.utils.FFT1D(this.image1D);
        this.utils.FFT1D(this.psf1D);
        double[] out = this.wiener.wienerQuad1D(alpha, this.psf1D, this.image1D, this.utils.width, this.utils.height);
        this.utils.IFFT1D(out);
        Double2D outArray = Double2D.wrap(out, this.utils.width * 2, this.utils.height);
        return outArray.view(new Range(0, -1, 2), null);
    }

    private ShapedArray nextDeconvolutionQuad1D(double alpha) {
        double[] out = this.wiener.wienerQuad1D(alpha);
        this.utils.IFFT1D(out);
        Double2D outArray = Double2D.wrap(out, this.utils.width * 2, this.utils.height);
        return outArray.view(new Range(0, -1, 2), null);
    }

    private ShapedArray firstDeconvolutionQuad3D(double alpha) {
        this.space = new DoubleShapedVectorSpace(this.utils.width, this.utils.height, this.utils.sizeZ);
        this.fft = new RealComplexFFT(this.space);
        this.complexSpace = (DoubleShapedVectorSpace)this.fft.getOutputSpace();
        this.vectorPsf = this.space.wrap(this.utils.shiftPsf3DToArray1D(false));
        this.vectorImage = this.space.wrap(this.utils.image3DToArray1D(false));
        DoubleShapedVector imgComplex = this.complexSpace.create(0.0);
        DoubleShapedVector psfComplex = this.complexSpace.create(0.0);
        this.fft.apply(this.vectorPsf, psfComplex);
        this.fft.apply(this.vectorImage, imgComplex);
        this.vectorPsf = psfComplex;
        this.vectorImage = imgComplex;
        DoubleShapedVector out = this.complexSpace.wrap(this.wiener.wienerQuad3D(alpha, psfComplex.getData(), imgComplex.getData(), this.utils.width, this.utils.height, this.utils.sizeZ, this.utils.sizePadding));
        DoubleShapedVector outReal = this.space.create();
        this.fft.apply(out, outReal, RealComplexFFT.ADJOINT);
        return Double3D.wrap(outReal.getData(), this.space.getShape());
    }

    private ShapedArray nextDeconvolutionQuad3D(double alpha) {
        DoubleShapedVector out = this.complexSpace.wrap(this.wiener.wienerQuad3D(alpha));
        DoubleShapedVector outReal = this.space.create();
        this.fft.apply(out, outReal, RealComplexFFT.ADJOINT);
        return Double3D.wrap(outReal.getData(), this.space.getShape());
    }

    private ShapedArray firstDeconvolutionQuadVector(double alpha) {
        this.vectorImage = (DoubleShapedVector)this.utils.cloneImageVect();
        this.vectorPsf = (DoubleShapedVector)this.utils.getPsfPadVect();
        this.utils.FFT1D(this.vectorImage);
        this.utils.FFT1D(this.vectorPsf);
        ShapedVector out = this.wiener.wienerQuadVect(alpha, this.vectorPsf, this.vectorImage);
        this.utils.IFFT1D(out);
        return Double2D.wrap(((DoubleShapedVector)out).getData(), this.space.getShape());
    }

    private ShapedArray nextDeconvolutionQuadVector(double alpha) {
        ShapedVector out = this.wiener.wienerQuadVect(alpha);
        this.utils.IFFT1D(out);
        return Double2D.wrap(((DoubleShapedVector)out).getData(), this.space.getShape());
    }

    private void parseOuputCG(int output) {
        if (output != 1 && output != 0) {
            if (output == 3) {
                System.err.println("A_IS_NOT_POSITIVE_DEFINITE");
            } else if (output == 2 && this.verbose) {
                System.err.println("TOO_MANY_ITERATIONS");
            } else if (this.verbose) {
                System.err.println("Not ended normally " + output);
            }
        }
    }

    public ShapedArray firstDeconvolutionCG(double alpha) {
        return this.firstDeconvolutionCG(alpha, 2, false);
    }

    public ShapedArray firstDeconvolutionCG(double alpha, boolean isPsfSplitted) {
        return this.firstDeconvolutionCG(alpha, 2, isPsfSplitted);
    }

    public ShapedArray firstDeconvolutionCG(double alpha, int job, boolean isPsfSplitted) {
        this.isPsfSplitted = isPsfSplitted;
        switch (job) {
            case 2: {
                return this.firstDeconvolutionCGNormal(alpha);
            }
            case 3: {
                return this.firstDeconvolutionCG3D(alpha);
            }
        }
        throw new IllegalArgumentException("The job given does not exist");
    }

    public ShapedArray nextDeconvolutionCG(double alpha) {
        return this.nextDeconvolutionCG(alpha, 2);
    }

    public ShapedArray nextDeconvolutionCG(double alpha, int job) {
        switch (job) {
            case 2: {
                return this.nextDeconvolutionCGNormal(alpha);
            }
            case 3: {
                return this.nextDeconvolutionCG3D(alpha);
            }
        }
        throw new IllegalArgumentException("The job given does not exist");
    }

    private ShapedArray firstDeconvolutionCGNormal(double alpha) {
        this.space = new DoubleShapedVectorSpace(this.utils.width, this.utils.height);
        this.vectorPsf = this.isPsfSplitted ? this.space.wrap(this.utils.psfToArray1D(false)) : this.space.wrap(this.utils.psfPadding1D(false));
        this.vectorImage = this.space.wrap(this.utils.imageToArray1D(false));
        this.x = this.space.create(0.0);
        this.w = this.space.create(1.0);
        this.linDeconv = new LinearDeconvolver(this.space.getShape(), this.vectorImage.getData(), this.vectorPsf.getData(), this.w.getData(), alpha);
        this.outputValue = this.linDeconv.solve(this.x.getData(), this.maxIter, false);
        this.parseOuputCG(this.outputValue);
        return Double2D.wrap(this.x.getData(), this.space.getShape());
    }

    private ShapedArray nextDeconvolutionCGNormal(double alpha) {
        boolean verbose = false;
        this.x = this.space.create(0.0);
        this.linDeconv.setMu(alpha);
        this.outputValue = this.linDeconv.solve(this.x.getData(), this.maxIter, false);
        if (verbose) {
            this.parseOuputCG(this.outputValue);
        }
        return Double2D.wrap(this.x.getData(), this.space.getShape());
    }

    private ShapedArray firstDeconvolutionCG3D(double alpha) {
        ShapedArray imgArray = this.utils.getImgShaped();
        ShapedArray psfArray = this.utils.getPsfShaped();
        double[] weight = new double[this.utils.width * this.utils.height * this.utils.sizeZ];
        int i = 0;
        while (i < weight.length) {
            weight[i] = 1.0;
            ++i;
        }
        weight = CommonUtils.imagePad(weight, this.utils.width, this.utils.height, this.utils.sizeZ, this.coef);
        imgArray = BufferedImageUtils.imagePad(imgArray, this.coef);
        psfArray = BufferedImageUtils.imagePad(psfArray, this.coef);
        psfArray = BufferedImageUtils.shiftPsf(psfArray);
        this.utils.PadImageAndPSF(this.coef);
        this.space = new DoubleShapedVectorSpace(this.utils.width, this.utils.height, this.utils.sizeZ);
        this.vectorPsf = this.space.wrap(psfArray.toDouble().flatten());
        this.vectorImage = this.space.wrap(imgArray.toDouble().flatten());
        this.x = this.space.create(0.0);
        this.w = this.space.wrap(weight);
        this.maxIter = 50;
        this.linDeconv = new LinearDeconvolver(this.space.getShape(), this.vectorImage.getData(), this.vectorPsf.getData(), this.w.getData(), alpha);
        this.outputValue = this.linDeconv.solve(this.x.getData(), this.maxIter, false);
        this.parseOuputCG(this.outputValue);
        return Double3D.wrap(this.x.getData(), this.space.getShape());
    }

    private ShapedArray nextDeconvolutionCG3D(double alpha) {
        boolean verbose = false;
        this.x = this.space.create(0.0);
        this.linDeconv.setMu(alpha);
        this.outputValue = this.linDeconv.solve(this.x.getData(), this.maxIter, false);
        if (verbose) {
            this.parseOuputCG(this.outputValue);
        }
        return Double3D.wrap(this.x.getData(), this.space.getShape());
    }

    public int getOuputValue() {
        return this.outputValue;
    }
}

