/*
 * Decompiled with CFR 0.152.
 */
package mitiv.io;

import mitiv.array.Array3D;
import mitiv.array.Byte2D;
import mitiv.array.Byte3D;
import mitiv.array.Double2D;
import mitiv.array.Double3D;
import mitiv.array.DoubleArray;
import mitiv.array.Float2D;
import mitiv.array.Float3D;
import mitiv.array.FloatArray;
import mitiv.array.Int2D;
import mitiv.array.Int3D;
import mitiv.array.Long2D;
import mitiv.array.Long3D;
import mitiv.array.ShapedArray;
import mitiv.array.Short2D;
import mitiv.array.Short3D;
import mitiv.base.indexing.Range;
import mitiv.exception.IllegalTypeException;

public enum ColorModel {
    RED(1, "red channel"),
    GREEN(1, "green channel"),
    BLUE(1, "blue channel"),
    ALPHA(1, "alpha channel"),
    GRAY(1, "intensity or gray-scale"),
    RGB(3, "red-green-blue"),
    RGBA(4, "red-green-blue-alpha"),
    NONE(-1, "non-image array");

    private final int bands;
    private final String description;

    private ColorModel(int bands, String descr) {
        this.bands = bands;
        this.description = descr;
    }

    public int bands() {
        return this.bands;
    }

    public String description() {
        return this.description;
    }

    public String toString() {
        return this.description;
    }

    public static ColorModel guessColorModel(ShapedArray arr) {
        int rank = arr.getRank();
        if (rank == 2) {
            return GRAY;
        }
        if (rank == 3) {
            int bands = arr.getDimension(0);
            if (bands == 3) {
                return RGB;
            }
            if (bands == 4 && arr.getType() == 0) {
                return RGBA;
            }
        }
        return NONE;
    }

    public static double colorToGrey(double red, double green, double blue) {
        return 0.2126 * red + 0.7152 * green + 0.0722 * blue;
    }

    public static float colorToGrey(float red, float green, float blue) {
        return 0.2126f * red + 0.7152f * green + 0.0722f * blue;
    }

    public static int colorToGrey(int red, int green, int blue) {
        return Math.round(0.2126f * (float)red + 0.7152f * (float)green + 0.0722f * (float)blue);
    }

    /*
     * Unable to fully structure code
     */
    public static FloatArray filterImageAsFloat(ShapedArray arr, ColorModel colorModel) {
        block155: {
            block154: {
                type = arr.getType();
                shape = arr.getShape();
                rank = shape.rank();
                depth = -1;
                colored = false;
                if (rank == 2) {
                    depth = 1;
                } else if (rank == 3) {
                    depth = shape.dimension(0);
                    if (depth == 3) {
                        colored = true;
                    } else if (depth == 4 && type == 0) {
                        colored = true;
                    } else {
                        depth = -1;
                    }
                }
                if (depth < 0) {
                    throw new IllegalArgumentException("Images must be WIDTH x HEIGHT arrays, 3 x WIDTH x HEIGHT arrays or 4 x WIDTH x HEIGHT byte arrays.");
                }
                width = shape.dimension(rank - 2);
                height = shape.dimension(rank - 1);
                view = null;
                if (colorModel != ColorModel.GRAY) break block154;
                if (colored) {
                    dst = Float2D.create(width, height);
                    switch (type) {
                        case 0: {
                            src = (Byte3D)arr;
                            y = 0;
                            while (y < height) {
                                x = 0;
                                while (x < width) {
                                    red = src.get(0, x, y) & 255;
                                    green = src.get(1, x, y) & 255;
                                    blue = src.get(2, x, y) & 255;
                                    dst.set(x, y, ColorModel.colorToGrey(red, green, blue));
                                    ++x;
                                }
                                ++y;
                            }
                            break;
                        }
                        case 1: {
                            src = (Short3D)arr;
                            y = 0;
                            while (y < height) {
                                x = 0;
                                while (x < width) {
                                    red = src.get(0, x, y);
                                    green = src.get(1, x, y);
                                    blue = src.get(2, x, y);
                                    dst.set(x, y, ColorModel.colorToGrey(red, green, blue));
                                    ++x;
                                }
                                ++y;
                            }
                            break;
                        }
                        case 2: {
                            src = (Int3D)arr;
                            y = 0;
                            while (y < height) {
                                x = 0;
                                while (x < width) {
                                    red = src.get(0, x, y);
                                    green = src.get(1, x, y);
                                    blue = src.get(2, x, y);
                                    dst.set(x, y, ColorModel.colorToGrey(red, green, blue));
                                    ++x;
                                }
                                ++y;
                            }
                            break;
                        }
                        case 3: {
                            src = (Long3D)arr;
                            y = 0;
                            while (y < height) {
                                x = 0;
                                while (x < width) {
                                    red = src.get(0, x, y);
                                    green = src.get(1, x, y);
                                    blue = src.get(2, x, y);
                                    dst.set(x, y, ColorModel.colorToGrey(red, green, blue));
                                    ++x;
                                }
                                ++y;
                            }
                            break;
                        }
                        case 4: {
                            src = (Float3D)arr;
                            y = 0;
                            while (y < height) {
                                x = 0;
                                while (x < width) {
                                    red = src.get(0, x, y);
                                    green = src.get(1, x, y);
                                    blue = src.get(2, x, y);
                                    dst.set(x, y, ColorModel.colorToGrey(red, green, blue));
                                    ++x;
                                }
                                ++y;
                            }
                            break;
                        }
                        case 5: {
                            src = (Double3D)arr;
                            y = 0;
                            while (y < height) {
                                x = 0;
                                while (x < width) {
                                    red = (float)src.get(0, x, y);
                                    green = (float)src.get(1, x, y);
                                    blue = (float)src.get(2, x, y);
                                    dst.set(x, y, ColorModel.colorToGrey(red, green, blue));
                                    ++x;
                                }
                                ++y;
                            }
                            break;
                        }
                        default: {
                            throw new IllegalTypeException();
                        }
                    }
                    return dst;
                }
                view = arr;
                break block155;
            }
            if (colorModel != ColorModel.RGB) ** GOTO lbl225
            if (depth == 3) {
                view = arr;
            } else if (depth == 4) {
                view = ((Array3D)arr).view(new Range(0, 2), null, null);
            } else {
                dst = Float3D.create(3, width, height);
                switch (type) {
                    case 0: {
                        src = (Byte2D)arr;
                        y = 0;
                        while (y < height) {
                            x = 0;
                            while (x < width) {
                                value = src.get(x, y) & 255;
                                dst.set(0, x, y, value);
                                dst.set(1, x, y, value);
                                dst.set(2, x, y, value);
                                ++x;
                            }
                            ++y;
                        }
                        break;
                    }
                    case 1: {
                        src = (Short2D)arr;
                        y = 0;
                        while (y < height) {
                            x = 0;
                            while (x < width) {
                                value = src.get(x, y);
                                dst.set(0, x, y, value);
                                dst.set(1, x, y, value);
                                dst.set(2, x, y, value);
                                ++x;
                            }
                            ++y;
                        }
                        break;
                    }
                    case 2: {
                        src = (Int2D)arr;
                        y = 0;
                        while (y < height) {
                            x = 0;
                            while (x < width) {
                                value = src.get(x, y);
                                dst.set(0, x, y, value);
                                dst.set(1, x, y, value);
                                dst.set(2, x, y, value);
                                ++x;
                            }
                            ++y;
                        }
                        break;
                    }
                    case 3: {
                        src = (Long2D)arr;
                        y = 0;
                        while (y < height) {
                            x = 0;
                            while (x < width) {
                                value = src.get(x, y);
                                dst.set(0, x, y, value);
                                dst.set(1, x, y, value);
                                dst.set(2, x, y, value);
                                ++x;
                            }
                            ++y;
                        }
                        break;
                    }
                    case 4: {
                        src = (Float2D)arr;
                        y = 0;
                        while (y < height) {
                            x = 0;
                            while (x < width) {
                                value = src.get(x, y);
                                dst.set(0, x, y, value);
                                dst.set(1, x, y, value);
                                dst.set(2, x, y, value);
                                ++x;
                            }
                            ++y;
                        }
                        break;
                    }
                    case 5: {
                        src = (Double2D)arr;
                        y = 0;
                        while (y < height) {
                            x = 0;
                            while (x < width) {
                                value = (float)src.get(x, y);
                                dst.set(0, x, y, value);
                                dst.set(1, x, y, value);
                                dst.set(2, x, y, value);
                                ++x;
                            }
                            ++y;
                        }
                        break;
                    }
                    default: {
                        throw new IllegalTypeException();
                    }
                }
                return dst;
lbl225:
                // 1 sources

                if (colorModel == ColorModel.RGBA) {
                    dst = Float3D.create(4, width, height);
                    if (depth == 1) {
                        opaque = 1.0f;
                        switch (type) {
                            case 0: {
                                src = (Byte2D)arr;
                                y = 0;
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        value = src.get(x, y) & 255;
                                        dst.set(0, x, y, value);
                                        dst.set(1, x, y, value);
                                        dst.set(2, x, y, value);
                                        dst.set(3, x, y, 1.0f);
                                        ++x;
                                    }
                                    ++y;
                                }
                            }
                            case 1: {
                                src = (Short2D)arr;
                                y = 0;
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        value = src.get(x, y);
                                        dst.set(0, x, y, value);
                                        dst.set(1, x, y, value);
                                        dst.set(2, x, y, value);
                                        dst.set(3, x, y, 1.0f);
                                        ++x;
                                    }
                                    ++y;
                                }
                            }
                            case 2: {
                                src = (Int2D)arr;
                                y = 0;
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        value = src.get(x, y);
                                        dst.set(0, x, y, value);
                                        dst.set(1, x, y, value);
                                        dst.set(2, x, y, value);
                                        dst.set(3, x, y, 1.0f);
                                        ++x;
                                    }
                                    ++y;
                                }
                            }
                            case 3: {
                                src = (Long2D)arr;
                                y = 0;
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        value = src.get(x, y);
                                        dst.set(0, x, y, value);
                                        dst.set(1, x, y, value);
                                        dst.set(2, x, y, value);
                                        dst.set(3, x, y, 1.0f);
                                        ++x;
                                    }
                                    ++y;
                                }
                            }
                            case 4: {
                                src = (Float2D)arr;
                                y = 0;
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        value = src.get(x, y);
                                        dst.set(0, x, y, value);
                                        dst.set(1, x, y, value);
                                        dst.set(2, x, y, value);
                                        dst.set(3, x, y, 1.0f);
                                        ++x;
                                    }
                                    ++y;
                                }
                            }
                            case 5: {
                                src = (Double2D)arr;
                                y = 0;
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        value = (float)src.get(x, y);
                                        dst.set(0, x, y, value);
                                        dst.set(1, x, y, value);
                                        dst.set(2, x, y, value);
                                        dst.set(3, x, y, 1.0f);
                                        ++x;
                                    }
                                    ++y;
                                }
                                break;
                            }
                        }
                        throw new IllegalTypeException();
                    }
                    if (depth == 3) {
                        opaque = 1.0f;
                        switch (type) {
                            case 0: {
                                src = (Byte3D)arr;
                                y = 0;
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        red = src.get(0, x, y) & 255;
                                        green = src.get(1, x, y) & 255;
                                        blue = src.get(2, x, y) & 255;
                                        dst.set(0, x, y, red);
                                        dst.set(1, x, y, green);
                                        dst.set(2, x, y, blue);
                                        dst.set(3, x, y, 1.0f);
                                        ++x;
                                    }
                                    ++y;
                                }
                            }
                            case 1: {
                                src = (Short3D)arr;
                                y = 0;
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        red = src.get(0, x, y);
                                        green = src.get(1, x, y);
                                        blue = src.get(2, x, y);
                                        dst.set(0, x, y, red);
                                        dst.set(1, x, y, green);
                                        dst.set(2, x, y, blue);
                                        dst.set(3, x, y, 1.0f);
                                        ++x;
                                    }
                                    ++y;
                                }
                            }
                            case 2: {
                                src = (Int3D)arr;
                                y = 0;
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        red = src.get(0, x, y);
                                        green = src.get(1, x, y);
                                        blue = src.get(2, x, y);
                                        dst.set(0, x, y, red);
                                        dst.set(1, x, y, green);
                                        dst.set(2, x, y, blue);
                                        dst.set(3, x, y, 1.0f);
                                        ++x;
                                    }
                                    ++y;
                                }
                            }
                            case 3: {
                                src = (Long3D)arr;
                                y = 0;
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        red = src.get(0, x, y);
                                        green = src.get(1, x, y);
                                        blue = src.get(2, x, y);
                                        dst.set(0, x, y, red);
                                        dst.set(1, x, y, green);
                                        dst.set(2, x, y, blue);
                                        dst.set(3, x, y, 1.0f);
                                        ++x;
                                    }
                                    ++y;
                                }
                            }
                            case 4: {
                                src = (Float3D)arr;
                                y = 0;
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        red = src.get(0, x, y);
                                        green = src.get(1, x, y);
                                        blue = src.get(2, x, y);
                                        dst.set(0, x, y, red);
                                        dst.set(1, x, y, green);
                                        dst.set(2, x, y, blue);
                                        dst.set(3, x, y, 1.0f);
                                        ++x;
                                    }
                                    ++y;
                                }
                            }
                            case 5: {
                                src = (Double3D)arr;
                                y = 0;
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        red = (float)src.get(0, x, y);
                                        green = (float)src.get(1, x, y);
                                        blue = (float)src.get(2, x, y);
                                        dst.set(0, x, y, red);
                                        dst.set(1, x, y, green);
                                        dst.set(2, x, y, blue);
                                        dst.set(3, x, y, 1.0f);
                                        ++x;
                                    }
                                    ++y;
                                }
                                break;
                            }
                        }
                        throw new IllegalTypeException();
                    }
                    src = (Byte3D)arr;
                    scale = 0.003921569f;
                    y = 0;
                    while (y < height) {
                        x = 0;
                        while (x < width) {
                            red = src.get(0, x, y) & 255;
                            green = src.get(1, x, y) & 255;
                            blue = src.get(2, x, y) & 255;
                            alpha = (float)(src.get(3, x, y) & 255) * 0.003921569f;
                            dst.set(0, x, y, red);
                            dst.set(1, x, y, green);
                            dst.set(2, x, y, blue);
                            dst.set(3, x, y, alpha);
                            ++x;
                        }
                        ++y;
                    }
                    return dst;
                }
                if (colorModel == ColorModel.RED) {
                    view = depth == 1 ? arr : ((Array3D)arr).slice(0, 0);
                } else if (colorModel == ColorModel.GREEN) {
                    view = depth == 1 ? arr : ((Array3D)arr).slice(1, 0);
                } else if (colorModel == ColorModel.BLUE) {
                    view = depth == 1 ? arr : ((Array3D)arr).slice(2, 0);
                } else {
                    if (colorModel == ColorModel.ALPHA) {
                        dst = Float2D.create(width, height);
                        if (depth == 4) {
                            src = (Byte3D)arr;
                            scale = 0.003921569f;
                            y = 0;
                            while (y < height) {
                                x = 0;
                                while (x < width) {
                                    alpha = (float)(src.get(3, x, y) & 255) * 0.003921569f;
                                    dst.set(x, y, alpha);
                                    ++x;
                                }
                                ++y;
                            }
                        } else {
                            dst.fill(1.0f);
                        }
                        return dst;
                    }
                    throw new IllegalArgumentException("Unkwnon color filter");
                }
            }
        }
        if (view == arr && type == 4) {
            return (FloatArray)arr;
        }
        shape = view.getShape();
        rank = view.getRank();
        depth = rank == 2 ? 1 : shape.dimension(0);
        switch (type) {
            case 0: {
                if (depth == 1) {
                    dst = Float2D.create(width, height);
                    src = (Byte2D)view;
                    y = 0;
                    while (y < height) {
                        x = 0;
                        while (x < width) {
                            value = src.get(x, y) & 255;
                            dst.set(x, y, value);
                            ++x;
                        }
                        ++y;
                    }
                    return dst;
                }
                dst = Float3D.create(depth, width, height);
                src = (Byte3D)view;
                if (depth != 3) {
                    throw new IllegalArgumentException("assertion failed");
                }
                y = 0;
                while (y < height) {
                    x = 0;
                    while (x < width) {
                        red = src.get(0, x, y) & 255;
                        green = src.get(1, x, y) & 255;
                        blue = src.get(2, x, y) & 255;
                        dst.set(0, x, y, red);
                        dst.set(1, x, y, green);
                        dst.set(2, x, y, blue);
                        ++x;
                    }
                    ++y;
                }
                return dst;
            }
            case 1: {
                if (depth == 1) {
                    dst = Float2D.create(width, height);
                    src = (Short2D)view;
                    y = 0;
                    while (y < height) {
                        x = 0;
                        while (x < width) {
                            value = src.get(x, y);
                            dst.set(x, y, value);
                            ++x;
                        }
                        ++y;
                    }
                    return dst;
                }
                dst = Float3D.create(depth, width, height);
                src = (Short3D)view;
                if (depth != 3) {
                    throw new IllegalArgumentException("assertion failed");
                }
                y = 0;
                while (y < height) {
                    x = 0;
                    while (x < width) {
                        red = src.get(0, x, y);
                        green = src.get(1, x, y);
                        blue = src.get(2, x, y);
                        dst.set(0, x, y, red);
                        dst.set(1, x, y, green);
                        dst.set(2, x, y, blue);
                        ++x;
                    }
                    ++y;
                }
                return dst;
            }
            case 2: {
                if (depth == 1) {
                    dst = Float2D.create(width, height);
                    src = (Int2D)view;
                    y = 0;
                    while (y < height) {
                        x = 0;
                        while (x < width) {
                            value = src.get(x, y);
                            dst.set(x, y, value);
                            ++x;
                        }
                        ++y;
                    }
                    return dst;
                }
                dst = Float3D.create(depth, width, height);
                src = (Int3D)view;
                if (depth != 3) {
                    throw new IllegalArgumentException("assertion failed");
                }
                y = 0;
                while (y < height) {
                    x = 0;
                    while (x < width) {
                        red = src.get(0, x, y);
                        green = src.get(1, x, y);
                        blue = src.get(2, x, y);
                        dst.set(0, x, y, red);
                        dst.set(1, x, y, green);
                        dst.set(2, x, y, blue);
                        ++x;
                    }
                    ++y;
                }
                return dst;
            }
            case 3: {
                if (depth == 1) {
                    dst = Float2D.create(width, height);
                    src = (Long2D)view;
                    y = 0;
                    while (y < height) {
                        x = 0;
                        while (x < width) {
                            value = src.get(x, y);
                            dst.set(x, y, value);
                            ++x;
                        }
                        ++y;
                    }
                    return dst;
                }
                dst = Float3D.create(depth, width, height);
                src = (Long3D)view;
                if (depth != 3) {
                    throw new IllegalArgumentException("assertion failed");
                }
                y = 0;
                while (y < height) {
                    x = 0;
                    while (x < width) {
                        red = src.get(0, x, y);
                        green = src.get(1, x, y);
                        blue = src.get(2, x, y);
                        dst.set(0, x, y, red);
                        dst.set(1, x, y, green);
                        dst.set(2, x, y, blue);
                        ++x;
                    }
                    ++y;
                }
                return dst;
            }
            case 4: {
                if (depth == 1) {
                    dst = Float2D.create(width, height);
                    src = (Float2D)view;
                    y = 0;
                    while (y < height) {
                        x = 0;
                        while (x < width) {
                            value = src.get(x, y);
                            dst.set(x, y, value);
                            ++x;
                        }
                        ++y;
                    }
                    return dst;
                }
                dst = Float3D.create(depth, width, height);
                src = (Float3D)view;
                if (depth != 3) {
                    throw new IllegalArgumentException("assertion failed");
                }
                y = 0;
                while (y < height) {
                    x = 0;
                    while (x < width) {
                        red = src.get(0, x, y);
                        green = src.get(1, x, y);
                        blue = src.get(2, x, y);
                        dst.set(0, x, y, red);
                        dst.set(1, x, y, green);
                        dst.set(2, x, y, blue);
                        ++x;
                    }
                    ++y;
                }
                return dst;
            }
            case 5: {
                if (depth == 1) {
                    dst = Float2D.create(width, height);
                    src = (Double2D)view;
                    y = 0;
                    while (y < height) {
                        x = 0;
                        while (x < width) {
                            value = (float)src.get(x, y);
                            dst.set(x, y, value);
                            ++x;
                        }
                        ++y;
                    }
                    return dst;
                }
                dst = Float3D.create(depth, width, height);
                src = (Double3D)view;
                if (depth != 3) {
                    throw new IllegalArgumentException("assertion failed");
                }
                y = 0;
                while (y < height) {
                    x = 0;
                    while (x < width) {
                        red = (float)src.get(0, x, y);
                        green = (float)src.get(1, x, y);
                        blue = (float)src.get(2, x, y);
                        dst.set(0, x, y, red);
                        dst.set(1, x, y, green);
                        dst.set(2, x, y, blue);
                        ++x;
                    }
                    ++y;
                }
                return dst;
            }
        }
        throw new IllegalTypeException();
    }

    /*
     * Unable to fully structure code
     */
    public static DoubleArray filterImageAsDouble(ShapedArray arr, ColorModel colorModel) {
        block155: {
            block154: {
                type = arr.getType();
                shape = arr.getShape();
                rank = shape.rank();
                depth = -1;
                colored = false;
                if (rank == 2) {
                    depth = 1;
                } else if (rank == 3) {
                    depth = shape.dimension(0);
                    if (depth == 3) {
                        colored = true;
                    } else if (depth == 4 && type == 0) {
                        colored = true;
                    } else {
                        depth = -1;
                    }
                }
                if (depth < 0) {
                    throw new IllegalArgumentException("Images must be WIDTH x HEIGHT arrays, 3 x WIDTH x HEIGHT arrays or 4 x WIDTH x HEIGHT byte arrays.");
                }
                width = shape.dimension(rank - 2);
                height = shape.dimension(rank - 1);
                view = null;
                if (colorModel != ColorModel.GRAY) break block154;
                if (colored) {
                    dst = Double2D.create(width, height);
                    switch (type) {
                        case 0: {
                            src = (Byte3D)arr;
                            y = 0;
                            while (y < height) {
                                x = 0;
                                while (x < width) {
                                    red = src.get(0, x, y) & 255;
                                    green = src.get(1, x, y) & 255;
                                    blue = src.get(2, x, y) & 255;
                                    dst.set(x, y, ColorModel.colorToGrey(red, green, blue));
                                    ++x;
                                }
                                ++y;
                            }
                            break;
                        }
                        case 1: {
                            src = (Short3D)arr;
                            y = 0;
                            while (y < height) {
                                x = 0;
                                while (x < width) {
                                    red = src.get(0, x, y);
                                    green = src.get(1, x, y);
                                    blue = src.get(2, x, y);
                                    dst.set(x, y, ColorModel.colorToGrey(red, green, blue));
                                    ++x;
                                }
                                ++y;
                            }
                            break;
                        }
                        case 2: {
                            src = (Int3D)arr;
                            y = 0;
                            while (y < height) {
                                x = 0;
                                while (x < width) {
                                    red = src.get(0, x, y);
                                    green = src.get(1, x, y);
                                    blue = src.get(2, x, y);
                                    dst.set(x, y, ColorModel.colorToGrey(red, green, blue));
                                    ++x;
                                }
                                ++y;
                            }
                            break;
                        }
                        case 3: {
                            src = (Long3D)arr;
                            y = 0;
                            while (y < height) {
                                x = 0;
                                while (x < width) {
                                    red = src.get(0, x, y);
                                    green = src.get(1, x, y);
                                    blue = src.get(2, x, y);
                                    dst.set(x, y, ColorModel.colorToGrey(red, green, blue));
                                    ++x;
                                }
                                ++y;
                            }
                            break;
                        }
                        case 4: {
                            src = (Float3D)arr;
                            y = 0;
                            while (y < height) {
                                x = 0;
                                while (x < width) {
                                    red = src.get(0, x, y);
                                    green = src.get(1, x, y);
                                    blue = src.get(2, x, y);
                                    dst.set(x, y, ColorModel.colorToGrey(red, green, blue));
                                    ++x;
                                }
                                ++y;
                            }
                            break;
                        }
                        case 5: {
                            src = (Double3D)arr;
                            y = 0;
                            while (y < height) {
                                x = 0;
                                while (x < width) {
                                    red = src.get(0, x, y);
                                    green = src.get(1, x, y);
                                    blue = src.get(2, x, y);
                                    dst.set(x, y, ColorModel.colorToGrey(red, green, blue));
                                    ++x;
                                }
                                ++y;
                            }
                            break;
                        }
                        default: {
                            throw new IllegalTypeException();
                        }
                    }
                    return dst;
                }
                view = arr;
                break block155;
            }
            if (colorModel != ColorModel.RGB) ** GOTO lbl225
            if (depth == 3) {
                view = arr;
            } else if (depth == 4) {
                view = ((Array3D)arr).view(new Range(0, 2), null, null);
            } else {
                dst = Double3D.create(3, width, height);
                switch (type) {
                    case 0: {
                        src = (Byte2D)arr;
                        y = 0;
                        while (y < height) {
                            x = 0;
                            while (x < width) {
                                value = src.get(x, y) & 255;
                                dst.set(0, x, y, value);
                                dst.set(1, x, y, value);
                                dst.set(2, x, y, value);
                                ++x;
                            }
                            ++y;
                        }
                        break;
                    }
                    case 1: {
                        src = (Short2D)arr;
                        y = 0;
                        while (y < height) {
                            x = 0;
                            while (x < width) {
                                value = src.get(x, y);
                                dst.set(0, x, y, value);
                                dst.set(1, x, y, value);
                                dst.set(2, x, y, value);
                                ++x;
                            }
                            ++y;
                        }
                        break;
                    }
                    case 2: {
                        src = (Int2D)arr;
                        y = 0;
                        while (y < height) {
                            x = 0;
                            while (x < width) {
                                value = src.get(x, y);
                                dst.set(0, x, y, value);
                                dst.set(1, x, y, value);
                                dst.set(2, x, y, value);
                                ++x;
                            }
                            ++y;
                        }
                        break;
                    }
                    case 3: {
                        src = (Long2D)arr;
                        y = 0;
                        while (y < height) {
                            x = 0;
                            while (x < width) {
                                value = src.get(x, y);
                                dst.set(0, x, y, value);
                                dst.set(1, x, y, value);
                                dst.set(2, x, y, value);
                                ++x;
                            }
                            ++y;
                        }
                        break;
                    }
                    case 4: {
                        src = (Float2D)arr;
                        y = 0;
                        while (y < height) {
                            x = 0;
                            while (x < width) {
                                value = src.get(x, y);
                                dst.set(0, x, y, value);
                                dst.set(1, x, y, value);
                                dst.set(2, x, y, value);
                                ++x;
                            }
                            ++y;
                        }
                        break;
                    }
                    case 5: {
                        src = (Double2D)arr;
                        y = 0;
                        while (y < height) {
                            x = 0;
                            while (x < width) {
                                value = src.get(x, y);
                                dst.set(0, x, y, value);
                                dst.set(1, x, y, value);
                                dst.set(2, x, y, value);
                                ++x;
                            }
                            ++y;
                        }
                        break;
                    }
                    default: {
                        throw new IllegalTypeException();
                    }
                }
                return dst;
lbl225:
                // 1 sources

                if (colorModel == ColorModel.RGBA) {
                    dst = Double3D.create(4, width, height);
                    if (depth == 1) {
                        opaque = 1.0;
                        switch (type) {
                            case 0: {
                                src = (Byte2D)arr;
                                y = 0;
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        value = src.get(x, y) & 255;
                                        dst.set(0, x, y, value);
                                        dst.set(1, x, y, value);
                                        dst.set(2, x, y, value);
                                        dst.set(3, x, y, 1.0);
                                        ++x;
                                    }
                                    ++y;
                                }
                            }
                            case 1: {
                                src = (Short2D)arr;
                                y = 0;
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        value = src.get(x, y);
                                        dst.set(0, x, y, value);
                                        dst.set(1, x, y, value);
                                        dst.set(2, x, y, value);
                                        dst.set(3, x, y, 1.0);
                                        ++x;
                                    }
                                    ++y;
                                }
                            }
                            case 2: {
                                src = (Int2D)arr;
                                y = 0;
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        value = src.get(x, y);
                                        dst.set(0, x, y, value);
                                        dst.set(1, x, y, value);
                                        dst.set(2, x, y, value);
                                        dst.set(3, x, y, 1.0);
                                        ++x;
                                    }
                                    ++y;
                                }
                            }
                            case 3: {
                                src = (Long2D)arr;
                                y = 0;
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        value = src.get(x, y);
                                        dst.set(0, x, y, value);
                                        dst.set(1, x, y, value);
                                        dst.set(2, x, y, value);
                                        dst.set(3, x, y, 1.0);
                                        ++x;
                                    }
                                    ++y;
                                }
                            }
                            case 4: {
                                src = (Float2D)arr;
                                y = 0;
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        value = src.get(x, y);
                                        dst.set(0, x, y, value);
                                        dst.set(1, x, y, value);
                                        dst.set(2, x, y, value);
                                        dst.set(3, x, y, 1.0);
                                        ++x;
                                    }
                                    ++y;
                                }
                            }
                            case 5: {
                                src = (Double2D)arr;
                                y = 0;
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        value = src.get(x, y);
                                        dst.set(0, x, y, value);
                                        dst.set(1, x, y, value);
                                        dst.set(2, x, y, value);
                                        dst.set(3, x, y, 1.0);
                                        ++x;
                                    }
                                    ++y;
                                }
                                break;
                            }
                        }
                        throw new IllegalTypeException();
                    }
                    if (depth == 3) {
                        opaque = 1.0;
                        switch (type) {
                            case 0: {
                                src = (Byte3D)arr;
                                y = 0;
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        red = src.get(0, x, y) & 255;
                                        green = src.get(1, x, y) & 255;
                                        blue = src.get(2, x, y) & 255;
                                        dst.set(0, x, y, red);
                                        dst.set(1, x, y, green);
                                        dst.set(2, x, y, blue);
                                        dst.set(3, x, y, 1.0);
                                        ++x;
                                    }
                                    ++y;
                                }
                            }
                            case 1: {
                                src = (Short3D)arr;
                                y = 0;
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        red = src.get(0, x, y);
                                        green = src.get(1, x, y);
                                        blue = src.get(2, x, y);
                                        dst.set(0, x, y, red);
                                        dst.set(1, x, y, green);
                                        dst.set(2, x, y, blue);
                                        dst.set(3, x, y, 1.0);
                                        ++x;
                                    }
                                    ++y;
                                }
                            }
                            case 2: {
                                src = (Int3D)arr;
                                y = 0;
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        red = src.get(0, x, y);
                                        green = src.get(1, x, y);
                                        blue = src.get(2, x, y);
                                        dst.set(0, x, y, red);
                                        dst.set(1, x, y, green);
                                        dst.set(2, x, y, blue);
                                        dst.set(3, x, y, 1.0);
                                        ++x;
                                    }
                                    ++y;
                                }
                            }
                            case 3: {
                                src = (Long3D)arr;
                                y = 0;
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        red = src.get(0, x, y);
                                        green = src.get(1, x, y);
                                        blue = src.get(2, x, y);
                                        dst.set(0, x, y, red);
                                        dst.set(1, x, y, green);
                                        dst.set(2, x, y, blue);
                                        dst.set(3, x, y, 1.0);
                                        ++x;
                                    }
                                    ++y;
                                }
                            }
                            case 4: {
                                src = (Float3D)arr;
                                y = 0;
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        red = src.get(0, x, y);
                                        green = src.get(1, x, y);
                                        blue = src.get(2, x, y);
                                        dst.set(0, x, y, red);
                                        dst.set(1, x, y, green);
                                        dst.set(2, x, y, blue);
                                        dst.set(3, x, y, 1.0);
                                        ++x;
                                    }
                                    ++y;
                                }
                            }
                            case 5: {
                                src = (Double3D)arr;
                                y = 0;
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        red = src.get(0, x, y);
                                        green = src.get(1, x, y);
                                        blue = src.get(2, x, y);
                                        dst.set(0, x, y, red);
                                        dst.set(1, x, y, green);
                                        dst.set(2, x, y, blue);
                                        dst.set(3, x, y, 1.0);
                                        ++x;
                                    }
                                    ++y;
                                }
                                break;
                            }
                        }
                        throw new IllegalTypeException();
                    }
                    src = (Byte3D)arr;
                    scale = 0.00392156862745098;
                    y = 0;
                    while (y < height) {
                        x = 0;
                        while (x < width) {
                            red = src.get(0, x, y) & 255;
                            green = src.get(1, x, y) & 255;
                            blue = src.get(2, x, y) & 255;
                            alpha = (double)(src.get(3, x, y) & 255) * 0.00392156862745098;
                            dst.set(0, x, y, red);
                            dst.set(1, x, y, green);
                            dst.set(2, x, y, blue);
                            dst.set(3, x, y, alpha);
                            ++x;
                        }
                        ++y;
                    }
                    return dst;
                }
                if (colorModel == ColorModel.RED) {
                    view = depth == 1 ? arr : ((Array3D)arr).slice(0, 0);
                } else if (colorModel == ColorModel.GREEN) {
                    view = depth == 1 ? arr : ((Array3D)arr).slice(1, 0);
                } else if (colorModel == ColorModel.BLUE) {
                    view = depth == 1 ? arr : ((Array3D)arr).slice(2, 0);
                } else {
                    if (colorModel == ColorModel.ALPHA) {
                        dst = Double2D.create(width, height);
                        if (depth == 4) {
                            src = (Byte3D)arr;
                            scale = 0.00392156862745098;
                            y = 0;
                            while (y < height) {
                                x = 0;
                                while (x < width) {
                                    alpha = (double)(src.get(3, x, y) & 255) * 0.00392156862745098;
                                    dst.set(x, y, alpha);
                                    ++x;
                                }
                                ++y;
                            }
                        } else {
                            dst.fill(1.0);
                        }
                        return dst;
                    }
                    throw new IllegalArgumentException("Unkwnon color filter");
                }
            }
        }
        if (view == arr && type == 5) {
            return (DoubleArray)arr;
        }
        shape = view.getShape();
        rank = view.getRank();
        depth = rank == 2 ? 1 : shape.dimension(0);
        switch (type) {
            case 0: {
                if (depth == 1) {
                    dst = Double2D.create(width, height);
                    src = (Byte2D)view;
                    y = 0;
                    while (y < height) {
                        x = 0;
                        while (x < width) {
                            value = src.get(x, y) & 255;
                            dst.set(x, y, value);
                            ++x;
                        }
                        ++y;
                    }
                    return dst;
                }
                dst = Double3D.create(depth, width, height);
                src = (Byte3D)view;
                if (depth != 3) {
                    throw new IllegalArgumentException("assertion failed");
                }
                y = 0;
                while (y < height) {
                    x = 0;
                    while (x < width) {
                        red = src.get(0, x, y) & 255;
                        green = src.get(1, x, y) & 255;
                        blue = src.get(2, x, y) & 255;
                        dst.set(0, x, y, red);
                        dst.set(1, x, y, green);
                        dst.set(2, x, y, blue);
                        ++x;
                    }
                    ++y;
                }
                return dst;
            }
            case 1: {
                if (depth == 1) {
                    dst = Double2D.create(width, height);
                    src = (Short2D)view;
                    y = 0;
                    while (y < height) {
                        x = 0;
                        while (x < width) {
                            value = src.get(x, y);
                            dst.set(x, y, value);
                            ++x;
                        }
                        ++y;
                    }
                    return dst;
                }
                dst = Double3D.create(depth, width, height);
                src = (Short3D)view;
                if (depth != 3) {
                    throw new IllegalArgumentException("assertion failed");
                }
                y = 0;
                while (y < height) {
                    x = 0;
                    while (x < width) {
                        red = src.get(0, x, y);
                        green = src.get(1, x, y);
                        blue = src.get(2, x, y);
                        dst.set(0, x, y, red);
                        dst.set(1, x, y, green);
                        dst.set(2, x, y, blue);
                        ++x;
                    }
                    ++y;
                }
                return dst;
            }
            case 2: {
                if (depth == 1) {
                    dst = Double2D.create(width, height);
                    src = (Int2D)view;
                    y = 0;
                    while (y < height) {
                        x = 0;
                        while (x < width) {
                            value = src.get(x, y);
                            dst.set(x, y, value);
                            ++x;
                        }
                        ++y;
                    }
                    return dst;
                }
                dst = Double3D.create(depth, width, height);
                src = (Int3D)view;
                if (depth != 3) {
                    throw new IllegalArgumentException("assertion failed");
                }
                y = 0;
                while (y < height) {
                    x = 0;
                    while (x < width) {
                        red = src.get(0, x, y);
                        green = src.get(1, x, y);
                        blue = src.get(2, x, y);
                        dst.set(0, x, y, red);
                        dst.set(1, x, y, green);
                        dst.set(2, x, y, blue);
                        ++x;
                    }
                    ++y;
                }
                return dst;
            }
            case 3: {
                if (depth == 1) {
                    dst = Double2D.create(width, height);
                    src = (Long2D)view;
                    y = 0;
                    while (y < height) {
                        x = 0;
                        while (x < width) {
                            value = src.get(x, y);
                            dst.set(x, y, value);
                            ++x;
                        }
                        ++y;
                    }
                    return dst;
                }
                dst = Double3D.create(depth, width, height);
                src = (Long3D)view;
                if (depth != 3) {
                    throw new IllegalArgumentException("assertion failed");
                }
                y = 0;
                while (y < height) {
                    x = 0;
                    while (x < width) {
                        red = src.get(0, x, y);
                        green = src.get(1, x, y);
                        blue = src.get(2, x, y);
                        dst.set(0, x, y, red);
                        dst.set(1, x, y, green);
                        dst.set(2, x, y, blue);
                        ++x;
                    }
                    ++y;
                }
                return dst;
            }
            case 4: {
                if (depth == 1) {
                    dst = Double2D.create(width, height);
                    src = (Float2D)view;
                    y = 0;
                    while (y < height) {
                        x = 0;
                        while (x < width) {
                            value = src.get(x, y);
                            dst.set(x, y, value);
                            ++x;
                        }
                        ++y;
                    }
                    return dst;
                }
                dst = Double3D.create(depth, width, height);
                src = (Float3D)view;
                if (depth != 3) {
                    throw new IllegalArgumentException("assertion failed");
                }
                y = 0;
                while (y < height) {
                    x = 0;
                    while (x < width) {
                        red = src.get(0, x, y);
                        green = src.get(1, x, y);
                        blue = src.get(2, x, y);
                        dst.set(0, x, y, red);
                        dst.set(1, x, y, green);
                        dst.set(2, x, y, blue);
                        ++x;
                    }
                    ++y;
                }
                return dst;
            }
            case 5: {
                if (depth == 1) {
                    dst = Double2D.create(width, height);
                    src = (Double2D)view;
                    y = 0;
                    while (y < height) {
                        x = 0;
                        while (x < width) {
                            value = src.get(x, y);
                            dst.set(x, y, value);
                            ++x;
                        }
                        ++y;
                    }
                    return dst;
                }
                dst = Double3D.create(depth, width, height);
                src = (Double3D)view;
                if (depth != 3) {
                    throw new IllegalArgumentException("assertion failed");
                }
                y = 0;
                while (y < height) {
                    x = 0;
                    while (x < width) {
                        red = src.get(0, x, y);
                        green = src.get(1, x, y);
                        blue = src.get(2, x, y);
                        dst.set(0, x, y, red);
                        dst.set(1, x, y, green);
                        dst.set(2, x, y, blue);
                        ++x;
                    }
                    ++y;
                }
                return dst;
            }
        }
        throw new IllegalTypeException();
    }
}

