/*
 * Decompiled with CFR 0.152.
 */
package mitiv.microscopy;

import mitiv.microscopy.WideFieldModel;
import mitiv.utils.MathUtils;

public class BiPhotonModel {
    private static final double[] JRho = null;
    private static final double[] psi = null;
    protected WideFieldModel WFFM;
    private double[] rho;
    private double ni;
    private int PState;
    private double[] phi;
    private double[] modulus_coefs;
    private double[] phase_coefs;
    private int lambda_ni;
    private int lambda;
    private int deltaX;
    private int deltaY;
    private double[] maskPupil;
    private double[] psf;
    private int Nx;
    private int Ny;
    private int Nzern;
    private double[] Z;
    private double[] a;

    public BiPhotonModel(double NA, double lambda, double ni, double ns, double zdepth, double dxy, double dz, int Nx, int Ny, int Nz, boolean use_depth_scaling) {
        this.WFFM = new WideFieldModel(NA, lambda, ni, ns, zdepth, dxy, dz, Nx, Ny, Nz, use_depth_scaling);
    }

    public void setRho(double[] beta) {
    }

    public void setPhi(double[] alpha) {
    }

    public void setDefocus(double[] defocus) {
    }

    public double[] apply_J_rho(double[] q) {
        return JRho;
    }

    public double[] apply_J_phi(double[] q) {
        return new double[0];
    }

    public double[] apply_J_defocus(double[] q) {
        return new double[0];
    }

    public double[] getRho() {
        return this.rho;
    }

    public double getLambda() {
        return this.WFFM.getLambda();
    }

    public double getNi() {
        return this.ni;
    }

    public double[] getPhi() {
        if (this.PState < 1) {
            this.computePSF();
        }
        return this.phi;
    }

    private void computePSF() {
    }

    public double[] getPsi() {
        if (this.PState < 1) {
            this.computePSF();
        }
        return psi;
    }

    public double[] getBeta() {
        return this.modulus_coefs;
    }

    public double[] getAlpha() {
        return this.phase_coefs;
    }

    public double[] getDefocusMultiplyByLambda() {
        if (this.PState < 1) {
            this.computePSF();
        }
        double[] defocus = new double[]{this.lambda_ni * this.lambda, this.deltaX * this.lambda, this.deltaY * this.lambda};
        return defocus;
    }

    public double[] getDefocus() {
        if (this.PState < 1) {
            this.computePSF();
        }
        double[] defocus = new double[]{this.lambda_ni, this.deltaX, this.deltaY};
        return defocus;
    }

    public double[] getGamma() {
        if (this.PState < 1) {
            this.computePSF();
        }
        return psi;
    }

    public double[] getMaskPupil() {
        if (this.PState < 1) {
            this.computePSF();
        }
        return this.maskPupil;
    }

    public double[] getPSF() {
        if (this.PState < 1) {
            this.computePSF();
        }
        return this.psf;
    }

    public double[] getPSF(int k) {
        if (this.PState < 1) {
            this.computePSF();
        }
        return MathUtils.getArray(this.psf, this.Nx, this.Ny, k);
    }

    public double[] getZernike() {
        return this.WFFM.getZernike();
    }

    public int getNZern() {
        return this.Nzern;
    }

    public double[] getZernike(int k) {
        return MathUtils.getArray(this.Z, this.Nx, this.Ny, k);
    }

    public double[] get_a() {
        if (this.PState < 1) {
            this.computePSF();
        }
        return this.a;
    }
}

