/*
 * Decompiled with CFR 0.152.
 */
package mitiv.microscopy;

import mitiv.array.ArrayFactory;
import mitiv.array.DoubleArray;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.deconv.WeightedConvolutionCost;
import mitiv.invpb.ReconstructionJob;
import mitiv.invpb.ReconstructionSynchronizer;
import mitiv.invpb.ReconstructionViewer;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.microscopy.WideFieldModel;
import mitiv.optim.ArmijoLineSearch;
import mitiv.optim.BoundProjector;
import mitiv.optim.LBFGS;
import mitiv.optim.LineSearch;
import mitiv.optim.MoreThuenteLineSearch;
import mitiv.optim.NonLinearConjugateGradient;
import mitiv.optim.OptimTask;
import mitiv.optim.ReverseCommunicationOptimizer;
import mitiv.optim.SimpleBounds;
import mitiv.optim.SimpleLowerBound;
import mitiv.optim.SimpleUpperBound;
import mitiv.optim.VMLMB;
import mitiv.utils.MathUtils;

public class PSF_Estimation
implements ReconstructionJob {
    private double mu = 10.0;
    private double epsilon = 1.0;
    private double gatol = 0.0;
    private double grtol = 0.001;
    private int limitedMemorySize = 5;
    private double lowerBound = Double.NEGATIVE_INFINITY;
    private double upperBound = Double.POSITIVE_INFINITY;
    private boolean debug = false;
    private int maxiter = 20;
    private DoubleArray data = null;
    private ShapedArray obj = null;
    private DoubleArray result = null;
    private ShapedArray psf = null;
    private double fcost = 0.0;
    private DoubleShapedVector gcost = null;
    private WideFieldModel pupil = null;
    private ReverseCommunicationOptimizer minimizer = null;
    private ReconstructionViewer viewer = null;
    private ReconstructionSynchronizer synchronizer = null;
    private double[] synchronizedParameters = new double[]{0.0, 0.0};
    private boolean[] change = new boolean[2];
    private DoubleArray weights = null;
    public static final int DEFOCUS = 1;
    public static final int ALPHA = 2;
    public static final int BETA = 3;
    private boolean run = true;

    public void createSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizedParameters[0] = this.mu;
            this.synchronizedParameters[1] = this.epsilon;
            this.synchronizer = new ReconstructionSynchronizer(this.synchronizedParameters);
        }
    }

    public void deleteSynchronizer() {
        this.synchronizer = null;
    }

    public void enablePositivity(Boolean positivity) {
        this.setLowerBound(positivity != false ? 0.0 : Double.NEGATIVE_INFINITY);
    }

    private static void fatal(String reason) {
        throw new IllegalArgumentException(reason);
    }

    public void fitPSF(DoubleShapedVector x, int flag) {
        int m;
        if (this.data == null) {
            PSF_Estimation.fatal("Input data not specified.");
        }
        Shape dataShape = this.data.getShape();
        Shape xShape = x.getShape();
        int rank = this.data.getRank();
        DoubleShapedVectorSpace dataSpace = new DoubleShapedVectorSpace(dataShape);
        if (this.obj == null) {
            PSF_Estimation.fatal("Object not specified.");
        }
        if (this.obj.getRank() != rank) {
            PSF_Estimation.fatal("Obj must have same rank as data.");
        }
        int k = 0;
        while (k < rank) {
            if (this.obj.getDimension(k) != dataShape.dimension(k)) {
                PSF_Estimation.fatal("The dimensions of the PSF must match those of the input image.");
            }
            ++k;
        }
        DoubleShapedVectorSpace objSpace = new DoubleShapedVectorSpace(dataShape);
        if (this.result != null) {
            int k2 = 0;
            while (k2 < rank) {
                if (this.result.getDimension(k2) != this.data.getDimension(k2)) {
                    this.result = null;
                    break;
                }
                ++k2;
            }
        }
        DoubleShapedVectorSpace variableSpace = x.getSpace();
        this.result = ArrayFactory.wrap(x.getData(), xShape);
        int[] off = new int[3];
        WeightedConvolutionCost fdata = WeightedConvolutionCost.build(objSpace, dataSpace);
        fdata.setPSF(this.obj, off);
        fdata.setWeightsAndData(this.weights, this.data);
        if (this.debug) {
            System.out.println("Vector space initialization complete.");
        }
        this.fcost = 0.0;
        this.gcost = objSpace.create();
        if (this.debug) {
            System.out.println("Cost function initialization complete.");
        }
        LineSearch lineSearch = null;
        LBFGS lbfgs = null;
        VMLMB vmlmb = null;
        NonLinearConjugateGradient nlcg = null;
        BoundProjector projector = null;
        int bounded = 0;
        this.limitedMemorySize = 0;
        if (bounded == 0) {
            lineSearch = new MoreThuenteLineSearch(0.05, 0.1, 1.0E-17);
            if (this.limitedMemorySize > 0) {
                lbfgs = new LBFGS(variableSpace, this.limitedMemorySize, lineSearch);
                lbfgs.setAbsoluteTolerance(this.gatol);
                lbfgs.setRelativeTolerance(this.grtol);
                this.minimizer = lbfgs;
            } else {
                int method = 771;
                nlcg = new NonLinearConjugateGradient(variableSpace, method, lineSearch);
                nlcg.setAbsoluteTolerance(this.gatol);
                nlcg.setRelativeTolerance(this.grtol);
                this.minimizer = nlcg;
            }
        } else {
            lineSearch = new ArmijoLineSearch(0.5, 0.1);
            projector = bounded == 1 ? new SimpleLowerBound(variableSpace, this.lowerBound) : (bounded == 2 ? new SimpleUpperBound(variableSpace, this.upperBound) : new SimpleBounds(variableSpace, this.lowerBound, this.upperBound));
            m = this.limitedMemorySize > 1 ? this.limitedMemorySize : 5;
            vmlmb = new VMLMB(variableSpace, projector, m, lineSearch);
            vmlmb.setAbsoluteTolerance(this.gatol);
            vmlmb.setRelativeTolerance(this.grtol);
            this.minimizer = vmlmb;
            projector.projectVariables(x);
        }
        if (this.debug) {
            System.out.println("Optimization method initialization complete.");
        }
        m = this.limitedMemorySize > 1 ? this.limitedMemorySize : 5;
        vmlmb = new VMLMB(variableSpace, projector, m, lineSearch);
        vmlmb.setAbsoluteTolerance(this.gatol);
        vmlmb.setRelativeTolerance(this.grtol);
        this.minimizer = vmlmb;
        DoubleShapedVector gX = variableSpace.create();
        OptimTask task = this.minimizer.start();
        while (this.run) {
            block46: {
                block44: {
                    block47: {
                        block45: {
                            if (task != OptimTask.COMPUTE_FG) break block44;
                            if (flag == 1) {
                                if (this.debug) {
                                    System.out.println("--------------");
                                    System.out.println("defocus");
                                    MathUtils.printArray(x.getData());
                                }
                                this.pupil.setDefocus(x.getData());
                            } else if (flag == 2) {
                                if (this.debug) {
                                    System.out.println("--------------");
                                    System.out.println("alpha");
                                    MathUtils.printArray(x.getData());
                                }
                                this.pupil.setPhi(x.getData());
                            } else if (flag == 3) {
                                if (this.debug) {
                                    System.out.println("--------------");
                                    System.out.println("beta");
                                    MathUtils.printArray(x.getData());
                                }
                                this.pupil.setRho(x.getData());
                            }
                            this.pupil.computePSF();
                            this.fcost = fdata.computeCostAndGradient(1.0, objSpace.wrap(this.pupil.getPSF()), this.gcost, true);
                            if (flag != 1) break block45;
                            gX = variableSpace.wrap(this.pupil.apply_J_defocus(this.gcost.getData()));
                            if (this.debug) {
                                System.out.println("grdx");
                                MathUtils.stat(this.gcost.getData());
                                System.out.println("grd");
                                MathUtils.printArray(gX.getData());
                            }
                            break block46;
                        }
                        if (flag != 2) break block47;
                        gX = variableSpace.wrap(this.pupil.apply_J_phi(this.gcost.getData()));
                        if (this.debug) {
                            System.out.println("grd");
                            MathUtils.printArray(gX.getData());
                        }
                        break block46;
                    }
                    if (flag != 3) break block46;
                    gX = variableSpace.wrap(this.pupil.apply_J_rho(this.gcost.getData()));
                    if (!this.debug) break block46;
                    System.out.println("grdx");
                    MathUtils.stat(this.gcost.getData());
                    System.out.println("grd");
                    MathUtils.printArray(gX.getData());
                    break block46;
                }
                if (task == OptimTask.NEW_X || task == OptimTask.FINAL_X) {
                    boolean stop;
                    if (this.viewer != null) {
                        this.viewer.display(this);
                    }
                    boolean bl = stop = task == OptimTask.FINAL_X;
                    if (!stop && this.maxiter >= 0 && this.minimizer.getIterations() >= this.maxiter) {
                        System.err.format("Warning: too many iterations (%d).\n", this.maxiter);
                        stop = true;
                    }
                    if (stop) {
                        break;
                    }
                } else {
                    System.err.println("TiPi: PSF_Estimation, " + (Object)((Object)task) + " : " + this.minimizer.getReason());
                    break;
                }
            }
            if (this.synchronizer != null) {
                if (this.synchronizer.getTask() == 1) break;
                this.synchronizedParameters[0] = this.mu;
                this.synchronizedParameters[1] = this.epsilon;
                if (this.synchronizer.updateParameters(this.synchronizedParameters, this.change)) {
                    if (this.change[0]) {
                        this.mu = this.synchronizedParameters[0];
                    }
                    if (this.change[1]) {
                        this.epsilon = this.synchronizedParameters[1];
                    }
                }
            }
            if (this.debug) {
                System.out.println("Evaluations");
                System.out.println(this.minimizer.getEvaluations());
                System.out.println("Iterations");
                System.out.println(this.minimizer.getIterations());
            }
            task = this.minimizer.iterate(x, this.fcost, gX);
            if (this.minimizer.getEvaluations() > 20) break;
        }
        if (flag == 1) {
            if (this.debug) {
                System.out.println("--------------");
                System.out.println("defocus");
                MathUtils.printArray(x.getData());
            }
            this.pupil.setDefocus(x.getData());
        } else if (flag == 2) {
            if (this.debug) {
                System.out.println("--------------");
                System.out.println("alpha");
                MathUtils.printArray(x.getData());
            }
            this.pupil.setPhi(x.getData());
        } else if (flag == 3) {
            if (this.debug) {
                System.out.println("--------------");
                System.out.println("beta");
                MathUtils.printArray(x.getData());
            }
            this.pupil.setRho(x.getData());
        }
    }

    public void setDebugMode(boolean value) {
        this.debug = value;
    }

    public void setMaximumIterations(int value) {
        this.maxiter = value;
    }

    public void setLimitedMemorySize(int value) {
        this.limitedMemorySize = value;
    }

    public void setAbsoluteTolerance(double value) {
        this.gatol = value;
    }

    public void setRelativeTolerance(double value) {
        this.grtol = value;
    }

    @Override
    public double getRelativeTolerance() {
        return this.grtol;
    }

    public void setLowerBound(double value) {
        this.lowerBound = value;
    }

    public void setUpperBound(double value) {
        this.upperBound = value;
    }

    public void stop() {
        this.run = false;
    }

    public void start() {
        this.run = true;
    }

    public void setWeight(DoubleArray W) {
        this.weights = W;
    }

    public ReconstructionViewer getViewer() {
        return this.viewer;
    }

    public void setViewer(ReconstructionViewer rv) {
        this.viewer = rv;
    }

    public ReconstructionSynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    public void setPupil(WideFieldModel pupil) {
        this.pupil = pupil;
    }

    public DoubleArray getData() {
        return this.data;
    }

    public void setData(DoubleArray data) {
        this.data = data;
    }

    public ShapedArray getPsf() {
        return this.psf;
    }

    public void setPsf(DoubleArray psf) {
        this.psf = psf;
    }

    @Override
    public DoubleArray getResult() {
        return this.result;
    }

    public void setResult(DoubleArray result) {
        this.result = result;
    }

    @Override
    public int getIterations() {
        return this.minimizer == null ? 0 : this.minimizer.getIterations();
    }

    @Override
    public int getEvaluations() {
        return this.minimizer == null ? 0 : this.minimizer.getEvaluations();
    }

    @Override
    public double getCost() {
        return this.fcost;
    }

    @Override
    public double getGradientNorm2() {
        return this.gcost == null ? 0.0 : this.gcost.norm2();
    }

    @Override
    public double getGradientNorm1() {
        return this.gcost == null ? 0.0 : this.gcost.norm1();
    }

    @Override
    public double getGradientNormInf() {
        return this.gcost == null ? 0.0 : this.gcost.normInf();
    }

    public void setObj(ShapedArray obj) {
        this.obj = obj;
    }
}

