/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array2D;
import mitiv.array.Byte1D;
import mitiv.array.ByteArray;
import mitiv.array.Double2D;
import mitiv.array.Float2D;
import mitiv.array.Int2D;
import mitiv.array.Long2D;
import mitiv.array.ShapedArray;
import mitiv.array.Short2D;
import mitiv.array.impl.FlatByte2D;
import mitiv.array.impl.StriddenByte2D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ByteFunction;
import mitiv.base.mapping.ByteScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.ByteGenerator;

public abstract class Byte2D
extends Array2D
implements ByteArray {
    protected Byte2D(int dim1, int dim2) {
        super(dim1, dim2);
    }

    protected Byte2D(int[] dims) {
        super(dims);
    }

    protected Byte2D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 0;
    }

    public abstract byte get(int var1, int var2);

    public abstract void set(int var1, int var2, byte var3);

    @Override
    public void fill(byte value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    this.set(i1, i2, value);
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, value);
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void increment(byte value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    this.set(i1, i2, (byte)(this.get(i1, i2) + value));
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, (byte)(this.get(i1, i2) + value));
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void decrement(byte value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    this.set(i1, i2, (byte)(this.get(i1, i2) - value));
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, (byte)(this.get(i1, i2) - value));
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void scale(byte value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    this.set(i1, i2, (byte)(this.get(i1, i2) * value));
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, (byte)(this.get(i1, i2) * value));
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void map(ByteFunction function) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    this.set(i1, i2, function.apply(this.get(i1, i2)));
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, function.apply(this.get(i1, i2)));
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void fill(ByteGenerator generator) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    this.set(i1, i2, generator.nextByte());
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, generator.nextByte());
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void scan(ByteScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    if (initialized) {
                        scanner.update(this.get(i1, i2));
                    } else {
                        scanner.initialize(this.get(i1, i2));
                        initialized = true;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    if (initialized) {
                        scanner.update(this.get(i1, i2));
                    } else {
                        scanner.initialize(this.get(i1, i2));
                        initialized = true;
                    }
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public byte[] flatten(boolean forceCopy) {
        byte[] out = new byte[this.number];
        int i = -1;
        int i2 = 0;
        while (i2 < this.dim2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                out[++i] = this.get(i1, i2);
                ++i1;
            }
            ++i2;
        }
        return out;
    }

    @Override
    public byte[] flatten() {
        return this.flatten(false);
    }

    @Override
    public int min() {
        int minValue = this.get(0, 0) & 0xFF;
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    if (skip) {
                        skip = false;
                    } else {
                        int value = this.get(i1, i2) & 0xFF;
                        if (value < minValue) {
                            minValue = value;
                        }
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    if (skip) {
                        skip = false;
                    } else {
                        int value = this.get(i1, i2) & 0xFF;
                        if (value < minValue) {
                            minValue = value;
                        }
                    }
                    ++i1;
                }
                ++i2;
            }
        }
        return minValue;
    }

    @Override
    public int max() {
        int maxValue = this.get(0, 0) & 0xFF;
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    if (skip) {
                        skip = false;
                    } else {
                        int value = this.get(i1, i2) & 0xFF;
                        if (value > maxValue) {
                            maxValue = value;
                        }
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    if (skip) {
                        skip = false;
                    } else {
                        int value = this.get(i1, i2) & 0xFF;
                        if (value > maxValue) {
                            maxValue = value;
                        }
                    }
                    ++i1;
                }
                ++i2;
            }
        }
        return maxValue;
    }

    @Override
    public int[] getMinAndMax() {
        int[] result = new int[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(int[] mm) {
        int minValue;
        int maxValue = minValue = this.get(0, 0) & 0xFF;
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    if (skip) {
                        skip = false;
                    } else {
                        int value = this.get(i1, i2) & 0xFF;
                        if (value < minValue) {
                            minValue = value;
                        }
                        if (value > maxValue) {
                            maxValue = value;
                        }
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    if (skip) {
                        skip = false;
                    } else {
                        int value = this.get(i1, i2) & 0xFF;
                        if (value < minValue) {
                            minValue = value;
                        }
                        if (value > maxValue) {
                            maxValue = value;
                        }
                    }
                    ++i1;
                }
                ++i2;
            }
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public int sum() {
        int totalValue = 0;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    totalValue += this.get(i1, i2) & 0xFF;
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    totalValue += this.get(i1, i2) & 0xFF;
                    ++i1;
                }
                ++i2;
            }
        }
        return totalValue;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte2D toByte() {
        return this;
    }

    @Override
    public Short2D toShort() {
        short[] out = new short[this.number];
        int i = -1;
        int i2 = 0;
        while (i2 < this.dim2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                out[++i] = this.get(i1, i2);
                ++i1;
            }
            ++i2;
        }
        return Short2D.wrap(out, this.dim1, this.dim2);
    }

    @Override
    public Int2D toInt() {
        int[] out = new int[this.number];
        int i = -1;
        int i2 = 0;
        while (i2 < this.dim2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                out[++i] = this.get(i1, i2);
                ++i1;
            }
            ++i2;
        }
        return Int2D.wrap(out, this.dim1, this.dim2);
    }

    @Override
    public Long2D toLong() {
        long[] out = new long[this.number];
        int i = -1;
        int i2 = 0;
        while (i2 < this.dim2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                out[++i] = this.get(i1, i2);
                ++i1;
            }
            ++i2;
        }
        return Long2D.wrap(out, this.dim1, this.dim2);
    }

    @Override
    public Float2D toFloat() {
        float[] out = new float[this.number];
        int i = -1;
        int i2 = 0;
        while (i2 < this.dim2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                out[++i] = this.get(i1, i2);
                ++i1;
            }
            ++i2;
        }
        return Float2D.wrap(out, this.dim1, this.dim2);
    }

    @Override
    public Double2D toDouble() {
        double[] out = new double[this.number];
        int i = -1;
        int i2 = 0;
        while (i2 < this.dim2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                out[++i] = this.get(i1, i2);
                ++i1;
            }
            ++i2;
        }
        return Double2D.wrap(out, this.dim1, this.dim2);
    }

    @Override
    public Byte2D copy() {
        return new FlatByte2D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        Byte2D src = arr.getType() == 0 ? (Byte2D)arr : (Byte2D)arr.toByte();
        if (this.getOrder() == 2 && src.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    this.set(i1, i2, src.get(i1, i2));
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, src.get(i1, i2));
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        int i = -1;
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, (byte)src.get(++i));
                    ++i1;
                }
                ++i2;
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, (byte)src.get(++i));
                    ++i1;
                }
                ++i2;
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Byte2D create() {
        return new FlatByte2D(this.getShape());
    }

    public static Byte2D create(int dim1, int dim2) {
        return new FlatByte2D(dim1, dim2);
    }

    public static Byte2D create(int[] dims) {
        return new FlatByte2D(dims);
    }

    public static Byte2D create(Shape shape) {
        return new FlatByte2D(shape);
    }

    public static Byte2D wrap(byte[] data, int dim1, int dim2) {
        return new FlatByte2D(data, dim1, dim2);
    }

    public static Byte2D wrap(byte[] data, int[] dims) {
        return new FlatByte2D(data, dims);
    }

    public static Byte2D wrap(byte[] data, Shape shape) {
        return new FlatByte2D(data, shape);
    }

    public static Byte2D wrap(byte[] data, int offset, int stride1, int stride2, int dim1, int dim2) {
        return new StriddenByte2D(data, offset, stride1, stride2, dim1, dim2);
    }

    @Override
    public abstract Byte1D slice(int var1);

    @Override
    public abstract Byte1D slice(int var1, int var2);

    @Override
    public abstract Byte2D view(Range var1, Range var2);

    @Override
    public abstract Byte2D view(int[] var1, int[] var2);

    @Override
    public abstract Byte1D as1D();
}

