/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Float3D;
import mitiv.random.MersenneTwisterGenerator;
import mitiv.random.NormalDistribution;

public class TestArray {
    public static void main(String[] args) {
        int n1 = 401;
        int n2 = 302;
        int n3 = 203;
        int number = 24583706;
        int repeat = 20;
        float[] arr = new float[24583706];
        float[][][] cube = new float[203][302][401];
        Float3D a = Float3D.wrap(arr, 401, 302, 203);
        NormalDistribution generator = new NormalDistribution(new MersenneTwisterGenerator(7864), -1.0, 1.0);
        generator.nextFloat();
        System.out.println("dimensions: 401x302x203");
        System.out.println("number of elements: 24583706");
        int loop = 1;
        while (loop <= 20) {
            int i2;
            System.out.println();
            System.out.println("loop #" + loop);
            long t0 = System.currentTimeMillis();
            int i = 0;
            while (i < 24583706) {
                arr[i] = i;
                ++i;
            }
            long t1 = System.currentTimeMillis();
            System.out.println("direct filling of flat array: " + (t1 - t0) + " ms");
            t0 = System.currentTimeMillis();
            int i3 = 0;
            while (i3 < 203) {
                i2 = 0;
                while (i2 < 302) {
                    int i1 = 0;
                    while (i1 < 401) {
                        cube[i3][i2][i1] = i1 + 401 * (i2 + 302 * i3);
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
            t1 = System.currentTimeMillis();
            System.out.println("direct filling of cube array: " + (t1 - t0) + " ms");
            t0 = System.currentTimeMillis();
            int i1 = 0;
            while (i1 < 401) {
                i2 = 0;
                while (i2 < 302) {
                    int i32 = 0;
                    while (i32 < 203) {
                        cube[i32][i2][i1] = i1 + 401 * (i2 + 302 * i32);
                        ++i32;
                    }
                    ++i2;
                }
                ++i1;
            }
            t1 = System.currentTimeMillis();
            System.out.println("direct filling of cube array in wrong order: " + (t1 - t0) + " ms");
            t0 = System.currentTimeMillis();
            a.fill(1.0f);
            t1 = System.currentTimeMillis();
            System.out.println("filling of flat array: " + (t1 - t0) + " ms");
            t0 = System.currentTimeMillis();
            a.fill(generator);
            t1 = System.currentTimeMillis();
            System.out.println("random fill of flat array: " + (t1 - t0) + " ms");
            ++loop;
        }
    }
}

