/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Short1D;
import mitiv.array.Short2D;
import mitiv.array.Short3D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedShort1D;
import mitiv.array.impl.SelectedShort2D;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.random.ShortGenerator;

public class SelectedShort3D
extends Short3D {
    static final int order = 0;
    final short[] data;
    final int[] idx1;
    final int[] idx2;
    final int[] idx3;

    public SelectedShort3D(short[] arr, int[] idx1, int[] idx2, int[] idx3) {
        super(idx1.length, idx2.length, idx3.length);
        this.data = arr;
        this.idx1 = idx1;
        this.idx2 = idx2;
        this.idx3 = idx3;
    }

    @Override
    public final void checkSanity() {
        int index;
        int indexMax;
        int offsetMin = 0;
        int offsetMax = 0;
        int indexMin = indexMax = this.idx1[0];
        int i1 = 1;
        while (i1 < this.dim1) {
            index = this.idx1[i1];
            if (index < indexMin) {
                indexMin = index;
            }
            if (index > indexMax) {
                indexMax = index;
            }
            ++i1;
        }
        offsetMin += indexMin;
        offsetMax += indexMax;
        indexMin = indexMax = this.idx2[0];
        int i2 = 1;
        while (i2 < this.dim2) {
            index = this.idx2[i2];
            if (index < indexMin) {
                indexMin = index;
            }
            if (index > indexMax) {
                indexMax = index;
            }
            ++i2;
        }
        offsetMin += indexMin;
        offsetMax += indexMax;
        indexMin = indexMax = this.idx3[0];
        int i3 = 1;
        while (i3 < this.dim3) {
            index = this.idx3[i3];
            if (index < indexMin) {
                indexMin = index;
            }
            if (index > indexMax) {
                indexMax = index;
            }
            ++i3;
        }
        if ((offsetMin += indexMin) < 0 || (offsetMax += indexMax) >= this.data.length) {
            throw new IndexOutOfBoundsException("Selected indices are out of bounds.");
        }
    }

    final int index(int i1, int i2, int i3) {
        return this.idx3[i3] + this.idx2[i2] + this.idx1[i1];
    }

    @Override
    public final short get(int i1, int i2, int i3) {
        return this.data[this.idx3[i3] + this.idx2[i2] + this.idx1[i1]];
    }

    @Override
    public final void set(int i1, int i2, int i3, short value) {
        this.data[this.idx3[i3] + this.idx2[i2] + this.idx1[i1]] = value;
    }

    @Override
    public final int getOrder() {
        return 0;
    }

    @Override
    public void fill(short value) {
        int i3 = 0;
        while (i3 < this.dim3) {
            int j3 = this.idx3[i3];
            int i2 = 0;
            while (i2 < this.dim2) {
                int j2 = this.idx2[i2] + j3;
                int i1 = 0;
                while (i1 < this.dim1) {
                    int j1 = this.idx1[i1] + j2;
                    this.data[j1] = value;
                    ++i1;
                }
                ++i2;
            }
            ++i3;
        }
    }

    @Override
    public void fill(ShortGenerator generator) {
        int i3 = 0;
        while (i3 < this.dim3) {
            int j3 = this.idx3[i3];
            int i2 = 0;
            while (i2 < this.dim2) {
                int j2 = this.idx2[i2] + j3;
                int i1 = 0;
                while (i1 < this.dim1) {
                    int j1 = this.idx1[i1] + j2;
                    this.data[j1] = generator.nextShort();
                    ++i1;
                }
                ++i2;
            }
            ++i3;
        }
    }

    @Override
    public void increment(short value) {
        int i3 = 0;
        while (i3 < this.dim3) {
            int j3 = this.idx3[i3];
            int i2 = 0;
            while (i2 < this.dim2) {
                int j2 = this.idx2[i2] + j3;
                int i1 = 0;
                while (i1 < this.dim1) {
                    int j1;
                    int n = j1 = this.idx1[i1] + j2;
                    this.data[n] = (short)(this.data[n] + value);
                    ++i1;
                }
                ++i2;
            }
            ++i3;
        }
    }

    @Override
    public void decrement(short value) {
        int i3 = 0;
        while (i3 < this.dim3) {
            int j3 = this.idx3[i3];
            int i2 = 0;
            while (i2 < this.dim2) {
                int j2 = this.idx2[i2] + j3;
                int i1 = 0;
                while (i1 < this.dim1) {
                    int j1;
                    int n = j1 = this.idx1[i1] + j2;
                    this.data[n] = (short)(this.data[n] - value);
                    ++i1;
                }
                ++i2;
            }
            ++i3;
        }
    }

    @Override
    public void scale(short value) {
        int i3 = 0;
        while (i3 < this.dim3) {
            int j3 = this.idx3[i3];
            int i2 = 0;
            while (i2 < this.dim2) {
                int j2 = this.idx2[i2] + j3;
                int i1 = 0;
                while (i1 < this.dim1) {
                    int j1;
                    int n = j1 = this.idx1[i1] + j2;
                    this.data[n] = (short)(this.data[n] * value);
                    ++i1;
                }
                ++i2;
            }
            ++i3;
        }
    }

    @Override
    public void map(ShortFunction function) {
        int i3 = 0;
        while (i3 < this.dim3) {
            int j3 = this.idx3[i3];
            int i2 = 0;
            while (i2 < this.dim2) {
                int j2 = this.idx2[i2] + j3;
                int i1 = 0;
                while (i1 < this.dim1) {
                    int j1 = this.idx1[i1] + j2;
                    this.data[j1] = function.apply(this.data[j1]);
                    ++i1;
                }
                ++i2;
            }
            ++i3;
        }
    }

    @Override
    public void scan(ShortScanner scanner) {
        boolean initialized = false;
        int i3 = 0;
        while (i3 < this.dim3) {
            int j3 = this.idx3[i3];
            int i2 = 0;
            while (i2 < this.dim2) {
                int j2 = this.idx2[i2] + j3;
                int i1 = 0;
                while (i1 < this.dim1) {
                    int j1 = this.idx1[i1] + j2;
                    if (initialized) {
                        scanner.update(this.data[j1]);
                    } else {
                        scanner.initialize(this.data[j1]);
                        initialized = true;
                    }
                    ++i1;
                }
                ++i2;
            }
            ++i3;
        }
    }

    @Override
    public short[] flatten(boolean forceCopy) {
        short[] out = new short[this.number];
        int j = -1;
        int i3 = 0;
        while (i3 < this.dim3) {
            int j3 = this.idx3[i3];
            int i2 = 0;
            while (i2 < this.dim2) {
                int j2 = this.idx2[i2] + j3;
                int i1 = 0;
                while (i1 < this.dim1) {
                    int j1 = this.idx1[i1] + j2;
                    out[++j] = this.data[j1];
                    ++i1;
                }
                ++i2;
            }
            ++i3;
        }
        return out;
    }

    @Override
    public Short2D slice(int idx) {
        int[] sliceIndex1;
        int sliceOffset = this.idx3[Helper.fixIndex(idx, this.dim3)];
        if (sliceOffset == 0) {
            sliceIndex1 = this.idx1;
        } else {
            sliceIndex1 = new int[this.dim1];
            int i = 0;
            while (i < this.dim1) {
                sliceIndex1[i] = this.idx1[i] + sliceOffset;
                ++i;
            }
        }
        return new SelectedShort2D(this.data, sliceIndex1, this.idx2);
    }

    @Override
    public Short2D slice(int idx, int dim) {
        int[] sliceIndex2;
        int[] sliceIndex1;
        int sliceOffset;
        if ((dim = Helper.fixSliceIndex(dim, 3)) == 0) {
            sliceOffset = this.idx1[Helper.fixIndex(idx, this.dim1)];
            sliceIndex1 = this.idx2;
            sliceIndex2 = this.idx3;
        } else if (dim == 1) {
            sliceIndex1 = this.idx1;
            sliceOffset = this.idx2[Helper.fixIndex(idx, this.dim2)];
            sliceIndex2 = this.idx3;
        } else {
            sliceIndex1 = this.idx1;
            sliceIndex2 = this.idx2;
            sliceOffset = this.idx3[Helper.fixIndex(idx, this.dim3)];
        }
        if (sliceOffset != 0) {
            int length = sliceIndex1.length;
            int[] tempIndex = new int[length];
            int i = 0;
            while (i < length) {
                tempIndex[i] = sliceOffset + sliceIndex1[i];
                ++i;
            }
            sliceIndex1 = tempIndex;
        }
        return new SelectedShort2D(this.data, sliceIndex1, sliceIndex2);
    }

    @Override
    public Short3D view(Range rng1, Range rng2, Range rng3) {
        int[] viewIndex1 = Helper.select(this.idx1, rng1);
        int[] viewIndex2 = Helper.select(this.idx2, rng2);
        int[] viewIndex3 = Helper.select(this.idx3, rng3);
        if (viewIndex1 == this.idx1 && viewIndex2 == this.idx2 && viewIndex3 == this.idx3) {
            return this;
        }
        return new SelectedShort3D(this.data, viewIndex1, viewIndex2, viewIndex3);
    }

    @Override
    public Short3D view(int[] sel1, int[] sel2, int[] sel3) {
        int[] viewIndex1 = Helper.select(this.idx1, sel1);
        int[] viewIndex2 = Helper.select(this.idx2, sel2);
        int[] viewIndex3 = Helper.select(this.idx3, sel3);
        if (viewIndex1 == this.idx1 && viewIndex2 == this.idx2 && viewIndex3 == this.idx3) {
            return this;
        }
        return new SelectedShort3D(this.data, viewIndex1, viewIndex2, viewIndex3);
    }

    @Override
    public Short1D as1D() {
        int[] idx = new int[this.number];
        int j = -1;
        int i3 = 0;
        while (i3 < this.dim3) {
            int j3 = this.idx3[i3];
            int i2 = 0;
            while (i2 < this.dim2) {
                int j2 = this.idx2[i2] + j3;
                int i1 = 0;
                while (i1 < this.dim1) {
                    int j1 = this.idx1[i1] + j2;
                    idx[++j] = j1;
                    ++i1;
                }
                ++i2;
            }
            ++i3;
        }
        return new SelectedShort1D(this.data, idx);
    }
}

