/*
 * Decompiled with CFR 0.152.
 */
package mitiv.base;

public class Shape {
    private final long number;
    private final int rank;
    private final int[] dims;
    private static final Shape scalarShape = new Shape(new int[0], true);

    public static Shape make() {
        return scalarShape;
    }

    public static Shape make(int[] dims) {
        if (dims == null || dims.length == 0) {
            return scalarShape;
        }
        return new Shape(dims, false);
    }

    public static Shape make(long[] dims) {
        if (dims == null || dims.length == 0) {
            return scalarShape;
        }
        return new Shape(dims);
    }

    public static Shape make(int dim1) {
        return new Shape(new int[]{dim1}, true);
    }

    public static Shape make(int dim1, int dim2) {
        return new Shape(new int[]{dim1, dim2}, true);
    }

    public static Shape make(int dim1, int dim2, int dim3) {
        return new Shape(new int[]{dim1, dim2, dim3}, true);
    }

    public static Shape make(int dim1, int dim2, int dim3, int dim4) {
        return new Shape(new int[]{dim1, dim2, dim3, dim4}, true);
    }

    public static Shape make(int dim1, int dim2, int dim3, int dim4, int dim5) {
        return new Shape(new int[]{dim1, dim2, dim3, dim4, dim5}, true);
    }

    public static Shape make(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6) {
        return new Shape(new int[]{dim1, dim2, dim3, dim4, dim5, dim6}, true);
    }

    public static Shape make(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7) {
        return new Shape(new int[]{dim1, dim2, dim3, dim4, dim5, dim6, dim7}, true);
    }

    public static Shape make(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8) {
        return new Shape(new int[]{dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8}, true);
    }

    public static Shape make(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8, int dim9) {
        return new Shape(new int[]{dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9}, true);
    }

    public final int rank() {
        return this.rank;
    }

    public final long number() {
        return this.number;
    }

    public final int dimension(int k) {
        return this.dims[k];
    }

    public final int[] copyDimensions() {
        if (this.rank == 0) {
            return this.dims;
        }
        int[] copy = new int[this.rank];
        int k = 0;
        while (k < this.rank) {
            copy[k] = this.dims[k];
            ++k;
        }
        return copy;
    }

    public final boolean equals(Shape other) {
        if (other != this && other.dims != this.dims) {
            if (this.rank != other.rank) {
                return false;
            }
            int k = 0;
            while (k < this.rank) {
                if (other.dims[k] != this.dims[k]) {
                    return false;
                }
                ++k;
            }
        }
        return true;
    }

    private Shape(int[] dims, boolean share) {
        long LONG_MAX = Long.MAX_VALUE;
        long number = 1L;
        this.rank = dims.length;
        if (share) {
            this.dims = dims;
            int k = 0;
            while (k < this.rank) {
                int dim = dims[k];
                if (dim < 1) {
                    Shape.dimensionTooSmall();
                }
                if ((long)dim > Long.MAX_VALUE / number) {
                    Shape.numberOverflow();
                }
                number *= (long)dim;
                ++k;
            }
        } else {
            this.dims = new int[this.rank];
            int k = 0;
            while (k < this.rank) {
                int dim = dims[k];
                if (dim < 1) {
                    Shape.dimensionTooSmall();
                }
                if ((long)dim > Long.MAX_VALUE / number) {
                    Shape.numberOverflow();
                }
                number *= (long)dim;
                this.dims[k] = dim;
                ++k;
            }
        }
        this.number = number;
    }

    private Shape(long[] dims) {
        long LONG_MAX = Long.MAX_VALUE;
        long INT_MAX = Integer.MAX_VALUE;
        long number = 1L;
        this.rank = dims.length;
        this.dims = new int[this.rank];
        int k = 0;
        while (k < this.rank) {
            long dim = dims[k];
            if (dim < 1L) {
                Shape.dimensionTooSmall();
            }
            if (dim > Integer.MAX_VALUE) {
                Shape.dimensionTooLarge();
            }
            if (dim > Long.MAX_VALUE / number) {
                Shape.numberOverflow();
            }
            number *= dim;
            this.dims[k] = (int)dim;
            ++k;
        }
        this.number = number;
    }

    private static void dimensionTooSmall() {
        throw new IllegalArgumentException("Dimensions must be at least 1.");
    }

    private static void dimensionTooLarge() {
        throw new IllegalArgumentException("Dimensions must be at most Integer.MAX_VALUE.");
    }

    private static void numberOverflow() {
        throw new IllegalArgumentException("Total number of elements is too large.");
    }
}

