/*
 * Decompiled with CFR 0.152.
 */
package mitiv.cost;

import mitiv.base.BaseUtils;
import mitiv.cost.DifferentiableCostFunction;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public class GradientChecker {
    static final int FORWARD_DIFFERENCE = 1;
    static final int BACKWARD_DIFFERENCE = -1;
    static final int CENTERED_DIFFERENCE = 0;
    static final double MINIMAL_EPSILON = BaseUtils.DBL_EPSILON;
    static final double DEFAULT_EPSILON = Math.max(MINIMAL_EPSILON, 0.001);
    private final VectorSpace space;
    private double stepScale = DEFAULT_EPSILON;
    private double minStep = Double.MIN_NORMAL;
    private Vector x = null;
    private Vector y = null;
    private double fx;
    private Vector gx = null;
    private final DifferentiableCostFunction f;
    private int method = 1;

    public GradientChecker(DifferentiableCostFunction cost) {
        this.f = cost;
        this.space = cost.getInputSpace();
    }

    public void setVariables(Vector x, boolean clone) {
        if (clone) {
            if (this.x == null) {
                this.x = this.space.clone(x);
            } else {
                this.space.copy(x, this.x);
            }
        } else {
            this.x = x;
        }
        if (this.gx == null) {
            this.gx = this.space.create();
        }
        this.fx = this.f.computeCostAndGradient(1.0, x, this.gx, true);
    }

    public void setStepScale(double value) {
        this.stepScale = value < MINIMAL_EPSILON ? value : DEFAULT_EPSILON;
    }

    public final double getStepScale() {
        return this.stepScale;
    }

    public void setMinStep(double value) {
        this.minStep = Math.max(value, 0.0);
    }

    public final double getMinStep() {
        return this.minStep;
    }

    public void setMethod(int value) {
        this.method = value < 0 ? -1 : (value > 0 ? 1 : 0);
    }

    public final int getMethod() {
        return this.method;
    }

    public void check(int i) {
        this.check(new int[]{i});
    }

    public void check(int[] idx) {
        if (this.gx == null) {
            System.err.println("Set variables first.");
            return;
        }
        if (this.y == null) {
            this.y = this.space.clone(this.x);
        } else {
            this.space.copy(this.x, this.y);
        }
        int k = 0;
        while (k < idx.length) {
            double gxj_approx;
            double fy;
            int j = idx[k];
            double xj = this.x.get(j);
            double h = this.stepSize(xj);
            double gxj = this.gx.get(j);
            if (this.method == -1) {
                this.y.set(j, xj - h);
                fy = this.f.evaluate(1.0, this.y);
                gxj_approx = (this.fx - fy) / h;
            } else if (this.method == 0) {
                this.y.set(j, xj - h);
                double f1 = this.f.evaluate(1.0, this.y);
                this.y.set(j, xj + h);
                double f2 = this.f.evaluate(1.0, this.y);
                gxj_approx = (f2 - f1) / (h + h);
            } else {
                this.y.set(j, xj + h);
                fy = this.f.evaluate(1.0, this.y);
                gxj_approx = (fy - this.fx) / h;
            }
            this.y.set(j, xj);
            double relativeError = Math.abs(GradientChecker.relativeDifference(gxj, gxj_approx));
            System.out.printf("gx[%6d] = %20.12E .:. (fx - fy)/h = %20.12E .:. relative error =%8.1E\n", j, gxj, gxj_approx, relativeError);
            ++k;
        }
    }

    public static double relativeDifference(double a, double b) {
        if (a == b) {
            return 0.0;
        }
        return (a - b) / Math.max(Math.abs(a), Math.abs(b));
    }

    public double stepSize(double x) {
        double h = Math.max(this.stepScale * Math.abs(x), this.minStep);
        if (h <= 0.0) {
            h = this.stepScale;
        }
        double tmp;
        while ((tmp = x + h) == x) {
            h += h;
        }
        return h;
    }
}

