/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv;

import mitiv.base.Shape;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVector;

public class Filter {
    int width;
    int height;
    int sizeZ;
    double cc;
    double[] psfFFT1D;
    double[] imgFFT1D;
    double[] tabcc1D;
    double coef;
    ShapedVector image;

    public double[] wiener1D(double alpha, double[] psfFFT, double[] imageFFT, int width, int height) {
        this.psfFFT1D = psfFFT;
        this.imgFFT1D = imageFFT;
        this.width = width;
        this.height = height;
        this.cc = this.psfFFT1D[0] * this.psfFFT1D[0] + this.psfFFT1D[2 * width] * this.psfFFT1D[2 * width];
        return this.wiener1D(alpha);
    }

    public double[] wiener1D(double alpha) {
        double[] out = new double[this.width * 2 * this.height];
        int i = 0;
        while (i < this.width * this.height) {
            int pos = 2 * i;
            double a = this.psfFFT1D[pos];
            double b = this.psfFFT1D[pos + 1];
            double c = this.imgFFT1D[pos];
            double d = this.imgFFT1D[pos + 1];
            double q = 1.0 / (a * a + b * b + this.cc * alpha);
            out[pos] = (a * c + b * d) * q;
            out[pos + 1] = (a * d - b * c) * q;
            ++i;
        }
        return out;
    }

    public double[] wiener3D(double alpha, double[] psfFFT, double[] imageFFT, double[] weight, int width, int height, int sizeZ, double coef) {
        this.psfFFT1D = psfFFT;
        this.imgFFT1D = imageFFT;
        this.width = height;
        this.height = width;
        this.sizeZ = sizeZ;
        this.coef = coef;
        this.cc = this.psfFFT1D[0] * this.psfFFT1D[0];
        return this.wiener3D(alpha);
    }

    public double[] wiener3D(double alpha) {
        double[] out = new double[2 * this.sizeZ * this.width * this.height];
        int i = 0;
        while (i < this.sizeZ * this.width * this.height) {
            int pos = 2 * i;
            double a = this.psfFFT1D[pos];
            double b = this.psfFFT1D[pos + 1];
            double c = this.imgFFT1D[pos];
            double d = this.imgFFT1D[pos + 1];
            double q = 1.0 / (a * a + b * b + this.cc * alpha);
            out[pos] = (a * c + b * d) * q;
            out[pos + 1] = (a * d - b * c) * q;
            ++i;
        }
        return out;
    }

    public DoubleShapedVector wiener3D(DoubleShapedVector FFT_PSF, DoubleShapedVector FFT_Image, double alpha) {
        Shape shape = FFT_PSF.getShape();
        this.psfFFT1D = FFT_PSF.getData();
        this.imgFFT1D = FFT_Image.getData();
        this.image = FFT_Image;
        this.width = shape.dimension(0);
        this.height = shape.dimension(1);
        this.sizeZ = shape.dimension(2);
        this.cc = this.psfFFT1D[0] * this.psfFFT1D[0];
        return this.wiener3Dvect(alpha);
    }

    public DoubleShapedVector wiener3Dvect(double alpha) {
        DoubleShapedVector vectOut = (DoubleShapedVector)this.image.getSpace().create();
        double[] out = vectOut.getData();
        int i = 0;
        while (i < this.sizeZ * this.width * this.height / 2) {
            int pos = 2 * i;
            double a = this.psfFFT1D[pos];
            double b = this.psfFFT1D[pos + 1];
            double c = this.imgFFT1D[pos];
            double d = this.imgFFT1D[pos + 1];
            double q = 1.0 / (a * a + b * b + this.cc * alpha);
            out[pos] = (a * c + b * d) * q;
            out[pos + 1] = (a * d - b * c) * q;
            ++i;
        }
        return vectOut;
    }

    public ShapedVector wienerVect(double alpha, ShapedVector PSF, ShapedVector image) {
        this.image = image;
        Shape shape = ((DoubleShapedVectorSpace)image.getSpace()).getShape();
        double[] out = this.wiener1D(alpha, ((DoubleShapedVector)PSF).getData(), ((DoubleShapedVector)image).getData(), shape.dimension(1), shape.dimension(0) / 2);
        return ((DoubleShapedVectorSpace)image.getSpace()).wrap(out);
    }

    public ShapedVector wienerVect(double alpha) {
        double[] out = this.wiener1D(alpha);
        return ((DoubleShapedVectorSpace)this.image.getSpace()).wrap(out);
    }

    public double[] wienerQuad1D(double alpha, double[] psfFFT, double[] imageFFT, int width, int height) {
        this.psfFFT1D = psfFFT;
        this.imgFFT1D = imageFFT;
        this.width = width;
        this.height = height;
        this.tabcc1D = new double[width * height];
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                double e = j <= height / 2 ? (double)j / (double)height : (double)(j - height) / (double)height;
                double f = i <= width / 2 ? (double)i / (double)width : (double)(i - width) / (double)width;
                this.tabcc1D[i + j * width] = 39.47841760435743 * (e * e + f * f);
                ++i;
            }
            ++j;
        }
        return this.wienerQuad1D(alpha);
    }

    public double[] wienerQuad1D(double alpha) {
        double[] out = new double[this.width * 2 * this.height];
        int j = 0;
        while (j < this.height) {
            int i = 0;
            while (i < this.width) {
                double a = this.psfFFT1D[2 * i + 2 * j * this.width];
                double b = this.psfFFT1D[2 * i + 1 + 2 * j * this.width];
                double c = this.imgFFT1D[2 * i + 2 * j * this.width];
                double d = this.imgFFT1D[2 * i + 1 + 2 * j * this.width];
                double q = 1.0 / (a * a + b * b + this.tabcc1D[i + j * this.width] * alpha);
                out[2 * i + 2 * j * this.width] = (a * c + b * d) * q;
                out[2 * i + 1 + 2 * j * this.width] = (a * d - b * c) * q;
                ++i;
            }
            ++j;
        }
        return out;
    }

    public double[] wienerQuad3D(double alpha, double[] psfFFT, double[] imageFFT, int width, int height, int sizeZ, int sizePading) {
        this.psfFFT1D = psfFFT;
        this.imgFFT1D = imageFFT;
        this.width = width;
        this.height = height;
        this.sizeZ = sizeZ;
        this.tabcc1D = new double[width * height];
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                double e = j <= height / 2 ? (double)j / (double)height : (double)(j - height) / (double)height;
                double f = i <= width / 2 ? (double)i / (double)width : (double)(i - width) / (double)width;
                this.tabcc1D[i + j * width] = 39.47841760435743 * (e * e + f * f);
                ++i;
            }
            ++j;
        }
        return this.wienerQuad3D(alpha);
    }

    public double[] wienerQuad3D(double alpha) {
        double[] out = new double[this.sizeZ * this.width * 2 * this.height];
        int j = 0;
        while (j < this.sizeZ) {
            int i = 0;
            while (i < this.width * this.height) {
                double a = this.psfFFT1D[2 * i + j * this.width * this.height * 2];
                double b = this.psfFFT1D[2 * i + 1 + j * this.width * this.height * 2];
                double c = this.imgFFT1D[2 * i + j * this.width * this.height * 2];
                double d = this.imgFFT1D[2 * i + 1 + j * this.width * this.height * 2];
                double q = 1.0 / (a * a + b * b + this.tabcc1D[i] * alpha);
                out[2 * i + j * this.width * this.height * 2] = (a * c + b * d) * q;
                out[2 * i + 1 + j * this.width * this.height * 2] = (a * d - b * c) * q;
                ++i;
            }
            ++j;
        }
        return out;
    }

    public ShapedVector wienerQuadVect(double alpha, ShapedVector PSF, ShapedVector image) {
        this.image = image;
        Shape shape = ((DoubleShapedVectorSpace)image.getSpace()).getShape();
        double[] out = this.wienerQuad1D(alpha, ((DoubleShapedVector)PSF).getData(), ((DoubleShapedVector)image).getData(), shape.dimension(1), shape.dimension(0) / 2);
        return ((DoubleShapedVectorSpace)image.getSpace()).wrap(out);
    }

    public ShapedVector wienerQuadVect(double alpha) {
        double[] out = this.wienerQuad1D(alpha);
        return ((DoubleShapedVectorSpace)this.image.getSpace()).wrap(out);
    }
}

