/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv;

import mitiv.exception.IllegalLinearOperationException;
import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.LinearOperator;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;

public class WeightingOperator
extends LinearOperator {
    Vector weight;

    public WeightingOperator(Vector weight) {
        super(weight.getSpace());
        this.weight = weight;
    }

    @Override
    protected void privApply(Vector src, Vector dst, int job) throws IncorrectSpaceException {
        int n = this.inputSpace.getNumber();
        DoubleShapedVector vectSrc = (DoubleShapedVector)src;
        DoubleShapedVector vectDst = (DoubleShapedVector)dst;
        DoubleShapedVector vectW = (DoubleShapedVector)this.weight;
        if (job == INVERSE) {
            int i = 0;
            while (i < n) {
                vectDst.set(i, vectSrc.get(i) / vectW.get(i));
                ++i;
            }
        } else if (job == DIRECT) {
            int i = 0;
            while (i < n) {
                vectDst.set(i, vectSrc.get(i) * vectW.get(i));
                ++i;
            }
        } else {
            throw new IllegalLinearOperationException("This job is not possible");
        }
    }

    public Vector getWeight() {
        return this.weight;
    }
}

