/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv.impl;

import mitiv.array.ShapedArray;
import mitiv.deconv.impl.ConvolutionDouble1D;
import mitiv.deconv.impl.WeightedConvolutionDouble;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;

public class WeightedConvolutionDouble1D
extends WeightedConvolutionDouble {
    private final double scale;
    private final int number;
    private final int dim1;
    private final int off1;
    private final int end1;
    private final ConvolutionDouble1D cnvl;

    public WeightedConvolutionDouble1D(ShapedVectorSpace objectSpace, ShapedVectorSpace dataSpace, int[] dataOffset) {
        super(objectSpace, dataSpace);
        if (objectSpace.getRank() != 1) {
            throw new IllegalArgumentException("Object space is not 1D");
        }
        if (dataSpace.getRank() != 1) {
            throw new IllegalArgumentException("Data space is not 1D");
        }
        this.number = objectSpace.getNumber();
        this.scale = 1.0 / (double)this.number;
        this.dim1 = objectSpace.getDimension(0);
        this.off1 = dataOffset[0];
        this.end1 = this.off1 + dataSpace.getDimension(0);
        if (this.off1 < 0 || this.off1 >= this.dim1) {
            throw new IllegalArgumentException("Out of range offset along 1st dimension.");
        }
        if (this.end1 > this.dim1) {
            throw new IllegalArgumentException("Data (+ offset) beyond 1st dimension.");
        }
        this.cnvl = new ConvolutionDouble1D(objectSpace);
    }

    @Override
    protected double cost(double alpha, Vector x) {
        this.checkData();
        this.cnvl.push(((DoubleShapedVector)x).getData());
        this.cnvl.convolve(false);
        double sum = 0.0;
        double[] z = this.cnvl.getWorkspace();
        int j = 0;
        int real = 0;
        if (this.wgt == null) {
            int i1 = 0;
            while (i1 < this.dim1) {
                if (this.off1 <= i1 && i1 < this.end1) {
                    double r = this.scale * z[real] - this.dat[j];
                    sum += r * r;
                    ++j;
                }
                real += 2;
                ++i1;
            }
        } else {
            int i1 = 0;
            while (i1 < this.dim1) {
                if (this.off1 <= i1 && i1 < this.end1) {
                    double d;
                    double w = this.wgt[j];
                    if (d > 0.0) {
                        double r = this.scale * z[real] - this.dat[j];
                        sum += w * r * r;
                    }
                    ++j;
                }
                real += 2;
                ++i1;
            }
        }
        return alpha * sum;
    }

    @Override
    protected double cost(double alpha, Vector x, Vector gx, boolean clr) {
        this.checkData();
        this.cnvl.push(((DoubleShapedVector)x).getData());
        this.cnvl.convolve(false);
        double q = 2.0 * this.scale * alpha;
        double sum = 0.0;
        double[] z = this.cnvl.getWorkspace();
        int j = 0;
        int real = 0;
        int imag = 1;
        if (this.wgt == null) {
            int i1 = 0;
            while (i1 < this.dim1) {
                if (this.off1 <= i1 && i1 < this.end1) {
                    double r = this.scale * z[real] - this.dat[j];
                    sum += r * r;
                    z[real] = q * r;
                    z[imag] = 0.0;
                    ++j;
                } else {
                    z[real] = 0.0;
                    z[imag] = 0.0;
                }
                real += 2;
                imag += 2;
                ++i1;
            }
        } else {
            int i1 = 0;
            while (i1 < this.dim1) {
                if (this.off1 <= i1 && i1 < this.end1) {
                    double d;
                    double w = this.wgt[j];
                    if (d > 0.0) {
                        double r = this.scale * z[real] - this.dat[j];
                        double wr = w * r;
                        sum += wr * r;
                        z[real] = q * wr;
                    } else {
                        z[real] = 0.0;
                    }
                    z[imag] = 0.0;
                    ++j;
                } else {
                    z[real] = 0.0;
                    z[imag] = 0.0;
                }
                real += 2;
                imag += 2;
                ++i1;
            }
        }
        double[] g = ((DoubleShapedVector)gx).getData();
        this.cnvl.convolve(true);
        real = 0;
        if (clr) {
            int k = 0;
            while (k < this.number) {
                g[k] = z[real];
                ++k;
                real += 2;
            }
        } else {
            int k = 0;
            while (k < this.number) {
                int n = k++;
                g[n] = g[n] + z[real];
                real += 2;
            }
        }
        return alpha * sum;
    }

    @Override
    public void setPSF(ShapedArray psf, int[] off) {
        this.cnvl.setPSF(psf, off);
    }

    @Override
    public void setPSF(ShapedVector psf) {
        this.cnvl.setPSF(psf);
    }
}

