/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv.impl;

import mitiv.array.ShapedArray;
import mitiv.deconv.WeightedConvolutionCost;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;

public abstract class WeightedConvolutionFloat
extends WeightedConvolutionCost {
    protected float[] dat = null;
    protected float[] wgt = null;

    public WeightedConvolutionFloat(ShapedVectorSpace objectSpace, ShapedVectorSpace dataSpace) {
        super(objectSpace, dataSpace);
        if (objectSpace.getType() != 4) {
            throw new IllegalArgumentException("Object space must be for float data type");
        }
        if (dataSpace.getType() != 4) {
            throw new IllegalArgumentException("Data space must be for float data type");
        }
    }

    @Override
    public void setWeightsAndData(ShapedVector weight, ShapedVector data) {
        if (data == null || !data.belongsTo(this.dataSpace)) {
            throw new IllegalArgumentException("Data must belong to the data space.");
        }
        if (weight == null) {
            this.setWeightsAndData(((FloatShapedVector)data).getData());
        } else if (weight.belongsTo(this.dataSpace)) {
            this.setWeightsAndData(((FloatShapedVector)weight).getData(), ((FloatShapedVector)data).getData());
        } else {
            throw new IllegalArgumentException("Weights must belong to the data space.");
        }
    }

    @Override
    public void setWeightsAndData(ShapedArray weight, ShapedArray data) {
        if (data == null || !this.dataSpace.getShape().equals(data.getShape())) {
            throw new IllegalArgumentException("Data must have the same shape as the vectors of the data space.");
        }
        if (weight == null) {
            this.setWeightsAndData(data.toFloat().flatten(false));
        } else if (this.dataSpace.getShape().equals(data.getShape())) {
            this.setWeightsAndData(weight.toFloat().flatten(false), data.toFloat().flatten(false));
        } else {
            throw new IllegalArgumentException("Weights must have the same shape as the vectors of the data space.");
        }
    }

    private void setWeightsAndData(float[] data) {
        this.wgt = null;
        this.dat = data;
    }

    private void setWeightsAndData(float[] weight, float[] data) {
        int n = weight.length;
        int k = 0;
        while (k < n) {
            float w = weight[k];
            if (Float.isNaN(w) || Float.isInfinite(w) || w < 0.0f) {
                WeightedConvolutionFloat.badWeights();
            }
            ++k;
        }
        this.wgt = weight;
        this.dat = data;
    }

    protected void checkData() {
        if (this.dat == null) {
            throw new IllegalArgumentException("You must set the data (and the weights) first.");
        }
    }
}

