/*
 * Decompiled with CFR 0.152.
 */
package mitiv.invpb;

import mitiv.base.Shape;
import mitiv.deconv.ConvolutionOperator;
import mitiv.exception.NotImplementedException;
import mitiv.invpb.LeftHandSideMatrix;
import mitiv.linalg.ArrayOps;
import mitiv.linalg.IdentityOperator;
import mitiv.linalg.LinearConjugateGradient;
import mitiv.linalg.LinearOperator;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.FloatShapedVectorSpace;
import mitiv.linalg.shaped.RealComplexFFT;
import mitiv.linalg.shaped.ShapedVectorSpace;

public class LinearDeconvolver {
    private int rank;
    private final Vector h;
    private Vector q;
    private final Vector w;
    private final Vector y;
    private Vector z;
    private Vector b;
    private LinearOperator H;
    private LinearOperator W;
    private LinearOperator Q;
    private LeftHandSideMatrix A;
    private final RealComplexFFT FFT;
    private LinearConjugateGradient cg;
    private double muFactor = 1.0;
    private final boolean single;

    public LinearDeconvolver(Shape shape, float[] data, float[] psf, float[] wgt, double mu) {
        FloatShapedVectorSpace space = new FloatShapedVectorSpace(shape);
        this.y = space.wrap(data);
        this.h = space.wrap(psf);
        this.w = wgt == null ? null : space.wrap(wgt);
        this.FFT = new RealComplexFFT(space);
        this.single = true;
        this.setup(shape, mu);
    }

    public LinearDeconvolver(Shape shape, double[] data, double[] psf, double[] wgt, double mu) {
        DoubleShapedVectorSpace space = new DoubleShapedVectorSpace(shape);
        this.y = space.wrap(data);
        this.h = space.wrap(psf);
        this.w = wgt == null ? null : space.wrap(wgt);
        this.FFT = new RealComplexFFT(space);
        this.single = false;
        this.setup(shape, mu);
    }

    private void setup(Shape shape, double mu) {
        this.rank = shape.rank();
        if (this.rank > 3) {
            throw new IllegalArgumentException("Too many dimensions.");
        }
        ShapedVectorSpace space = this.FFT.getInputSpace();
        this.z = this.FFT.getOutputSpace().create();
        this.q = space.create();
        if (this.single) {
            LinearDeconvolver.generateIsotropicQ(shape, ((FloatShapedVector)this.q).getData());
            this.Q = new LinearOperator((VectorSpace)space){

                @Override
                protected void privApply(Vector src, Vector dst, int job) {
                    if (job != DIRECT && job != ADJOINT) {
                        throw new NotImplementedException();
                    }
                    LinearDeconvolver.this.FFT.apply(src, LinearDeconvolver.this.z, DIRECT);
                    LinearDeconvolver.multiplyByQ(((FloatShapedVector)LinearDeconvolver.this.q).getData(), ((FloatShapedVector)LinearDeconvolver.this.z).getData());
                    LinearDeconvolver.this.FFT.apply(LinearDeconvolver.this.z, dst, INVERSE);
                }
            };
        } else {
            LinearDeconvolver.generateIsotropicQ(shape, ((DoubleShapedVector)this.q).getData());
            this.Q = new LinearOperator((VectorSpace)space){

                @Override
                protected void privApply(Vector src, Vector dst, int job) {
                    if (job != DIRECT && job != ADJOINT) {
                        throw new NotImplementedException();
                    }
                    LinearDeconvolver.this.FFT.apply(src, LinearDeconvolver.this.z, DIRECT);
                    LinearDeconvolver.multiplyByQ(((DoubleShapedVector)LinearDeconvolver.this.q).getData(), ((DoubleShapedVector)LinearDeconvolver.this.z).getData());
                    LinearDeconvolver.this.FFT.apply(LinearDeconvolver.this.z, dst, INVERSE);
                }
            };
        }
        this.H = new ConvolutionOperator(this.FFT, this.h);
        if (this.w == null) {
            this.muFactor = 1.0;
            this.W = new IdentityOperator(this.H.getOutputSpace());
        } else {
            double wMax;
            double wMin;
            if (this.single) {
                float[] wMinMax = ArrayOps.getMinMax(((FloatShapedVector)this.w).getData());
                wMin = wMinMax[0];
                wMax = wMinMax[1];
            } else {
                double[] wMinMax = ArrayOps.getMinMax(((DoubleShapedVector)this.w).getData());
                wMin = wMinMax[0];
                wMax = wMinMax[1];
            }
            if (wMin < 0.0) {
                throw new IllegalArgumentException("Weights must be non-negative.");
            }
            if (wMax <= 0.0) {
                throw new IllegalArgumentException("All weights are zero.");
            }
            if (wMin == wMax) {
                this.muFactor = 1.0 / wMax;
                this.W = new IdentityOperator(this.H.getOutputSpace());
            } else {
                this.muFactor = 1.0;
                this.W = this.single ? new LinearOperator((VectorSpace)space){

                    @Override
                    protected void privApply(Vector src, Vector dst, int job) {
                        if (job != DIRECT && job != ADJOINT) {
                            throw new NotImplementedException();
                        }
                        LinearDeconvolver.multiplyByW(((FloatShapedVector)LinearDeconvolver.this.w).getData(), ((FloatShapedVector)src).getData(), ((FloatShapedVector)dst).getData());
                    }
                } : new LinearOperator((VectorSpace)space){

                    @Override
                    protected void privApply(Vector src, Vector dst, int job) {
                        if (job != DIRECT && job != ADJOINT) {
                            throw new NotImplementedException();
                        }
                        LinearDeconvolver.multiplyByW(((DoubleShapedVector)LinearDeconvolver.this.w).getData(), ((DoubleShapedVector)src).getData(), ((DoubleShapedVector)dst).getData());
                    }
                };
            }
        }
        if (mu < 0.0) {
            throw new IllegalArgumentException("Regularization weight must be non-negative.");
        }
        this.A = new LeftHandSideMatrix(this.H, this.W, this.Q, mu *= this.muFactor);
        this.b = this.A.getOutputSpace().create();
        this.A.computeRightHandSideVector(this.y, this.b);
        this.cg = new LinearConjugateGradient(this.A, this.b);
    }

    private static void multiplyByQ(double[] q, double[] z) {
        int size = q.length;
        int k = 0;
        while (k < size) {
            int n = 2 * k;
            z[n] = z[n] * q[k];
            int n2 = 2 * k + 1;
            z[n2] = z[n2] * q[k];
            ++k;
        }
    }

    private static void multiplyByQ(float[] q, float[] z) {
        int size = q.length;
        int k = 0;
        while (k < size) {
            int n = 2 * k;
            z[n] = z[n] * q[k];
            int n2 = 2 * k + 1;
            z[n2] = z[n2] * q[k];
            ++k;
        }
    }

    private static void multiplyByW(double[] w, double[] x, double[] y) {
        int n = w.length;
        int j = 0;
        while (j < n) {
            y[j] = w[j] * x[j];
            ++j;
        }
    }

    private static void multiplyByW(float[] w, float[] x, float[] y) {
        int n = w.length;
        int j = 0;
        while (j < n) {
            y[j] = w[j] * x[j];
            ++j;
        }
    }

    private static double[] generateFrequency(double s, int length) {
        double[] u = new double[length];
        int k0 = length / 2;
        int k = 0;
        while (k <= k0) {
            u[k] = s * (double)k;
            ++k;
        }
        k = k0 + 1;
        while (k < length) {
            u[k] = s * (double)(k - length);
            ++k;
        }
        return u;
    }

    private static void generateIsotropicQ(Shape shape, float[] q) {
        int n = q.length;
        double[] qTemp = new double[n];
        LinearDeconvolver.generateIsotropicQ(shape, qTemp);
        int j = 0;
        while (j < n) {
            q[j] = (float)qTemp[j];
            ++j;
        }
    }

    private static void generateIsotropicQ(Shape shape, double[] q) {
        int n1;
        int rank = shape.rank();
        double[][] u = new double[rank][];
        int r = 0;
        while (r < rank) {
            double[] t = LinearDeconvolver.generateFrequency(Math.PI * 2 / (double)shape.dimension(r), shape.dimension(r));
            int k = 0;
            while (k < t.length) {
                t[k] = t[k] * t[k];
                ++k;
            }
            u[r] = t;
            ++r;
        }
        if (rank == 1) {
            n1 = shape.dimension(0);
            double[] u1 = u[0];
            int k1 = 0;
            while (k1 < n1) {
                q[k1] = u1[k1];
                ++k1;
            }
        } else if (rank == 2) {
            n1 = shape.dimension(0);
            int n2 = shape.dimension(1);
            double[] u1 = u[0];
            double[] u2 = u[1];
            int k2 = 0;
            while (k2 < n2) {
                int k1 = 0;
                while (k1 < n1) {
                    q[k1 + n1 * k2] = u1[k1] + u2[k2];
                    ++k1;
                }
                ++k2;
            }
        } else {
            n1 = shape.dimension(0);
            int n2 = shape.dimension(1);
            int n3 = shape.dimension(2);
            double[] u1 = u[0];
            double[] u2 = u[1];
            double[] u3 = u[2];
            int k3 = 0;
            while (k3 < n3) {
                int k2 = 0;
                while (k2 < n2) {
                    int k1 = 0;
                    while (k1 < n1) {
                        q[k1 + n1 * k2 + n1 * n2 * k3] = u1[k1] + u2[k2] + u3[k3];
                        ++k1;
                    }
                    ++k2;
                }
                ++k3;
            }
        }
    }

    public double getMu() {
        return this.A.getMu() / this.muFactor;
    }

    public void setMu(double mu) {
        this.A.setMu(mu * this.muFactor);
    }

    public int solve(float[] x, int maxiter, boolean reset) {
        if (!this.single) {
            throw new IllegalArgumentException("Expecting a single precision floating point array.");
        }
        return this.solve(((FloatShapedVectorSpace)this.A.getInputSpace()).wrap(x), maxiter, reset);
    }

    public int solve(double[] x, int maxiter, boolean reset) {
        if (this.single) {
            throw new IllegalArgumentException("Expecting a double precision floating point array.");
        }
        return this.solve(((DoubleShapedVectorSpace)this.A.getInputSpace()).wrap(x), maxiter, reset);
    }

    public int solve(Vector x, int maxiter, boolean reset) {
        return this.cg.solve(x, maxiter, reset);
    }
}

