/*
 * Decompiled with CFR 0.152.
 */
package mitiv.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.WritableByteChannel;
import mitiv.io.InternalBuffer;

public class BufferedOutputDataStream
extends InternalBuffer {
    private final WritableByteChannel channel;
    private boolean writable;

    BufferedOutputDataStream(FileOutputStream file, int capacity) {
        super(capacity);
        this.buffer.clear();
        this.channel = file.getChannel();
        this.writable = true;
    }

    BufferedOutputDataStream(FileOutputStream file) {
        this(file, 0);
    }

    public void close() throws IOException {
        this.flush();
        this.channel.close();
        this.writable = false;
    }

    public void flush() throws IOException {
        if (this.writable && this.buffer.position() > 0) {
            try {
                this.buffer.flip();
                do {
                    this.channel.write(this.buffer);
                } while (this.buffer.hasRemaining());
            }
            finally {
                this.buffer.compact();
            }
        }
    }

    public void writeByte(byte value) throws IOException {
        if (this.buffer.remaining() < 1) {
            this.flush();
        }
        this.buffer.put(value);
    }

    public void writeShort(short value) throws IOException {
        if (this.buffer.remaining() < 2) {
            this.flush();
        }
        this.buffer.putShort(value);
    }

    public void writeInt(int value) throws IOException {
        if (this.buffer.remaining() < 4) {
            this.flush();
        }
        this.buffer.putInt(value);
    }

    public void writeLong(long value) throws IOException {
        if (this.buffer.remaining() < 8) {
            this.flush();
        }
        this.buffer.putLong(value);
    }

    public void writeFloat(float value) throws IOException {
        if (this.buffer.remaining() < 4) {
            this.flush();
        }
        this.buffer.putFloat(value);
    }

    public void writeDouble(double value) throws IOException {
        if (this.buffer.remaining() < 8) {
            this.flush();
        }
        this.buffer.putDouble(value);
    }

    public int write(byte[] arr, int offset, int number) throws IOException {
        if (offset < 0 || number <= 0) {
            return 0;
        }
        if (this.buffer.remaining() < 1) {
            this.flush();
        }
        int start = offset;
        while (true) {
            int chunk = Math.min(number, this.buffer.remaining());
            this.buffer.put(arr, offset, chunk);
            offset += chunk;
            if ((number -= chunk) <= 0) break;
            this.flush();
        }
        return offset - start;
    }

    public int write(short[] arr, int offset, int number) throws IOException {
        if (offset < 0 || number <= 0) {
            return 0;
        }
        int elemSize = 2;
        if (this.buffer.remaining() < 2) {
            this.flush();
        }
        int start = offset;
        while (true) {
            ShortBuffer buf = this.buffer.asShortBuffer();
            int chunk = Math.min(number, buf.remaining());
            buf.put(arr, offset, chunk);
            this.buffer.position(this.buffer.position() + 2 * chunk);
            offset += chunk;
            if ((number -= chunk) <= 0) break;
            this.flush();
        }
        return offset - start;
    }

    public int write(int[] arr, int offset, int number) throws IOException {
        if (offset < 0 || number <= 0) {
            return 0;
        }
        int elemSize = 4;
        if (this.buffer.remaining() < 4) {
            this.flush();
        }
        int start = offset;
        while (true) {
            IntBuffer buf = this.buffer.asIntBuffer();
            int chunk = Math.min(number, buf.remaining());
            buf.put(arr, offset, chunk);
            this.buffer.position(this.buffer.position() + 4 * chunk);
            offset += chunk;
            if ((number -= chunk) <= 0) break;
            this.flush();
        }
        return offset - start;
    }

    public int write(long[] arr, int offset, int number) throws IOException {
        if (offset < 0 || number <= 0) {
            return 0;
        }
        int elemSize = 8;
        if (this.buffer.remaining() < 8) {
            this.flush();
        }
        int start = offset;
        while (true) {
            LongBuffer buf = this.buffer.asLongBuffer();
            int chunk = Math.min(number, buf.remaining());
            buf.put(arr, offset, chunk);
            this.buffer.position(this.buffer.position() + 8 * chunk);
            offset += chunk;
            if ((number -= chunk) <= 0) break;
            this.flush();
        }
        return offset - start;
    }

    public int write(float[] arr, int offset, int number) throws IOException {
        if (offset < 0 || number <= 0) {
            return 0;
        }
        int elemSize = 4;
        if (this.buffer.remaining() < 4) {
            this.flush();
        }
        int start = offset;
        while (true) {
            FloatBuffer buf = this.buffer.asFloatBuffer();
            int chunk = Math.min(number, buf.remaining());
            buf.put(arr, offset, chunk);
            this.buffer.position(this.buffer.position() + 4 * chunk);
            offset += chunk;
            if ((number -= chunk) <= 0) break;
            this.flush();
        }
        return offset - start;
    }

    public int write(double[] arr, int offset, int number) throws IOException {
        if (offset < 0 || number <= 0) {
            return 0;
        }
        int elemSize = 8;
        if (this.buffer.remaining() < 8) {
            this.flush();
        }
        int start = offset;
        while (true) {
            DoubleBuffer buf = this.buffer.asDoubleBuffer();
            int chunk = Math.min(number, buf.remaining());
            buf.put(arr, offset, chunk);
            this.buffer.position(this.buffer.position() + 8 * chunk);
            offset += chunk;
            if ((number -= chunk) <= 0) break;
            this.flush();
        }
        return offset - start;
    }
}

