/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import mitiv.exception.NotImplementedException;
import mitiv.linalg.LinearOperator;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public class ScaleOperator
extends LinearOperator {
    protected double scale = 1.0;

    public ScaleOperator(VectorSpace vsp) {
        super(vsp);
    }

    public ScaleOperator(VectorSpace vsp, double alpha) {
        super(vsp);
        this.scale = alpha;
    }

    @Override
    protected void privApply(Vector src, Vector dst, int job) {
        if (job == DIRECT || job == ADJOINT) {
            if (this.scale == 0.0) {
                this.outputSpace.zero(dst);
            } else if (dst == src) {
                if (this.scale != 1.0) {
                    this.outputSpace.axpby(0.0, src, this.scale, dst);
                }
            } else if (this.scale != 1.0) {
                this.outputSpace.axpby(this.scale, src, 0.0, dst);
            } else {
                this.outputSpace.copy(src, dst);
            }
        } else {
            throw new NotImplementedException();
        }
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double alpha) {
        this.scale = alpha;
    }
}

