/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.VectorSpace;

public abstract class Vector {
    protected final VectorSpace space;
    protected final int number;

    protected Vector(VectorSpace owner) {
        this.space = owner;
        this.number = owner.number;
    }

    public VectorSpace getOwner() {
        return this.space;
    }

    public final int getNumber() {
        return this.number;
    }

    public final int length() {
        return this.number;
    }

    public VectorSpace getSpace() {
        return this.space;
    }

    public boolean belongsTo(VectorSpace space) {
        return this.space == space;
    }

    public void assertBelongsTo(VectorSpace space) throws IncorrectSpaceException {
        if (!this.belongsTo(space)) {
            throw new IncorrectSpaceException();
        }
    }

    public abstract double get(int var1) throws IndexOutOfBoundsException;

    public abstract void set(int var1, double var2) throws IndexOutOfBoundsException;

    public Vector clone() {
        return this.space._clone(this);
    }

    public final void copyTo(Vector dst) throws IncorrectSpaceException {
        if (dst != this) {
            this.space.check(dst);
            this.space._copy(this, dst);
        }
    }

    public final void copyFrom(Vector src) throws IncorrectSpaceException {
        if (src != this) {
            this.space.check(src);
            this.space._copy(src, this);
        }
    }

    public final void swap(Vector v) throws IncorrectSpaceException {
        if (v != this) {
            this.space.check(v);
            this.space._swap(this, v);
        }
    }

    public void scale(double alpha) {
        this.space._scale(this, alpha);
    }

    public double dot(Vector other) {
        if (other == null || !other.belongsTo(this.space)) {
            throw new IncorrectSpaceException();
        }
        return this.space._dot(this, other);
    }

    public double norm1() {
        return this.space._norm1(this);
    }

    public double norm2() {
        return this.space._norm2(this);
    }

    public double normInf() {
        return this.space._normInf(this);
    }

    public void fill(double value) {
        this.space._fill(this, value);
    }

    public void zero() {
        this.space._zero(this);
    }

    public final void axpby(double alpha, Vector x, double beta, Vector y) throws IncorrectSpaceException {
        this.space.check(x);
        this.space.check(y);
        this.space._axpby(alpha, x, beta, y, this);
    }

    public final void axpbypcz(double alpha, Vector x, double beta, Vector y, double gamma, Vector z) throws IncorrectSpaceException {
        this.space.check(x);
        this.space.check(y);
        this.space.check(z);
        this.space._axpbypcz(alpha, x, beta, y, gamma, z, this);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.number) {
            buf.append(i == 0 ? "{" : ", ");
            buf.append(this.get(i));
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }
}

