/*
 * Decompiled with CFR 0.152.
 */
package mitiv.microscopy;

import mitiv.microscopy.Zernike;
import mitiv.utils.MathUtils;
import org.jtransforms.fft.DoubleFFT_2D;

public class WideFieldModel {
    protected static final int NORMALIZED = 1;
    protected static final double DEUXPI = Math.PI * 2;
    protected double NA;
    protected double lambda;
    protected double ni;
    protected double ns;
    protected double zdepth;
    protected double dxy;
    protected double dz;
    protected int Nx;
    protected int Ny;
    protected int Nz;
    protected int Nzern;
    protected int PState = 0;
    protected boolean use_depth_scaling;
    protected double deltaX;
    protected double deltaY;
    protected double defocus_L2;
    protected double depth_dot_defocus;
    protected double sum_depth_over_defocus;
    protected double sum_defocus_over_depth;
    protected int nb_defocus_coefs;
    protected int nb_modulus_coefs;
    protected int nb_phase_coefs;
    protected double[] modulus_coefs;
    protected double[] phase_coefs;
    protected double lambda_ni;
    protected double lambda_ns;
    protected double radius;
    protected double pupil_area;
    protected double NormZ1;
    protected double[] rho;
    protected double[] phi;
    protected double[] psi;
    protected double[] phasePupil;
    protected double[] gamma;
    protected double[] a;
    public double[] Z;
    protected double[] psf;
    protected double[] maskPupil;
    protected double eta;

    public WideFieldModel(double NA, double lambda, double ni, double ns, double zdepth, double dxy, double dz, int Nx, int Ny, int Nz, boolean use_depth_scaling) {
        this.NA = NA;
        this.lambda = lambda;
        this.ni = ni;
        this.ns = ns;
        this.zdepth = zdepth;
        this.dxy = dxy;
        this.dz = dz;
        this.Nx = Nx;
        this.Ny = Ny;
        this.Nz = Nz;
        this.Nzern = 4;
        this.radius = NA / lambda;
        this.lambda_ni = ni / lambda;
        this.lambda_ns = ns / lambda;
        this.nb_defocus_coefs = 0;
        this.nb_modulus_coefs = 0;
        this.nb_phase_coefs = 0;
        this.phi = new double[Ny * Nx];
        this.psi = new double[Ny * Nx];
        this.phasePupil = new double[Ny * Nx];
        this.psf = new double[Nz * Ny * Nx];
        this.gamma = new double[Ny * Nx];
        this.a = new double[Nz * Ny * 2 * Nx];
        this.use_depth_scaling = use_depth_scaling;
        this.Z = this.computeZernike();
        this.maskPupil = this.computeMaskPupil();
        this.PState = 0;
        this.setRho(new double[]{1.0});
        this.setDefocus(new double[]{ni / lambda, 0.0, 0.0});
    }

    private double[] computeMaskPupil() {
        double[] maskPupil = new double[this.Nx * this.Ny];
        double scale_y = Math.pow(1.0 / this.dxy / (double)this.Ny, 2.0);
        double scale_x = Math.pow(1.0 / this.dxy / (double)this.Nx, 2.0);
        double radius2 = this.radius * this.radius;
        this.pupil_area = 0.0;
        int ny = 0;
        while (ny < this.Ny) {
            double iy = Math.min(ny, this.Ny - ny);
            double ry = iy * iy * scale_y;
            int nx = 0;
            while (nx < this.Nx) {
                double ix = Math.min(nx, this.Nx - nx);
                double rx = ix * ix * scale_x;
                if (rx + ry < radius2) {
                    maskPupil[nx + ny * this.Nx] = 1.0;
                    this.pupil_area += 1.0;
                }
                ++nx;
            }
            ++ny;
        }
        this.pupil_area = Math.sqrt(this.pupil_area);
        this.PState = 0;
        return maskPupil;
    }

    private double[] computeZernike() {
        Zernike zernike = new Zernike(this.Nx, this.Ny);
        this.Z = zernike.zernikePupilMultipleOpt(this.Nzern, this.Nx, this.Ny, this.radius * this.dxy * (double)this.Nx, 1);
        this.Z = MathUtils.gram_schmidt_orthonormalization(this.Z, this.Nx, this.Ny, this.Nzern);
        return this.Z;
    }

    public void setRho(double[] beta) {
        if (beta.length > this.Nzern) {
            this.Nzern = beta.length;
            this.Z = this.computeZernike();
        }
        this.nb_modulus_coefs = beta.length;
        this.modulus_coefs = new double[this.nb_modulus_coefs];
        int i = 0;
        while (i < this.nb_modulus_coefs) {
            this.modulus_coefs[i] = beta[i];
            ++i;
        }
        int Npix = this.Nx * this.Ny;
        this.rho = new double[Npix];
        double betaNorm = 1.0 / Math.sqrt(MathUtils.innerProd(this.modulus_coefs, this.modulus_coefs));
        int in = 0;
        while (in < Npix) {
            if (this.maskPupil[in] == 1.0) {
                int n = 0;
                while (n < this.nb_modulus_coefs) {
                    int n2 = in;
                    this.rho[n2] = this.rho[n2] + this.Z[in + n * Npix] * this.modulus_coefs[n] * betaNorm;
                    ++n;
                }
            }
            ++in;
        }
        this.PState = 0;
    }

    public void setPhi(double[] alpha) {
        if (alpha.length + 3 > this.Nzern) {
            this.Nzern = alpha.length + 3;
            this.Z = this.computeZernike();
        }
        this.nb_phase_coefs = alpha.length;
        this.phase_coefs = new double[this.nb_phase_coefs];
        int i = 0;
        while (i < this.nb_phase_coefs) {
            this.phase_coefs[i] = alpha[i];
            ++i;
        }
        int Npix = this.Nx * this.Ny;
        this.phi = new double[Npix];
        int in = 0;
        while (in < Npix) {
            if (this.maskPupil[in] == 1.0) {
                int n = 0;
                while (n < this.nb_phase_coefs) {
                    int n2 = in;
                    this.phi[n2] = this.phi[n2] + this.Z[in + (n + 3) * Npix] * this.phase_coefs[n];
                    ++n;
                }
            }
            ++in;
        }
        this.PState = 0;
    }

    public void computeDefocus() {
        double lambda_ns2 = this.lambda_ns * this.lambda_ns;
        double lambda_ni2 = this.lambda_ni * this.lambda_ni;
        double scale_x = 1.0 / ((double)this.Nx * this.dxy);
        double scale_y = 1.0 / ((double)this.Ny * this.dxy);
        int ny = 0;
        while (ny < this.Ny) {
            double ry = ny > this.Ny / 2 ? Math.pow(scale_y * (double)(ny - this.Ny) - this.deltaY, 2.0) : Math.pow(scale_y * (double)ny - this.deltaY, 2.0);
            int nx = 0;
            while (nx < this.Nx) {
                int nxy = nx + ny * this.Nx;
                if (this.maskPupil[nxy] == 1.0) {
                    double rx = nx > this.Nx / 2 ? Math.pow(scale_x * (double)(nx - this.Nx) - this.deltaX, 2.0) : Math.pow(scale_x * (double)nx - this.deltaX, 2.0);
                    double q = lambda_ni2 - rx - ry;
                    if (q < 0.0) {
                        this.psi[nxy] = 0.0;
                        this.maskPupil[nxy] = 0.0;
                    } else {
                        this.psi[nxy] = Math.sqrt(q);
                        if (this.zdepth != 0.0) {
                            double tmpdepth = lambda_ns2 - rx - ry;
                            if (tmpdepth < 0.0) {
                                this.maskPupil[nxy] = 0.0;
                            } else {
                                this.gamma[nxy] = Math.sqrt(tmpdepth);
                            }
                        }
                    }
                }
                ++nx;
            }
            ++ny;
        }
        if (this.zdepth != 0.0 && this.use_depth_scaling) {
            double depth_dot_defocus = 0.0;
            double defocus_L2 = 0.0;
            this.sum_depth_over_defocus = 0.0;
            this.sum_defocus_over_depth = 0.0;
            int Nxy = 0;
            while (Nxy < this.Nx * this.Ny) {
                if (this.maskPupil[Nxy] == 1.0) {
                    depth_dot_defocus += this.gamma[Nxy] * this.psi[Nxy];
                    defocus_L2 += this.psi[Nxy] * this.psi[Nxy];
                    this.sum_depth_over_defocus += this.gamma[Nxy] / this.gamma[Nxy];
                    this.sum_defocus_over_depth += this.psi[Nxy] / this.gamma[Nxy];
                }
                ++Nxy;
            }
            this.eta = depth_dot_defocus / defocus_L2 - 1.0;
        } else {
            this.eta = 0.0;
        }
        this.PState = 0;
    }

    public void setDefocus(double[] defocus) {
        this.nb_defocus_coefs = defocus.length;
        switch (this.nb_defocus_coefs) {
            case 4: {
                this.lambda_ns = defocus[3];
                if (this.zdepth == 0.0) {
                    throw new IllegalArgumentException("zdepth == 0!!!");
                }
            }
            case 3: {
                this.deltaX = defocus[1];
                this.deltaY = defocus[2];
            }
            case 1: {
                this.lambda_ni = defocus[0];
                break;
            }
            case 2: {
                this.lambda_ni = defocus[0];
                this.lambda_ns = defocus[1];
                break;
            }
            default: {
                throw new IllegalArgumentException("bad defocus / depth parameters");
            }
        }
        this.computeDefocus();
        this.PState = 0;
    }

    public void computePSF(double[] alpha, double[] beta, double deltaX, double deltaY) {
        this.computeDefocus();
        this.setPhi(alpha);
        this.setRho(beta);
        this.computePSF();
    }

    public void computePSF() {
        int in;
        if (this.PState > 0) {
            return;
        }
        DoubleFFT_2D FFT2D = new DoubleFFT_2D((long)this.Ny, (long)this.Nx);
        double PSFnorm = 1.0 / (double)(this.Nx * this.Ny * this.Nz);
        int Npix = this.Nx * this.Ny;
        double[] A = new double[2 * Npix];
        if (this.zdepth != 0.0) {
            in = 0;
            while (in < Npix) {
                int n = in;
                this.phi[n] = this.phi[n] + Math.PI * 2 * this.ni * this.zdepth * (this.gamma[in] - (1.0 - this.eta) * this.psi[in]);
                ++in;
            }
        }
        int iz = 0;
        while (iz < this.Nz) {
            int Ci;
            double defoc_scale = iz > this.Nz / 2 ? Math.PI * 2 * (double)(iz - this.Nz) * this.dz : Math.PI * 2 * (double)iz * this.dz;
            int in2 = 0;
            while (in2 < Npix) {
                Ci = iz * Npix + in2;
                double phasePupil = this.phi[in2] + defoc_scale * this.psi[in2];
                A[2 * in2] = this.rho[in2] * Math.cos(phasePupil);
                A[2 * in2 + 1] = this.rho[in2] * Math.sin(phasePupil);
                ++in2;
            }
            FFT2D.complexForward(A);
            in2 = 0;
            while (in2 < Npix) {
                Ci = iz * Npix + in2;
                this.a[2 * Ci] = A[2 * in2];
                this.a[2 * Ci + 1] = -A[2 * in2 + 1];
                ++in2;
            }
            ++iz;
        }
        double[] a_2 = MathUtils.abs2(this.a, 1);
        in = 0;
        while (in < Npix * this.Nz) {
            this.psf[in] = a_2[in] * PSFnorm;
            ++in;
        }
        this.PState = 1;
    }

    public double[] apply_J_rho(double[] q) {
        int Ci;
        int Npix = this.Nx * this.Ny;
        double defoc_scale = 0.0;
        double PSFNorm = 1.0 / (double)(this.Nx * this.Ny * this.Nz);
        double[] Aq = new double[2 * Npix];
        double[] J = new double[this.Ny * this.Nx];
        double[] JRho = new double[this.nb_modulus_coefs];
        double NBeta = 1.0 / Math.sqrt(MathUtils.innerProd(this.modulus_coefs, this.modulus_coefs));
        DoubleFFT_2D FFT2D = new DoubleFFT_2D((long)this.Ny, (long)this.Nx);
        int iz = 0;
        while (iz < this.Nz) {
            defoc_scale = iz > this.Nz / 2 ? Math.PI * 2 * (double)(iz - this.Nz) * this.dz : Math.PI * 2 * (double)iz * this.dz;
            int in = 0;
            while (in < Npix) {
                Ci = iz * Npix + in;
                Aq[2 * in] = this.a[2 * Ci] * q[Ci];
                Aq[2 * in + 1] = this.a[2 * Ci + 1] * q[Ci];
                ++in;
            }
            FFT2D.complexForward(Aq);
            in = 0;
            while (in < Npix) {
                Ci = iz * Npix + in;
                double ph = this.phi[in] + defoc_scale * this.psi[in];
                J[in] = J[in] + Aq[2 * in] * Math.cos(ph) - Aq[2 * in + 1] * Math.sin(ph);
                ++in;
            }
            ++iz;
        }
        int k = 0;
        while (k < this.nb_modulus_coefs) {
            double tmp = 0.0;
            int in = 0;
            while (in < Npix) {
                Ci = k * Npix + in;
                tmp += J[in] * this.Z[Ci];
                ++in;
            }
            JRho[k] = 2.0 * PSFNorm * tmp * (1.0 - this.modulus_coefs[k] * this.modulus_coefs[k] * NBeta * NBeta) * NBeta;
            ++k;
        }
        return JRho;
    }

    public double[] apply_J_phi(double[] q) {
        int Ci;
        int in;
        int Npix = this.Nx * this.Ny;
        double PSFNorm = 1.0 / (double)(this.Nx * this.Ny * this.Nz);
        double[] JPhi = new double[this.nb_phase_coefs];
        double[] J = new double[this.Ny * this.Nx];
        double[] Aq = new double[2 * Npix];
        DoubleFFT_2D FFT2D = new DoubleFFT_2D((long)this.Ny, (long)this.Nx);
        int iz = 0;
        while (iz < this.Nz) {
            double defoc_scale = 0.0;
            defoc_scale = iz > this.Nz / 2 ? Math.PI * 2 * (double)(iz - this.Nz) * this.dz : Math.PI * 2 * (double)iz * this.dz;
            in = 0;
            while (in < Npix) {
                Ci = iz * Npix + in;
                Aq[2 * in] = this.a[2 * Ci] * q[Ci];
                Aq[2 * in + 1] = this.a[2 * Ci + 1] * q[Ci];
                ++in;
            }
            FFT2D.complexForward(Aq);
            in = 0;
            while (in < Npix) {
                Ci = iz * Npix + in;
                double ph = this.phi[in] + defoc_scale * this.psi[in];
                J[in] = J[in] + this.rho[in] * (Aq[2 * in] * Math.sin(ph) + Aq[2 * in + 1] * Math.cos(ph));
                ++in;
            }
            ++iz;
        }
        int k = 0;
        while (k < this.nb_phase_coefs) {
            double tmp = 0.0;
            in = 0;
            while (in < Npix) {
                Ci = k * Npix + in;
                tmp += J[in] * this.Z[Ci + 3 * Npix];
                ++in;
            }
            JPhi[k] = -2.0 * PSFNorm * tmp;
            ++k;
        }
        return JPhi;
    }

    public double[] apply_J_defocus(double[] q) {
        double scale_x = 1.0 / ((double)this.Nx * this.dxy);
        double scale_y = 1.0 / ((double)this.Ny * this.dxy);
        double d0 = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double[] rx = new double[this.Nx];
        double[] ry = new double[this.Ny];
        double sum_rx = 0.0;
        double sum_ry = 0.0;
        double etadx = 0.0;
        double etady = 0.0;
        double Npupil = 0.0;
        double etadni = 0.0;
        double etadns = 0.0;
        double ni_depth = this.lambda_ni * this.lambda * this.zdepth;
        int Npix = this.Nx * this.Ny;
        DoubleFFT_2D FFT2D = new DoubleFFT_2D((long)this.Ny, (long)this.Nx);
        double[] Aq = new double[2 * Npix];
        double PSFNorm = 1.0 / (double)(this.Nx * this.Ny * this.Nz);
        double[] grd = new double[this.nb_defocus_coefs];
        int nx = 0;
        while (nx < this.Nx) {
            rx[nx] = nx > this.Nx / 2 ? (double)(nx - this.Nx) * scale_x - this.deltaX : (double)nx * scale_x - this.deltaX;
            ++nx;
        }
        int ny = 0;
        while (ny < this.Ny) {
            ry[ny] = ny > this.Ny / 2 ? (double)(ny - this.Ny) * scale_y - this.deltaY : (double)ny * scale_y - this.deltaY;
            ++ny;
        }
        int iz = 0;
        while (iz < this.Nz) {
            int Ci;
            double defoc;
            double defoc_scale = 0.0;
            if (iz > this.Nz / 2) {
                defoc = (double)(iz - this.Nz) * this.dz;
                defoc_scale = Math.PI * 2 * defoc;
            } else {
                defoc = (double)iz * this.dz;
                defoc_scale = Math.PI * 2 * defoc;
            }
            int in = 0;
            while (in < Npix) {
                Ci = iz * Npix + in;
                Aq[2 * in] = this.a[2 * Ci] * q[Ci];
                Aq[2 * in + 1] = this.a[2 * Ci + 1] * q[Ci];
                ++in;
            }
            FFT2D.complexForward(Aq);
            int j = 0;
            while (j < this.Ny) {
                int i = 0;
                while (i < this.Nx) {
                    int in2 = i + j * this.Nx;
                    if (this.maskPupil[in2] == 1.0) {
                        Ci = iz * Npix + in2;
                        double idef = 1.0 / this.psi[in2];
                        double idepth = 0.0;
                        double ph = this.phi[in2] + defoc_scale * this.psi[in2];
                        double tmpvar = Math.PI * -2 * this.rho[in2] * (Aq[2 * in2] * Math.sin(ph) + Aq[2 * in2 + 1] * Math.cos(ph)) * PSFNorm;
                        d1 -= tmpvar * (rx[i] * (defoc * idef));
                        d2 -= tmpvar * (ry[j] * (defoc * idef));
                        d0 += tmpvar * (idef * this.lambda_ni * defoc);
                    }
                    ++i;
                }
                ++j;
            }
            ++iz;
        }
        switch (this.nb_defocus_coefs) {
            case 4: {
                grd[3] = d3;
            }
            case 3: {
                grd[2] = d2;
            }
            case 2: {
                grd[1] = d1;
            }
            case 1: {
                grd[0] = d0;
            }
        }
        return grd;
    }

    public double[] getRho() {
        if (this.PState < 1) {
            this.computePSF();
        }
        return this.rho;
    }

    public double getLambda() {
        return this.lambda;
    }

    public double getNi() {
        return this.ni;
    }

    public double[] getPhi() {
        if (this.PState < 1) {
            this.computePSF();
        }
        return this.phi;
    }

    public double[] getPsi() {
        if (this.PState < 1) {
            this.computePSF();
        }
        return this.psi;
    }

    public double[] getBeta() {
        return this.modulus_coefs;
    }

    public double[] getAlpha() {
        return this.phase_coefs;
    }

    public double[] getDefocusMultiplyByLambda() {
        if (this.PState < 1) {
            this.computePSF();
        }
        double[] defocus = new double[]{this.lambda_ni * this.lambda, this.deltaX * this.lambda, this.deltaY * this.lambda};
        return defocus;
    }

    public double[] getDefocus() {
        if (this.PState < 1) {
            this.computePSF();
        }
        double[] defocus = new double[]{this.lambda_ni, this.deltaX, this.deltaY};
        return defocus;
    }

    public double[] getGamma() {
        if (this.PState < 1) {
            this.computePSF();
        }
        return this.psi;
    }

    public double[] getMaskPupil() {
        if (this.PState < 1) {
            this.computePSF();
        }
        return this.maskPupil;
    }

    public double[] getPSF() {
        if (this.PState < 1) {
            this.computePSF();
        }
        return this.psf;
    }

    public double[] getPSF(int k) {
        if (this.PState < 1) {
            this.computePSF();
        }
        return MathUtils.getArray(this.psf, this.Nx, this.Ny, k);
    }

    public double[] getZernike() {
        return this.Z;
    }

    public int getNZern() {
        return this.Nzern;
    }

    public double[] getZernike(int k) {
        return MathUtils.getArray(this.Z, this.Nx, this.Ny, k);
    }

    public double[] get_a() {
        if (this.PState < 1) {
            this.computePSF();
        }
        return this.a;
    }

    public void getInfo() {
        System.out.println("----PSF----");
        MathUtils.stat(this.psf);
        System.out.println();
        System.out.println("----PHI----");
        MathUtils.stat(this.phi);
        System.out.println();
        System.out.println("----RHO----");
        MathUtils.stat(this.rho);
        System.out.println();
        System.out.println("----PSI----");
        MathUtils.stat(this.psi);
        System.out.println();
        System.out.println("----PUPIL----");
        MathUtils.stat(this.maskPupil);
        System.out.println();
        System.out.println("----a----");
        MathUtils.statC(this.a);
        System.out.println();
        System.out.println("----ZERNIKES----");
        MathUtils.stat(this.Z);
    }
}

