/*
 * Decompiled with CFR 0.152.
 */
package mitiv.utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import mitiv.base.Shape;
import mitiv.io.ColorModel;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.FloatShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.utils.ColorMap;

public class CommonUtils {
    public static final int LOWER_LEFT = 0;
    public static final int CENTERED = 1;
    public static final int FFT_INDEXING = -1;
    public static int NO_SCALE = 3;
    public static int SCALE = 4;
    public static int SCALE_CORRECTED = 5;
    public static int SCALE_COLORMAP = 6;
    public static int SCALE_CORRECTED_COLORMAP = 7;

    public static int greyToColor(double g, double alpha, double beta) {
        double x = alpha * g + beta;
        int i = x < 0.5 ? 0 : (x > 254.5 ? 255 : (int)(x + 0.5));
        return i;
    }

    public static int colorToGrey(double r, double g, double b) {
        return (int)ColorModel.colorToGrey(r, g, b);
    }

    public static int colorToGrey(int[] rgb) {
        if (rgb.length == 3) {
            return ColorModel.colorToGrey(rgb[0], rgb[1], rgb[2]);
        }
        return rgb[0];
    }

    public static double[] computeMinMax1D(double[] array, boolean isComplex) {
        double min = array[0];
        double max = array[0];
        int sizeArray = isComplex ? array.length / 2 : array.length;
        int i = 0;
        while (i < sizeArray) {
            double value = isComplex ? array[2 * i] : array[i];
            if (value < min) {
                min = value;
            }
            if (value > max) {
                max = value;
            }
            ++i;
        }
        return new double[]{min, max};
    }

    public static float[] computeMinMax1D(float[] array, boolean isComplex) {
        float min = array[0];
        float max = array[0];
        int sizeArray = isComplex ? array.length / 2 : array.length;
        int i = 0;
        while (i < sizeArray) {
            float value = isComplex ? array[2 * i] : array[i];
            if (value < min) {
                min = value;
            }
            if (value > max) {
                max = value;
            }
            ++i;
        }
        return new float[]{min, max};
    }

    public static float[] computeMinMax1Das2D(float[] array, int width, int height, boolean isComplex) {
        float min = array[0];
        float max = array[0];
        int current = 0;
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                current = isComplex ? 2 * (i + j * width) : i + j * width;
                if (array[current] < min) {
                    min = array[current];
                }
                if (array[current] > max) {
                    max = array[current];
                }
                ++i;
            }
            ++j;
        }
        return new float[]{min, max};
    }

    public static double[] computeMinMax1Das2D(double[] array, int width, int height, boolean isComplex) {
        double min = array[0];
        double max = array[0];
        int current = 0;
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                current = isComplex ? 2 * (i + j * width) : i + j * width;
                if (array[current] < min) {
                    min = array[current];
                }
                if (array[current] > max) {
                    max = array[current];
                }
                ++i;
            }
            ++j;
        }
        return new double[]{min, max};
    }

    public static double[] computeAlphaBeta1D(double[] array, boolean isComplex) {
        double beta;
        double alpha;
        double max;
        double[] out = CommonUtils.computeMinMax1D(array, isComplex);
        double min = out[0];
        if (min < (max = out[1])) {
            alpha = 255.0 / (max - min);
            beta = -alpha * min;
        } else {
            alpha = 0.0;
            beta = 0.0;
        }
        return new double[]{alpha, beta};
    }

    public static float[] computeAlphaBeta1D(float[] tab, boolean isComplex) {
        float beta;
        float alpha;
        float max;
        float[] out = CommonUtils.computeMinMax1D(tab, isComplex);
        float min = out[0];
        if (min < (max = out[1])) {
            alpha = 255.0f / (max - min);
            beta = -alpha * min;
        } else {
            alpha = 0.0f;
            beta = 0.0f;
        }
        return new float[]{alpha, beta};
    }

    @Deprecated
    public static double[] imageToArray1D(BufferedImage image, boolean isComplex) {
        double[] out;
        int height = image.getHeight();
        int width = image.getWidth();
        WritableRaster raster = image.getRaster();
        int size = width * height;
        if (isComplex) {
            out = new double[2 * size];
            int i = 0;
            while (i < size) {
                out[size + i] = 0.0;
                ++i;
            }
        } else {
            out = new double[size];
        }
        int[] tmp = new int[raster.getNumBands()];
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                raster.getPixel(i, j, tmp);
                out[i + j * width] = tmp.length == 1 || tmp.length == 2 ? (double)CommonUtils.colorToGrey(tmp[0], tmp[0], tmp[0]) : (double)CommonUtils.colorToGrey(tmp[0], tmp[1], tmp[2]);
                ++i;
            }
            ++j;
        }
        return out;
    }

    @Deprecated
    public static float[] imageToArray1DFloat(BufferedImage image, boolean isComplex) {
        int height = image.getHeight();
        int width = image.getWidth();
        WritableRaster raster = image.getRaster();
        float[] out = isComplex ? new float[width * 2 * height] : new float[width * height];
        int[] tmp = new int[raster.getNumBands()];
        if (isComplex) {
            int j = 0;
            while (j < height) {
                int i = 0;
                while (i < width) {
                    raster.getPixel(i, j, tmp);
                    out[2 * (i + j * width)] = tmp.length == 1 || tmp.length == 2 ? (float)CommonUtils.colorToGrey(tmp[0], tmp[0], tmp[0]) : (float)CommonUtils.colorToGrey(tmp[0], tmp[1], tmp[2]);
                    ++i;
                }
                ++j;
            }
        } else {
            int j = 0;
            while (j < height) {
                int i = 0;
                while (i < width) {
                    raster.getPixel(i, j, tmp);
                    out[i + j * width] = tmp.length == 1 || tmp.length == 2 ? (float)CommonUtils.colorToGrey(tmp[0], tmp[0], tmp[0]) : (float)CommonUtils.colorToGrey(tmp[0], tmp[1], tmp[2]);
                    ++i;
                }
                ++j;
            }
        }
        return out;
    }

    @Deprecated
    public static double[] image3DToArray1D(ArrayList<BufferedImage> listImage, int width, int height, int sizeZ, boolean isComplex) {
        double[] out;
        if (isComplex) {
            out = new double[2 * sizeZ * width * height];
            int strideW = width;
            int strideH = width * height;
            int k = 0;
            while (k < sizeZ) {
                double[] tmp = CommonUtils.imageToArray1D(listImage.get(k), false);
                int j = 0;
                while (j < height) {
                    int i = 0;
                    while (i < width) {
                        out[2 * i + 2 * j * strideW + 2 * k * strideH] = tmp[i + j * strideW];
                        ++i;
                    }
                    ++j;
                }
                ++k;
            }
        } else {
            out = new double[sizeZ * width * height];
            int j = 0;
            while (j < sizeZ) {
                double[] tmp = CommonUtils.imageToArray1D(listImage.get(j), false);
                int i = 0;
                while (i < tmp.length) {
                    out[i + j * tmp.length] = tmp[i];
                    ++i;
                }
                ++j;
            }
        }
        return out;
    }

    public static double[] shiftPsf3DToArray1D(ArrayList<BufferedImage> listPSF, int width, int height, int sizeZ, boolean isComplex) {
        double[] out = isComplex ? new double[width * height * sizeZ * 2] : new double[width * height * sizeZ];
        double[] psfIn = CommonUtils.image3DToArray1D(listPSF, width, height, sizeZ, isComplex);
        if (psfIn.length != out.length) {
            throw new IllegalArgumentException("The PSF and the output should be of same size");
        }
        CommonUtils.fftShift3D(psfIn, out, width, height, sizeZ);
        return out;
    }

    @Deprecated
    public static ShapedVector imageToVector(ShapedVectorSpace outputSpace, BufferedImage image, boolean singlePrecision, boolean isComplex) {
        if (singlePrecision) {
            FloatShapedVectorSpace space = (FloatShapedVectorSpace)outputSpace;
            float[] tab = CommonUtils.imageToArray1DFloat(image, isComplex);
            return space.wrap(tab);
        }
        DoubleShapedVectorSpace space = (DoubleShapedVectorSpace)outputSpace;
        double[] tab = CommonUtils.imageToArray1D(image, isComplex);
        return space.wrap(tab);
    }

    @Deprecated
    public static BufferedImage vectorToImage(ShapedVectorSpace outputSpace, ShapedVector vector, int job, boolean singlePrecision, boolean isComplex) {
        Shape shape = outputSpace.getShape();
        if (singlePrecision) {
            if (outputSpace.getRank() != 2) {
                throw new IllegalArgumentException("The vector should be of rank 2 to create an image");
            }
            return CommonUtils.arrayToImage1D(((FloatShapedVector)vector).getData(), job, shape.dimension(1), shape.dimension(0), isComplex);
        }
        if (outputSpace.getRank() != 2) {
            throw new IllegalArgumentException("The vector should be of rank 2 to create an image");
        }
        return CommonUtils.arrayToImage1D(((DoubleShapedVector)vector).getData(), job, shape.dimension(1), shape.dimension(0), isComplex);
    }

    public static BufferedImage createNewBufferedImage(BufferedImage originalImage) {
        BufferedImage imageout = originalImage.getType() == 0 ? new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), 5) : new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), originalImage.getType());
        return imageout;
    }

    public static BufferedImage createNewBufferedImage(int width, int height) {
        return new BufferedImage(width, height, 5);
    }

    public static void scaleArray1Das2D(double[] array, int width, int height, boolean isComplex) {
        double[] alphta = CommonUtils.computeAlphaBeta1D(array, isComplex);
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                int grey;
                if (isComplex) {
                    grey = CommonUtils.greyToColor(array[2 * (i + j * width)], alphta[0], alphta[1]);
                    array[2 * (i + j * width)] = grey;
                } else {
                    grey = CommonUtils.greyToColor(array[i + j * width], alphta[0], alphta[1]);
                    array[i + j * width] = grey;
                }
                ++i;
            }
            ++j;
        }
    }

    public static void scaleArray1D(double[] array, boolean isComplex) {
        double[] alphta = CommonUtils.computeAlphaBeta1D(array, isComplex);
        int sizeArray = isComplex ? array.length / 2 : array.length;
        int i = 0;
        while (i < sizeArray) {
            int grey;
            if (isComplex) {
                grey = CommonUtils.greyToColor(array[2 * i], alphta[0], alphta[1]);
                array[2 * i] = grey;
            } else {
                grey = CommonUtils.greyToColor(array[i], alphta[0], alphta[1]);
                array[i] = grey;
            }
            ++i;
        }
    }

    public static void scaleArray1Das2D(float[] array, int width, int height, boolean isComplex) {
        float[] alphta = CommonUtils.computeAlphaBeta1D(array, isComplex);
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                int grey;
                if (isComplex) {
                    grey = CommonUtils.greyToColor(array[2 * (i + j * width)], alphta[0], alphta[1]);
                    array[2 * (i + j * width)] = grey;
                } else {
                    grey = CommonUtils.greyToColor(array[i + j * width], alphta[0], alphta[1]);
                    array[i + j * width] = grey;
                }
                ++i;
            }
            ++j;
        }
    }

    public static void scaleArray1D(float[] array, boolean isComplex) {
        float[] alphta = CommonUtils.computeAlphaBeta1D(array, isComplex);
        int sizeArray = isComplex ? array.length / 2 : array.length;
        int i = 0;
        while (i < sizeArray) {
            int grey;
            if (isComplex) {
                grey = CommonUtils.greyToColor(array[2 * i], alphta[0], alphta[1]);
                array[2 * i] = grey;
            } else {
                grey = CommonUtils.greyToColor(array[i], alphta[0], alphta[1]);
                array[i] = grey;
            }
            ++i;
        }
    }

    public static void correctArray1Das2D(double[] array, int width, int height, boolean isComplex) {
        double beta;
        double alpha;
        int grey;
        int[] tmpOut = new int[256];
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                grey = isComplex ? (int)array[2 * (i + j * width)] : (int)array[i + j * width];
                int n = grey;
                tmpOut[n] = tmpOut[n] + 1;
                ++i;
            }
            ++j;
        }
        int newMin = 0;
        int newMax = 255;
        int i = 0;
        while (i < 256) {
            if (newMin == 0 && tmpOut[i] > 2) {
                newMin = i;
            }
            if (newMax == 255 && tmpOut[255 - i] > 2) {
                newMax = 255 - i;
            }
            ++i;
        }
        if (newMin < newMax) {
            alpha = 255.0 / (double)(newMax - newMin);
            beta = -alpha * (double)newMin;
        } else {
            alpha = 0.0;
            beta = 0.0;
        }
        int j2 = 0;
        while (j2 < height) {
            int i2 = 0;
            while (i2 < width) {
                if (isComplex) {
                    grey = CommonUtils.greyToColor(array[2 * (i2 + j2 * width)], alpha, beta);
                    array[2 * (i2 + j2 * width)] = grey;
                } else {
                    grey = CommonUtils.greyToColor(array[i2 + j2 * width], alpha, beta);
                    array[i2 + j2 * width] = grey;
                }
                ++i2;
            }
            ++j2;
        }
    }

    public static void correctArray1Das2D(float[] array, int width, int height, boolean isComplex) {
        double beta;
        double alpha;
        int grey;
        int[] tmpOut = new int[256];
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                grey = isComplex ? (int)array[2 * (i + j * width)] : (int)array[i + j * width];
                int n = grey;
                tmpOut[n] = tmpOut[n] + 1;
                ++i;
            }
            ++j;
        }
        int newMin = 0;
        int newMax = 255;
        int i = 0;
        while (i < 256) {
            if (newMin == 0 && tmpOut[i] > 2) {
                newMin = i;
            }
            if (newMax == 255 && tmpOut[255 - i] > 2) {
                newMax = 255 - i;
            }
            ++i;
        }
        if (newMin < newMax) {
            alpha = 255.0 / (double)(newMax - newMin);
            beta = -alpha * (double)newMin;
        } else {
            alpha = 0.0;
            beta = 0.0;
        }
        int j2 = 0;
        while (j2 < height) {
            int i2 = 0;
            while (i2 < width) {
                if (isComplex) {
                    grey = CommonUtils.greyToColor(array[2 * (i2 + j2 * width)], alpha, beta);
                    array[2 * (i2 + j2 * width)] = grey;
                } else {
                    grey = CommonUtils.greyToColor(array[i2 + j2 * width], alpha, beta);
                    array[i2 + j2 * width] = grey;
                }
                ++i2;
            }
            ++j2;
        }
    }

    public static void correctArray1D(double[] array, boolean isComplex) {
        double beta;
        double alpha;
        int grey;
        int[] tmpOut = new int[256];
        int sizeArray = isComplex ? array.length / 2 : array.length;
        int i = 0;
        while (i < sizeArray) {
            grey = isComplex ? (int)array[2 * i] : (int)array[i];
            int n = grey;
            tmpOut[n] = tmpOut[n] + 1;
            ++i;
        }
        int newMin = 0;
        int newMax = 255;
        int i2 = 0;
        while (i2 < 256) {
            if (newMin == 0 && tmpOut[i2] > 2) {
                newMin = i2;
            }
            if (newMax == 255 && tmpOut[255 - i2] > 2) {
                newMax = 255 - i2;
            }
            ++i2;
        }
        if (newMin < newMax) {
            alpha = 255.0 / (double)(newMax - newMin);
            beta = -alpha * (double)newMin;
        } else {
            alpha = 0.0;
            beta = 0.0;
        }
        i2 = 0;
        while (i2 < sizeArray) {
            if (isComplex) {
                grey = CommonUtils.greyToColor(array[2 * i2], alpha, beta);
                array[2 * i2] = grey;
            } else {
                grey = CommonUtils.greyToColor(array[i2], alpha, beta);
                array[i2] = grey;
            }
            ++i2;
        }
    }

    public static void correctArray1D(float[] array, boolean isComplex) {
        double beta;
        double alpha;
        int grey;
        int[] tmpOut = new int[256];
        int sizeArray = isComplex ? array.length / 2 : array.length;
        int i = 0;
        while (i < sizeArray) {
            grey = isComplex ? (int)array[2 * i] : (int)array[i];
            int n = grey;
            tmpOut[n] = tmpOut[n] + 1;
            ++i;
        }
        int newMin = 0;
        int newMax = 255;
        int i2 = 0;
        while (i2 < 256) {
            if (newMin == 0 && tmpOut[i2] > 2) {
                newMin = i2;
            }
            if (newMax == 255 && tmpOut[255 - i2] > 2) {
                newMax = 255 - i2;
            }
            ++i2;
        }
        if (newMin < newMax) {
            alpha = 255.0 / (double)(newMax - newMin);
            beta = -alpha * (double)newMin;
        } else {
            alpha = 0.0;
            beta = 0.0;
        }
        i2 = 0;
        while (i2 < sizeArray) {
            if (isComplex) {
                grey = CommonUtils.greyToColor(array[2 * i2], alpha, beta);
                array[2 * i2] = grey;
            } else {
                grey = CommonUtils.greyToColor(array[i2], alpha, beta);
                array[i2] = grey;
            }
            ++i2;
        }
    }

    public static BufferedImage colorArray1D(double[] array, int width, int height, boolean isComplex) {
        BufferedImage imageout = CommonUtils.createNewBufferedImage(width, height);
        WritableRaster raster = imageout.getRaster();
        ColorMap map = ColorMap.getJet(256);
        int[] tmp = new int[3];
        int j = 0;
        while (j < imageout.getHeight()) {
            int i = 0;
            while (i < imageout.getWidth()) {
                int grey = isComplex ? (int)array[2 * (i + j * imageout.getWidth())] : (int)array[i + j * imageout.getWidth()];
                tmp[0] = map.r[grey];
                tmp[1] = map.g[grey];
                tmp[2] = map.b[grey];
                raster.setPixel(i, j, tmp);
                ++i;
            }
            ++j;
        }
        return imageout;
    }

    public static BufferedImage colorArray1D(float[] array, int width, int height, boolean isComplex) {
        BufferedImage imageout = CommonUtils.createNewBufferedImage(width, height);
        WritableRaster raster = imageout.getRaster();
        ColorMap map = ColorMap.getJet(256);
        int[] tmp = new int[3];
        int j = 0;
        while (j < imageout.getHeight()) {
            int i = 0;
            while (i < imageout.getWidth()) {
                int grey = isComplex ? (int)array[2 * (i + j * imageout.getWidth())] : (int)array[i + j * imageout.getWidth()];
                tmp[0] = map.r[grey];
                tmp[1] = map.g[grey];
                tmp[2] = map.b[grey];
                raster.setPixel(i, j, tmp);
                ++i;
            }
            ++j;
        }
        return imageout;
    }

    @Deprecated
    public static BufferedImage arrayToImage1D_3D(double[] array, int width, int height, int depth, boolean isComplex) {
        BufferedImage imageout = CommonUtils.createNewBufferedImage(width, height);
        WritableRaster raster = imageout.getRaster();
        int[] tmp = new int[3];
        int k = 0;
        while (k < depth) {
            int j = 0;
            while (j < height) {
                int i = 0;
                while (i < width) {
                    int grey = isComplex ? (int)array[2 * (i + j * width + k * width * height)] : (int)array[i + j * width + k * width * height];
                    tmp[1] = tmp[2] = grey;
                    tmp[0] = tmp[2];
                    raster.setPixel(i, j, tmp);
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        return imageout;
    }

    public static BufferedImage arrayToImage1D(double[] array, int width, int height, boolean isComplex) {
        BufferedImage imageout = CommonUtils.createNewBufferedImage(width, height);
        WritableRaster raster = imageout.getRaster();
        int[] tmp = new int[3];
        int j = 0;
        while (j < imageout.getHeight()) {
            int i = 0;
            while (i < imageout.getWidth()) {
                int grey = isComplex ? (int)array[2 * (i + j * imageout.getHeight())] : (int)array[i + j * imageout.getHeight()];
                tmp[1] = tmp[2] = grey;
                tmp[0] = tmp[2];
                raster.setPixel(i, j, tmp);
                ++i;
            }
            ++j;
        }
        return imageout;
    }

    public static BufferedImage arrayToImage1D(float[] array, int width, int height, boolean isComplex) {
        BufferedImage imageout = new BufferedImage(width, height, 11);
        WritableRaster raster = imageout.getRaster();
        int[] tmp = new int[3];
        int j = 0;
        while (j < imageout.getHeight()) {
            int i = 0;
            while (i < imageout.getWidth()) {
                int grey = isComplex ? (int)array[2 * (i + j * imageout.getHeight())] : (int)array[i + j * imageout.getHeight()];
                tmp[1] = tmp[2] = grey;
                tmp[0] = tmp[2];
                raster.setPixel(i, j, tmp);
                ++i;
            }
            ++j;
        }
        return imageout;
    }

    public static BufferedImage arrayToImage1D(double[] array, int job, int width, int height, boolean isComplex) {
        if (job > SCALE_CORRECTED_COLORMAP) {
            System.err.println("Wrong job");
            throw new IllegalArgumentException();
        }
        if (job != NO_SCALE) {
            CommonUtils.scaleArray1D(array, isComplex);
        }
        if (job == SCALE_CORRECTED || job == SCALE_CORRECTED_COLORMAP) {
            CommonUtils.correctArray1D(array, isComplex);
        }
        BufferedImage out = job == SCALE_COLORMAP || job == SCALE_CORRECTED_COLORMAP ? CommonUtils.colorArray1D(array, width, height, isComplex) : CommonUtils.arrayToImage1D(array, width, height, isComplex);
        return out;
    }

    public static BufferedImage arrayToImage1D(float[] array, int job, int width, int height, boolean isComplex) {
        if (job > SCALE_CORRECTED_COLORMAP) {
            System.err.println("Wrong job");
            throw new IllegalArgumentException();
        }
        if (job != NO_SCALE) {
            CommonUtils.scaleArray1D(array, isComplex);
        }
        if (job == SCALE_CORRECTED || job == SCALE_CORRECTED_COLORMAP) {
            CommonUtils.correctArray1D(array, isComplex);
        }
        BufferedImage out = job == SCALE_COLORMAP || job == SCALE_CORRECTED_COLORMAP ? CommonUtils.colorArray1D(array, width, height, isComplex) : CommonUtils.arrayToImage1D(array, width, height, isComplex);
        return out;
    }

    public static int estimatePsfSize(BufferedImage PSF) {
        int greyEnd;
        int greyBegin;
        int width = PSF.getWidth();
        int height = PSF.getHeight();
        WritableRaster raster = PSF.getRaster();
        int min = -1;
        int max = width;
        int prev = 0;
        int i = 0;
        while (i < width) {
            greyBegin = CommonUtils.colorToGrey(raster.getPixel(i, height / 2, (int[])null));
            greyEnd = CommonUtils.colorToGrey(raster.getPixel(width - i - 1, height / 2, (int[])null));
            if (greyBegin != 0 && min == -1) {
                min = i;
            }
            if (greyEnd != 0 && max == width) {
                max = width - i - 1;
            }
            ++i;
        }
        prev = max - min;
        max = height;
        min = -1;
        i = 0;
        while (i < height) {
            greyBegin = CommonUtils.colorToGrey(raster.getPixel(width / 2, i, (int[])null));
            greyEnd = CommonUtils.colorToGrey(raster.getPixel(width / 2, height - i - 1, (int[])null));
            if (greyBegin != 0 && min == -1) {
                min = i;
            }
            if (greyEnd != 0 && max == height) {
                max = height - i - 1;
            }
            ++i;
        }
        return max - min > prev ? max - min : prev;
    }

    private static BufferedImage createZeroBufferedImage(int width, int height) {
        BufferedImage out = new BufferedImage(width, height, 11);
        WritableRaster rasterImage = out.getRaster();
        int[] tmp = new int[3];
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                rasterImage.setPixel(i, j, tmp);
                ++i;
            }
            ++j;
        }
        return out;
    }

    public static BufferedImage imagePad(BufferedImage image, double coef) {
        BufferedImage pad = CommonUtils.createZeroBufferedImage((int)((double)image.getWidth() * coef), (int)((double)image.getHeight() * coef));
        WritableRaster rasterImage = image.getRaster();
        WritableRaster rasterPad = pad.getRaster();
        int padW = (int)((double)image.getWidth() * coef - (double)image.getWidth()) / 2;
        int padH = (int)((double)image.getHeight() * coef - (double)image.getHeight()) / 2;
        int j = 0;
        while (j < image.getHeight()) {
            int i = 0;
            while (i < image.getWidth()) {
                rasterPad.setPixel(padW + i, padH + j, rasterImage.getPixel(i, j, (int[])null));
                ++i;
            }
            ++j;
        }
        return pad;
    }

    public static ArrayList<BufferedImage> imagePad(ArrayList<BufferedImage> image, double coef, boolean isPsf) {
        ArrayList<BufferedImage> out = new ArrayList<BufferedImage>();
        int width = image.get(0).getWidth();
        int height = image.get(0).getHeight();
        int size = image.size();
        BufferedImage zero = CommonUtils.createZeroBufferedImage((int)((double)width * coef), (int)((double)height * coef));
        double sizePad = (double)size * coef - (double)size;
        int i = 0;
        while (i < size) {
            out.add(CommonUtils.imagePad(image.get(i), coef));
            ++i;
        }
        i = 0;
        while (i < (int)sizePad) {
            out.add(zero);
            ++i;
        }
        return out;
    }

    public static double[] imagePad(double[] input, int width, int height, int sizeZ, double coefWH, double coefZ) {
        int sizePadW = (int)((double)width * coefWH - (double)width);
        int sizePadH = (int)((double)height * coefWH - (double)height);
        int sizePadZ = (int)((double)sizeZ * coefZ - (double)sizeZ);
        int halfSizePadW = sizePadW / 2;
        int halfSizePadH = sizePadH / 2;
        int halfSizePadZ = sizePadZ / 2;
        double[] output = new double[(width + sizePadW) * (height + sizePadH) * (sizeZ + sizePadZ)];
        int i = 0;
        while (i < output.length) {
            output[i] = 0.0;
            ++i;
        }
        int k = 0;
        while (k < sizeZ) {
            int j = 0;
            while (j < height) {
                int i2 = 0;
                while (i2 < width) {
                    double temp;
                    output[i2 + halfSizePadW + (j + halfSizePadH) * (width + sizePadW) + (k + halfSizePadZ) * (width + sizePadW) * (height + sizePadH)] = temp = input[i2 + j * width + k * width * height];
                    ++i2;
                }
                ++j;
            }
            ++k;
        }
        return output;
    }

    public static double[] imagePad(double[] input, int width, int height, int sizeZ, double coef) {
        return CommonUtils.imagePad(input, width, height, sizeZ, coef, coef);
    }

    public static BufferedImage imageUnPad(BufferedImage image, int sizePSF) {
        int hlf = sizePSF / 2;
        return image.getSubimage(hlf, hlf, image.getWidth() - sizePSF, image.getHeight() - sizePSF);
    }

    public static ArrayList<BufferedImage> imageUnPad(ArrayList<BufferedImage> image, int sizePSF) {
        ArrayList<BufferedImage> out = new ArrayList<BufferedImage>();
        int i = image.size() / 4;
        while (i < image.size() * 3 / 4) {
            out.add(CommonUtils.imageUnPad(image.get(i), sizePSF));
            ++i;
        }
        return out;
    }

    public static double[] psfPadding1D(BufferedImage image, BufferedImage imagePsf, boolean isComplex) {
        int width = image.getWidth();
        int height = image.getHeight();
        double[] tableau_psf = isComplex ? new double[width * 2 * height] : new double[width * height];
        int psfH = imagePsf.getHeight();
        int psfW = imagePsf.getWidth();
        double[] test = CommonUtils.imageToArray1D(imagePsf, false);
        return CommonUtils.psfPadding1D(tableau_psf, width, height, test, psfW, psfH, isComplex);
    }

    public static ShapedVector psfPadding1D(ShapedVectorSpace inputSpace, ShapedVectorSpace outputSpace, ShapedVector imagePsf, boolean singlePrecision, boolean isComplex) {
        if (singlePrecision) {
            FloatShapedVectorSpace spaceFloat = (FloatShapedVectorSpace)outputSpace;
            FloatShapedVector vectorPsf = (FloatShapedVector)imagePsf;
            if (spaceFloat.getRank() != 2) {
                throw new IllegalArgumentException("The rank of vector must be 2");
            }
            Shape shape = spaceFloat.getShape();
            Shape shapePsf = ((FloatShapedVectorSpace)imagePsf.getSpace()).getShape();
            float[] psfPad = CommonUtils.psfPadding1D(spaceFloat.create().getData(), shape.dimension(1), shape.dimension(0), vectorPsf.getData(), shapePsf.dimension(1), shapePsf.dimension(0), isComplex);
            return spaceFloat.wrap(psfPad);
        }
        DoubleShapedVectorSpace spaceDoubleOut = (DoubleShapedVectorSpace)outputSpace;
        DoubleShapedVectorSpace spaceDoubleIn = (DoubleShapedVectorSpace)inputSpace;
        DoubleShapedVector vectorPsf = (DoubleShapedVector)imagePsf;
        if (spaceDoubleOut.getRank() != 2) {
            throw new IllegalArgumentException("The rank of vector must be 2");
        }
        Shape shape = spaceDoubleIn.getShape();
        Shape shapePsf = ((DoubleShapedVectorSpace)imagePsf.getSpace()).getShape();
        double[] psfPad = CommonUtils.psfPadding1D(spaceDoubleOut.create().getData(), shape.dimension(1), shape.dimension(0), vectorPsf.getData(), shapePsf.dimension(1), shapePsf.dimension(0), isComplex);
        return spaceDoubleOut.wrap(psfPad);
    }

    public static double[] psfPadding1D(double[] imageout, int imageWidth, int imageHeight, double[] imagePsf, int psfWidth, int psfHeight, boolean isComplex) {
        int i;
        int demiPsfW = psfWidth / 2;
        int demiPsfH = psfHeight / 2;
        int j = 0;
        while (j < demiPsfH) {
            i = 0;
            while (i < demiPsfW) {
                imageout[i + j * imageWidth] = imagePsf[demiPsfW + i + (demiPsfH + j) * psfWidth];
                ++i;
            }
            ++j;
        }
        j = 0;
        while (j < demiPsfH) {
            i = imageWidth - demiPsfW;
            while (i < imageWidth) {
                imageout[i + j * imageWidth] = imagePsf[demiPsfW - imageWidth + i + (demiPsfH + j) * psfWidth];
                ++i;
            }
            ++j;
        }
        j = imageHeight - demiPsfH;
        while (j < imageHeight) {
            i = 0;
            while (i < demiPsfW) {
                imageout[i + j * imageWidth] = imagePsf[demiPsfW + i + (demiPsfH - imageHeight + j) * psfWidth];
                ++i;
            }
            ++j;
        }
        j = imageHeight - demiPsfH;
        while (j < imageHeight) {
            i = imageWidth - demiPsfW;
            while (i < imageWidth) {
                imageout[i + j * imageWidth] = imagePsf[demiPsfW - imageWidth + i + (demiPsfH - imageHeight + j) * psfWidth];
                ++i;
            }
            ++j;
        }
        return imageout;
    }

    public static double[] fftShift3D(double[] psf, double[] out, int w, int h, int d) {
        int wh = w * h;
        int k = 0;
        while (k < d / 2) {
            int j = 0;
            while (j < h / 2) {
                int i = 0;
                while (i < w / 2) {
                    out[w - w / 2 + i + w * (h - h / 2 + j) + wh * (d - d / 2 + k)] = psf[i + w * j + k * wh];
                    out[i + w * (h - h / 2 + j) + wh * (d - d / 2 + k)] = psf[i + w / 2 + w * j + k * wh];
                    out[w - w / 2 + i + w * j + wh * (d - d / 2 + k)] = psf[i + w * (j + h / 2) + k * wh];
                    out[i + w * j + wh * (d - d / 2 + k)] = psf[i + w / 2 + w * (j + h / 2) + k * wh];
                    out[w - w / 2 + i + w * (h - h / 2 + j) + k * wh] = psf[i + w * j + wh * (d - d / 2 + k)];
                    out[i + w * (h - h / 2 + j) + k * wh] = psf[i + w / 2 + w * j + wh * (d - d / 2 + k)];
                    out[w - w / 2 + i + w * j + k * wh] = psf[i + w * (j + h / 2) + wh * (d - d / 2 + k)];
                    out[i + w * j + k * wh] = psf[i + w / 2 + w * (j + h / 2) + wh * (d - d / 2 + k)];
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        return out;
    }

    public static double[] psf3DPadding1D(double[] psfIn, double[] psfOut, int psfWidth, int psfHeight, int psfZ) {
        int i;
        int j;
        int demiPsfW = psfWidth / 2;
        int demiPsfH = psfHeight / 2;
        int demiPsfZ = psfZ / 2;
        int strideJ = psfWidth;
        int strideK = psfWidth * psfHeight;
        int k = 0;
        while (k < demiPsfZ) {
            j = 0;
            while (j < demiPsfH) {
                i = 0;
                while (i < demiPsfW) {
                    psfOut[i + j * strideJ + k * strideK] = psfIn[demiPsfW + i + (demiPsfH + j) * strideJ + (demiPsfZ + k) * strideK];
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        k = demiPsfZ;
        while (k < psfZ) {
            j = demiPsfH;
            while (j < psfHeight) {
                i = demiPsfW;
                while (i < psfWidth) {
                    psfOut[i + j * strideJ + k * strideK] = psfIn[i - demiPsfW + (j - demiPsfH) * strideJ + (k - demiPsfZ) * strideK];
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        k = 0;
        while (k < demiPsfZ) {
            j = 0;
            while (j < demiPsfH) {
                i = demiPsfW;
                while (i < psfWidth) {
                    psfOut[i + j * strideJ + k * strideK] = psfIn[i - demiPsfW + (demiPsfH + j) * strideJ + (demiPsfZ + k) * strideK];
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        k = demiPsfZ;
        while (k < psfZ) {
            j = demiPsfH;
            while (j < psfHeight) {
                i = 0;
                while (i < demiPsfW) {
                    psfOut[i + j * strideJ + k * strideK] = psfIn[demiPsfW + i + (j - demiPsfH) * strideJ + (k - demiPsfZ) * strideK];
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        k = demiPsfZ;
        while (k < psfZ) {
            j = 0;
            while (j < demiPsfH) {
                i = 0;
                while (i < demiPsfW) {
                    psfOut[i + j * strideJ + k * strideK] = psfIn[demiPsfW + i + (demiPsfH + j) * strideJ + (k - demiPsfZ) * strideK];
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        k = 0;
        while (k < demiPsfZ) {
            j = demiPsfH;
            while (j < psfHeight) {
                i = demiPsfW;
                while (i < psfWidth) {
                    psfOut[i + j * strideJ + k * strideK] = psfIn[i - demiPsfW + (j - demiPsfH) * strideJ + (demiPsfZ + k) * strideK];
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        k = demiPsfZ;
        while (k < psfZ) {
            j = 0;
            while (j < demiPsfH) {
                i = demiPsfW;
                while (i < psfWidth) {
                    psfOut[i + j * strideJ + k * strideK] = psfIn[i - demiPsfW + (demiPsfH + j) * strideJ + (k - demiPsfZ) * strideK];
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        k = 0;
        while (k < demiPsfZ) {
            j = demiPsfH;
            while (j < psfHeight) {
                i = 0;
                while (i < demiPsfW) {
                    psfOut[i + j * strideJ + k * strideK] = psfIn[demiPsfW + i + (j - demiPsfH) * strideJ + (demiPsfZ + k) * strideK];
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        return psfOut;
    }

    public static float[] psfPadding1DFloat(BufferedImage image, BufferedImage imagePsf, boolean isComplex) {
        int width = image.getWidth();
        int height = image.getHeight();
        float[] tableau_psf = isComplex ? new float[width * 2 * height] : new float[width * height];
        int psfH = imagePsf.getHeight();
        int psfW = imagePsf.getWidth();
        float[] test = CommonUtils.imageToArray1DFloat(imagePsf, false);
        return CommonUtils.psfPadding1D(tableau_psf, width, height, test, psfH, psfW, isComplex);
    }

    public static float[] psfPadding1D(float[] imageout, int imageWidth, int imageHeight, float[] imagePsf, int psfWidth, int psfHeight, boolean isComplex) {
        int i;
        int demiPsfW = psfWidth / 2;
        int demiPsfH = psfHeight / 2;
        int coef = isComplex ? 1 : 1;
        int j = 0;
        while (j < demiPsfH) {
            i = 0;
            while (i < demiPsfW) {
                imageout[i + coef * j * imageWidth] = imagePsf[demiPsfW + i + (demiPsfH + j) * psfWidth];
                ++i;
            }
            ++j;
        }
        j = 0;
        while (j < demiPsfH) {
            i = imageWidth - demiPsfW;
            while (i < imageWidth) {
                imageout[i + coef * j * imageWidth] = imagePsf[demiPsfW - imageWidth + i + (demiPsfH + j) * psfWidth];
                ++i;
            }
            ++j;
        }
        j = imageHeight - demiPsfH;
        while (j < imageHeight) {
            i = 0;
            while (i < demiPsfW) {
                imageout[i + coef * j * imageWidth] = imagePsf[demiPsfW + i + (demiPsfH - imageHeight + j) * psfWidth];
                ++i;
            }
            ++j;
        }
        j = imageHeight - demiPsfH;
        while (j < imageHeight) {
            i = imageWidth - demiPsfW;
            while (i < imageWidth) {
                imageout[i + coef * j * imageWidth] = imagePsf[demiPsfW - imageWidth + i + (demiPsfH - imageHeight + j) * psfWidth];
                ++i;
            }
            ++j;
        }
        return imageout;
    }

    public static double[] array2DTo1D(double[][] In) {
        int W = In.length;
        int H = In[0].length;
        double[] Out = new double[H * W];
        int j = 0;
        while (j < H) {
            int i = 0;
            while (i < W) {
                Out[j * W + i] = In[i][j];
                ++i;
            }
            ++j;
        }
        return Out;
    }

    public static double[][] array1DTo2D(double[] In, int H) {
        int W = In.length / H;
        double[][] Out = new double[H][W];
        int j = 0;
        while (j < H) {
            int i = 0;
            while (i < W) {
                Out[i][j] = In[j * W + i];
                ++i;
            }
            ++j;
        }
        return Out;
    }

    @Deprecated
    public static void showBufferedImage(BufferedImage I) {
        JFrame frame = new JFrame();
        JLabel label = new JLabel();
        label.setIcon(new ImageIcon(I));
        frame.add(label);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    @Deprecated
    public static void saveBufferedImage(BufferedImage I, String name) {
        try {
            ImageIO.write((RenderedImage)I, "PNG", new File(name));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static BufferedImage openAsBufferedImage(String path) {
        BufferedImage I = null;
        try {
            I = ImageIO.read(new File(path));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return I;
    }

    @Deprecated
    public static void saveArrayToImage(double[] A, int W, String name) {
        int H = A.length / W;
        BufferedImage I = CommonUtils.arrayToImage1D(A, W, H, false);
        CommonUtils.saveBufferedImage(I, name);
    }
}

