/*
 * Decompiled with CFR 0.152.
 */
package mitiv.utils;

public class FFTUtils {
    protected FFTUtils() {
    }

    public static int bestPowerOfTwo(int dim) {
        int maxDim = 0x40000000;
        if (dim > 0x40000000) {
            throw new IllegalArgumentException("Integer overflow");
        }
        int best = 1;
        while (best < dim) {
            best *= 2;
        }
        return best;
    }

    public static int bestDimension(int dim) {
        int best = 2 * dim;
        int n5 = 1;
        while (n5 < best) {
            int n3 = n5;
            while (n3 < best) {
                int n2 = n3;
                while (n2 < dim) {
                    n2 *= 2;
                }
                if (n2 == dim) {
                    return dim;
                }
                if (best > n2) {
                    best = n2;
                }
                n3 *= 3;
            }
            n5 *= 5;
        }
        return best;
    }

    public static int[] generateFrequels(int dim) {
        int[] freq = new int[dim];
        FFTUtils.generateFrequels(freq);
        return freq;
    }

    public static void generateFrequels(int[] freq) {
        int dim = freq.length;
        int cut = dim / 2;
        int i = 0;
        while (i <= cut) {
            freq[i] = i;
            ++i;
        }
        i = cut + 1;
        while (i < dim) {
            freq[i] = i - dim;
            ++i;
        }
    }
}

