/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.DefaultSecurity;
import com.sun.media.sound.IESecurity;
import com.sun.media.sound.JDK12Security;
import com.sun.media.sound.JSSecurity;
import com.sun.media.sound.NetscapeSecurity;
import com.sun.media.sound.Printer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class JSSecurityManager {
    private static JSSecurity security;
    private static SecurityManager securityManager;
    static /* synthetic */ Class class$java$lang$String;

    JSSecurityManager() {
    }

    public static JSSecurity getJSSecurity() throws SecurityException {
        return security;
    }

    public static void checkRecord() throws SecurityException {
        if (security == null) {
            return;
        }
        try {
            Object[] arguments;
            if (Printer.debug) {
                Printer.debug("JSSecurity.checkRecord(): looking up JMF registry class, using reflection");
            }
            Class<?> registry = Class.forName("com.sun.media.util.Registry");
            Method m = registry.getMethod("get", class$java$lang$String == null ? (class$java$lang$String = JSSecurityManager.class$("java.lang.String")) : class$java$lang$String);
            Object captureFromApplets = m.invoke(registry, arguments = new Object[]{"secure.allowCaptureFromApplets"});
            if (captureFromApplets == null || !(captureFromApplets instanceof Boolean) || !((Boolean)captureFromApplets).booleanValue()) {
                if (Printer.debug) {
                    Printer.debug("    record permission denied by Registry");
                }
                throw new SecurityException("record permission denied");
            }
        }
        catch (ClassNotFoundException e1) {
            if (Printer.debug) {
                Printer.debug("caught ClassNotFoundException");
            }
            throw new SecurityException("record permission denied");
        }
        catch (InvocationTargetException e2) {
            if (Printer.debug) {
                Printer.debug("caught InvocationTargetException");
            }
            throw new SecurityException("record permission denied");
        }
        catch (IllegalAccessException e3) {
            if (Printer.debug) {
                Printer.debug("caught IllegalAccessException");
            }
            throw new SecurityException("record permission denied");
        }
        catch (NoSuchMethodException e4) {
            if (Printer.debug) {
                Printer.debug("caught NoSuchMethodException");
            }
            throw new SecurityException("record permission denied");
        }
    }

    public static boolean isLinkPermissionEnabled() {
        if (security == null) {
            return true;
        }
        return security.isLinkPermissionEnabled();
    }

    public static void loadLibrary(String name) throws UnsatisfiedLinkError {
        try {
            JSSecurity s = JSSecurityManager.getJSSecurity();
            if (s != null) {
                s.loadLibrary(name);
            } else {
                System.loadLibrary(name);
            }
        }
        catch (Throwable t) {
            throw new UnsatisfiedLinkError("JSSecurityManager: " + t);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        boolean msjvm;
        boolean jdk11;
        boolean jdk12;
        block28: {
            security = null;
            securityManager = System.getSecurityManager();
            jdk12 = false;
            jdk11 = false;
            msjvm = false;
            try {
                String javaVendor;
                String javaVersion = System.getProperty("java.version");
                if (Printer.debug) {
                    Printer.debug("javaVersion " + javaVersion);
                }
                if (!javaVersion.equals("")) {
                    if (javaVersion.startsWith("1.1")) {
                        if (Printer.debug) {
                            Printer.debug("JDK 1.1.x");
                        }
                        jdk11 = true;
                    } else {
                        jdk12 = true;
                        if (Printer.debug) {
                            Printer.debug("JDK 1.2 and up");
                        }
                    }
                }
                if ((javaVendor = System.getProperty("java.vendor", "Sun").toLowerCase()).indexOf("icrosoft") > 0) {
                    msjvm = true;
                }
            }
            catch (Throwable t) {
                if (!Printer.debug) break block28;
                Printer.debug("Exception caught: " + t);
            }
        }
        if (securityManager != null) {
            if (Printer.debug) {
                Printer.debug("securityManager: " + securityManager);
            }
            if (securityManager.toString().indexOf("netscape") != -1) {
                if (Printer.debug) {
                    Printer.debug("NetscapeSecurity");
                }
                security = NetscapeSecurity.security;
            } else if (securityManager.toString().indexOf("com.ms.security") != -1 || msjvm) {
                if (Printer.debug) {
                    Printer.debug("IESecurity");
                }
                security = IESecurity.security;
            } else if (securityManager.toString().indexOf("sun.applet.AppletSecurity") != -1 || securityManager.toString().indexOf("sun.plugin.ActivatorSecurityManager") != -1) {
                if (jdk11) {
                    if (Printer.debug) {
                        Printer.debug("DefaultSecurity");
                    }
                    security = DefaultSecurity.security;
                }
                if (jdk12) {
                    if (Printer.debug) {
                        Printer.debug("JDK12Security for applets");
                    }
                    security = JDK12Security.security;
                }
            } else if (securityManager.toString().indexOf("java.lang.SecurityManager") != -1) {
                if (jdk12) {
                    if (Printer.debug) {
                        Printer.debug("JDK12Security");
                    }
                    security = JDK12Security.security;
                }
            } else {
                if (Printer.debug) {
                    Printer.debug("unknown security manager");
                }
                security = jdk12 ? JDK12Security.security : DefaultSecurity.security;
            }
        }
    }
}

