/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dct;

import java.util.concurrent.Future;
import org.jtransforms.fft.DoubleFFT_1D;
import org.jtransforms.utils.CommonUtils;
import org.jtransforms.utils.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.LongLargeArray;
import pl.edu.icm.jlargearrays.Utilities;

public class DoubleDCT_1D {
    private int n;
    private long nl;
    private int[] ip;
    private LongLargeArray ipl;
    private double[] w;
    private DoubleLargeArray wl;
    private int nw;
    private long nwl;
    private int nc;
    private long ncl;
    private boolean isPowerOfTwo = false;
    private DoubleFFT_1D fft;
    private static final double PI = Math.PI;
    private boolean useLargeArrays;

    public DoubleDCT_1D(long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("n must be greater than 0");
        }
        boolean bl = this.useLargeArrays = l >= ConcurrencyUtils.getLargeArraysBeginN();
        if (!this.useLargeArrays) {
            if (l > 0x10000000L) {
                throw new IllegalArgumentException("n must be smaller or equal to 268435456 when useLargeArrays argument is set to false");
            }
            this.n = (int)l;
            if (ConcurrencyUtils.isPowerOf2(l)) {
                this.isPowerOfTwo = true;
                this.ip = new int[(int)Math.ceil(2 + (1 << (int)(Math.log((double)(l / 2L) + 0.5) / Math.log(2.0)) / 2))];
                this.w = new double[this.n * 5 / 4];
                this.nw = this.ip[0];
                if (l > (long)(this.nw << 2)) {
                    this.nw = this.n >> 2;
                    CommonUtils.makewt(this.nw, this.ip, this.w);
                }
                this.nc = this.ip[1];
                if (l > (long)this.nc) {
                    this.nc = this.n;
                    CommonUtils.makect(this.nc, this.w, this.nw, this.ip);
                }
            } else {
                this.w = this.makect(this.n);
                this.fft = new DoubleFFT_1D(2L * l);
            }
        } else {
            this.nl = l;
            if (ConcurrencyUtils.isPowerOf2(l)) {
                this.isPowerOfTwo = true;
                this.ipl = new LongLargeArray((long)Math.ceil(2L + (1L << (int)((long)(Math.log((double)(l / 2L) + 0.5) / Math.log(2.0)) / 2L))), false);
                this.wl = new DoubleLargeArray(this.nl * 5L / 4L, false);
                this.nwl = this.ipl.getLong(0L);
                if (l > this.nwl << 2) {
                    this.nwl = this.nl >> 2;
                    CommonUtils.makewt(this.nwl, this.ipl, this.wl);
                }
                this.ncl = this.ipl.getLong(1L);
                if (l > this.ncl) {
                    this.ncl = this.nl;
                    CommonUtils.makect(this.ncl, this.wl, this.nwl, this.ipl);
                }
            } else {
                this.wl = this.makect(l);
                this.fft = new DoubleFFT_1D(2L * l);
            }
        }
    }

    public void forward(double[] dArray, boolean bl) {
        this.forward(dArray, 0, bl);
    }

    public void forward(DoubleLargeArray doubleLargeArray, boolean bl) {
        this.forward(doubleLargeArray, 0L, bl);
    }

    public void forward(final double[] dArray, final int n, boolean bl) {
        if (this.n == 1) {
            return;
        }
        if (this.useLargeArrays) {
            this.forward(new DoubleLargeArray(dArray), (long)n, bl);
        } else if (this.isPowerOfTwo) {
            double d = dArray[n + this.n - 1];
            for (int i = this.n - 2; i >= 2; i -= 2) {
                dArray[n + i + 1] = dArray[n + i] - dArray[n + i - 1];
                int n2 = n + i;
                dArray[n2] = dArray[n2] + dArray[n + i - 1];
            }
            dArray[n + 1] = dArray[n] - d;
            int n3 = n;
            dArray[n3] = dArray[n3] + d;
            if (this.n > 4) {
                DoubleDCT_1D.rftbsub(this.n, dArray, n, this.nc, this.w, this.nw);
                CommonUtils.cftbsub(this.n, dArray, n, this.ip, this.nw, this.w);
            } else if (this.n == 4) {
                CommonUtils.cftbsub(this.n, dArray, n, this.ip, this.nw, this.w);
            }
            CommonUtils.dctsub(this.n, dArray, n, this.nc, this.w, this.nw);
            if (bl) {
                CommonUtils.scale(this.n, Math.sqrt(2.0 / (double)this.n), dArray, n, false);
                dArray[n] = dArray[n] / Math.sqrt(2.0);
            }
        } else {
            int n4;
            int n5 = 2 * this.n;
            final double[] dArray2 = new double[n5];
            System.arraycopy(dArray, n, dArray2, 0, this.n);
            int n6 = ConcurrencyUtils.getNumberOfThreads();
            for (n4 = this.n; n4 < n5; ++n4) {
                dArray2[n4] = dArray2[n5 - n4 - 1];
            }
            this.fft.realForward(dArray2);
            if (n6 > 1 && (long)this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n6 = 2;
                n4 = this.n / n6;
                Future[] futureArray = new Future[n6];
                for (int i = 0; i < n6; ++i) {
                    final int n7 = i * n4;
                    final int n8 = i == n6 - 1 ? this.n : n7 + n4;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = n7; i < n8; ++i) {
                                int n3 = 2 * i;
                                int n2 = n + i;
                                dArray[n2] = DoubleDCT_1D.this.w[n3] * dArray2[n3] - DoubleDCT_1D.this.w[n3 + 1] * dArray2[n3 + 1];
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (n4 = 0; n4 < this.n; ++n4) {
                    int n9 = 2 * n4;
                    int n10 = n + n4;
                    dArray[n10] = this.w[n9] * dArray2[n9] - this.w[n9 + 1] * dArray2[n9 + 1];
                }
            }
            if (bl) {
                CommonUtils.scale(this.n, 1.0 / Math.sqrt(n5), dArray, n, false);
                dArray[n] = dArray[n] / Math.sqrt(2.0);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void forward(final DoubleLargeArray doubleLargeArray, final long l, boolean bl) {
        if (this.nl == 1L) {
            return;
        }
        if (!this.useLargeArrays) {
            if (doubleLargeArray.getData() == null || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.forward(doubleLargeArray.getData(), (int)l, bl);
            return;
        } else if (this.isPowerOfTwo) {
            double d = doubleLargeArray.getDouble(l + this.nl - 1L);
            for (long i = this.nl - 2L; i >= 2L; i -= 2L) {
                doubleLargeArray.setDouble(l + i + 1L, doubleLargeArray.getDouble(l + i) - doubleLargeArray.getDouble(l + i - 1L));
                doubleLargeArray.setDouble(l + i, doubleLargeArray.getDouble(l + i) + doubleLargeArray.getDouble(l + i - 1L));
            }
            doubleLargeArray.setDouble(l + 1L, doubleLargeArray.getDouble(l) - d);
            doubleLargeArray.setDouble(l, doubleLargeArray.getDouble(l) + d);
            if (this.nl > 4L) {
                DoubleDCT_1D.rftbsub(this.nl, doubleLargeArray, l, this.ncl, this.wl, this.nwl);
                CommonUtils.cftbsub(this.nl, doubleLargeArray, l, this.ipl, this.nwl, this.wl);
            } else if (this.nl == 4L) {
                CommonUtils.cftbsub(this.nl, doubleLargeArray, l, this.ipl, this.nwl, this.wl);
            }
            CommonUtils.dctsub(this.nl, doubleLargeArray, l, this.ncl, this.wl, this.nwl);
            if (!bl) return;
            CommonUtils.scale(this.nl, Math.sqrt(2.0 / (double)this.nl), doubleLargeArray, l, false);
            doubleLargeArray.setDouble(l, doubleLargeArray.getDouble(l) / Math.sqrt(2.0));
            return;
        } else {
            long l2;
            long l3 = 2L * this.nl;
            final DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(l3, false);
            Utilities.arraycopy(doubleLargeArray, l, doubleLargeArray2, 0L, this.nl);
            int n = ConcurrencyUtils.getNumberOfThreads();
            for (l2 = this.nl; l2 < l3; ++l2) {
                doubleLargeArray2.setDouble(l2, doubleLargeArray2.getDouble(l3 - l2 - 1L));
            }
            this.fft.realForward(doubleLargeArray2);
            if (n > 1 && this.nl > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n = 2;
                l2 = this.nl / (long)n;
                Future[] futureArray = new Future[n];
                for (int i = 0; i < n; ++i) {
                    final long l4 = (long)i * l2;
                    final long l5 = i == n - 1 ? this.nl : l4 + l2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i = l4; i < l5; ++i) {
                                long l3 = 2L * i;
                                long l2 = l + i;
                                doubleLargeArray.setDouble(l2, DoubleDCT_1D.this.wl.getDouble(l3) * doubleLargeArray2.getDouble(l3) - DoubleDCT_1D.this.wl.getDouble(l3 + 1L) * doubleLargeArray2.getDouble(l3 + 1L));
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (l2 = 0L; l2 < this.nl; ++l2) {
                    long l6 = 2L * l2;
                    long l7 = l + l2;
                    doubleLargeArray.setDouble(l7, this.wl.getDouble(l6) * doubleLargeArray2.getDouble(l6) - this.wl.getDouble(l6 + 1L) * doubleLargeArray2.getDouble(l6 + 1L));
                }
            }
            if (!bl) return;
            CommonUtils.scale(this.nl, 1.0 / Math.sqrt(l3), doubleLargeArray, l, false);
            doubleLargeArray.setDouble(l, doubleLargeArray.getDouble(l) / Math.sqrt(2.0));
        }
    }

    public void inverse(double[] dArray, boolean bl) {
        this.inverse(dArray, 0, bl);
    }

    public void inverse(DoubleLargeArray doubleLargeArray, boolean bl) {
        this.inverse(doubleLargeArray, 0L, bl);
    }

    public void inverse(final double[] dArray, final int n, boolean bl) {
        if (this.n == 1) {
            return;
        }
        if (this.useLargeArrays) {
            this.inverse(new DoubleLargeArray(dArray), (long)n, bl);
        } else if (this.isPowerOfTwo) {
            if (bl) {
                CommonUtils.scale(this.n, Math.sqrt(2.0 / (double)this.n), dArray, n, false);
                dArray[n] = dArray[n] / Math.sqrt(2.0);
            }
            CommonUtils.dctsub(this.n, dArray, n, this.nc, this.w, this.nw);
            if (this.n > 4) {
                CommonUtils.cftfsub(this.n, dArray, n, this.ip, this.nw, this.w);
                DoubleDCT_1D.rftfsub(this.n, dArray, n, this.nc, this.w, this.nw);
            } else if (this.n == 4) {
                CommonUtils.cftfsub(this.n, dArray, n, this.ip, this.nw, this.w);
            }
            double d = dArray[n] - dArray[n + 1];
            int n2 = n;
            dArray[n2] = dArray[n2] + dArray[n + 1];
            for (int i = 2; i < this.n; i += 2) {
                dArray[n + i - 1] = dArray[n + i] - dArray[n + i + 1];
                int n3 = n + i;
                dArray[n3] = dArray[n3] + dArray[n + i + 1];
            }
            dArray[n + this.n - 1] = d;
        } else {
            int n4 = 2 * this.n;
            if (bl) {
                CommonUtils.scale(this.n, Math.sqrt(n4), dArray, n, false);
                dArray[n] = dArray[n] * Math.sqrt(2.0);
            }
            final double[] dArray2 = new double[n4];
            int n5 = ConcurrencyUtils.getNumberOfThreads();
            if (n5 > 1 && (long)this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n5 = 2;
                int n6 = this.n / n5;
                Future[] futureArray = new Future[n5];
                for (int i = 0; i < n5; ++i) {
                    final int n7 = i * n6;
                    final int n8 = i == n5 - 1 ? this.n : n7 + n6;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = n7; i < n8; ++i) {
                                int n2 = 2 * i;
                                double d = dArray[n + i];
                                dArray2[n2] = DoubleDCT_1D.this.w[n2] * d;
                                dArray2[n2 + 1] = -DoubleDCT_1D.this.w[n2 + 1] * d;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < this.n; ++i) {
                    int n9 = 2 * i;
                    double d = dArray[n + i];
                    dArray2[n9] = this.w[n9] * d;
                    dArray2[n9 + 1] = -this.w[n9 + 1] * d;
                }
            }
            this.fft.realInverse(dArray2, true);
            System.arraycopy(dArray2, 0, dArray, n, this.n);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void inverse(final DoubleLargeArray doubleLargeArray, final long l, boolean bl) {
        if (this.nl == 1L) {
            return;
        }
        if (!this.useLargeArrays) {
            if (doubleLargeArray.getData() == null || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.inverse(doubleLargeArray.getData(), (int)l, bl);
            return;
        } else if (this.isPowerOfTwo) {
            if (bl) {
                CommonUtils.scale(this.nl, Math.sqrt(2.0 / (double)this.nl), doubleLargeArray, l, false);
                doubleLargeArray.setDouble(l, doubleLargeArray.getDouble(l) / Math.sqrt(2.0));
            }
            CommonUtils.dctsub(this.nl, doubleLargeArray, l, this.ncl, this.wl, this.nwl);
            if (this.nl > 4L) {
                CommonUtils.cftfsub(this.nl, doubleLargeArray, l, this.ipl, this.nwl, this.wl);
                DoubleDCT_1D.rftfsub(this.nl, doubleLargeArray, l, this.ncl, this.wl, this.nwl);
            } else if (this.nl == 4L) {
                CommonUtils.cftfsub(this.nl, doubleLargeArray, l, this.ipl, this.nwl, this.wl);
            }
            double d = doubleLargeArray.getDouble(l) - doubleLargeArray.getDouble(l + 1L);
            doubleLargeArray.setDouble(l, doubleLargeArray.getDouble(l) + doubleLargeArray.getDouble(l + 1L));
            for (long i = 2L; i < this.nl; i += 2L) {
                doubleLargeArray.setDouble(l + i - 1L, doubleLargeArray.getDouble(l + i) - doubleLargeArray.getDouble(l + i + 1L));
                doubleLargeArray.setDouble(l + i, doubleLargeArray.getDouble(l + i) + doubleLargeArray.getDouble(l + i + 1L));
            }
            doubleLargeArray.setDouble(l + this.nl - 1L, d);
            return;
        } else {
            long l2 = 2L * this.nl;
            if (bl) {
                CommonUtils.scale(this.nl, Math.sqrt(l2), doubleLargeArray, l, false);
                doubleLargeArray.setDouble(l, doubleLargeArray.getDouble(l) * Math.sqrt(2.0));
            }
            final DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(l2, false);
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.nl > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n = 2;
                long l3 = this.nl / (long)n;
                Future[] futureArray = new Future[n];
                for (int i = 0; i < n; ++i) {
                    final long l4 = (long)i * l3;
                    final long l5 = i == n - 1 ? this.nl : l4 + l3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i = l4; i < l5; ++i) {
                                long l2 = 2L * i;
                                double d = doubleLargeArray.getDouble(l + i);
                                doubleLargeArray2.setDouble(l2, DoubleDCT_1D.this.wl.getDouble(l2) * d);
                                doubleLargeArray2.setDouble(l2 + 1L, -DoubleDCT_1D.this.wl.getDouble(l2 + 1L) * d);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (long i = 0L; i < this.nl; ++i) {
                    long l6 = 2L * i;
                    double d = doubleLargeArray.getDouble(l + i);
                    doubleLargeArray2.setDouble(l6, this.wl.getDouble(l6) * d);
                    doubleLargeArray2.setDouble(l6 + 1L, -this.wl.getDouble(l6 + 1L) * d);
                }
            }
            this.fft.realInverse(doubleLargeArray2, true);
            Utilities.arraycopy(doubleLargeArray2, 0L, doubleLargeArray, l, this.nl);
        }
    }

    private double[] makect(int n) {
        int n2 = 2 * n;
        double d = Math.PI / (double)n2;
        double[] dArray = new double[n2];
        dArray[0] = 1.0;
        for (int i = 1; i < n; ++i) {
            int n3 = 2 * i;
            double d2 = d * (double)i;
            dArray[n3] = Math.cos(d2);
            dArray[n3 + 1] = -Math.sin(d2);
        }
        return dArray;
    }

    private DoubleLargeArray makect(long l) {
        long l2 = 2L * l;
        double d = Math.PI / (double)l2;
        DoubleLargeArray doubleLargeArray = new DoubleLargeArray(l2, false);
        doubleLargeArray.setDouble(0L, 1.0);
        for (long i = 1L; i < l; ++i) {
            long l3 = 2L * i;
            double d2 = d * (double)i;
            doubleLargeArray.setDouble(l3, Math.cos(d2));
            doubleLargeArray.setDouble(l3 + 1L, -Math.sin(d2));
        }
        return doubleLargeArray;
    }

    private static void rftfsub(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4) {
        int n5 = n >> 1;
        int n6 = 2 * n3 / n5;
        int n7 = 0;
        for (int i = 2; i < n5; i += 2) {
            int n8 = n - i;
            double d = 0.5 - dArray2[n4 + n3 - (n7 += n6)];
            double d2 = dArray2[n4 + n7];
            int n9 = n2 + i;
            int n10 = n2 + n8;
            double d3 = dArray[n9] - dArray[n10];
            double d4 = dArray[n9 + 1] + dArray[n10 + 1];
            double d5 = d * d3 - d2 * d4;
            double d6 = d * d4 + d2 * d3;
            int n11 = n9;
            dArray[n11] = dArray[n11] - d5;
            int n12 = n9 + 1;
            dArray[n12] = dArray[n12] - d6;
            int n13 = n10;
            dArray[n13] = dArray[n13] + d5;
            int n14 = n10 + 1;
            dArray[n14] = dArray[n14] - d6;
        }
    }

    private static void rftfsub(long l, DoubleLargeArray doubleLargeArray, long l2, long l3, DoubleLargeArray doubleLargeArray2, long l4) {
        long l5 = l >> 1;
        long l6 = 2L * l3 / l5;
        long l7 = 0L;
        for (long i = 2L; i < l5; i += 2L) {
            long l8 = l - i;
            double d = 0.5 - doubleLargeArray2.getDouble(l4 + l3 - (l7 += l6));
            double d2 = doubleLargeArray2.getDouble(l4 + l7);
            long l9 = l2 + i;
            long l10 = l2 + l8;
            double d3 = doubleLargeArray.getDouble(l9) - doubleLargeArray.getDouble(l10);
            double d4 = doubleLargeArray.getDouble(l9 + 1L) + doubleLargeArray.getDouble(l10 + 1L);
            double d5 = d * d3 - d2 * d4;
            double d6 = d * d4 + d2 * d3;
            doubleLargeArray.setDouble(l9, doubleLargeArray.getDouble(l9) - d5);
            doubleLargeArray.setDouble(l9 + 1L, doubleLargeArray.getDouble(l9 + 1L) - d6);
            doubleLargeArray.setDouble(l10, doubleLargeArray.getDouble(l10) + d5);
            doubleLargeArray.setDouble(l10 + 1L, doubleLargeArray.getDouble(l10 + 1L) - d6);
        }
    }

    private static void rftbsub(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4) {
        int n5 = n >> 1;
        int n6 = 2 * n3 / n5;
        int n7 = 0;
        for (int i = 2; i < n5; i += 2) {
            int n8 = n - i;
            double d = 0.5 - dArray2[n4 + n3 - (n7 += n6)];
            double d2 = dArray2[n4 + n7];
            int n9 = n2 + i;
            int n10 = n2 + n8;
            double d3 = dArray[n9] - dArray[n10];
            double d4 = dArray[n9 + 1] + dArray[n10 + 1];
            double d5 = d * d3 + d2 * d4;
            double d6 = d * d4 - d2 * d3;
            int n11 = n9;
            dArray[n11] = dArray[n11] - d5;
            int n12 = n9 + 1;
            dArray[n12] = dArray[n12] - d6;
            int n13 = n10;
            dArray[n13] = dArray[n13] + d5;
            int n14 = n10 + 1;
            dArray[n14] = dArray[n14] - d6;
        }
    }

    private static void rftbsub(long l, DoubleLargeArray doubleLargeArray, long l2, long l3, DoubleLargeArray doubleLargeArray2, long l4) {
        long l5 = l >> 1;
        long l6 = 2L * l3 / l5;
        long l7 = 0L;
        for (long i = 2L; i < l5; i += 2L) {
            long l8 = l - i;
            double d = 0.5 - doubleLargeArray2.getDouble(l4 + l3 - (l7 += l6));
            double d2 = doubleLargeArray2.getDouble(l4 + l7);
            long l9 = l2 + i;
            long l10 = l2 + l8;
            double d3 = doubleLargeArray.getDouble(l9) - doubleLargeArray.getDouble(l10);
            double d4 = doubleLargeArray.getDouble(l9 + 1L) + doubleLargeArray.getDouble(l10 + 1L);
            double d5 = d * d3 + d2 * d4;
            double d6 = d * d4 - d2 * d3;
            doubleLargeArray.setDouble(l9, doubleLargeArray.getDouble(l9) - d5);
            doubleLargeArray.setDouble(l9 + 1L, doubleLargeArray.getDouble(l9 + 1L) - d6);
            doubleLargeArray.setDouble(l10, doubleLargeArray.getDouble(l10) + d5);
            doubleLargeArray.setDouble(l10 + 1L, doubleLargeArray.getDouble(l10 + 1L) - d6);
        }
    }
}

