/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeMap;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DFuzzy;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageInt;
import mcib3d.utils.exceptionPrinter;

public class Object3DFactory {
    ImageFloat SP;
    ImageInt S;
    double scaleXY;
    double scaleZ;
    double XX;
    double XZ;
    int sizeXY;
    int sizeX;
    int sizeY;
    int sizeZ;
    int limX;
    int limY;
    int limZ;
    private TreeMap<Integer, HashMap<Integer, Voxel3D>> objects;

    public Object3DFactory(ImageInt imageInt) {
        if (imageInt == null) {
            return;
        }
        this.S = imageInt;
        this.scaleXY = imageInt.getScaleXY();
        this.scaleZ = imageInt.getScaleZ();
        this.XZ = this.scaleXY * this.scaleZ;
        this.XX = this.scaleXY * this.scaleXY;
        this.sizeXY = imageInt.sizeXY;
        this.sizeX = imageInt.sizeX;
        this.sizeY = imageInt.sizeY;
        this.sizeZ = imageInt.sizeZ;
        this.limX = this.sizeX - 1;
        this.limY = this.sizeY - 1;
        this.limZ = this.sizeZ - 1;
    }

    /*
     * WARNING - void declaration
     */
    public Object3DFuzzy[] getFuzzyObjects(float f, ImageFloat imageFloat) {
        try {
            this.SP = imageFloat;
            this.objects = new TreeMap();
            for (int i = 0; i < this.sizeZ; ++i) {
                for (int j = 0; j < this.sizeXY; ++j) {
                    if (this.S.getPixel(j, i) == 0.0f) continue;
                    this.addVoxel(j % this.sizeX, j / this.sizeX, i, this.S.getPixelInt(j, i), this.SP.pixels[i][j]);
                }
            }
            ArrayList<Object3DFuzzy> arrayList = new ArrayList<Object3DFuzzy>(this.objects.size());
            Object3DFuzzy[] object3DFuzzyArray = this.objects.keySet().iterator();
            while (object3DFuzzyArray.hasNext()) {
                int n = object3DFuzzyArray.next();
                Object3DFuzzy object3DFuzzy = new Object3DFuzzy(n, new ArrayList<Voxel3D>(this.objects.get(n).values()));
                HashMap<Integer, Voxel3D> hashMap = this.objects.get(n);
                boolean bl = true;
                while (bl) {
                    bl = false;
                    for (Voxel3D voxel3D : hashMap.values()) {
                        if (this.S.getPixelInt(voxel3D.getRoundX(), voxel3D.getRoundY(), voxel3D.getRoundZ()) != n || !this.isContour(voxel3D, n) || !(this.SP.getPixel(voxel3D.getRoundX(), voxel3D.getRoundY(), voxel3D.getRoundZ()) < f)) continue;
                        this.S.setPixel(voxel3D.getRoundX(), voxel3D.getRoundY(), voxel3D.getRoundZ(), 0);
                        bl = true;
                    }
                }
                ArrayList arrayList2 = new ArrayList();
                for (Voxel3D voxel3D : hashMap.values()) {
                    if (this.S.getPixelInt(voxel3D.getRoundX(), voxel3D.getRoundY(), voxel3D.getRoundZ()) != n || !this.isContour(voxel3D, n)) continue;
                    arrayList2.add(voxel3D);
                }
                if (arrayList2.isEmpty()) {
                    void var10_18;
                    Object var10_17 = null;
                    float f2 = 0.0f;
                    for (Voxel3D voxel3D : hashMap.values()) {
                        if (!(this.SP.getPixel(voxel3D.getRoundX(), voxel3D.getRoundY(), voxel3D.getRoundZ()) > f2)) continue;
                        f2 = this.SP.getPixel(voxel3D.getRoundX(), voxel3D.getRoundY(), voxel3D.getRoundZ());
                        Voxel3D voxel3D2 = voxel3D;
                    }
                    arrayList2.add(var10_18);
                }
                arrayList2.trimToSize();
                for (Voxel3D voxel3D : hashMap.values()) {
                    this.S.setPixel(voxel3D.getRoundX(), voxel3D.getRoundY(), voxel3D.getRoundZ(), n);
                }
                object3DFuzzy.setContours(arrayList2);
                object3DFuzzy.setResXY(this.scaleXY);
                object3DFuzzy.setResZ(this.scaleZ);
                arrayList.add(object3DFuzzy);
            }
            object3DFuzzyArray = new Object3DFuzzy[arrayList.size()];
            object3DFuzzyArray = arrayList.toArray(object3DFuzzyArray);
            return object3DFuzzyArray;
        }
        catch (Exception exception) {
            exceptionPrinter.print(exception, "", true);
            return null;
        }
    }

    public Object3DVoxels[] getObjects() {
        this.objects = new TreeMap();
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeXY; ++j) {
                if (this.S.getPixelInt(j, i) == 0) continue;
                this.addVoxel(j % this.sizeX, j / this.sizeX, i, this.S.getPixelInt(j, i));
            }
        }
        ArrayList<Object3DVoxels> arrayList = new ArrayList<Object3DVoxels>(this.objects.size());
        Object3DVoxels[] object3DVoxelsArray = this.objects.keySet().iterator();
        while (object3DVoxelsArray.hasNext()) {
            int n = object3DVoxelsArray.next();
            Object3DVoxels object3DVoxels = new Object3DVoxels(new ArrayList<Voxel3D>(this.objects.get(n).values()));
            object3DVoxels.setValue(n);
            HashMap<Integer, Voxel3D> hashMap = this.objects.get(n);
            ArrayList<Voxel3D> arrayList2 = new ArrayList<Voxel3D>();
            double d = 0.0;
            for (Voxel3D voxel3D : hashMap.values()) {
                double d2 = this.getContourSurface(voxel3D, n);
                if (!(d2 > 0.0)) continue;
                d += d2;
                arrayList2.add(voxel3D);
            }
            object3DVoxels.setContours(arrayList2, d);
            object3DVoxels.setResXY(this.scaleXY);
            object3DVoxels.setResZ(this.scaleZ);
            object3DVoxels.setLabelImage(this.S);
            arrayList.add(object3DVoxels);
        }
        object3DVoxelsArray = new Object3DVoxels[arrayList.size()];
        object3DVoxelsArray = arrayList.toArray(object3DVoxelsArray);
        return object3DVoxelsArray;
    }

    private void addVoxel(int n, int n2, int n3, int n4, float f) {
        Voxel3D voxel3D = new Voxel3D(n, n2, n3, f);
        if (this.objects.containsKey(n4)) {
            this.objects.get(n4).put(n3 * this.sizeXY + n2 * this.sizeX + n, voxel3D);
        } else {
            int n5 = n3 * this.sizeXY + n2 * this.sizeX + n;
            HashMap<Integer, Voxel3D> hashMap = new HashMap<Integer, Voxel3D>();
            hashMap.put(n5, voxel3D);
            this.objects.put(n4, hashMap);
        }
    }

    private void addVoxel(int n, int n2, int n3, int n4) {
        Voxel3D voxel3D = new Voxel3D(n, n2, n3, n4);
        if (this.objects.containsKey(n4)) {
            this.objects.get(n4).put(n3 * this.sizeXY + n2 * this.sizeX + n, voxel3D);
        } else {
            HashMap<Integer, Voxel3D> hashMap = new HashMap<Integer, Voxel3D>();
            hashMap.put(n3 * this.sizeXY + n2 * this.sizeX + n, voxel3D);
            this.objects.put(n4, hashMap);
        }
    }

    private double getContourSurface(Voxel3D voxel3D, int n) {
        double d = 0.0;
        int n2 = voxel3D.getRoundX();
        int n3 = voxel3D.getRoundY();
        int n4 = voxel3D.getRoundZ();
        if (n2 < this.limX) {
            if (this.S.getPixelInt(n2 + 1, n3, n4) != n) {
                d += this.XZ;
            }
        } else {
            d += this.XZ;
        }
        if (n2 > 0) {
            if (this.S.getPixelInt(n2 - 1, n3, n4) != n) {
                d += this.XZ;
            }
        } else {
            d += this.XZ;
        }
        if (n3 < this.limY) {
            if (this.S.getPixelInt(n2, n3 + 1, n4) != n) {
                d += this.XZ;
            }
        } else {
            d += this.XZ;
        }
        if (n3 > 0) {
            if (this.S.getPixelInt(n2, n3 - 1, n4) != n) {
                d += this.XZ;
            }
        } else {
            d += this.XZ;
        }
        if (n4 < this.limZ) {
            if (this.S.getPixelInt(n2, n3, n4 + 1) != n) {
                d += this.XX;
            }
        } else if (this.limZ > 0) {
            d += this.XX;
        }
        if (n4 > 0) {
            if (this.S.getPixelInt(n2, n3, n4 - 1) != n) {
                d += this.XX;
            }
        } else if (this.limZ > 0) {
            d += this.XX;
        }
        return d;
    }

    private boolean isContour(Voxel3D voxel3D, int n) {
        int n2 = voxel3D.getRoundX();
        int n3 = voxel3D.getRoundY();
        int n4 = voxel3D.getRoundZ();
        if (n2 < this.limX) {
            if (this.S.getPixelInt(voxel3D.getRoundX() + 1, voxel3D.getRoundY(), voxel3D.getRoundZ()) != n) {
                return true;
            }
        } else {
            return true;
        }
        if (n2 > 0) {
            if (this.S.getPixelInt(voxel3D.getRoundX() - 1, voxel3D.getRoundY(), voxel3D.getRoundZ()) != n) {
                return true;
            }
        } else {
            return true;
        }
        if (n3 < this.limY) {
            if (this.S.getPixelInt(voxel3D.getRoundX(), voxel3D.getRoundY() + 1, voxel3D.getRoundZ()) != n) {
                return true;
            }
        } else {
            return true;
        }
        if (n3 > 0) {
            if (this.S.getPixelInt(voxel3D.getRoundX(), voxel3D.getRoundY() - 1, voxel3D.getRoundZ()) != n) {
                return true;
            }
        } else {
            return true;
        }
        if (n4 < this.limZ ? this.S.getPixelInt(voxel3D.getRoundX(), voxel3D.getRoundY(), voxel3D.getRoundZ() + 1) != n : this.limZ > 0) {
            return true;
        }
        return n4 > 0 ? this.S.getPixelInt(voxel3D.getRoundX(), voxel3D.getRoundY(), voxel3D.getRoundZ() - 1) != n : this.limZ > 0;
    }

    public class ObjectValueComparator
    implements Comparator<Object3D> {
        @Override
        public int compare(Object3D object3D, Object3D object3D2) {
            if (object3D.getValue() < object3D2.getValue()) {
                return -1;
            }
            if (object3D.getValue() > object3D2.getValue()) {
                return 1;
            }
            return 0;
        }
    }
}

