/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d;

import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.NewImage;
import ij.plugin.CanvasResizer;
import ij.plugin.Resizer;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import mcib3d.geom.IntCoord3D;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Point3D;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.BlankMask;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.ImageStats;

public class ImageByte
extends ImageInt {
    public byte[][] pixels;

    public ImageByte(ImagePlus imagePlus) {
        super(imagePlus);
        this.buildPixels();
    }

    public ImageByte(ImageStack imageStack) {
        super(imageStack);
        this.buildPixels();
    }

    private void buildPixels() {
        this.pixels = new byte[this.sizeZ][];
        if (this.img.getImageStack() != null) {
            for (int i = 0; i < this.sizeZ; ++i) {
                this.pixels[i] = (byte[])this.img.getImageStack().getPixels(i + 1);
            }
        } else {
            ImageStack imageStack = new ImageStack(this.sizeX, this.sizeY);
            imageStack.addSlice(this.img.getProcessor());
            this.pixels[0] = (byte[])this.img.getProcessor().getPixels();
            this.img.setStack(null, imageStack);
        }
    }

    public ImageByte(byte[][] byArray, String string, int n) {
        super(string, n, byArray[0].length / n, byArray.length, 0, 0, 0);
        this.pixels = byArray;
        ImageStack imageStack = new ImageStack(n, this.sizeY, this.sizeZ);
        for (int i = 0; i < this.sizeZ; ++i) {
            imageStack.setPixels((Object)byArray[i], i + 1);
        }
        this.img = new ImagePlus(string, imageStack);
    }

    public ImageByte(String string, int n, int n2, int n3) {
        super(string, n, n2, n3);
        this.img = NewImage.createByteImage((String)string, (int)n, (int)n2, (int)n3, (int)1);
        this.pixels = new byte[n3][];
        for (int i = 0; i < n3; ++i) {
            this.pixels[i] = (byte[])this.img.getImageStack().getPixels(i + 1);
        }
    }

    protected ImageByte(int n, int n2, int n3) {
        super("blank mask", n, n2, n3);
    }

    public ImageByte(ImageHandler imageHandler, boolean bl) {
        super(imageHandler.title, imageHandler.sizeX, imageHandler.sizeY, imageHandler.sizeZ, imageHandler.offsetX, imageHandler.offsetY, imageHandler.offsetZ);
        ImageStats imageStats = this.getImageStats(null);
        if (imageHandler instanceof ImageShort) {
            ImageByte imageByte = ((ImageShort)imageHandler).convertToByte(bl);
            this.pixels = imageByte.pixels;
            this.img = imageByte.img;
            imageStats.setMinAndMax(0.0, 255.0);
        } else if (imageHandler instanceof ImageFloat) {
            if (imageHandler.img != null) {
                ImageByte imageByte = ((ImageFloat)imageHandler).convertToByte(bl);
                this.pixels = imageByte.pixels;
                this.img = imageByte.img;
                imageStats.setMinAndMax(0.0, 255.0);
            }
        } else {
            this.img = imageHandler.img;
            this.pixels = ((ImageByte)imageHandler).pixels;
        }
    }

    public static byte[] getArray1DByte(ImagePlus imagePlus) {
        byte[] byArray = new byte[imagePlus.getNSlices() * imagePlus.getWidth() * imagePlus.getHeight()];
        int n = 0;
        int n2 = imagePlus.getWidth() * imagePlus.getHeight();
        for (int i = 0; i < imagePlus.getNSlices(); ++i) {
            System.arraycopy((byte[])imagePlus.getImageStack().getPixels(i + 1), 0, byArray, n, n2);
            n += n2;
        }
        return byArray;
    }

    @Override
    public Object getArray1D() {
        byte[] byArray = new byte[this.sizeXYZ];
        int n = 0;
        for (int i = 0; i < this.img.getNSlices(); ++i) {
            System.arraycopy((byte[])this.img.getImageStack().getPixels(i + 1), 0, byArray, n, this.sizeXY);
            n += this.sizeXY;
        }
        return byArray;
    }

    @Override
    public Object getArray1D(int n) {
        byte[] byArray = new byte[this.sizeXY];
        System.arraycopy((byte[])this.img.getImageStack().getPixels(n + 1), 0, byArray, 0, this.sizeXY);
        return byArray;
    }

    public static ImagePlus getImagePlus(byte[] byArray, int n, int n2, int n3, boolean bl) {
        int n4;
        if (byArray == null) {
            return null;
        }
        ImagePlus imagePlus = NewImage.createShortImage((String)"", (int)n, (int)n2, (int)n3, (int)1);
        int n5 = 0;
        int n6 = n * n2;
        for (n4 = 0; n4 < n3; ++n4) {
            System.arraycopy(byArray, n5, (byte[])imagePlus.getImageStack().getPixels(n4 + 1), 0, n6);
            n5 += n6;
        }
        if (bl) {
            n4 = 0;
            int n7 = 0;
            for (int i = 0; i < byArray.length; ++i) {
                if ((byArray[i] & 0xFF) > n4) {
                    n4 = byArray[i] & 0xFF;
                }
                if ((byArray[i] & 0xFF) >= n7) continue;
                n7 = byArray[i] & 0xFF;
            }
            imagePlus.getProcessor().setMinAndMax((double)n7, (double)n4);
        }
        return imagePlus;
    }

    public ImageShort convertToShort(boolean bl) {
        if (bl) {
            this.setMinAndMax(null);
        }
        ImageStats imageStats = this.getImageStats(null);
        int n = this.img.getCurrentSlice();
        ImageStack imageStack = new ImageStack(this.sizeX, this.sizeY);
        ImageStack imageStack2 = this.img.getImageStack();
        for (int i = 1; i <= this.sizeZ; ++i) {
            String string = imageStack2.getSliceLabel(i);
            ImageProcessor imageProcessor = imageStack2.getProcessor(i);
            if (bl) {
                imageProcessor.setMinAndMax(imageStats.getMin(), imageStats.getMax());
            }
            imageStack.addSlice(string, imageProcessor.convertToShort(bl));
        }
        ImagePlus imagePlus = new ImagePlus(this.img.getTitle(), imageStack);
        imagePlus.setCalibration(this.img.getCalibration());
        imagePlus.setSlice(n);
        imagePlus.getProcessor().setMinAndMax(0.0, 255.0);
        return (ImageShort)ImageHandler.wrap(imagePlus);
    }

    public ImageFloat convertToFloat(boolean bl) {
        if (bl) {
            this.setMinAndMax(null);
        }
        ImageStats imageStats = this.getImageStats(null);
        int n = this.img.getCurrentSlice();
        ImageStack imageStack = new ImageStack(this.sizeX, this.sizeY);
        ImageStack imageStack2 = this.img.getImageStack();
        for (int i = 1; i <= this.sizeZ; ++i) {
            String string = imageStack2.getSliceLabel(i);
            ImageProcessor imageProcessor = imageStack2.getProcessor(i);
            if (bl) {
                imageProcessor.setMinAndMax(imageStats.getMin(), imageStats.getMax());
            }
            imageStack.addSlice(string, imageProcessor.convertToFloat());
        }
        ImagePlus imagePlus = new ImagePlus(this.img.getTitle(), imageStack);
        imagePlus.setCalibration(this.img.getCalibration());
        imagePlus.setSlice(n);
        imagePlus.getProcessor().setMinAndMax(0.0, 255.0);
        return (ImageFloat)ImageHandler.wrap(imagePlus);
    }

    public static byte[] convert(float[] fArray, boolean bl) {
        byte[] byArray = new byte[fArray.length];
        if (!bl) {
            for (int i = 0; i < fArray.length; ++i) {
                byArray[i] = (byte)(fArray[i] + 0.5f);
            }
        } else {
            float f = fArray[0];
            float f2 = fArray[0];
            float[] fArray2 = fArray;
            int n = fArray2.length;
            for (int i = 0; i < n; ++i) {
                float f3 = fArray2[i];
                if (f3 < f) {
                    f = f3;
                }
                if (!(f3 > f2)) continue;
                f2 = f3;
            }
            float f4 = 255.0f / (f2 - f);
            for (n = 0; n < fArray.length; ++n) {
                byArray[n] = (byte)((double)((fArray[n] - f) * f4) - 127.5);
            }
        }
        return byArray;
    }

    public static byte[] convert(short[] sArray, boolean bl) {
        byte[] byArray = new byte[sArray.length];
        if (!bl) {
            for (int i = 0; i < sArray.length; ++i) {
                byArray[i] = (byte)((float)sArray[i] + 0.5f);
            }
        } else {
            float f = sArray[0];
            float f2 = sArray[0];
            short[] sArray2 = sArray;
            int n = sArray2.length;
            for (int i = 0; i < n; ++i) {
                float f3 = sArray2[i];
                if (f3 < f) {
                    f = f3;
                }
                if (!(f3 > f2)) continue;
                f2 = f3;
            }
            float f4 = 255.0f / (f2 - f);
            for (n = 0; n < sArray.length; ++n) {
                byArray[n] = (byte)((double)(((float)sArray[n] - f) * f4) - 127.5);
            }
        }
        return byArray;
    }

    @Override
    public void erase() {
        int n;
        for (n = 0; n < this.sizeXY; ++n) {
            this.pixels[0][n] = 0;
        }
        for (n = 1; n < this.sizeZ; ++n) {
            System.arraycopy(this.pixels[0], 0, this.pixels[n], 0, this.sizeXY);
        }
    }

    @Override
    public void fill(double d) {
        int n;
        for (n = 0; n < this.sizeXY; ++n) {
            this.pixels[0][n] = (byte)d;
        }
        for (n = 1; n < this.sizeZ; ++n) {
            System.arraycopy(this.pixels[0], 0, this.pixels[n], 0, this.sizeXY);
        }
    }

    @Override
    public ImageByte duplicate() {
        ImageByte imageByte = new ImageByte(this.img.duplicate());
        imageByte.offsetX = this.offsetX;
        imageByte.offsetY = this.offsetY;
        imageByte.offsetZ = this.offsetZ;
        if (this.title != null) {
            imageByte.title = this.title;
        }
        return imageByte;
    }

    public void copy(ImageByte imageByte) {
        for (int i = 0; i < this.sizeZ; ++i) {
            System.arraycopy(this.pixels[i], 0, imageByte.pixels[i], 0, this.sizeXY);
        }
    }

    @Override
    public float getPixel(int n, int n2) {
        return this.pixels[n2][n] & 0xFF;
    }

    @Override
    public float getPixel(int n) {
        return this.pixels[n / this.sizeXY][n % this.sizeXY] & 0xFF;
    }

    public float getPixel(Voxel3D voxel3D, boolean bl) {
        return this.pixels[(int)voxel3D.getZ()][(int)voxel3D.getX() + (int)voxel3D.getY() * this.sizeX] & 0xFF;
    }

    @Override
    public float getPixel(int n, int n2, int n3) {
        return this.pixels[n3][n + n2 * this.sizeX] & 0xFF;
    }

    @Override
    public int getPixelInt(int n, int n2) {
        return this.pixels[n2][n] & 0xFF;
    }

    @Override
    public int getPixelInt(int n) {
        return this.pixels[n / this.sizeXY][n % this.sizeXY] & 0xFF;
    }

    @Override
    public int getPixelInt(int n, int n2, int n3) {
        return this.pixels[n3][n + n2 * this.sizeX] & 0xFF;
    }

    public float getPixel(IntCoord3D intCoord3D) {
        return this.pixels[intCoord3D.z][intCoord3D.x + intCoord3D.y * this.sizeX] & 0xFF;
    }

    public int getPixelInt(IntCoord3D intCoord3D) {
        return this.pixels[intCoord3D.z][intCoord3D.x + intCoord3D.y * this.sizeX] & 0xFF;
    }

    @Override
    public void setPixel(int n, float f) {
        this.pixels[n / this.sizeXY][n % this.sizeXY] = (byte)f;
    }

    @Override
    public void setPixel(Point3D point3D, float f) {
        this.pixels[(int)point3D.z][(int)point3D.x + (int)point3D.y * this.sizeX] = (byte)f;
    }

    @Override
    public void setPixel(int n, int n2, int n3, float f) {
        this.pixels[n3][n + n2 * this.sizeX] = (byte)f;
    }

    @Override
    public void setPixel(int n, int n2, float f) {
        this.pixels[n2][n] = (byte)((double)f + 0.5);
    }

    @Override
    public void setPixel(int n, int n2, int n3, int n4) {
        this.pixels[n3][n + n2 * this.sizeX] = (byte)n4;
    }

    @Override
    public void setPixel(int n, int n2, int n3) {
        this.pixels[n2][n] = (byte)n3;
    }

    @Override
    protected synchronized void getMinAndMax(ImageInt imageInt) {
        ImageStats imageStats = this.getImageStats(imageInt);
        if (imageStats.minAndMaxSet()) {
            return;
        }
        int n = 0;
        int n2 = 255;
        if (imageInt == null) {
            for (int i = 0; i < this.sizeZ; ++i) {
                for (int j = 0; j < this.sizeXY; ++j) {
                    if ((this.pixels[i][j] & 0xFF) > n) {
                        n = this.pixels[i][j] & 0xFF;
                    }
                    if ((this.pixels[i][j] & 0xFF) >= n2) continue;
                    n2 = this.pixels[i][j] & 0xFF;
                }
            }
        } else {
            for (int i = 0; i < this.sizeZ; ++i) {
                for (int j = 0; j < this.sizeXY; ++j) {
                    if (imageInt.getPixel(j, i) == 0.0f) continue;
                    if ((this.pixels[i][j] & 0xFF) > n) {
                        n = this.pixels[i][j] & 0xFF;
                    }
                    if ((this.pixels[i][j] & 0xFF) >= n2) continue;
                    n2 = this.pixels[i][j] & 0xFF;
                }
            }
        }
        imageStats.setMinAndMax(n2, n);
    }

    @Override
    protected int[] getHisto(ImageInt imageInt) {
        if (imageInt == null) {
            imageInt = new BlankMask(this);
        }
        this.getMinAndMax(imageInt);
        ImageStats imageStats = this.getImageStats(imageInt);
        int[] nArray = new int[256];
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeXY; ++j) {
                if (imageInt.getPixel(j, i) == 0.0f) continue;
                int n = this.pixels[i][j] & 0xFF;
                nArray[n] = nArray[n] + 1;
            }
        }
        imageStats.setHisto256(nArray, 1.0);
        return nArray;
    }

    @Override
    protected int[] getHisto(ImageInt imageInt, int n, double d, double d2) {
        if (imageInt == null) {
            imageInt = new BlankMask(this);
        }
        double d3 = (double)n / (d2 - d);
        int[] nArray = new int[n];
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeXY; ++j) {
                if (imageInt.getPixel(j, i) == 0.0f) continue;
                int n2 = (int)(((double)(this.pixels[i][j] & 0xFF) - d) * d3);
                if (n2 >= n) {
                    int n3 = nArray.length - 1;
                    nArray[n3] = nArray[n3] + 1;
                    continue;
                }
                int n4 = n2;
                nArray[n4] = nArray[n4] + 1;
            }
        }
        return nArray;
    }

    @Override
    public void eraseOutsideMask(ImageInt imageInt) {
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeXY; ++j) {
                if (imageInt.getPixel(j, i) != 0.0f) continue;
                this.pixels[i][j] = 0;
            }
        }
    }

    @Override
    public ImageByte threshold(float f, boolean bl, boolean bl2) {
        ImageByte imageByte;
        block9: {
            block11: {
                block10: {
                    block8: {
                        imageByte = new ImageByte(this.title + "thld", this.sizeX, this.sizeY, this.sizeZ);
                        imageByte.offsetX = this.offsetX;
                        imageByte.offsetY = this.offsetY;
                        imageByte.offsetZ = this.offsetZ;
                        if (bl || bl2) break block8;
                        for (int i = 0; i < this.sizeZ; ++i) {
                            for (int j = 0; j < this.sizeXY; ++j) {
                                if (!((float)(this.pixels[i][j] & 0xFF) >= f)) continue;
                                imageByte.pixels[i][j] = -1;
                            }
                        }
                        break block9;
                    }
                    if (bl || !bl2) break block10;
                    for (int i = 0; i < this.sizeZ; ++i) {
                        for (int j = 0; j < this.sizeXY; ++j) {
                            if (!((float)(this.pixels[i][j] & 0xFF) > f)) continue;
                            imageByte.pixels[i][j] = -1;
                        }
                    }
                    break block9;
                }
                if (!bl || bl2) break block11;
                for (int i = 0; i < this.sizeZ; ++i) {
                    for (int j = 0; j < this.sizeXY; ++j) {
                        if (!((float)(this.pixels[i][j] & 0xFF) <= f)) continue;
                        imageByte.pixels[i][j] = -1;
                    }
                }
                break block9;
            }
            if (!bl || !bl2) break block9;
            for (int i = 0; i < this.sizeZ; ++i) {
                for (int j = 0; j < this.sizeXY; ++j) {
                    if (!((float)(this.pixels[i][j] & 0xFF) < f)) continue;
                    imageByte.pixels[i][j] = -1;
                }
            }
        }
        return imageByte;
    }

    @Override
    public void thresholdCut(float f, boolean bl, boolean bl2) {
        block9: {
            block11: {
                block10: {
                    block8: {
                        if (bl || bl2) break block8;
                        for (int i = 0; i < this.sizeZ; ++i) {
                            for (int j = 0; j < this.sizeXY; ++j) {
                                if (!((float)(this.pixels[i][j] & 0xFF) < f)) continue;
                                this.pixels[i][j] = 0;
                            }
                        }
                        break block9;
                    }
                    if (bl || !bl2) break block10;
                    for (int i = 0; i < this.sizeZ; ++i) {
                        for (int j = 0; j < this.sizeXY; ++j) {
                            if (!((float)(this.pixels[i][j] & 0xFF) <= f)) continue;
                            this.pixels[i][j] = 0;
                        }
                    }
                    break block9;
                }
                if (!bl || bl2) break block11;
                for (int i = 0; i < this.sizeZ; ++i) {
                    for (int j = 0; j < this.sizeXY; ++j) {
                        if (!((float)(this.pixels[i][j] & 0xFF) > f)) continue;
                        this.pixels[i][j] = 0;
                    }
                }
                break block9;
            }
            if (!bl || !bl2) break block9;
            for (int i = 0; i < this.sizeZ; ++i) {
                for (int j = 0; j < this.sizeXY; ++j) {
                    if (!((float)(this.pixels[i][j] & 0xFF) >= f)) continue;
                    this.pixels[i][j] = 0;
                }
            }
        }
    }

    @Override
    public ImageByte crop3D(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n;
        int n8 = n5;
        int n9 = n3;
        int n10 = n2;
        int n11 = n4;
        int n12 = n6;
        int n13 = n10 - n7 + 1;
        int n14 = n11 - n9 + 1;
        int n15 = n12 - n8 + 1;
        ImageByte imageByte = new ImageByte(string, n13, n14, n15);
        imageByte.offsetX = n7;
        imageByte.offsetY = n9;
        imageByte.offsetZ = n8;
        imageByte.setScale(this);
        int n16 = -n8;
        int n17 = 0;
        int n18 = 0;
        if (n7 <= -1) {
            n7 = 0;
        }
        if (n10 >= this.sizeX) {
            n10 = this.sizeX - 1;
        }
        if (n9 <= -1) {
            n17 = -n13 * n9;
            n9 = 0;
        }
        if (n11 >= this.sizeY) {
            n11 = this.sizeY - 1;
        }
        if (n8 <= -1) {
            n8 = 0;
        }
        if (n12 >= this.sizeZ) {
            n12 = this.sizeZ - 1;
        }
        int n19 = n10 - n7 + 1;
        for (int i = n8; i <= n12; ++i) {
            int n20 = n9 * this.sizeX;
            int n21 = n17;
            for (int j = n9; j <= n11; ++j) {
                System.arraycopy(this.pixels[i], n20 + n7, imageByte.pixels[i + n16], n21 + n18, n19);
                n21 += n13;
                n20 += this.sizeX;
            }
        }
        return imageByte;
    }

    @Override
    public boolean shiftIndexes(TreeMap<Integer, int[]> treeMap) {
        boolean bl = false;
        int n = 1;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(treeMap.keySet());
        for (int i = 0; i < arrayList.size(); ++i) {
            int n2 = arrayList.get(i);
            if (n2 > n) {
                int[] nArray = treeMap.get(n2);
                for (int j = nArray[4]; j <= nArray[5]; ++j) {
                    for (int k = nArray[2]; k <= nArray[3]; ++k) {
                        for (int i2 = nArray[0]; i2 <= nArray[1]; ++i2) {
                            int n3 = i2 + k * this.sizeX;
                            if ((this.pixels[j][n3] & 0xFF) != n2) continue;
                            this.pixels[j][n3] = (byte)n;
                        }
                    }
                }
                bl = true;
                treeMap.remove(n2);
                treeMap.put(n, nArray);
            }
            ++n;
        }
        return bl;
    }

    public ImageByte[] crop3D(TreeMap<Integer, int[]> treeMap) {
        ImageByte[] imageByteArray = new ImageByte[treeMap.size()];
        ArrayList<Integer> arrayList = new ArrayList<Integer>(treeMap.keySet());
        for (int i = 0; i < imageByteArray.length; ++i) {
            int n = arrayList.get(i);
            int[] nArray = treeMap.get(n);
            imageByteArray[i] = this.crop3D(this.title + ":" + n, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5]);
        }
        return imageByteArray;
    }

    @Override
    public ImageByte crop3DMask(String string, ImageInt imageInt, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        ImageByte imageByte;
        block13: {
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            block12: {
                int n14 = n2;
                int n15 = n6;
                n13 = n4;
                n12 = n3;
                n11 = n5;
                n10 = n7;
                n9 = n12 - n14 + 1;
                int n16 = n11 - n13 + 1;
                int n17 = n10 - n15 + 1;
                imageByte = new ImageByte(string, n9, n16, n17);
                imageByte.offsetX = n14;
                imageByte.offsetY = n13;
                imageByte.offsetZ = n15;
                imageByte.setScale(this);
                int n18 = -n15;
                n8 = 0;
                int n19 = -n14;
                if (n14 <= -1) {
                    n14 = 0;
                }
                if (n12 >= this.sizeX) {
                    n12 = this.sizeX - 1;
                }
                if (n13 <= -1) {
                    n8 = -n9 * n13;
                    n13 = 0;
                }
                if (n11 >= this.sizeY) {
                    n11 = this.sizeY - 1;
                }
                if (n15 <= -1) {
                    n15 = 0;
                }
                if (n10 >= this.sizeZ) {
                    n10 = this.sizeZ - 1;
                }
                if (!(imageInt instanceof ImageShort)) break block12;
                ImageShort imageShort = (ImageShort)imageInt;
                for (int i = n15; i <= n10; ++i) {
                    int n20 = n13 * this.sizeX;
                    int n21 = n8;
                    for (int j = n13; j <= n11; ++j) {
                        for (int k = n14; k <= n12; ++k) {
                            if ((imageShort.pixels[i][n20 + k] & 0xFFFF) != n) continue;
                            imageByte.pixels[i + n18][n21 + k + n19] = this.pixels[i][n20 + k];
                        }
                        n21 += n9;
                        n20 += this.sizeX;
                    }
                }
                break block13;
            }
            if (!(imageInt instanceof ImageByte)) break block13;
            ImageByte imageByte2 = (ImageByte)imageInt;
            for (int i = n15; i <= n10; ++i) {
                int n22 = n13 * this.sizeX;
                int n23 = n8;
                for (int j = n13; j <= n11; ++j) {
                    for (int k = n14; k <= n12; ++k) {
                        if ((imageByte2.pixels[i][n22 + k] & 0xFF) != n) continue;
                        imageByte.pixels[i + n18][n23 + k + n19] = this.pixels[i][n22 + k];
                    }
                    n23 += n9;
                    n22 += this.sizeX;
                }
            }
        }
        return imageByte;
    }

    @Override
    public ImageByte crop3DBinary(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2;
        int n9 = n6;
        int n10 = n4;
        int n11 = n3;
        int n12 = n5;
        int n13 = n7;
        int n14 = n11 - n8 + 1;
        int n15 = n12 - n10 + 1;
        int n16 = n13 - n9 + 1;
        ImageByte imageByte = new ImageByte(string, n14, n15, n16);
        imageByte.offsetX = n8;
        imageByte.offsetY = n10;
        imageByte.offsetZ = n9;
        imageByte.setScale(this);
        int n17 = -n9;
        int n18 = 0;
        int n19 = -n8;
        if (n8 <= -1) {
            n8 = 0;
        }
        if (n11 >= this.sizeX) {
            n11 = this.sizeX - 1;
        }
        if (n10 <= -1) {
            n18 = -n14 * n10;
            n10 = 0;
        }
        if (n12 >= this.sizeY) {
            n12 = this.sizeY - 1;
        }
        if (n9 <= -1) {
            n9 = 0;
        }
        if (n13 >= this.sizeZ) {
            n13 = this.sizeZ - 1;
        }
        for (int i = n9; i <= n13; ++i) {
            int n20 = n10 * this.sizeX;
            int n21 = n18;
            for (int j = n10; j <= n12; ++j) {
                for (int k = n8; k <= n11; ++k) {
                    if ((this.pixels[i][n20 + k] & 0xFF) != n) continue;
                    imageByte.pixels[i + n17][n21 + k + n19] = -1;
                }
                n21 += n14;
                n20 += this.sizeX;
            }
        }
        return imageByte;
    }

    @Override
    public ImageHandler resize(int n, int n2, int n3) {
        int n4 = Math.max(1, this.sizeX + 2 * n);
        int n5 = Math.max(1, this.sizeY + 2 * n2);
        boolean bl = Prefs.get((String)"resizer.zero", (boolean)true);
        Prefs.set((String)"resizer.zero", (boolean)true);
        CanvasResizer canvasResizer = new CanvasResizer();
        ImageStack imageStack = canvasResizer.expandStack(this.img.getStack(), n4, n5, n, n2);
        if (!bl) {
            // empty if block
        }
        if (n3 > 0) {
            for (int i = 0; i < n3; ++i) {
                imageStack.addSlice("", (ImageProcessor)new ByteProcessor(n4, n5), 0);
                imageStack.addSlice("", (ImageProcessor)new ByteProcessor(n4, n5));
            }
        } else {
            for (int i = 0; i < -n3 && imageStack.getSize() > 2; ++i) {
                imageStack.deleteLastSlice();
                imageStack.deleteSlice(1);
            }
        }
        return new ImageByte(new ImagePlus(this.title + "::resized", imageStack));
    }

    @Override
    public ImageByte resample(int n, int n2, int n3, int n4) {
        ImagePlus imagePlus;
        Resizer resizer;
        if (n4 == -1) {
            n4 = 2;
        }
        if (n == this.sizeX && n2 == this.sizeY && n3 == this.sizeZ || n == 0 && n2 == 0 && n3 == 0) {
            return new ImageByte(this.img.duplicate());
        }
        if (n != 0 && n2 != 0 && n != this.sizeX && n2 != this.sizeY) {
            resizer = new StackProcessor(this.img.getImageStack(), this.img.getProcessor());
            imagePlus = new ImagePlus(this.title + "::resampled", resizer.resize(n, n2, true));
        } else {
            imagePlus = this.img;
        }
        if (n3 != 0 && n3 != this.sizeZ) {
            resizer = new Resizer();
            imagePlus = resizer.zScale(imagePlus, n3, n4);
        }
        return new ImageByte(imagePlus);
    }

    @Override
    public ImageByte resample(int n, int n2) {
        if (n2 == -1) {
            n2 = 2;
        }
        Resizer resizer = new Resizer();
        return new ImageByte(resizer.zScale(this.img, n, n2));
    }

    @Override
    protected ImageFloat normalize_(ImageInt imageInt, double d) {
        this.getMinAndMax(imageInt);
        ImageStats imageStats = this.getImageStats(imageInt);
        double d2 = imageStats.getMax();
        if (d > 0.0 && d < 1.0) {
            d2 = this.getPercentile(d, imageInt);
        }
        if (d2 <= imageStats.getMin()) {
            d2 = imageStats.getMin() + 1.0;
        }
        double d3 = 1.0 / (d2 - imageStats.getMin());
        double d4 = -imageStats.getMin() * d3;
        ImageFloat imageFloat = new ImageFloat(this.title + "::normalized", this.sizeX, this.sizeY, this.sizeZ);
        if (d > 0.0 && d < 1.0) {
            for (int i = 0; i < this.sizeZ; ++i) {
                for (int j = 0; j < this.sizeXY; ++j) {
                    imageFloat.pixels[i][j] = (float)((double)(this.pixels[i][j] & 0xFF) >= d2 ? 1.0 : (double)(this.pixels[i][j] & 0xFF) * d3 + d4);
                }
            }
        } else {
            for (int i = 0; i < this.sizeZ; ++i) {
                for (int j = 0; j < this.sizeXY; ++j) {
                    imageFloat.pixels[i][j] = (float)((double)(this.pixels[i][j] & 0xFF) * d3 + d4);
                }
            }
        }
        return imageFloat;
    }

    @Override
    public ImageFloat normalize(double d, double d2) {
        double d3 = 1.0 / (d2 - d);
        double d4 = -d * d3;
        ImageFloat imageFloat = new ImageFloat(this.title + "::normalized", this.sizeX, this.sizeY, this.sizeZ);
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeXY; ++j) {
                double d5 = this.pixels[i][j] & 0xFF;
                imageFloat.pixels[i][j] = d5 >= d2 ? 1.0f : (d5 <= d ? 0.0f : (float)(d5 * d3 + d4));
            }
        }
        return imageFloat;
    }

    @Override
    public void invert(ImageInt imageInt) {
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeXY; ++j) {
                this.pixels[i][j] = (byte)(255 - this.pixels[i][j]);
            }
        }
    }

    @Override
    public void draw(Object3D object3D, float f) {
        this.draw(object3D, (int)((double)f + 0.5));
    }

    @Override
    public void draw(Object3D object3D, int n) {
        Object3DVoxels object3DVoxels = !(object3D instanceof Object3DVoxels) ? object3D.getObject3DVoxels() : (Object3DVoxels)object3D;
        if (n > 255) {
            n = 255;
        }
        if (n < 0) {
            n = 0;
        }
        byte by = (byte)n;
        for (Voxel3D voxel3D : object3DVoxels.getVoxels()) {
            if (!this.contains(voxel3D.getX(), voxel3D.getY(), voxel3D.getZ())) continue;
            this.pixels[voxel3D.getRoundZ()][voxel3D.getRoundX() + voxel3D.getRoundY() * this.sizeX] = by;
        }
    }

    @Override
    protected void flushPixels() {
        if (this.pixels != null) {
            for (int i = 0; i < this.pixels.length; ++i) {
                this.pixels[i] = null;
            }
            this.pixels = null;
        }
    }

    @Override
    public boolean isOpened() {
        return this.pixels != null && this.img != null && this.img.getProcessor() != null;
    }

    @Override
    public float getPixel(Point3D point3D) {
        return this.pixels[point3D.getRoundZ()][point3D.getRoundX() + point3D.getRoundY() * this.sizeX] & 0xFF;
    }

    @Override
    public int getPixelInt(Point3D point3D) {
        return this.pixels[point3D.getRoundZ()][point3D.getRoundX() + point3D.getRoundY() * this.sizeX] & 0xFF;
    }

    @Override
    public float getPixelInterpolated(Point3D point3D) {
        return this.getPixel((float)point3D.getX(), (float)point3D.getY(), (float)point3D.getZ());
    }

    @Override
    public int getPixelIntInterpolated(Point3D point3D) {
        return (int)this.getPixel((float)point3D.getX(), (float)point3D.getY(), (float)point3D.getZ());
    }

    @Override
    public ImageHandler deleteSlices(int n, int n2) {
        int n3;
        int n4 = Math.min(n, n2);
        int n5 = Math.max(n, n2);
        int n6 = n5 - n4 + 1;
        int n7 = this.sizeZ - n6;
        ImageByte imageByte = new ImageByte("deleted slices", this.sizeX, this.sizeY, n7);
        for (n3 = 0; n3 < n4; ++n3) {
            System.arraycopy(this.pixels[n3], 0, imageByte.pixels[n3], 0, this.sizeXY);
        }
        for (n3 = n5 + 1; n3 < this.sizeZ; ++n3) {
            System.arraycopy(this.pixels[n3], 0, imageByte.pixels[n3 - n6], 0, this.sizeXY);
        }
        return imageByte;
    }

    @Override
    public void trimSlices(int n, int n2) {
        int n3 = Math.max(1, Math.min(n, n2));
        int n4 = Math.min(this.sizeZ, Math.max(n, n2));
        int n5 = n4 - n3 + 1;
        byte[][] byArrayArray = new byte[n5][];
        for (int i = 0; i < n5; ++i) {
            byArrayArray[i] = this.pixels[i + n3 - 1];
        }
        if (this.img != null) {
            int n6;
            ImageStack imageStack = this.img.getImageStack();
            for (n6 = 1; n6 < n3; ++n6) {
                imageStack.deleteSlice(1);
            }
            for (n6 = n4 + 1; n6 <= this.sizeZ; ++n6) {
                imageStack.deleteLastSlice();
            }
        }
        this.sizeZ = n5;
        this.sizeXYZ = this.sizeXY * this.sizeZ;
        this.offsetZ += n3 - 1;
        this.stats = new HashMap(2);
    }

    @Override
    public void intersectMask(ImageInt imageInt) {
        if (imageInt == null) {
            return;
        }
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeXY; ++j) {
                if (imageInt.getPixel(j, i) != 0.0f) continue;
                this.pixels[i][j] = 0;
            }
        }
    }

    public void substractMask(ImageInt imageInt) {
        if (imageInt == null) {
            return;
        }
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeXY; ++j) {
                if (imageInt.getPixel(j, i) == 0.0f) continue;
                this.pixels[i][j] = 0;
            }
        }
    }

    public void addMask(ImageInt imageInt) {
        if (imageInt == null) {
            return;
        }
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeXY; ++j) {
                if (imageInt.getPixel(j, i) == 0.0f) continue;
                this.pixels[i][j] = -1;
            }
        }
    }

    @Override
    public double getSizeInMb() {
        return (double)(this.sizeX * this.sizeY * this.sizeZ) / 1048576.0;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public ImageByte toMask() {
        ImageByte imageByte = new ImageByte("mask", this.sizeX, this.sizeY, this.sizeZ);
        imageByte.setScale(this);
        imageByte.setOffset(this);
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeXY; ++j) {
                if (this.pixels[i][j] == 0) continue;
                imageByte.pixels[i][j] = -1;
            }
        }
        return imageByte;
    }

    @Override
    public int countMaskVolume() {
        int n = 0;
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeXY; ++j) {
                if (this.pixels[i][j] == 0) continue;
                ++n;
            }
        }
        return n;
    }
}

