/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.NewImage;
import ij.plugin.CanvasResizer;
import ij.plugin.Resizer;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import mcib3d.geom.IntCoord3D;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Point3D;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.BlankMask;
import mcib3d.image3d.Coordinate3D;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.ImageStats;
import mcib3d.image3d.processing.FastFilters3D;
import mcib3d.utils.ArrayUtil;
import mcib3d.utils.ThreadUtil;

public class ImageFloat
extends ImageHandler {
    public float[][] pixels;

    public ImageFloat(ImagePlus imagePlus) {
        super(imagePlus);
        this.buildPixels();
    }

    public ImageFloat(ImageStack imageStack) {
        super(imageStack);
        this.buildPixels();
    }

    private void buildPixels() {
        this.pixels = new float[this.sizeZ][];
        if (this.img.getImageStack() != null) {
            for (int i = 0; i < this.sizeZ; ++i) {
                this.pixels[i] = (float[])this.img.getImageStack().getPixels(i + 1);
            }
        } else {
            ImageStack imageStack = new ImageStack(this.sizeX, this.sizeY);
            imageStack.addSlice(this.img.getProcessor());
            this.pixels[0] = (float[])this.img.getProcessor().getPixels();
            this.img.setStack(null, imageStack);
        }
    }

    public ImageFloat(float[][] fArray, String string, int n) {
        super(string, n, fArray[0].length / n, fArray.length, 0, 0, 0);
        this.pixels = fArray;
        ImageStack imageStack = new ImageStack(n, this.sizeY, this.sizeZ);
        for (int i = 0; i < this.sizeZ; ++i) {
            imageStack.setPixels((Object)fArray[i], i + 1);
        }
        this.img = new ImagePlus(string, imageStack);
    }

    public ImageFloat(String string, int n, int n2, int n3) {
        super(string, n, n2, n3);
        this.img = NewImage.createFloatImage((String)string, (int)n, (int)n2, (int)n3, (int)1);
        this.pixels = new float[n3][];
        for (int i = 0; i < n3; ++i) {
            this.pixels[i] = (float[])this.img.getImageStack().getPixels(i + 1);
        }
    }

    public ImageFloat(ImageHandler imageHandler) {
        super(imageHandler.title, imageHandler.sizeX, imageHandler.sizeY, imageHandler.sizeZ, imageHandler.offsetX, imageHandler.offsetY, imageHandler.offsetZ);
        ImageStats imageStats = this.getImageStats(null);
        if (imageHandler instanceof ImageShort) {
            if (imageHandler.img != null) {
                ImageFloat imageFloat = ((ImageShort)imageHandler).convertToFloat(false);
                this.pixels = imageFloat.pixels;
                this.img = imageFloat.img;
                imageStats.setMinAndMax(this.img.getProcessor().getMin(), this.img.getProcessor().getMax());
            }
        } else if (imageHandler instanceof ImageByte) {
            if (imageHandler.img != null) {
                ImageFloat imageFloat = ((ImageByte)imageHandler).convertToFloat(false);
                this.pixels = imageFloat.pixels;
                this.img = imageFloat.img;
                imageStats.setMinAndMax(this.img.getProcessor().getMin(), this.img.getProcessor().getMax());
            }
        } else {
            this.img = imageHandler.img;
            this.pixels = ((ImageFloat)imageHandler).pixels;
        }
    }

    public static ImageFloat newBlankImageFloat(String string, ImageHandler imageHandler) {
        ImageFloat imageFloat = new ImageFloat(string, imageHandler.sizeX, imageHandler.sizeY, imageHandler.sizeZ);
        imageFloat.setScale(imageHandler);
        imageFloat.setOffset(imageHandler);
        return imageFloat;
    }

    public ImageFloat(float[][] fArray) {
        super("matrix", fArray[0].length, fArray.length, 1);
        this.img = NewImage.createFloatImage((String)this.title, (int)this.sizeX, (int)this.sizeY, (int)this.sizeZ, (int)1);
        this.pixels = new float[1][];
        this.pixels[0] = (float[])this.img.getImageStack().getPixels(1);
        int n = 0;
        for (float[] fArray2 : fArray) {
            System.arraycopy(fArray2, 0, this.pixels[0], n, fArray2.length);
            n += this.sizeX;
        }
    }

    public static float[] getArray1DFloat(ImagePlus imagePlus) {
        float[] fArray = new float[imagePlus.getNSlices() * imagePlus.getWidth() * imagePlus.getHeight()];
        int n = 0;
        int n2 = imagePlus.getWidth() * imagePlus.getHeight();
        for (int i = 0; i < imagePlus.getNSlices(); ++i) {
            System.arraycopy((float[])imagePlus.getImageStack().getPixels(i + 1), 0, fArray, n, n2);
            n += n2;
        }
        return fArray;
    }

    @Override
    public Object getArray1D() {
        float[] fArray = new float[this.sizeXYZ];
        int n = 0;
        for (int i = 0; i < this.img.getNSlices(); ++i) {
            System.arraycopy((float[])this.img.getImageStack().getPixels(i + 1), 0, fArray, n, this.sizeXY);
            n += this.sizeXY;
        }
        return fArray;
    }

    @Override
    public Object getArray1D(int n) {
        float[] fArray = new float[this.sizeXY];
        System.arraycopy((float[])this.img.getImageStack().getPixels(n + 1), 0, fArray, 0, this.sizeXY);
        return fArray;
    }

    public static ImagePlus getImagePlus(float[] fArray, int n, int n2, int n3, boolean bl) {
        if (fArray == null) {
            return null;
        }
        ImagePlus imagePlus = NewImage.createFloatImage((String)"", (int)n, (int)n2, (int)n3, (int)1);
        int n4 = 0;
        int n5 = n * n2;
        for (int i = 0; i < n3; ++i) {
            System.arraycopy(fArray, n4, (float[])imagePlus.getImageStack().getPixels(i + 1), 0, n5);
            n4 += n5;
        }
        if (bl) {
            float f = 0.0f;
            float f2 = 0.0f;
            for (int i = 0; i < fArray.length; ++i) {
                if (fArray[i] > f) {
                    f = fArray[i];
                }
                if (!(fArray[i] < f2)) continue;
                f2 = fArray[i];
            }
            imagePlus.getProcessor().setMinAndMax((double)f2, (double)f);
        }
        return imagePlus;
    }

    public static ImagePlus getImagePlus(int[] nArray, int n, int n2, int n3, boolean bl) {
        int n4;
        if (nArray == null) {
            return null;
        }
        ImagePlus imagePlus = NewImage.createFloatImage((String)"", (int)n, (int)n2, (int)n3, (int)1);
        int n5 = 0;
        int n6 = n * n2;
        for (int i = 0; i < n3; ++i) {
            float[] fArray = (float[])imagePlus.getImageStack().getPixels(i + 1);
            for (n4 = 0; n4 < n6; ++n4) {
                fArray[n4] = nArray[n5 + n4];
            }
            n5 += n6;
        }
        if (bl) {
            float f = 0.0f;
            float f2 = 0.0f;
            for (n4 = 0; n4 < nArray.length; ++n4) {
                if ((float)nArray[n4] > f) {
                    f = nArray[n4];
                }
                if (!((float)nArray[n4] < f2)) continue;
                f2 = nArray[n4];
            }
            imagePlus.getProcessor().setMinAndMax((double)f2, (double)f);
        }
        return imagePlus;
    }

    public ImageShort convertToShort(boolean bl) {
        if (bl) {
            this.setMinAndMax(null);
        }
        ImageStats imageStats = this.getImageStats(null);
        int n = this.img.getCurrentSlice();
        ImageStack imageStack = new ImageStack(this.sizeX, this.sizeY);
        ImageStack imageStack2 = this.img.getImageStack();
        for (int i = 1; i <= this.sizeZ; ++i) {
            String string = imageStack2.getSliceLabel(i);
            ImageProcessor imageProcessor = imageStack2.getProcessor(i);
            if (bl) {
                imageProcessor.setMinAndMax(imageStats.getMin(), imageStats.getMax());
            }
            imageStack.addSlice(string, imageProcessor.convertToShort(bl));
        }
        ImagePlus imagePlus = new ImagePlus(this.img.getTitle(), imageStack);
        imagePlus.setCalibration(this.img.getCalibration());
        imagePlus.setSlice(n);
        return (ImageShort)ImageHandler.wrap(imagePlus);
    }

    public ImageByte convertToByte(boolean bl) {
        this.getMinAndMax(null);
        ImageStats imageStats = this.getImageStats(null);
        ImageByte imageByte = new ImageByte(this.title, this.sizeX, this.sizeY, this.sizeZ);
        if (bl) {
            double d = 255.0 / (imageStats.getMax() - imageStats.getMin());
            System.out.println("convert to byte: min:" + imageStats.getMin() + " max:" + imageStats.getMax() + "coeff:" + d);
            double d2 = imageStats.getMin();
            for (int i = 0; i < this.sizeZ; ++i) {
                for (int j = 0; j < this.sizeXY; ++j) {
                    int n = (int)(((double)this.pixels[i][j] - d2) * d + 0.5);
                    if (n < 0 || n > 255) {
                        System.out.println(this.pixels[i][j] + " to " + n);
                    }
                    imageByte.pixels[i][j] = (byte)(((double)this.pixels[i][j] - d2) * d + 0.5);
                }
            }
            imageByte.setMinAndMax(0.0f, 255.0f);
        } else {
            for (int i = 0; i < this.sizeZ; ++i) {
                for (int j = 0; j < this.sizeXY; ++j) {
                    imageByte.pixels[i][j] = (byte)this.pixels[i][j];
                }
            }
        }
        imageByte.setScale(this);
        imageByte.setOffset(this);
        return imageByte;
    }

    public static float[] convert(short[] sArray) {
        float[] fArray = new float[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            fArray[i] = (float)sArray[i] + 0.5f;
        }
        return fArray;
    }

    public static float[] convert(byte[] byArray) {
        float[] fArray = new float[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            fArray[i] = byArray[i];
        }
        return fArray;
    }

    @Override
    public void erase() {
        int n;
        for (n = 0; n < this.sizeXY; ++n) {
            this.pixels[0][n] = 0.0f;
        }
        for (n = 1; n < this.sizeZ; ++n) {
            System.arraycopy(this.pixels[0], 0, this.pixels[n], 0, this.sizeXY);
        }
    }

    @Override
    public void fill(double d) {
        int n;
        for (n = 0; n < this.sizeXY; ++n) {
            this.pixels[0][n] = (float)d;
        }
        for (n = 1; n < this.sizeZ; ++n) {
            System.arraycopy(this.pixels[0], 0, this.pixels[n], 0, this.sizeXY);
        }
    }

    @Override
    public ImageFloat duplicate() {
        ImageFloat imageFloat = new ImageFloat(this.img.duplicate());
        imageFloat.offsetX = this.offsetX;
        imageFloat.offsetY = this.offsetY;
        imageFloat.offsetZ = this.offsetZ;
        if (this.title != null) {
            imageFloat.title = this.title;
        }
        return imageFloat;
    }

    public void copy(ImageFloat imageFloat) {
        for (int i = 0; i < this.sizeZ; ++i) {
            System.arraycopy(this.pixels[i], 0, imageFloat.pixels[i], 0, this.sizeXY);
        }
    }

    @Override
    public float getPixel(int n) {
        return this.pixels[n / this.sizeXY][n % this.sizeXY];
    }

    public float getPixel(IntCoord3D intCoord3D) {
        return this.pixels[intCoord3D.z][intCoord3D.x + intCoord3D.y * this.sizeX];
    }

    public float getPixel(Coordinate3D coordinate3D) {
        return this.pixels[coordinate3D.z][coordinate3D.x + coordinate3D.y * this.sizeX];
    }

    @Override
    public float getPixel(int n, int n2, int n3) {
        return this.pixels[n3][n + n2 * this.sizeX];
    }

    @Override
    public float getPixel(int n, int n2) {
        return this.pixels[n2][n];
    }

    @Override
    public void setPixel(int n, float f) {
        this.pixels[n / this.sizeXY][n % this.sizeXY] = f;
    }

    @Override
    public void setPixel(Point3D point3D, float f) {
        this.pixels[(int)point3D.z][(int)point3D.x + (int)point3D.y * this.sizeX] = f;
    }

    @Override
    public void setPixel(int n, int n2, int n3, float f) {
        this.pixels[n3][n + n2 * this.sizeX] = f;
    }

    @Override
    public void setPixel(int n, int n2, float f) {
        this.pixels[n2][n] = f;
    }

    @Override
    protected synchronized void getMinAndMax(ImageInt imageInt) {
        ImageStats imageStats = this.getImageStats(imageInt);
        if (imageStats.minAndMaxSet()) {
            return;
        }
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        if (imageInt == null) {
            for (int i = 0; i < this.sizeZ; ++i) {
                for (int j = 0; j < this.sizeXY; ++j) {
                    if ((double)this.pixels[i][j] > d2) {
                        d2 = this.pixels[i][j];
                    }
                    if (!((double)this.pixels[i][j] < d)) continue;
                    d = this.pixels[i][j];
                }
            }
        } else {
            for (int i = 0; i < this.sizeZ; ++i) {
                for (int j = 0; j < this.sizeXY; ++j) {
                    if (imageInt.getPixel(j, i) == 0.0f) continue;
                    if ((double)this.pixels[i][j] > d2) {
                        d2 = this.pixels[i][j];
                    }
                    if (!((double)this.pixels[i][j] < d)) continue;
                    d = this.pixels[i][j];
                }
            }
        }
        imageStats.setMinAndMax(d, d2);
    }

    @Override
    protected int[] getHisto(ImageInt imageInt) {
        if (imageInt == null) {
            imageInt = new BlankMask(this);
        }
        this.getMinAndMax(imageInt);
        ImageStats imageStats = this.getImageStats(imageInt);
        double d = 256.0 / (imageStats.getMax() - imageStats.getMin());
        double d2 = imageStats.getMin();
        int[] nArray = new int[256];
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeXY; ++j) {
                if (imageInt.getPixel(j, i) == 0.0f) continue;
                int n = (int)(((double)this.pixels[i][j] - d2) * d);
                if (n >= 256) {
                    nArray[255] = nArray[255] + 1;
                    continue;
                }
                int n2 = n;
                nArray[n2] = nArray[n2] + 1;
            }
        }
        imageStats.setHisto256(nArray, 1.0 / d);
        return nArray;
    }

    @Override
    protected int[] getHisto(ImageInt imageInt, int n, double d, double d2) {
        if (imageInt == null) {
            imageInt = new BlankMask(this);
        }
        double d3 = (double)n / (d2 - d);
        int[] nArray = new int[n];
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeXY; ++j) {
                if (imageInt.getPixel(j, i) == 0.0f) continue;
                int n2 = (int)(((double)this.pixels[i][j] - d) * d3);
                if (n2 >= n) {
                    int n3 = n - 1;
                    nArray[n3] = nArray[n3] + 1;
                    continue;
                }
                int n4 = n2;
                nArray[n4] = nArray[n4] + 1;
            }
        }
        return nArray;
    }

    @Override
    public void draw(Object3D object3D, float f) {
        Object3DVoxels object3DVoxels = !(object3D instanceof Object3DVoxels) ? object3D.getObject3DVoxels() : (Object3DVoxels)object3D;
        for (Voxel3D voxel3D : object3DVoxels.getVoxels()) {
            this.pixels[voxel3D.getRoundZ()][voxel3D.getRoundX() + voxel3D.getRoundY() * this.sizeX] = f;
        }
    }

    @Override
    public void eraseOutsideMask(ImageInt imageInt) {
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeXY; ++j) {
                if (imageInt.getPixel(j, i) != 0.0f) continue;
                this.pixels[i][j] = 0.0f;
            }
        }
    }

    @Override
    public ImageByte threshold(float f, boolean bl, boolean bl2) {
        ImageByte imageByte;
        block9: {
            block11: {
                block10: {
                    block8: {
                        imageByte = new ImageByte(this.title + "thld", this.sizeX, this.sizeY, this.sizeZ);
                        imageByte.offsetX = this.offsetX;
                        imageByte.offsetY = this.offsetY;
                        imageByte.offsetZ = this.offsetZ;
                        if (bl || bl2) break block8;
                        for (int i = 0; i < this.sizeZ; ++i) {
                            for (int j = 0; j < this.sizeXY; ++j) {
                                if (!(this.pixels[i][j] >= f)) continue;
                                imageByte.pixels[i][j] = -1;
                            }
                        }
                        break block9;
                    }
                    if (bl || !bl2) break block10;
                    for (int i = 0; i < this.sizeZ; ++i) {
                        for (int j = 0; j < this.sizeXY; ++j) {
                            if (!(this.pixels[i][j] > f)) continue;
                            imageByte.pixels[i][j] = -1;
                        }
                    }
                    break block9;
                }
                if (!bl || bl2) break block11;
                for (int i = 0; i < this.sizeZ; ++i) {
                    for (int j = 0; j < this.sizeXY; ++j) {
                        if (!(this.pixels[i][j] <= f)) continue;
                        imageByte.pixels[i][j] = -1;
                    }
                }
                break block9;
            }
            if (!bl || !bl2) break block9;
            for (int i = 0; i < this.sizeZ; ++i) {
                for (int j = 0; j < this.sizeXY; ++j) {
                    if (!(this.pixels[i][j] < f)) continue;
                    imageByte.pixels[i][j] = -1;
                }
            }
        }
        return imageByte;
    }

    @Override
    public void thresholdCut(float f, boolean bl, boolean bl2) {
        block9: {
            block11: {
                block10: {
                    block8: {
                        if (bl || bl2) break block8;
                        for (int i = 0; i < this.sizeZ; ++i) {
                            for (int j = 0; j < this.sizeXY; ++j) {
                                if (!(this.pixels[i][j] < f)) continue;
                                this.pixels[i][j] = 0.0f;
                            }
                        }
                        break block9;
                    }
                    if (bl || !bl2) break block10;
                    for (int i = 0; i < this.sizeZ; ++i) {
                        for (int j = 0; j < this.sizeXY; ++j) {
                            if (!(this.pixels[i][j] <= f)) continue;
                            this.pixels[i][j] = 0.0f;
                        }
                    }
                    break block9;
                }
                if (!bl || bl2) break block11;
                for (int i = 0; i < this.sizeZ; ++i) {
                    for (int j = 0; j < this.sizeXY; ++j) {
                        if (!(this.pixels[i][j] > f)) continue;
                        this.pixels[i][j] = 0.0f;
                    }
                }
                break block9;
            }
            if (!bl || !bl2) break block9;
            for (int i = 0; i < this.sizeZ; ++i) {
                for (int j = 0; j < this.sizeXY; ++j) {
                    if (!(this.pixels[i][j] >= f)) continue;
                    this.pixels[i][j] = 0.0f;
                }
            }
        }
    }

    @Override
    public ImageFloat crop3D(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n;
        int n8 = n5;
        int n9 = n3;
        int n10 = n2;
        int n11 = n4;
        int n12 = n6;
        int n13 = n10 - n7 + 1;
        int n14 = n11 - n9 + 1;
        int n15 = n12 - n8 + 1;
        ImageFloat imageFloat = new ImageFloat(string, n13, n14, n15);
        imageFloat.offsetX = n7;
        imageFloat.offsetY = n9;
        imageFloat.offsetZ = n8;
        imageFloat.setScale(this);
        int n16 = -n8;
        int n17 = 0;
        int n18 = 0;
        if (n7 <= -1) {
            n7 = 0;
        }
        if (n10 >= this.sizeX) {
            n10 = this.sizeX - 1;
        }
        if (n9 <= -1) {
            n17 = -n13 * n9;
            n9 = 0;
        }
        if (n11 >= this.sizeY) {
            n11 = this.sizeY - 1;
        }
        if (n8 <= -1) {
            n8 = 0;
        }
        if (n12 >= this.sizeZ) {
            n12 = this.sizeZ - 1;
        }
        int n19 = n10 - n7 + 1;
        for (int i = n8; i <= n12; ++i) {
            int n20 = n9 * this.sizeX;
            int n21 = n17;
            for (int j = n9; j <= n11; ++j) {
                System.arraycopy(this.pixels[i], n20 + n7, imageFloat.pixels[i + n16], n21 + n18, n19);
                n21 += n13;
                n20 += this.sizeX;
            }
        }
        return imageFloat;
    }

    public ImageFloat[] crop3D(TreeMap<Integer, int[]> treeMap) {
        ImageFloat[] imageFloatArray = new ImageFloat[treeMap.size()];
        ArrayList<Integer> arrayList = new ArrayList<Integer>(treeMap.keySet());
        for (int i = 0; i < imageFloatArray.length; ++i) {
            int n = arrayList.get(i);
            int[] nArray = treeMap.get(n);
            imageFloatArray[i] = this.crop3D(this.title + ":" + n, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5]);
        }
        return imageFloatArray;
    }

    @Override
    public ImageFloat crop3DMask(String string, ImageInt imageInt, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        ImageFloat imageFloat;
        block13: {
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            block12: {
                int n14 = n2;
                int n15 = n6;
                n13 = n4;
                n12 = n3;
                n11 = n5;
                n10 = n7;
                n9 = n12 - n14 + 1;
                int n16 = n11 - n13 + 1;
                int n17 = n10 - n15 + 1;
                imageFloat = new ImageFloat(string, n9, n16, n17);
                imageFloat.offsetX = n14;
                imageFloat.offsetY = n13;
                imageFloat.offsetZ = n15;
                imageFloat.setScale(this);
                int n18 = -n15;
                n8 = 0;
                int n19 = -n14;
                if (n14 <= -1) {
                    n14 = 0;
                }
                if (n12 >= this.sizeX) {
                    n12 = this.sizeX - 1;
                }
                if (n13 <= -1) {
                    n8 = -n9 * n13;
                    n13 = 0;
                }
                if (n11 >= this.sizeY) {
                    n11 = this.sizeY - 1;
                }
                if (n15 <= -1) {
                    n15 = 0;
                }
                if (n10 >= this.sizeZ) {
                    n10 = this.sizeZ - 1;
                }
                if (!(imageInt instanceof ImageShort)) break block12;
                ImageShort imageShort = (ImageShort)imageInt;
                for (int i = n15; i <= n10; ++i) {
                    int n20 = n13 * this.sizeX;
                    int n21 = n8;
                    for (int j = n13; j <= n11; ++j) {
                        for (int k = n14; k <= n12; ++k) {
                            if ((imageShort.pixels[i][n20 + k] & 0xFFFF) != n) continue;
                            imageFloat.pixels[i + n18][n21 + k + n19] = this.pixels[i][n20 + k];
                        }
                        n21 += n9;
                        n20 += this.sizeX;
                    }
                }
                break block13;
            }
            if (!(imageInt instanceof ImageByte)) break block13;
            ImageByte imageByte = (ImageByte)imageInt;
            for (int i = n15; i <= n10; ++i) {
                int n22 = n13 * this.sizeX;
                int n23 = n8;
                for (int j = n13; j <= n11; ++j) {
                    for (int k = n14; k <= n12; ++k) {
                        if ((imageByte.pixels[i][n22 + k] & 0xFF) != n) continue;
                        imageFloat.pixels[i + n18][n23 + k + n19] = this.pixels[i][n22 + k];
                    }
                    n23 += n9;
                    n22 += this.sizeX;
                }
            }
        }
        return imageFloat;
    }

    @Override
    public ImageHandler resize(int n, int n2, int n3) {
        int n4 = Math.max(1, this.sizeX + 2 * n);
        int n5 = Math.max(1, this.sizeY + 2 * n2);
        boolean bl = Prefs.get((String)"resizer.zero", (boolean)true);
        Prefs.set((String)"resizer.zero", (boolean)true);
        CanvasResizer canvasResizer = new CanvasResizer();
        ImageStack imageStack = canvasResizer.expandStack(this.img.getStack(), n4, n5, n, n2);
        if (!bl) {
            // empty if block
        }
        if (n3 > 0) {
            for (int i = 0; i < n3; ++i) {
                imageStack.addSlice("", (ImageProcessor)new FloatProcessor(n4, n5), 0);
                imageStack.addSlice("", (ImageProcessor)new FloatProcessor(n4, n5));
            }
        } else {
            for (int i = 0; i < -n3 && imageStack.getSize() > 2; ++i) {
                imageStack.deleteLastSlice();
                imageStack.deleteSlice(1);
            }
        }
        return new ImageFloat(new ImagePlus(this.title + "::resized", imageStack));
    }

    @Override
    public ImageHandler resample(int n, int n2, int n3, int n4) {
        ImagePlus imagePlus;
        Resizer resizer;
        if (n4 == -1) {
            n4 = 2;
        }
        if (n == this.sizeX && n2 == this.sizeY && n3 == this.sizeZ || n == 0 && n2 == 0 && n3 == 0) {
            return new ImageFloat(this.img.duplicate());
        }
        if (n != 0 && n2 != 0 && n != this.sizeX && n2 != this.sizeY) {
            resizer = new StackProcessor(this.img.getImageStack(), this.img.getProcessor());
            imagePlus = new ImagePlus(this.title + "::resampled", resizer.resize(n, n2, true));
        } else {
            imagePlus = this.img;
        }
        if (n3 != 0 && n3 != this.sizeZ) {
            resizer = new Resizer();
            imagePlus = resizer.zScale(imagePlus, n3, n4);
        }
        return new ImageFloat(imagePlus);
    }

    @Override
    public ImageHandler resample(int n, int n2) {
        if (n2 == -1) {
            n2 = 2;
        }
        Resizer resizer = new Resizer();
        return new ImageFloat(resizer.zScale(this.img, n, n2));
    }

    @Override
    protected ImageFloat normalize_(ImageInt imageInt, double d) {
        this.getMinAndMax(imageInt);
        ImageStats imageStats = this.getImageStats(imageInt);
        double d2 = imageStats.getMax();
        if (d > 0.0 && d < 1.0) {
            d2 = this.getPercentile(d, imageInt);
        }
        if (d2 <= imageStats.getMin()) {
            d2 = imageStats.getMin();
        }
        double d3 = 1.0 / (d2 - imageStats.getMin());
        double d4 = -imageStats.getMin() * d3;
        ImageFloat imageFloat = new ImageFloat(this.title + "::normalized", this.sizeX, this.sizeY, this.sizeZ);
        if (d > 0.0 && d < 1.0) {
            for (int i = 0; i < this.sizeZ; ++i) {
                for (int j = 0; j < this.sizeXY; ++j) {
                    imageFloat.pixels[i][j] = (float)((double)this.pixels[i][j] >= d2 ? 1.0 : (double)this.pixels[i][j] * d3 + d4);
                }
            }
        } else {
            for (int i = 0; i < this.sizeZ; ++i) {
                for (int j = 0; j < this.sizeXY; ++j) {
                    imageFloat.pixels[i][j] = (float)((double)this.pixels[i][j] * d3 + d4);
                }
            }
        }
        return imageFloat;
    }

    @Override
    public ImageFloat normalize(double d, double d2) {
        double d3 = 1.0 / (d2 - d);
        double d4 = -d * d3;
        ImageFloat imageFloat = new ImageFloat(this.title + "::normalized", this.sizeX, this.sizeY, this.sizeZ);
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeXY; ++j) {
                imageFloat.pixels[i][j] = (double)this.pixels[i][j] >= d2 ? 1.0f : ((double)this.pixels[i][j] <= d ? 0.0f : (float)((double)this.pixels[i][j] * d3 + d4));
            }
        }
        return imageFloat;
    }

    @Override
    public void intersectMask(ImageInt imageInt) {
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeXY; ++j) {
                if (imageInt.getPixel(j, i) != 0.0f) continue;
                this.pixels[i][j] = 0.0f;
            }
        }
    }

    @Override
    public void invert(ImageInt imageInt) {
        this.getMinAndMax(imageInt);
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeXY; ++j) {
                this.pixels[i][j] = -this.pixels[i][j];
            }
        }
    }

    public void opposite() {
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeXY; ++j) {
                this.pixels[i][j] = -this.pixels[i][j];
            }
        }
    }

    public void subtract(ImageFloat imageFloat) {
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeXY; ++j) {
                float[] fArray = this.pixels[i];
                int n = j;
                fArray[n] = fArray[n] - imageFloat.pixels[i][j];
            }
        }
    }

    @Override
    protected void flushPixels() {
        if (this.pixels != null) {
            for (int i = 0; i < this.pixels.length; ++i) {
                this.pixels[i] = null;
            }
            this.pixels = null;
        }
    }

    @Override
    public boolean isOpened() {
        return this.pixels != null && this.img != null && this.img.getProcessor() != null;
    }

    @Override
    public float getPixel(Point3D point3D) {
        return this.pixels[point3D.getRoundZ()][point3D.getRoundX() + point3D.getRoundY() * this.sizeX];
    }

    @Override
    public float getPixelInterpolated(Point3D point3D) {
        return this.getPixel((float)point3D.x, (float)point3D.y, (float)point3D.z);
    }

    @Override
    public ImageHandler cropRadius(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2) {
        int n7 = Math.max(0, n - n4);
        int n8 = Math.max(0, n2 - n5);
        int n9 = Math.max(0, n3 - n6);
        int n10 = Math.min(this.sizeX, n + n4);
        int n11 = Math.min(this.sizeY, n2 + n5);
        int n12 = Math.min(this.sizeZ, n3 + n6);
        double d = n4 * n4;
        double d2 = n5 * n5;
        double d3 = n6 * n6;
        float f = 0.0f;
        if (bl) {
            ImageStats imageStats = this.getImageStats(null);
            f = (int)imageStats.getMean();
        }
        ImageFloat imageFloat = new ImageFloat("crop_" + this.title, n10 - n7 + 1, n11 - n8 + 1, n12 - n9 + 1);
        for (int i = n3 - n6; i <= n12; ++i) {
            for (int j = n - n4; j <= n10; ++j) {
                for (int k = n2 - n5; k <= n11; ++k) {
                    if (bl2) {
                        double d4 = (double)((j - n) * (j - n)) / d + (double)((k - n2) * (k - n2)) / d2 + (double)((i - n3) * (i - n3)) / d3;
                        if (d4 <= 1.0) {
                            imageFloat.setPixel(j - n + n4, k - n2 + n5, i - n3 + n6, this.getPixel(j, k, i));
                            continue;
                        }
                        imageFloat.setPixel(j - n + n4, k - n2 + n5, i - n3 + n6, f);
                        continue;
                    }
                    imageFloat.setPixel(j - n + n4, k - n2 + n5, i - n3 + n6, this.getPixel(j, k, i));
                }
            }
        }
        return imageFloat;
    }

    public void filterGeneric(ImageFloat imageFloat, float f, float f2, float f3, int n, int n2, int n3) {
        int[] nArray = FastFilters3D.createKernelEllipsoid(f, f2, f3);
        int n4 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n4 += nArray[i];
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.sizeZ) {
            n2 = this.sizeZ;
        }
        for (int i = n; i < n2; ++i) {
            IJ.showStatus((String)("3D filter : " + i + "/" + n2));
            for (int j = 0; j < this.sizeY; ++j) {
                for (int k = 0; k < this.sizeX; ++k) {
                    ArrayUtil arrayUtil = this.getNeighborhoodKernel(nArray, n4, k, j, i, f, f2, f3);
                    if (n3 == 0) {
                        imageFloat.setPixel(k, j, i, (float)arrayUtil.getMean());
                    } else if (n3 == 1) {
                        imageFloat.setPixel(k, j, i, (float)arrayUtil.medianSort());
                    }
                    if (n3 == 2) {
                        imageFloat.setPixel(k, j, i, (float)arrayUtil.getMinimum());
                    }
                    if (n3 == 3) {
                        imageFloat.setPixel(k, j, i, (float)arrayUtil.getMaximum());
                    }
                    if (n3 == 8) {
                        imageFloat.setPixel(k, j, i, (float)arrayUtil.getVariance2());
                    }
                    if (n3 != 4) continue;
                    float f4 = this.getPixel(k, j, i);
                    if (arrayUtil.isMaximum(f4)) {
                        imageFloat.setPixel(k, j, i, f4);
                        continue;
                    }
                    imageFloat.setPixel(k, j, i, 0.0f);
                }
            }
        }
    }

    public void filterGeneric(ImageFloat imageFloat, Object3DVoxels object3DVoxels, int n, int n2, int n3) {
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.sizeZ) {
            n2 = this.sizeZ;
        }
        int[] nArray = FastFilters3D.createKernelFromObject(object3DVoxels);
        int n4 = FastFilters3D.getNbFromKernel(nArray);
        float[] fArray = FastFilters3D.getRadiiFromObject(object3DVoxels);
        for (int i = n; i < n2; ++i) {
            IJ.showStatus((String)("3D filter : " + (i + 1) + "/" + n2));
            for (int j = 0; j < this.sizeY; ++j) {
                for (int k = 0; k < this.sizeX; ++k) {
                    ArrayUtil arrayUtil = this.getNeighborhoodKernel(nArray, n4, k, j, i, fArray[0], fArray[1], fArray[2]);
                    if (n3 == 0) {
                        imageFloat.setPixel(k, j, i, (float)(arrayUtil.getMean() + 0.5));
                    } else if (n3 == 1) {
                        imageFloat.setPixel(k, j, i, (float)arrayUtil.medianSort());
                    }
                    if (n3 == 2) {
                        imageFloat.setPixel(k, j, i, (float)arrayUtil.getMinimum());
                    }
                    if (n3 == 3) {
                        imageFloat.setPixel(k, j, i, (float)arrayUtil.getMaximum());
                    }
                    if (n3 == 8) {
                        imageFloat.setPixel(k, j, i, (float)(arrayUtil.getVariance2() + 0.5));
                    }
                    if (n3 != 4) continue;
                    float f = this.getPixel(k, j, i);
                    if (arrayUtil.isMaximum(f)) {
                        imageFloat.setPixel(k, j, i, f);
                        continue;
                    }
                    imageFloat.setPixel(k, j, i, 0.0f);
                }
            }
        }
    }

    public ImageFloat sobelFilter() {
        ImageFloat imageFloat = (ImageFloat)this.createSameDimensions();
        double[] dArray = new double[]{-1.0, 0.0, 1.0, -2.0, 0.0, 2.0, -1.0, 0.0, 1.0, -2.0, 0.0, 2.0, -4.0, 0.0, 4.0, -2.0, 0.0, 2.0, -1.0, 0.0, 1.0, -2.0, 0.0, 2.0, -1.0, 0.0, 1.0};
        double[] dArray2 = new double[]{-1.0, -2.0, -1.0, 0.0, 0.0, 0.0, 1.0, 2.0, 1.0, -2.0, -4.0, -2.0, 0.0, 0.0, 0.0, 2.0, 4.0, 2.0, -1.0, -2.0, -1.0, 0.0, 0.0, 0.0, 1.0, 2.0, 1.0};
        double[] dArray3 = new double[]{-1.0, -2.0, -1.0, -2.0, -4.0, -2.0, -1.0, -2.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 1.0, 2.0, 4.0, 2.0, 1.0, 2.0, 1.0};
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeY; ++j) {
                for (int k = 0; k < this.sizeX; ++k) {
                    ArrayUtil arrayUtil = this.getNeighborhood3x3x3(k, j, i);
                    double d = arrayUtil.convolve(dArray, 1.0);
                    double d2 = arrayUtil.convolve(dArray2, 1.0);
                    double d3 = arrayUtil.convolve(dArray3, 1.0);
                    double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
                    imageFloat.setPixel(k, j, i, (float)d4);
                }
            }
        }
        return imageFloat;
    }

    public ImageFloat adaptiveFilter(float f, float f2, float f3, int n) {
        int n2;
        ImageFloat imageFloat;
        final ImageFloat imageFloat2 = imageFloat = (ImageFloat)this.createSameDimensions();
        final int[] nArray = FastFilters3D.createKernelEllipsoid(f, f2, f3);
        int n3 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n3 += nArray[n2];
        }
        n2 = n3;
        final float f4 = f;
        final float f5 = f2;
        final float f6 = f3;
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        Thread[] threadArray = ThreadUtil.createThreadArray(n);
        for (int i = 0; i < threadArray.length; ++i) {
            threadArray[i] = new Thread(){

                @Override
                public void run() {
                    ArrayUtil[] arrayUtilArray = new ArrayUtil[7];
                    int n = 1;
                    double d = 0.0;
                    int n22 = atomicInteger.getAndIncrement();
                    while (n22 < ImageFloat.this.sizeZ) {
                        for (int i = 0; i < ImageFloat.this.sizeY; ++i) {
                            for (int j = 0; j < ImageFloat.this.sizeX; ++j) {
                                arrayUtilArray[0] = ImageFloat.this.getNeighborhoodKernel(nArray, n2, j, i, n22, f4, f5, f6);
                                arrayUtilArray[1] = ImageFloat.this.getNeighborhoodKernel(nArray, n2, j + n, i, n22, f4, f5, f6);
                                arrayUtilArray[2] = ImageFloat.this.getNeighborhoodKernel(nArray, n2, j - n, i, n22, f4, f5, f6);
                                arrayUtilArray[3] = ImageFloat.this.getNeighborhoodKernel(nArray, n2, j, i + n, n22, f4, f5, f6);
                                arrayUtilArray[4] = ImageFloat.this.getNeighborhoodKernel(nArray, n2, j, i - n, n22, f4, f5, f6);
                                arrayUtilArray[5] = ImageFloat.this.getNeighborhoodKernel(nArray, n2, j, i, n22 + n, f4, f5, f6);
                                arrayUtilArray[6] = ImageFloat.this.getNeighborhoodKernel(nArray, n2, j, i, n22 - n, f4, f5, f6);
                                double d2 = 0.0;
                                double d3 = 3.4028234663852886E38;
                                for (int k = 0; k < 7; ++k) {
                                    d = arrayUtilArray[k].getMean();
                                    double d4 = arrayUtilArray[k].getStdDev();
                                    if (!(d4 < d3)) continue;
                                    d3 = d4;
                                    d2 = d;
                                }
                                imageFloat2.setPixel(j, i, n22, (int)d2);
                            }
                        }
                        n22 = atomicInteger.getAndIncrement();
                    }
                }
            };
        }
        ThreadUtil.startAndJoin(threadArray);
        return imageFloat2;
    }

    @Override
    public ImageHandler deleteSlices(int n, int n2) {
        int n3;
        int n4 = Math.min(n, n2);
        int n5 = Math.max(n, n2);
        int n6 = n5 - n4 + 1;
        int n7 = this.sizeZ - n6;
        ImageFloat imageFloat = new ImageFloat("deleted slices", this.sizeX, this.sizeY, n7);
        for (n3 = 0; n3 < n4; ++n3) {
            System.arraycopy(this.pixels[n3], 0, imageFloat.pixels[n3], 0, this.sizeXY);
        }
        for (n3 = n5 + 1; n3 < this.sizeZ; ++n3) {
            System.arraycopy(this.pixels[n3], 0, imageFloat.pixels[n3 - n6], 0, this.sizeXY);
        }
        return imageFloat;
    }

    @Override
    public void trimSlices(int n, int n2) {
        int n3 = Math.max(1, Math.min(n, n2));
        int n4 = Math.min(this.sizeZ, Math.max(n, n2));
        int n5 = n4 - n3 + 1;
        float[][] fArrayArray = new float[n5][];
        for (int i = 0; i < n5; ++i) {
            fArrayArray[i] = this.pixels[i + n3 - 1];
        }
        if (this.img != null) {
            int n6;
            ImageStack imageStack = this.img.getImageStack();
            for (n6 = 1; n6 < n3; ++n6) {
                imageStack.deleteSlice(1);
            }
            for (n6 = n4 + 1; n6 <= this.sizeZ; ++n6) {
                imageStack.deleteLastSlice();
            }
        }
        this.sizeZ = n5;
        this.sizeXYZ = this.sizeXY * this.sizeZ;
        this.offsetZ += n3 - 1;
        this.stats = new HashMap(2);
    }

    @Override
    public double getSizeInMb() {
        return (double)(4 * this.sizeX * this.sizeY * this.sizeZ) / 1048576.0;
    }

    @Override
    public int getType() {
        return 2;
    }
}

