/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.utils;

import java.util.concurrent.atomic.AtomicInteger;

public class ThreadRunner {
    public final int start;
    public final int end;
    public final Thread[] threads;
    public final AtomicInteger ai;

    public ThreadRunner(int n, int n2, int n3) {
        this.start = n;
        this.end = n2;
        this.ai = new AtomicInteger(this.start);
        int n4 = this.getNbCpus();
        if (n3 > 0 && n4 > n3) {
            n4 = n3;
        }
        this.threads = new Thread[n4];
    }

    public void startAndJoin() {
        ThreadRunner.startAndJoin(this.threads);
    }

    protected static void startAndJoin(Thread[] threadArray) {
        int n;
        for (n = 0; n < threadArray.length; ++n) {
            threadArray[n].setPriority(5);
            threadArray[n].start();
        }
        try {
            for (n = 0; n < threadArray.length; ++n) {
                threadArray[n].join();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    public void resetAi() {
        this.ai.set(this.start);
    }

    private int getNbCpus() {
        return Math.max(1, Math.min(Runtime.getRuntime().availableProcessors(), this.end - this.start));
    }
}

