/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLImage;
import com.jogamp.opencl.CLImageFormat;
import com.jogamp.opencl.llb.CLImageBinding;
import java.nio.Buffer;
import java.nio.IntBuffer;

public class CLImage3d<B extends Buffer>
extends CLImage<B> {
    public final int depth;

    private CLImage3d(CLContext cLContext, B b, CLImageFormat cLImageFormat, int n, int n2, int n3, long l, int n4) {
        super(cLContext, b, cLImageFormat, n, n2, l, n4);
        this.depth = n3;
    }

    protected CLImage3d(CLContext cLContext, B b, CLImageFormat cLImageFormat, CLImage.CLImageInfoAccessor cLImageInfoAccessor, int n, int n2, int n3, long l, int n4) {
        super(cLContext, b, cLImageFormat, cLImageInfoAccessor, n, n2, l, n4);
        this.depth = n3;
    }

    static <B extends Buffer> CLImage3d<B> createImage(CLContext cLContext, B b, int n, int n2, int n3, int n4, int n5, CLImageFormat cLImageFormat, int n6) {
        CLImageBinding cLImageBinding = cLContext.getPlatform().getImageBinding();
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
        Buffer buffer = null;
        if (CLImage3d.isHostPointerFlag(n6)) {
            buffer = b;
        }
        long l = cLImageBinding.clCreateImage3D(cLContext.ID, n6, cLImageFormat.getFormatImpl(), n, n2, n3, n4, n5, buffer, intBuffer);
        CLException.checkForError(intBuffer.get(), "can not create 2d image");
        return new CLImage3d<B>(cLContext, b, cLImageFormat, n, n2, n3, l, n6);
    }

    @Override
    public <T extends Buffer> CLImage3d<T> cloneWith(T t) {
        return new CLImage3d<T>(this.context, t, this.format, this.width, this.height, this.depth, this.ID, this.FLAGS);
    }

    public int getSlicePitch() {
        return (int)this.imageInfo.getLong(4371);
    }

    public int getDepth() {
        return this.depth;
    }

    @Override
    public String toString() {
        return "CLImage3d [id: " + this.ID + " width: " + this.width + " height: " + this.height + " depth: " + this.depth + "]";
    }
}

